/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityBijuManager;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntityTailedBeast;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntitySealing
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 385;
    public static final int ENTITYID_RANGED = 386;

    public EntitySealing(ElementsNarutomodMod instance) {
        super(instance, 765);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "sealing"), 385).name("sealing").tracker(96, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderSeal(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelSeal
        extends ModelBase {
            private final ModelRenderer bb_main;

            public ModelSeal() {
                this.field_78090_t = 64;
                this.field_78089_u = 16;
                this.bb_main = new ModelRenderer((ModelBase)this);
                this.bb_main.func_78793_a(0.0f, 0.0f, 0.0f);
                this.bb_main.field_78804_l.add(new ModelBox(this.bb_main, 0, 0, -8.0f, 0.0f, -8.0f, 16, 0, 16, 0.0f, false));
                this.bb_main.field_78804_l.add(new ModelBox(this.bb_main, 0, 0, -1.5f, -1.0f, -1.5f, 3, 1, 3, 0.0f, false));
                this.bb_main.field_78804_l.add(new ModelBox(this.bb_main, 0, 4, -1.5f, -1.2f, -1.5f, 3, 1, 3, -0.1f, false));
            }

            public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                this.bb_main.func_78785_a(f5);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderSeal
        extends Render<EC> {
            private final ResourceLocation texture;
            protected ModelBase mainModel;

            public RenderSeal(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.texture = new ResourceLocation("narutomod:textures/sealing_circle.png");
                this.mainModel = new ModelSeal();
            }

            public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
                this.func_180548_c(entity);
                GlStateManager.func_179094_E();
                GlStateManager.func_179129_p();
                GlStateManager.func_179137_b((double)x, (double)(y + 0.01), (double)z);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179140_f();
                float f = partialTicks + (float)entity.field_70173_aa;
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(f / 60.0f, 1.0f));
                this.mainModel.func_78088_a((Entity)entity, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.85f);
                GlStateManager.func_179145_e();
                GlStateManager.func_179084_k();
                GlStateManager.func_179118_c();
                GlStateManager.func_179089_o();
                GlStateManager.func_179121_F();
                super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
            }

            protected ResourceLocation getEntityTexture(EC entity) {
                return this.texture;
            }
        }
    }

    public static class EntitySittingCircle
    extends MultiPartEntityPart {
        private final EC ec;

        public EntitySittingCircle(IEntityMultiPart parent, String partName) {
            super(parent, partName, 1.0f, 0.01f);
            this.ec = (EC)parent;
        }

        public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
            return player.func_184220_m((Entity)this);
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.func_184207_aI()) {
                Entity passenger = this.func_184179_bs();
                this.field_70170_p.func_72870_g(passenger);
                if (!(passenger instanceof EntityLivingBase) || passenger.func_70093_af() || !this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0 && this.ec.isSealingInProgress() && !Chakra.pathway((EntityLivingBase)passenger).consume(10.0)) {
                    passenger.func_184210_p();
                }
                if (!this.field_70170_p.field_72995_K) {
                    ProcedureSync.MultiPartsSetPassengers.sendToTracking(this.ec, this.func_145782_y());
                }
            }
            ++this.field_70173_aa;
        }

        public Entity func_184179_bs() {
            return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        }

        public double func_70042_X() {
            return -0.25;
        }
    }

    public static class EC
    extends Entity
    implements IEntityMultiPart {
        private final EntitySittingCircle[] parts = new EntitySittingCircle[4];
        private final AxisAlignedBB tableBB = new AxisAlignedBB(-1.3, 0.0, -1.3, 1.3, 0.9, 1.3);
        private EntityTailedBeast.Base bijuEntity;
        private int ticks2Death = 600;

        public EC(World world) {
            super(world);
            this.func_70105_a(13.0f, 0.01f);
            this.field_70178_ae = true;
            for (int i = 0; i < this.parts.length; ++i) {
                this.parts[i] = new EntitySittingCircle(this, "circle" + i);
            }
        }

        public EC(World worldIn, BlockPos pos) {
            this(worldIn);
            double x = 0.5 + (double)pos.func_177958_n();
            double y = pos.func_177956_o();
            double z = 0.5 + (double)pos.func_177952_p();
            this.func_70012_b(x, y, z, 0.0f, 0.0f);
        }

        protected void func_70088_a() {
        }

        public Entity[] func_70021_al() {
            return this.parts;
        }

        public World func_82194_d() {
            return this.field_70170_p;
        }

        public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
            return false;
        }

        public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
            Vec3d vec;
            AxisAlignedBB bb;
            if (!this.field_70170_p.field_72995_K && !EntityBijuManager.isJinchuriki(player) && (bb = this.tableBB.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_72327_a(vec = player.func_174824_e(1.0f), vec.func_178787_e(player.func_70040_Z().func_186678_a(4.0))) != null) {
                return player.func_184220_m((Entity)this);
            }
            return false;
        }

        public double func_70042_X() {
            return 0.7;
        }

        @Nullable
        public Entity func_184179_bs() {
            return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        }

        public void func_70106_y() {
            super.func_70106_y();
            for (int i = 0; i < this.parts.length; ++i) {
                this.parts[i].func_184226_ay();
            }
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            for (int i = 0; i < this.parts.length; ++i) {
                this.parts[i].func_70071_h_();
            }
            this.parts[0].func_70012_b(this.field_70165_t - 5.0, this.field_70163_u + 0.005, this.field_70161_v, 0.0f, 0.0f);
            this.parts[1].func_70012_b(this.field_70165_t, this.field_70163_u + 0.005, this.field_70161_v + 5.0, 0.0f, 0.0f);
            this.parts[2].func_70012_b(this.field_70165_t + 5.0, this.field_70163_u + 0.005, this.field_70161_v, 0.0f, 0.0f);
            this.parts[3].func_70012_b(this.field_70165_t, this.field_70163_u + 0.005, this.field_70161_v - 5.0, 0.0f, 0.0f);
            if (this.bijuEntity == null) {
                for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ())) {
                    if (!(entity instanceof EntityTailedBeast.Base) || ((EntityTailedBeast.Base)entity).getBijuManager().isSealed()) continue;
                    this.bijuEntity = (EntityTailedBeast.Base)entity;
                }
            }
            if (!this.field_70170_p.field_72995_K && this.bijuEntity != null) {
                if (this.bijuEntity.getBijuManager().isSealed()) {
                    this.ticks2Death = 0;
                } else if (this.func_184207_aI() && this.getSealersCount() > 0) {
                    if (!this.bijuEntity.isFuuinInProgress()) {
                        this.bijuEntity.fuuinIntoVessel(this.func_184179_bs(), 36000);
                    } else {
                        this.bijuEntity.incFuuinProgress(this.getSealersCount() - 1);
                        this.sendSealingProgress(this.bijuEntity.getFuuinProgress());
                        this.ticks2Death = 600;
                    }
                } else if (this.bijuEntity.isFuuinInProgress()) {
                    this.bijuEntity.cancelFuuin();
                    this.ticks2Death = 0;
                }
            }
            if (!this.field_70170_p.field_72995_K && --this.ticks2Death <= 0) {
                this.func_70106_y();
            }
        }

        public boolean isSealingInProgress() {
            return this.bijuEntity != null && this.bijuEntity.isFuuinInProgress();
        }

        public int getSealersCount() {
            int j = 0;
            for (int i = 0; i < this.parts.length; ++i) {
                j += this.parts[i].func_184207_aI() ? 1 : 0;
            }
            return j;
        }

        public void sendSealingProgress(float progress) {
            Entity entity = this.func_184179_bs();
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentString(String.format("%.1f", Float.valueOf(progress * 100.0f)) + "%"), true);
            }
            for (int i = 0; i < this.parts.length; ++i) {
                entity = this.parts[i].func_184179_bs();
                if (!(entity instanceof EntityPlayer)) continue;
                ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentString(String.format("%.1f", Float.valueOf(progress * 100.0f)) + "%"), true);
            }
        }

        public boolean func_70067_L() {
            return true;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                RayTraceResult rtr = ProcedureUtils.objectEntityLookingAt((Entity)entity, 10.0, true);
                if (rtr != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK && rtr.field_178784_b == EnumFacing.UP) {
                    for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)rtr.func_178782_a().func_177982_a(-6, 0, -6), (BlockPos)rtr.func_178782_a().func_177982_a(6, 0, 6))) {
                        if (!(pos.func_177951_i((Vec3i)rtr.func_178782_a()) < 49.0) || entity.field_70170_p.func_180495_p((BlockPos)pos).func_185913_b() && entity.field_70170_p.func_175623_d(pos.func_177981_b(2)) && this.isTorchOrAir(entity.field_70170_p, pos.func_177984_a(), rtr.func_178782_a())) continue;
                        return false;
                    }
                    entity.field_70170_p.func_184133_a(null, rtr.func_178782_a().func_177984_a(), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:jutsu")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    entity.field_70170_p.func_72838_d((Entity)new EC(entity.field_70170_p, rtr.func_178782_a().func_177984_a()));
                    return true;
                }
                return false;
            }

            private boolean isTorchOrAir(World world, BlockPos pos, BlockPos centerPos) {
                BlockPos[] torchPos = new BlockPos[]{new BlockPos(-2, 1, 1), new BlockPos(-1, 1, 2), new BlockPos(1, 1, 2), new BlockPos(2, 1, 1), new BlockPos(2, 1, -1), new BlockPos(1, 1, -2), new BlockPos(-1, 1, -2), new BlockPos(-2, 1, -1)};
                IBlockState blockstate = world.func_180495_p(pos);
                for (BlockPos pos1 : torchPos) {
                    if (!pos.equals((Object)centerPos.func_177971_a((Vec3i)pos1))) continue;
                    return blockstate.func_177230_c() == Blocks.field_150478_aa;
                }
                return blockstate.func_177230_c().isAir(blockstate, (IBlockAccess)world, pos);
            }
        }
    }
}

