/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public abstract class EntityShieldBase
extends EntityLivingBase {
    private static final DataParameter<Optional<UUID>> SUMMONER_UUID = EntityDataManager.func_187226_a(EntityShieldBase.class, (DataSerializer)DataSerializers.field_187203_m);
    private EntityLivingBase summoner;
    private boolean ownerCanSteer = false;
    private float steerSpeed;
    protected boolean dieOnNoPassengers = true;

    public EntityShieldBase(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_174805_g(false);
    }

    public EntityShieldBase(EntityLivingBase summonerIn) {
        this(summonerIn, summonerIn.field_70165_t, summonerIn.field_70163_u, summonerIn.field_70161_v);
    }

    public EntityShieldBase(EntityLivingBase summonerIn, double x, double y, double z) {
        this(summonerIn.field_70170_p);
        this.setSummoner(summonerIn);
        this.func_70012_b(x, y, z, summonerIn.field_70177_z, summonerIn.field_70125_A);
        this.func_174805_g(false);
        summonerIn.func_184220_m((Entity)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUMMONER_UUID, (Object)Optional.absent());
    }

    private void setSummonerUuid(UUID uuid) {
        this.field_70180_af.func_187227_b(SUMMONER_UUID, (Object)Optional.fromNullable((Object)uuid));
    }

    private UUID getSummonerUuid() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(SUMMONER_UUID)).orNull();
    }

    public void setSummoner(EntityLivingBase player) {
        this.setSummonerUuid(player.func_110124_au());
    }

    @Nullable
    public EntityLivingBase getSummoner() {
        UUID uuid = this.getSummonerUuid();
        if (uuid == null) {
            return null;
        }
        Entity entity = ProcedureUtils.getEntityFromUUID(this.field_70170_p, uuid);
        if (entity instanceof EntityLivingBase) {
            return (EntityLivingBase)entity;
        }
        return null;
    }

    public SoundEvent func_184601_bQ(DamageSource ds) {
        return null;
    }

    public SoundEvent func_184615_bR() {
        return null;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof EntityLivingBase && source.func_76364_f().equals((Object)this.func_184179_bs())) {
            return false;
        }
        if (source == DamageSource.field_76379_h || source == DamageSource.field_76367_g || source == DamageSource.field_76368_d) {
            return false;
        }
        float f = this.func_110143_aJ();
        boolean flag = super.func_70097_a(source, amount);
        EntityLivingBase summoner = this.getSummoner();
        if (flag && summoner != null && !this.func_70089_S()) {
            summoner.func_70097_a(source, CombatRules.func_189427_a((float)amount, (float)this.func_70658_aO(), (float)0.0f) - f);
        }
        return flag;
    }

    public boolean func_184230_a(EntityPlayer entity, EnumHand hand) {
        super.func_184230_a(entity, hand);
        if (!this.field_70170_p.field_72995_K && entity.equals((Object)this.getSummoner())) {
            entity.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(ProcedureUtils.MAXHEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public IAttributeInstance func_110148_a(IAttribute attribute) {
        return super.func_110148_a(attribute == SharedMonsterAttributes.field_111267_a ? ProcedureUtils.MAXHEALTH : attribute);
    }

    protected void turnBodyAndHead(Entity passenger) {
        this.field_70126_B = this.field_70177_z = passenger.field_70177_z;
        this.field_70125_A = passenger.field_70125_A;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.field_70761_aq = passenger.field_70177_z;
        this.field_70759_as = passenger.field_70177_z;
    }

    public void func_191986_a(float ti, float tj, float tk) {
        if (this.func_184207_aI()) {
            Entity entity = this.func_184179_bs();
            this.turnBodyAndHead(entity);
            if (entity instanceof EntityLivingBase && this.ownerCanSteer) {
                this.field_70747_aH = ((EntityLivingBase)entity).func_70689_ay() * 0.15f;
                this.func_70659_e((float)ProcedureUtils.getModifiedSpeed((EntityLivingBase)entity) * this.steerSpeed);
                float forward = ((EntityLivingBase)entity).field_191988_bg;
                float strafe = ((EntityLivingBase)entity).field_70702_br;
                super.func_191986_a(strafe, 0.0f, forward);
            }
        }
    }

    public double func_70042_X() {
        return 0.35;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void setOwnerCanSteer(boolean canSteer, float speed) {
        this.ownerCanSteer = canSteer;
        this.steerSpeed = speed;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    private void clampMotion(double d) {
        if (this.func_70643_av() != null && this.field_70173_aa - this.func_142015_aE() < 10) {
            if (Math.abs(this.field_70159_w) > d) {
                double d2 = this.field_70159_w = this.field_70159_w > 0.0 ? d : -d;
            }
            if (Math.abs(this.field_70181_x) > d) {
                double d3 = this.field_70181_x = this.field_70181_x > 0.0 ? d : -d;
            }
            if (Math.abs(this.field_70179_y) > d) {
                this.field_70179_y = this.field_70179_y > 0.0 ? d : -d;
            }
        }
    }

    public void func_70636_d() {
        this.func_70674_bp();
        super.func_70636_d();
        this.clampMotion(0.1);
        EntityLivingBase summoner = this.getSummoner();
        if (this.func_184188_bt().isEmpty() && this.dieOnNoPassengers || summoner != null && !summoner.func_70089_S()) {
            this.func_70106_y();
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70729_aU) {
            this.field_70729_aU = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        }
    }

    protected void func_70609_aI() {
        this.func_70106_y();
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("summonerUUID")) {
            this.setSummonerUuid(compound.func_186857_a("summonerUUID"));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        UUID suuid = this.getSummonerUuid();
        if (suuid != null) {
            compound.func_186854_a("summonerUUID", suuid);
        }
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }
}

