/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.Particles;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.entity.EntitySummonAnimal;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntitySnake
extends ElementsNarutomodMod.ModElement {
    public EntitySnake(ElementsNarutomodMod instance) {
        super(instance, 686);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(ServerMessage.Handler.class, ServerMessage.class, Side.CLIENT);
    }

    private static boolean canStandOn(World world, BlockPos pos) {
        IBlockState blockstate = world.func_180495_p(pos);
        if (blockstate.func_185904_a() == Material.field_151586_h) {
            return true;
        }
        IBlockState blockstate2 = world.func_180495_p(pos.func_177977_b());
        return !blockstate.func_185913_b() && blockstate.func_185904_a() != Material.field_151587_i && blockstate.func_185904_a() != Material.field_151581_o && blockstate2.func_185913_b() && blockstate2.func_185904_a() != Material.field_151588_w;
    }

    public static Vec3d getOffsetPoint(float x, float y, float z, float rotateX, float rotateY, float offset) {
        return new Vec3d((double)(-x) - Math.sin(rotateY) * Math.cos(rotateX) * (double)offset, (double)(-y) + Math.sin(rotateX) * (double)offset, (double)(-z) - Math.cos(rotateY) * Math.cos(rotateX) * (double)offset).func_186678_a(-1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public static class ModelSnake
    extends ModelBase {
        private final ModelRenderer headNeck;
        private final ModelRenderer head;
        private final ModelRenderer bone2;
        private final ModelRenderer bone3;
        private final ModelRenderer bone4;
        private final ModelRenderer bone5;
        private final ModelRenderer bone6;
        private final ModelRenderer bone7;
        private final ModelRenderer bone8;
        private final ModelRenderer bone9;
        private final ModelRenderer bone11;
        private final ModelRenderer bone19;
        private final ModelRenderer bone20;
        private final ModelRenderer jaw;
        private final ModelRenderer bone21;
        private final ModelRenderer bone22;
        private final ModelRenderer bone23;
        private final ModelRenderer horns;
        private final ModelRenderer bone24;
        private final ModelRenderer bone25;
        private final ModelRenderer bone26;
        private final ModelRenderer bone37;
        private final ModelRenderer[] segment = new ModelRenderer[21];
        private float partialTicks;

        public ModelSnake() {
            this.field_78090_t = 32;
            this.field_78089_u = 32;
            this.headNeck = new ModelRenderer((ModelBase)this);
            this.headNeck.func_78793_a(0.0f, 22.0f, 0.0f);
            this.headNeck.field_78804_l.add(new ModelBox(this.headNeck, 0, 0, -2.5f, -2.0f, -5.0f, 5, 4, 6, 0.0f, false));
            this.head = new ModelRenderer((ModelBase)this);
            this.head.func_78793_a(0.0f, 0.0f, -5.0f);
            this.headNeck.func_78792_a(this.head);
            this.head.field_78804_l.add(new ModelBox(this.head, 16, 0, -2.5f, -2.0f, 0.0f, 5, 4, 1, 0.1f, false));
            this.bone2 = new ModelRenderer((ModelBase)this);
            this.bone2.func_78793_a(1.4f, -0.7f, -5.35f);
            this.head.func_78792_a(this.bone2);
            this.setRotationAngle(this.bone2, 0.7854f, 0.0f, 0.6109f);
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 17, 22, -0.5f, -0.5f, 0.0f, 1, 1, 3, 0.0f, false));
            this.bone3 = new ModelRenderer((ModelBase)this);
            this.bone3.func_78793_a(0.0f, -0.5f, 3.0f);
            this.bone2.func_78792_a(this.bone3);
            this.setRotationAngle(this.bone3, -0.9599f, 0.0f, 0.0f);
            this.bone3.field_78804_l.add(new ModelBox(this.bone3, 22, 5, -0.5f, 0.0f, 0.0f, 1, 1, 3, 0.0f, false));
            this.bone4 = new ModelRenderer((ModelBase)this);
            this.bone4.func_78793_a(-1.4f, -0.7f, -5.35f);
            this.head.func_78792_a(this.bone4);
            this.setRotationAngle(this.bone4, 0.7854f, 0.0f, -0.6109f);
            this.bone4.field_78804_l.add(new ModelBox(this.bone4, 17, 22, -0.5f, -0.5f, 0.0f, 1, 1, 3, 0.0f, true));
            this.bone5 = new ModelRenderer((ModelBase)this);
            this.bone5.func_78793_a(0.0f, -0.5f, 3.0f);
            this.bone4.func_78792_a(this.bone5);
            this.setRotationAngle(this.bone5, -0.9599f, 0.0f, 0.0f);
            this.bone5.field_78804_l.add(new ModelBox(this.bone5, 22, 5, -0.5f, 0.0f, 0.0f, 1, 1, 3, 0.0f, true));
            this.bone6 = new ModelRenderer((ModelBase)this);
            this.bone6.func_78793_a(0.0f, -1.0f, 0.0f);
            this.head.func_78792_a(this.bone6);
            this.setRotationAngle(this.bone6, 0.0436f, 0.0873f, 0.0f);
            this.bone6.field_78804_l.add(new ModelBox(this.bone6, 13, 10, -0.0076f, -1.5f, -3.8257f, 3, 3, 4, 0.0f, false));
            this.bone7 = new ModelRenderer((ModelBase)this);
            this.bone7.func_78793_a(0.0f, -1.0f, 0.0f);
            this.head.func_78792_a(this.bone7);
            this.setRotationAngle(this.bone7, 0.0436f, -0.0873f, 0.0f);
            this.bone7.field_78804_l.add(new ModelBox(this.bone7, 13, 10, -2.9924f, -1.5f, -3.8257f, 3, 3, 4, 0.0f, true));
            this.bone8 = new ModelRenderer((ModelBase)this);
            this.bone8.func_78793_a(-0.15f, -1.1f, -2.5f);
            this.head.func_78792_a(this.bone8);
            this.setRotationAngle(this.bone8, 0.5236f, 0.2618f, 0.0f);
            this.bone8.field_78804_l.add(new ModelBox(this.bone8, 17, 17, -0.05f, -1.5f, -3.0757f, 3, 2, 3, 0.0f, false));
            this.bone9 = new ModelRenderer((ModelBase)this);
            this.bone9.func_78793_a(0.15f, -1.1f, -2.5f);
            this.head.func_78792_a(this.bone9);
            this.setRotationAngle(this.bone9, 0.5236f, -0.2618f, 0.0f);
            this.bone9.field_78804_l.add(new ModelBox(this.bone9, 17, 17, -2.95f, -1.5f, -3.0757f, 3, 2, 3, 0.0f, true));
            this.bone11 = new ModelRenderer((ModelBase)this);
            this.bone11.func_78793_a(2.6f, 0.1f, -3.95f);
            this.head.func_78792_a(this.bone11);
            this.setRotationAngle(this.bone11, 0.0f, 0.2618f, 0.0f);
            this.bone11.field_78804_l.add(new ModelBox(this.bone11, 10, 19, -2.0f, -1.0f, -2.75f, 2, 1, 3, 0.0f, false));
            this.bone11.field_78804_l.add(new ModelBox(this.bone11, 0, 19, -2.0f, -0.4f, -2.75f, 2, 1, 3, 0.0f, false));
            this.bone19 = new ModelRenderer((ModelBase)this);
            this.bone19.func_78793_a(-2.65f, 0.1f, -3.95f);
            this.head.func_78792_a(this.bone19);
            this.setRotationAngle(this.bone19, 0.0f, -0.2618f, 0.0f);
            this.bone19.field_78804_l.add(new ModelBox(this.bone19, 10, 19, 0.05f, -1.0f, -2.75f, 2, 1, 3, 0.0f, true));
            this.bone19.field_78804_l.add(new ModelBox(this.bone19, 0, 19, 0.05f, -0.4f, -2.75f, 2, 1, 3, 0.0f, true));
            this.bone20 = new ModelRenderer((ModelBase)this);
            this.bone20.func_78793_a(1.6f, 1.8f, -5.95f);
            this.head.func_78792_a(this.bone20);
            this.bone20.field_78804_l.add(new ModelBox(this.bone20, 0, 1, -0.2f, -1.0f, 0.0f, 0, 1, 1, 0.1f, false));
            this.bone20.field_78804_l.add(new ModelBox(this.bone20, 0, 1, -3.0f, -1.0f, 0.0f, 0, 1, 1, 0.1f, true));
            this.jaw = new ModelRenderer((ModelBase)this);
            this.jaw.func_78793_a(0.0f, 0.5f, 0.0f);
            this.head.func_78792_a(this.jaw);
            this.setRotationAngle(this.jaw, 0.0f, 0.0f, 0.0f);
            this.bone21 = new ModelRenderer((ModelBase)this);
            this.bone21.func_78793_a(3.0f, 0.9f, 0.0f);
            this.jaw.func_78792_a(this.bone21);
            this.setRotationAngle(this.bone21, 0.0f, 0.2182f, 0.0f);
            this.bone21.field_78804_l.add(new ModelBox(this.bone21, 0, 10, -3.0f, -1.0f, -6.7f, 3, 2, 7, -0.1f, false));
            this.bone22 = new ModelRenderer((ModelBase)this);
            this.bone22.func_78793_a(-3.0f, 0.9f, 0.0f);
            this.jaw.func_78792_a(this.bone22);
            this.setRotationAngle(this.bone22, 0.0f, -0.2182f, 0.0f);
            this.bone22.field_78804_l.add(new ModelBox(this.bone22, 0, 10, 0.0f, -1.0f, -6.7f, 3, 2, 7, -0.1f, true));
            this.bone23 = new ModelRenderer((ModelBase)this);
            this.bone23.func_78793_a(0.0f, -0.2f, -5.5f);
            this.jaw.func_78792_a(this.bone23);
            this.setRotationAngle(this.bone23, 3.1416f, 3.1416f, 0.0f);
            this.bone23.field_78804_l.add(new ModelBox(this.bone23, 0, 1, 1.2f, -0.5f, -0.5f, 0, 1, 1, 0.1f, false));
            this.bone23.field_78804_l.add(new ModelBox(this.bone23, 0, 1, -1.2f, -0.5f, -0.5f, 0, 1, 1, 0.1f, true));
            this.horns = new ModelRenderer((ModelBase)this);
            this.horns.func_78793_a(0.0f, 0.6f, 0.0f);
            this.head.func_78792_a(this.horns);
            this.bone24 = new ModelRenderer((ModelBase)this);
            this.bone24.func_78793_a(-2.3f, -2.5f, -1.6f);
            this.horns.func_78792_a(this.bone24);
            this.setRotationAngle(this.bone24, 0.2618f, -0.5236f, 0.0f);
            this.bone24.field_78804_l.add(new ModelBox(this.bone24, 28, 0, -0.5f, -0.5f, 0.0f, 1, 1, 1, 0.15f, false));
            this.bone24.field_78804_l.add(new ModelBox(this.bone24, 28, 0, -0.5f, -0.5f, 1.0f, 1, 1, 1, 0.1f, false));
            this.bone24.field_78804_l.add(new ModelBox(this.bone24, 28, 0, -0.5f, -0.5f, 2.0f, 1, 1, 1, 0.0f, false));
            this.bone24.field_78804_l.add(new ModelBox(this.bone24, 28, 0, -0.5f, -0.5f, 2.9f, 1, 1, 1, -0.1f, false));
            this.bone24.field_78804_l.add(new ModelBox(this.bone24, 28, 0, -0.5f, -0.5f, 3.6f, 1, 1, 1, -0.2f, false));
            this.bone24.field_78804_l.add(new ModelBox(this.bone24, 28, 0, -0.5f, -0.5f, 4.1f, 1, 1, 1, -0.3f, false));
            this.bone25 = new ModelRenderer((ModelBase)this);
            this.bone25.func_78793_a(-1.2f, -2.5f, -1.2f);
            this.horns.func_78792_a(this.bone25);
            this.setRotationAngle(this.bone25, 0.4363f, -0.3491f, 0.0f);
            this.bone25.field_78804_l.add(new ModelBox(this.bone25, 28, 0, -0.5f, -0.5f, 0.0f, 1, 1, 1, 0.1f, false));
            this.bone25.field_78804_l.add(new ModelBox(this.bone25, 28, 0, -0.5f, -0.5f, 0.9f, 1, 1, 1, -0.05f, false));
            this.bone25.field_78804_l.add(new ModelBox(this.bone25, 28, 0, -0.5f, -0.5f, 1.6f, 1, 1, 1, -0.2f, false));
            this.bone25.field_78804_l.add(new ModelBox(this.bone25, 28, 0, -0.5f, -0.5f, 2.1f, 1, 1, 1, -0.3f, false));
            this.bone26 = new ModelRenderer((ModelBase)this);
            this.bone26.func_78793_a(1.2f, -2.5f, -1.2f);
            this.horns.func_78792_a(this.bone26);
            this.setRotationAngle(this.bone26, 0.4363f, 0.3491f, 0.0f);
            this.bone26.field_78804_l.add(new ModelBox(this.bone26, 28, 0, -0.5f, -0.5f, 0.0f, 1, 1, 1, 0.1f, true));
            this.bone26.field_78804_l.add(new ModelBox(this.bone26, 28, 0, -0.5f, -0.5f, 0.9f, 1, 1, 1, -0.05f, true));
            this.bone26.field_78804_l.add(new ModelBox(this.bone26, 28, 0, -0.5f, -0.5f, 1.6f, 1, 1, 1, -0.2f, true));
            this.bone26.field_78804_l.add(new ModelBox(this.bone26, 28, 0, -0.5f, -0.5f, 2.1f, 1, 1, 1, -0.3f, true));
            this.bone37 = new ModelRenderer((ModelBase)this);
            this.bone37.func_78793_a(2.3f, -2.5f, -1.6f);
            this.horns.func_78792_a(this.bone37);
            this.setRotationAngle(this.bone37, 0.2618f, 0.5236f, 0.0f);
            this.bone37.field_78804_l.add(new ModelBox(this.bone37, 28, 0, -0.5f, -0.5f, 0.0f, 1, 1, 1, 0.15f, true));
            this.bone37.field_78804_l.add(new ModelBox(this.bone37, 28, 0, -0.5f, -0.5f, 1.0f, 1, 1, 1, 0.1f, true));
            this.bone37.field_78804_l.add(new ModelBox(this.bone37, 28, 0, -0.5f, -0.5f, 2.0f, 1, 1, 1, 0.0f, true));
            this.bone37.field_78804_l.add(new ModelBox(this.bone37, 28, 0, -0.5f, -0.5f, 2.9f, 1, 1, 1, -0.1f, true));
            this.bone37.field_78804_l.add(new ModelBox(this.bone37, 28, 0, -0.5f, -0.5f, 3.6f, 1, 1, 1, -0.2f, true));
            this.bone37.field_78804_l.add(new ModelBox(this.bone37, 28, 0, -0.5f, -0.5f, 4.1f, 1, 1, 1, -0.3f, true));
            for (int i = 0; i < 21; ++i) {
                this.segment[i] = new ModelRenderer((ModelBase)this);
                this.segment[i].field_78804_l.add(new ModelBox(this.segment[i], 0, 0, -2.5f, -2.0f, -1.0f, 5, 4, 6, i >= 12 ? (float)(11 - i) * 0.2f : 0.0f, false));
            }
        }

        public void func_78086_a(EntityLivingBase entityIn, float limbSwing, float limbSwingAmount, float partialTicksIn) {
            this.partialTicks = partialTicksIn;
        }

        public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            EntityCustom entity = (EntityCustom)entityIn;
            this.headNeck.field_78796_g = netHeadYaw * 0.5f * ((float)Math.PI / 180);
            this.head.field_78796_g = netHeadYaw * 0.5f * ((float)Math.PI / 180);
            if (headPitch == 0.0f) {
                this.headNeck.field_78795_f = -0.2618f;
                this.head.field_78795_f = 0.2618f;
            } else {
                this.headNeck.field_78795_f = headPitch * 0.5f * ((float)Math.PI / 180);
                this.head.field_78795_f = headPitch * 0.5f * ((float)Math.PI / 180);
            }
            if (entity.getPhase() == Phase.AGGRESIVE) {
                this.headNeck.field_78795_f -= 0.2618f;
                this.head.field_78795_f += 0.1745f;
                this.jaw.field_78795_f = 0.5236f;
            } else {
                this.jaw.field_78795_f = 0.0f;
            }
            float mscale = entity.getScale();
            float yOffset = 0.0f;
            if (entity.phaseManager.getPhase().getType() == Phase.DEFENSIVE) {
                yOffset = (float)entity.phaseManager.getPhase().getYOffset() * mscale * 0.0625f;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)(1.5f - 1.5f * mscale - yOffset), (float)0.0f);
            GlStateManager.func_179152_a((float)mscale, (float)mscale, (float)mscale);
            this.headNeck.func_78785_a(scale);
            Vec3d vec = new Vec3d((double)this.headNeck.field_78800_c, (double)this.headNeck.field_78797_d, (double)this.headNeck.field_78798_e);
            float f0 = 0.0f;
            for (int i = 1; i < entity.parts.length; ++i) {
                this.segment[i - 1].func_78793_a((float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c);
                ProcedureUtils.Vec2f vec0 = entity.getMovementOffsets(i, this.partialTicks);
                f0 = MathHelper.func_76142_g((float)(f0 - vec0.x));
                this.setRotationAngle(this.segment[i - 1], -vec0.y * ((float)Math.PI / 180), f0 * ((float)Math.PI / 180), 0.0f);
                this.segment[i - 1].func_78785_a(scale);
                vec = this.getNextSegmentRotationPoint(this.segment[i - 1], 4.0f);
            }
            GlStateManager.func_179121_F();
        }

        private Vec3d getNextSegmentRotationPoint(ModelRenderer modelrenderer, float offset) {
            return EntitySnake.getOffsetPoint(modelrenderer.field_78800_c, modelrenderer.field_78797_d, modelrenderer.field_78798_e, modelrenderer.field_78795_f, modelrenderer.field_78796_g, offset);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class RenderSnake<T extends EntityCustom>
    extends RenderLiving<T> {
        public RenderSnake(RenderManager renderManagerIn) {
            super(renderManagerIn, (ModelBase)new ModelSnake(), 0.3f);
        }

        protected ResourceLocation getEntityTexture(T entity) {
            return null;
        }
    }

    public static class ServerMessage
    implements IMessage {
        int id;
        float[] x = new float[21];
        float[] y = new float[21];

        public ServerMessage() {
        }

        public ServerMessage(EntityCustom entity) {
            this.id = entity.func_145782_y();
            for (int i = 0; i < 21 && i < entity.partRot.size(); ++i) {
                ProcedureUtils.Vec2f vec = (ProcedureUtils.Vec2f)entity.partRot.get(i);
                this.x[i] = vec.x;
                this.y[i] = vec.y;
            }
        }

        public static void sendToTracking(EntityCustom entity) {
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new ServerMessage(entity), (Entity)entity);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            for (int i = 0; i < 21; ++i) {
                buf.writeFloat(this.x[i]);
                buf.writeFloat(this.y[i]);
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            for (int i = 0; i < 21; ++i) {
                this.x[i] = buf.readFloat();
                this.y[i] = buf.readFloat();
            }
        }

        public static class Handler
        implements IMessageHandler<ServerMessage, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(ServerMessage message, MessageContext context) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> {
                    Entity entity = mc.field_71441_e.func_73045_a(message.id);
                    if (entity instanceof EntityCustom) {
                        for (int i = 0; i < ((EntityCustom)entity).partRot.size(); ++i) {
                            ((EntityCustom)entity).partRot.set(i, new ProcedureUtils.Vec2f(message.x[i], message.y[i]));
                        }
                    }
                });
                return null;
            }
        }
    }

    public static class PhaseRiding
    extends PhaseBase {
        private static final ProcedureUtils.Vec2f[][] RIDINGROTATIONS = new ProcedureUtils.Vec2f[][]{{new ProcedureUtils.Vec2f(0.0f, 0.0f), new ProcedureUtils.Vec2f(0.0f, 30.0f), new ProcedureUtils.Vec2f(0.0f, 60.0f), new ProcedureUtils.Vec2f(0.0f, 90.0f), new ProcedureUtils.Vec2f(0.0f, 120.0f), new ProcedureUtils.Vec2f(0.0f, 150.0f), new ProcedureUtils.Vec2f(0.0f, 180.0f), new ProcedureUtils.Vec2f(-45.0f, 180.0f), new ProcedureUtils.Vec2f(-30.0f, 180.0f), new ProcedureUtils.Vec2f(-30.0f, 180.0f), new ProcedureUtils.Vec2f(-45.0f, 180.0f), new ProcedureUtils.Vec2f(-30.0f, 180.0f), new ProcedureUtils.Vec2f(-30.0f, 195.0f), new ProcedureUtils.Vec2f(0.0f, 210.0f), new ProcedureUtils.Vec2f(15.0f, 225.0f), new ProcedureUtils.Vec2f(0.0f, 240.0f), new ProcedureUtils.Vec2f(0.0f, 255.0f), new ProcedureUtils.Vec2f(0.0f, 270.0f), new ProcedureUtils.Vec2f(0.0f, 255.0f), new ProcedureUtils.Vec2f(0.0f, 240.0f), new ProcedureUtils.Vec2f(0.0f, 225.0f)}, {new ProcedureUtils.Vec2f(0.0f, 0.0f), new ProcedureUtils.Vec2f(0.0f, 30.0f), new ProcedureUtils.Vec2f(0.0f, 60.0f), new ProcedureUtils.Vec2f(0.0f, 90.0f), new ProcedureUtils.Vec2f(0.0f, 120.0f), new ProcedureUtils.Vec2f(0.0f, 150.0f), new ProcedureUtils.Vec2f(0.0f, 180.0f), new ProcedureUtils.Vec2f(45.0f, 180.0f), new ProcedureUtils.Vec2f(30.0f, 180.0f), new ProcedureUtils.Vec2f(30.0f, 180.0f), new ProcedureUtils.Vec2f(45.0f, 180.0f), new ProcedureUtils.Vec2f(30.0f, 180.0f), new ProcedureUtils.Vec2f(30.0f, 195.0f), new ProcedureUtils.Vec2f(0.0f, 210.0f), new ProcedureUtils.Vec2f(-15.0f, 225.0f), new ProcedureUtils.Vec2f(0.0f, 240.0f), new ProcedureUtils.Vec2f(0.0f, 255.0f), new ProcedureUtils.Vec2f(0.0f, 270.0f), new ProcedureUtils.Vec2f(0.0f, 255.0f), new ProcedureUtils.Vec2f(0.0f, 240.0f), new ProcedureUtils.Vec2f(0.0f, 225.0f)}};
        private final int transitionTime = 20;

        public PhaseRiding(PhaseManager phaseManager) {
            super(phaseManager);
        }

        @Override
        public Phase getType() {
            return Phase.RIDING;
        }

        @Override
        public void onUpdate() {
            if (this.entity.func_184218_aH()) {
                ProcedureUtils.Vec2f[] rotations = RIDINGROTATIONS[this.entity.func_184187_bx().func_184188_bt().indexOf((Object)this.entity)];
                for (int i = 0; i < this.entity.partRot.size(); ++i) {
                    this.entity.partRot.set(i, rotations[i]);
                }
            }
            super.onUpdate();
        }
    }

    public static class PhaseDefensive
    extends PhaseBase {
        private static final ProcedureUtils.Vec2f[] STARTROTATIONS = new ProcedureUtils.Vec2f[]{new ProcedureUtils.Vec2f(0.0f, 60.0f), new ProcedureUtils.Vec2f(0.0f, 105.0f), new ProcedureUtils.Vec2f(0.0f, 135.0f), new ProcedureUtils.Vec2f(0.0f, 90.0f), new ProcedureUtils.Vec2f(0.0f, 45.0f), new ProcedureUtils.Vec2f(0.0f, 0.0f), new ProcedureUtils.Vec2f(60.0f, 0.0f), new ProcedureUtils.Vec2f(60.0f, 0.0f), new ProcedureUtils.Vec2f(45.0f, 0.0f), new ProcedureUtils.Vec2f(30.0f, 0.0f), new ProcedureUtils.Vec2f(30.0f, 0.0f), new ProcedureUtils.Vec2f(30.0f, 0.0f), new ProcedureUtils.Vec2f(30.0f, 0.0f), new ProcedureUtils.Vec2f(30.0f, 0.0f), new ProcedureUtils.Vec2f(30.0f, 0.0f), new ProcedureUtils.Vec2f(30.0f, 0.0f), new ProcedureUtils.Vec2f(15.0f, 0.0f), new ProcedureUtils.Vec2f(30.0f, 0.0f), new ProcedureUtils.Vec2f(15.0f, 0.0f), new ProcedureUtils.Vec2f(30.0f, 0.0f), new ProcedureUtils.Vec2f(30.0f, 0.0f)};
        private static final ProcedureUtils.Vec2f[] ENDROTATIONS = new ProcedureUtils.Vec2f[]{new ProcedureUtils.Vec2f(0.0f, 0.0f), new ProcedureUtils.Vec2f(0.0f, -45.0f), new ProcedureUtils.Vec2f(0.0f, -15.0f), new ProcedureUtils.Vec2f(0.0f, 15.0f), new ProcedureUtils.Vec2f(0.0f, 45.0f)};
        private final ProcedureUtils.Vec2f[] rotationOffsets = new ProcedureUtils.Vec2f[STARTROTATIONS.length];
        private final int transitionTime = 20;
        private int startTime2Finish = 20;
        private int endTime2Finish = -1;

        public PhaseDefensive(PhaseManager phaseManager) {
            super(phaseManager);
            for (int i = 0; i < STARTROTATIONS.length && i < this.entity.partRot.size(); ++i) {
                this.rotationOffsets[i] = STARTROTATIONS[i].subtract((ProcedureUtils.Vec2f)this.entity.partRot.get(i));
            }
        }

        @Override
        public Phase getType() {
            return Phase.DEFENSIVE;
        }

        @Override
        public void onUpdate() {
            if (this.endTime2Finish > 0) {
                --this.endTime2Finish;
                float f = this.endTime2Finish;
                this.getClass();
                float f2 = f / 20.0f;
                for (int i = 0; i < ENDROTATIONS.length; ++i) {
                    this.entity.partRot.set(i, ENDROTATIONS[i].subtract(this.rotationOffsets[i].scale(f2)));
                }
            } else if (this.startTime2Finish > 0 && (this.startTime2Finish < this.transitionTime || this.entity.field_70122_E)) {
                --this.startTime2Finish;
                float f = this.startTime2Finish;
                this.getClass();
                float f3 = f / 20.0f;
                for (int i = 0; i < this.entity.partRot.size(); ++i) {
                    this.entity.partRot.set(i, STARTROTATIONS[i].subtract(this.rotationOffsets[i].scale(f3)));
                }
            }
            if (this.startTime2Finish != this.transitionTime) {
                this.entity.field_70159_w = 0.0;
                this.entity.field_70179_y = 0.0;
            }
            super.onUpdate();
        }

        @Override
        protected void finishPhase() {
            if (this.endTime2Finish < 0) {
                this.endTime2Finish = this.startTime2Finish > 0 ? this.transitionTime - this.startTime2Finish : this.transitionTime;
                for (int i = 0; i < ENDROTATIONS.length; ++i) {
                    this.rotationOffsets[i] = ENDROTATIONS[i].subtract(STARTROTATIONS[i]);
                }
            }
        }

        @Override
        protected boolean isPhaseFinished() {
            return this.nextPhase == Phase.RIDING || this.endTime2Finish == 0;
        }

        @Override
        protected double getYOffset() {
            float f;
            if (this.endTime2Finish >= 0) {
                float f2 = this.endTime2Finish;
                this.getClass();
                f = f2 / 20.0f;
            } else {
                float f3 = this.startTime2Finish;
                this.getClass();
                f = 1.0f - f3 / 20.0f;
            }
            return 17.0f * f;
        }
    }

    public static class PhaseAggresive
    extends PhaseRoaming {
        public PhaseAggresive(PhaseManager phaseManager) {
            super(phaseManager);
        }

        @Override
        public Phase getType() {
            return Phase.AGGRESIVE;
        }
    }

    public static class PhaseRoaming
    extends PhaseBase {
        private Vec3d lastVec;
        private float prevYaw;
        private final List<Vec3d> lastPivots = Lists.newArrayList();

        public PhaseRoaming(PhaseManager phaseManager) {
            super(phaseManager);
            this.lastVec = this.entity.func_174791_d();
            this.prevYaw = this.entity.field_70761_aq;
        }

        @Override
        public Phase getType() {
            return Phase.ROAMING;
        }

        @Override
        public void onUpdate() {
            Vec3d cposvec = this.entity.func_174791_d();
            float slength = this.entity.getScale() * 4.0f * 0.0625f;
            ProcedureUtils.Vec2f vec0 = new ProcedureUtils.Vec2f(this.entity.field_70761_aq, this.entity.yOffset2Pitch((float)(cposvec.field_72448_b - this.entity.field_70167_r), slength));
            ProcedureUtils.Vec2f vec = vec0.subtract(new ProcedureUtils.Vec2f(this.prevYaw, 0.0f));
            Vec3d vec4 = cposvec.func_178788_d(this.lastVec);
            double d4 = vec4.func_72433_c();
            if (d4 >= (double)slength) {
                this.entity.partRot.add(0, vec);
                this.entity.partRot.remove(this.entity.parts.length - 1);
                this.lastVec = vec4.func_186678_a((double)slength / d4).func_178787_e(this.lastVec);
            } else {
                int i = 0;
                float f0 = 0.0f;
                do {
                    vec0 = (ProcedureUtils.Vec2f)this.entity.partRot.get(i);
                } while (((f0 = MathHelper.func_76142_g((float)(vec0.x + vec.x))) > 90.0f || f0 < -90.0f) && ++i < this.entity.partRot.size());
                if (i < this.entity.partRot.size()) {
                    this.entity.partRot.set(i, new ProcedureUtils.Vec2f(f0, vec0.y));
                }
                vec0 = (ProcedureUtils.Vec2f)this.entity.partRot.get(0);
                this.entity.partRot.set(0, new ProcedureUtils.Vec2f(vec0.x, MathHelper.func_76142_g((float)(vec0.y + vec.y))));
            }
            this.prevYaw = this.entity.field_70761_aq;
            super.onUpdate();
        }
    }

    public static abstract class PhaseBase {
        protected final PhaseManager manager;
        protected final EntityCustom entity;
        protected Phase nextPhase;

        public PhaseBase(PhaseManager phaseManager) {
            this.manager = phaseManager;
            this.entity = phaseManager.entity;
        }

        public abstract Phase getType();

        public void onUpdate() {
            if (this.nextPhase != null && this.isPhaseFinished()) {
                this.manager.setPhase(this.nextPhase);
                this.nextPhase = null;
            }
        }

        protected boolean setNextPhase(Phase phase) {
            if (!this.isPhaseFinished()) {
                this.finishPhase();
                this.nextPhase = phase;
                return true;
            }
            return false;
        }

        protected void finishPhase() {
        }

        protected boolean isPhaseFinished() {
            return true;
        }

        protected double getYOffset() {
            return 0.0;
        }
    }

    public static class PhaseManager {
        private final EntityCustom entity;
        private PhaseBase phase;

        public PhaseManager(EntityCustom entityIn) {
            this.entity = entityIn;
        }

        public void setPhase(Phase phaseIn) {
            if (!(this.phase != null && phaseIn == this.phase.getType() || this.phase != null && this.phase.setNextPhase(phaseIn))) {
                this.phase = phaseIn.createPhase(this);
                this.entity.setPhase(phaseIn);
            }
        }

        public PhaseBase getPhase() {
            return this.phase;
        }
    }

    public static enum Phase {
        DEFENSIVE(0, PhaseDefensive.class),
        ROAMING(1, PhaseRoaming.class),
        AGGRESIVE(2, PhaseAggresive.class),
        RIDING(3, PhaseRiding.class);

        private final int id;
        private final Class<? extends PhaseBase> clazz;
        private static final Map<Integer, Phase> PHASES;

        private Phase(int i, Class<? extends PhaseBase> classIn) {
            this.id = i;
            this.clazz = classIn;
        }

        public PhaseBase createPhase(PhaseManager phaseManager) {
            try {
                Constructor<? extends PhaseBase> constructor = this.getConstructor();
                return constructor.newInstance(phaseManager);
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }

        private Constructor<? extends PhaseBase> getConstructor() throws NoSuchMethodException {
            return this.clazz.getConstructor(PhaseManager.class);
        }

        public int getID() {
            return this.id;
        }

        public static Phase getPhaseFromId(int i) {
            return PHASES.get(i);
        }

        static {
            PHASES = Maps.newHashMap();
            for (Phase phase : Phase.values()) {
                PHASES.put(phase.getID(), phase);
            }
        }
    }

    static class MoveHelper
    extends EntityMoveHelper {
        private int strafe;

        MoveHelper(EntityCustom entityIn) {
            super((EntityLiving)entityIn);
        }

        public void func_75641_c() {
            if (this.func_75640_a()) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                Vec3d vec0 = new Vec3d(this.field_75646_b, this.field_75647_c, this.field_75644_d).func_178788_d(this.field_75648_a.func_174791_d());
                double d = vec0.func_189985_c();
                if (d < 0.25 * (double)this.field_75648_a.field_70130_N * (double)this.field_75648_a.field_70130_N) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float f = (float)(this.field_75645_e * ProcedureUtils.getModifiedSpeed((EntityLivingBase)this.field_75648_a));
                if (d > 2.25 * (double)this.field_75648_a.field_70130_N * (double)this.field_75648_a.field_70130_N) {
                    vec0 = vec0.func_178785_b(MathHelper.func_76126_a((float)(0.3f * (float)this.strafe++)) * 0.5236f);
                }
                float f9 = (float)(MathHelper.func_181159_b((double)vec0.field_72449_c, (double)vec0.field_72450_a) * 180.0 / Math.PI) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f9, 30.0f);
                if (this.field_75648_a.func_70090_H()) {
                    Vec3d vec1 = vec0.func_72432_b().func_186678_a((double)f);
                    this.field_75648_a.field_70159_w = vec1.field_72450_a;
                    this.field_75648_a.field_70181_x = vec1.field_72448_b;
                    this.field_75648_a.field_70179_y = vec1.field_72449_c;
                } else {
                    this.field_75648_a.func_70659_e(f);
                }
                if (this.field_75648_a.field_70123_F) {
                    this.field_75648_a.field_70181_x = 0.2 + 0.2 * (double)this.field_75648_a.field_70131_O;
                }
            } else {
                this.field_75648_a.func_191989_p(0.0f);
                this.field_75648_a.func_70657_f(0.0f);
            }
        }
    }

    static class NavigateSwim
    extends PathNavigateSwimmer {
        private BlockPos targetPosition;

        public NavigateSwim(EntityCustom entityLivingIn, World worldIn) {
            super((EntityLiving)entityLivingIn, worldIn);
        }

        public Path func_179680_a(BlockPos pos) {
            this.targetPosition = pos;
            return super.func_179680_a(pos);
        }

        public Path func_75494_a(Entity entityIn) {
            this.targetPosition = new BlockPos(entityIn);
            return super.func_75494_a(entityIn);
        }

        public boolean func_75497_a(Entity entityIn, double speedIn) {
            Path path = this.func_75494_a(entityIn);
            if (path != null) {
                return this.func_75484_a(path, speedIn);
            }
            this.targetPosition = new BlockPos(entityIn);
            this.field_75511_d = speedIn;
            return true;
        }

        public void func_75501_e() {
            if (!this.func_75500_f()) {
                super.func_75501_e();
            } else if (this.targetPosition != null) {
                double d0 = this.field_75515_a.field_70130_N * this.field_75515_a.field_70130_N;
                double d1 = (double)this.targetPosition.func_177956_o() - this.field_75515_a.field_70163_u;
                if (this.field_75515_a.func_174831_c(this.targetPosition) >= d0 && d1 <= (double)this.field_75515_a.field_70131_O * 4.0) {
                    this.field_75515_a.func_70605_aq().func_75642_a((double)this.targetPosition.func_177958_n(), (double)this.targetPosition.func_177956_o(), (double)this.targetPosition.func_177952_p(), this.field_75511_d);
                } else {
                    this.targetPosition = null;
                }
            }
        }

        public boolean func_188555_b(BlockPos pos) {
            return EntitySnake.canStandOn(this.field_75513_b, pos);
        }
    }

    static class Navigate
    extends EntitySummonAnimal.NavigateGround {
        private BlockPos targetPosition;

        public Navigate(EntityCustom entityLivingIn, World worldIn) {
            super(entityLivingIn, worldIn);
        }

        public Path func_179680_a(BlockPos pos) {
            this.targetPosition = pos;
            return super.func_179680_a(pos);
        }

        public Path func_75494_a(Entity entityIn) {
            this.targetPosition = new BlockPos(entityIn);
            return super.func_75494_a(entityIn);
        }

        public boolean func_75497_a(Entity entityIn, double speedIn) {
            Path path = this.func_75494_a(entityIn);
            if (path != null) {
                return this.func_75484_a(path, speedIn);
            }
            this.targetPosition = new BlockPos(entityIn);
            this.field_75511_d = speedIn;
            return true;
        }

        public void func_75499_g() {
            super.func_75499_g();
            this.targetPosition = null;
        }

        public void func_75501_e() {
            if (!this.func_75500_f()) {
                super.func_75501_e();
            } else if (this.targetPosition != null) {
                double d0 = this.field_75515_a.field_70130_N * this.field_75515_a.field_70130_N;
                double d1 = (double)this.targetPosition.func_177956_o() - this.field_75515_a.field_70163_u;
                double d2 = this.field_75515_a.func_174831_c(new BlockPos(this.targetPosition.func_177958_n(), MathHelper.func_76128_c((double)this.field_75515_a.field_70163_u), this.targetPosition.func_177952_p()));
                if (d2 >= d0 || d1 <= 8.0 * (double)this.field_75515_a.field_70131_O && d1 >= -12.0 * (double)this.field_75515_a.field_70131_O) {
                    this.field_75515_a.func_70605_aq().func_75642_a((double)this.targetPosition.func_177958_n() + 0.5, (double)this.targetPosition.func_177956_o(), (double)this.targetPosition.func_177952_p() + 0.5, this.field_75511_d);
                } else {
                    this.targetPosition = null;
                }
            }
        }

        public boolean func_188555_b(BlockPos pos) {
            return EntitySnake.canStandOn(this.field_75513_b, pos);
        }
    }

    public static class SnakeSegment
    extends MultiPartEntityPart {
        private final EntityCustom head;

        public SnakeSegment(EntityCustom parentIn, String partName, float width, float height) {
            super((IEntityMultiPart)parentIn, partName, width, height);
            this.head = parentIn;
        }

        protected void func_70105_a(float width, float height) {
            super.func_70105_a(width, height);
        }

        public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
            return this.head.func_184230_a(player, hand);
        }
    }

    public static abstract class EntityCustom
    extends EntitySummonAnimal.Base
    implements IEntityMultiPart {
        private static final DataParameter<Integer> PHASE = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187192_b);
        private SnakeSegment[] parts = new SnakeSegment[22];
        private List<ProcedureUtils.Vec2f> partRot = Lists.newArrayList();
        private final PathNavigate altNavigator;
        private final PathNavigate mainNavigator;
        private final EntityMoveHelper altMoveHelper;
        private final EntityMoveHelper mainMoveHelper;
        private final PhaseManager phaseManager;
        private boolean needsSync;
        private boolean prevOnGround;
        private boolean defensive;
        private final EntityAIWander wanderAI = new EntityAIWander(this, 0.8, 10){

            public boolean func_75250_a() {
                Phase phase = this.getPhaseManager().getPhase().getType();
                return phase != Phase.DEFENSIVE && phase != Phase.RIDING && super.func_75250_a();
            }

            @Nullable
            protected Vec3d func_190864_f() {
                float f = this.getScale();
                Vec3d vec = this.field_75457_a.func_174791_d();
                while (vec != null && vec.func_72438_d(this.field_75457_a.func_174791_d()) < 4.0 + (double)f) {
                    vec = RandomPositionGenerator.func_75463_a((EntityCreature)this.field_75457_a, (int)(4 + (int)(f * 3.0f)), (int)(6 + (int)f));
                }
                return vec;
            }
        };

        public EntityCustom(World worldIn) {
            super(worldIn);
            this.setOGSize(0.3f, 0.25f);
            this.field_70178_ae = false;
            this.func_94061_f(false);
            this.dontWander(false);
            this.field_70158_ak = true;
            this.mainNavigator = this.field_70699_by;
            this.altNavigator = new NavigateSwim(this, worldIn);
            this.mainMoveHelper = this.field_70765_h = new MoveHelper(this);
            this.altMoveHelper = new EntityNinjaMob.SwimHelper((EntityLiving)this);
            this.field_70177_z = 0.0f;
            this.field_70759_as = 0.0f;
            this.field_70126_B = 0.0f;
            this.field_70758_at = 0.0f;
            this.phaseManager = new PhaseManager(this);
            float f = this.getScale();
            this.parts[0] = new SnakeSegment(this, "head", this.ogWidth * f, this.ogWidth * f);
            for (int i = 1; i < this.parts.length; ++i) {
                this.parts[i] = new SnakeSegment(this, "segment" + i, this.ogHeight * f, this.ogHeight * f);
                this.partRot.add(ProcedureUtils.Vec2f.ZERO);
            }
        }

        public EntityCustom(EntityLivingBase summonerIn) {
            this(summonerIn.field_70170_p);
            this.setSummoner(summonerIn);
            this.phaseManager.setPhase(Phase.DEFENSIVE);
            this.dontWander(true);
        }

        @Override
        public void func_70088_a() {
            super.func_70088_a();
            this.func_184212_Q().func_187214_a(PHASE, (Object)Phase.DEFENSIVE.getID());
        }

        @Override
        public void func_184206_a(DataParameter<?> key) {
            super.func_184206_a(key);
            if (SCALE.equals(key) && this.field_70170_p.field_72995_K) {
                this.resizeSegments(this.getScale());
            } else if (PHASE.equals(key) && this.field_70170_p.field_72995_K) {
                this.phaseManager.setPhase(this.getPhase());
            }
        }

        private Phase getPhase() {
            return Phase.getPhaseFromId((Integer)this.func_184212_Q().func_187225_a(PHASE));
        }

        private void setPhase(Phase phase) {
            this.func_184212_Q().func_187227_b(PHASE, (Object)phase.getID());
        }

        protected PhaseManager getPhaseManager() {
            return this.phaseManager;
        }

        protected PathNavigate func_175447_b(World worldIn) {
            Navigate navi = new Navigate(this, worldIn);
            navi.func_179693_d(true);
            return navi;
        }

        public Entity[] func_70021_al() {
            return this.parts;
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:snake_hiss"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return SoundEvents.field_187543_bD;
        }

        public SoundEvent func_184615_bR() {
            return SoundEvents.field_187661_by;
        }

        protected void func_180429_a(BlockPos pos, Block blockIn) {
            this.func_184185_a(SoundEvents.field_187592_bb, 0.1f * this.getScale(), this.field_70146_Z.nextFloat() * 0.4f + 0.9f);
        }

        protected SoundEvent func_184184_Z() {
            return SoundEvents.field_187917_gq;
        }

        protected float func_70599_aP() {
            return this.getScale() * 0.2f;
        }

        @Override
        protected void postScaleFixup() {
            float f = this.getScale();
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(5.0 * (double)f);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25 + (double)f * 0.05);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0 * (double)f * (double)f);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.3333 * (double)f);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(13.0 + 3.0 * (double)f);
            super.postScaleFixup();
            this.resizeSegments(f);
            this.field_70728_aV = (int)(f * 10.0f);
        }

        private void resizeSegments(float scale) {
            this.parts[0].func_70105_a(this.ogWidth * scale, this.ogWidth * scale);
            for (int i = 0; i < this.parts.length; ++i) {
                this.parts[i].func_70105_a(this.ogHeight * scale, this.ogHeight * scale);
            }
        }

        public boolean func_96092_aw() {
            return false;
        }

        public boolean func_70648_aU() {
            return true;
        }

        protected float func_189749_co() {
            return 1.0f;
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 5.0f, 0.1f){

                public boolean func_75250_a() {
                    this.field_75333_c = 3.8f + 4.0f * this.field_75332_b.field_70130_N;
                    if (!this.field_75332_b.func_184218_aH() && this.field_75332_b.func_70638_az() == null && this.field_75332_b.func_70681_au().nextFloat() < 0.1f) {
                        this.field_75334_a = this.field_75332_b.field_70170_p.func_190525_a(this.field_75332_b.field_70165_t, this.field_75332_b.field_70163_u, this.field_75332_b.field_70161_v, (double)this.field_75333_c, Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)EntitySelectors.func_191324_b((Entity)this.field_75332_b)));
                        return this.field_75334_a != null;
                    }
                    return false;
                }

                public boolean func_75253_b() {
                    return !this.field_75332_b.func_184218_aH() && this.field_75334_a.func_70089_S() && this.field_75332_b.func_70068_e(this.field_75334_a) <= (double)(this.field_75333_c * this.field_75333_c);
                }

                public void func_75249_e() {
                    defensive = true;
                }

                public void func_75251_c() {
                    super.func_75251_c();
                    defensive = false;
                }
            });
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        }

        @Override
        protected void dontWander(boolean dont) {
            if (dont) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.wanderAI);
            } else {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.wanderAI);
            }
        }

        @Override
        protected void func_70619_bc() {
            if (this.func_70090_H() && this.field_70699_by != this.altNavigator) {
                this.field_70699_by = this.altNavigator;
            } else if (!this.func_70090_H() && this.field_70699_by != this.mainNavigator) {
                this.field_70699_by = this.mainNavigator;
            }
            this.phaseManager.setPhase(this.ageTicks < 20 ? Phase.DEFENSIVE : (this.func_184218_aH() ? Phase.RIDING : (this.func_70638_az() != null && this.func_70638_az().func_70089_S() ? Phase.AGGRESIVE : (this.defensive && !this.func_70090_H() ? Phase.DEFENSIVE : Phase.ROAMING))));
            super.func_70619_bc();
        }

        @Override
        public boolean couldBreakBlocks() {
            return this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && this.getScale() >= 4.0f;
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            this.syncParts();
            this.phaseManager.getPhase().onUpdate();
            this.parts[0].func_70071_h_();
            Vec3d vec2 = Vec3d.field_186680_a;
            float f = this.getScale() * 0.0625f;
            float f0 = MathHelper.func_76142_g((float)((this.field_70759_as - this.field_70761_aq) * 0.5f + this.field_70761_aq)) * ((float)Math.PI / 180);
            float f0a = MathHelper.func_76142_g((float)this.field_70759_as) * ((float)Math.PI / 180);
            float f1 = this.field_70125_A * ((float)Math.PI / 180);
            Vec3d vec3 = EntitySnake.getOffsetPoint((float)vec2.field_72450_a, (float)vec2.field_72448_b, (float)vec2.field_72449_c, f1 == 0.0f ? -0.2618f : f1 * 0.5f, -f0, 5.0f * f);
            vec3 = EntitySnake.getOffsetPoint((float)vec3.field_72450_a, (float)vec3.field_72448_b, (float)vec3.field_72449_c, f1 == 0.0f ? 0.2618f : f1, -f0a, 3.0f * f).func_178787_e(this.func_174791_d()).func_72441_c(0.0, this.phaseManager.getPhase().getYOffset() * (double)f, 0.0);
            this.parts[0].func_70012_b(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, this.field_70759_as, this.field_70125_A);
            f0 = this.field_70761_aq;
            for (int i = 1; i < this.parts.length; ++i) {
                this.parts[i].func_70071_h_();
                ProcedureUtils.Vec2f pr = this.partRot.get(i - 1);
                f0 = MathHelper.func_76142_g((float)(f0 - pr.x));
                f1 = pr.y * ((float)Math.PI / 180);
                vec3 = EntitySnake.getOffsetPoint((float)vec2.field_72450_a, (float)vec2.field_72448_b, (float)vec2.field_72449_c, -f1, -f0 * ((float)Math.PI / 180), -2.0f * f).func_178787_e(this.func_174791_d()).func_72441_c(0.0, this.phaseManager.getPhase().getYOffset() * (double)f, 0.0);
                this.parts[i].func_70012_b(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, pr.x, pr.y);
                this.collideWithEntities(this.parts[i].func_174813_aQ());
                vec2 = EntitySnake.getOffsetPoint((float)vec2.field_72450_a, (float)vec2.field_72448_b, (float)vec2.field_72449_c, -f1, -f0 * ((float)Math.PI / 180), -4.0f * f);
            }
        }

        private ProcedureUtils.Vec2f getMovementOffsets(int index, float partialTicks) {
            ProcedureUtils.Vec2f vec = new ProcedureUtils.Vec2f(this.parts[index %= this.parts.length].field_70126_B, this.parts[index].field_70127_C);
            return new ProcedureUtils.Vec2f(this.parts[index].field_70177_z, this.parts[index].field_70125_A).subtract(vec).scale(partialTicks).add(vec);
        }

        private float yOffset2Pitch(float yoffset, float xlen) {
            return (float)Math.asin(MathHelper.func_76131_a((float)(yoffset / xlen), (float)-1.0f, (float)1.0f)) * 180.0f / (float)Math.PI;
        }

        @Override
        public boolean canSitOnShoulder() {
            return this.getScale() <= 1.0f;
        }

        private void collideWithEntities(AxisAlignedBB boundingbox) {
            double d0 = (boundingbox.field_72340_a + boundingbox.field_72336_d) / 2.0;
            double d1 = (boundingbox.field_72339_c + boundingbox.field_72334_f) / 2.0;
            for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, boundingbox)) {
                if (entity.equals((Object)this)) continue;
                this.applyEntityCollision(d0, d1, (Entity)entity);
            }
        }

        @Override
        public boolean func_70104_M() {
            return false;
        }

        @Override
        protected void func_82167_n(Entity entityIn) {
            this.applyEntityCollision(this.field_70165_t, this.field_70161_v, entityIn);
        }

        private void applyEntityCollision(double centerX, double centerZ, Entity entity) {
            double d3;
            double d2;
            double d4;
            if (!this.func_184223_x(entity) && !entity.field_70145_X && !entity.func_184207_aI() && (d4 = MathHelper.func_76132_a((double)(d2 = entity.field_70165_t - centerX), (double)(d3 = entity.field_70161_v - centerZ))) >= 0.01) {
                d4 = MathHelper.func_76133_a((double)d4);
                d2 /= d4;
                d3 /= d4;
                double d5 = d4 >= 1.0 ? 1.0 / d4 : 1.0;
                entity.field_70159_w = d2 *= d5 * 0.05;
                entity.field_70179_y = d3 *= d5 * 0.05;
                entity.field_70160_al = true;
            }
        }

        @Override
        public void func_70108_f(Entity entityIn) {
            this.applyEntityCollision(this.field_70165_t, this.field_70161_v, entityIn);
        }

        public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
            int i = part.field_146032_b.equals("head") ? 0 : (part.field_146032_b.substring(0, 7).equals("segment") ? Integer.decode(part.field_146032_b.substring(7)) : this.parts.length);
            return this.func_70097_a(source, damage * (1.0f - (float)i / (float)this.parts.length));
        }

        public void func_180430_e(float distance, float damageMultiplier) {
            super.func_180430_e(distance / this.getScale(), damageMultiplier);
        }

        public World func_82194_d() {
            return this.field_70170_p;
        }

        private void syncParts() {
            if (!this.field_70170_p.field_72995_K) {
                if (this.needsSync) {
                    ServerMessage.sendToTracking(this);
                    this.needsSync = false;
                }
                if (this.prevOnGround != this.field_70122_E) {
                    ProcedureSync.EntityState.sendToTracking((Entity)this);
                    this.prevOnGround = this.field_70122_E;
                }
                if (this.field_70173_aa == 1) {
                    for (int i = 0; i < this.parts.length; ++i) {
                        this.parts[i].func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                    }
                }
            }
        }

        public float func_70047_e() {
            return super.func_70047_e() + (float)this.phaseManager.getPhase().getYOffset() * this.getScale() * 0.0625f;
        }

        public double func_70042_X() {
            return 0.34375 * (double)this.getScale();
        }

        public boolean shouldRiderSit() {
            return false;
        }

        public void func_184232_k(Entity passenger) {
            float f = this.getScale();
            if (this.func_184196_w(passenger)) {
                Vec3d vec2 = this.parts[0].func_174791_d().func_72441_c(0.0, 0.0625 * (double)f + (double)this.parts[0].field_70131_O, 0.0);
                passenger.func_70107_b(vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
            }
        }

        @Override
        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                for (int i = 0; i < this.parts.length; ++i) {
                    Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.parts[i].field_70165_t, this.parts[i].field_70163_u + (double)(this.parts[i].field_70131_O / 2.0f), this.parts[i].field_70161_v, 30, (double)this.parts[i].field_70130_N * 0.5, (double)this.parts[i].field_70131_O * 0.3, (double)this.parts[i].field_70130_N * 0.5, 0.0, 0.0, 0.0, -788529153, 20 + (int)(this.getScale() * 5.0f));
                }
            }
        }

        @Override
        public void func_70037_a(NBTTagCompound compound) {
            super.func_70037_a(compound);
            this.phaseManager.setPhase(Phase.getPhaseFromId(compound.func_74762_e("phase")));
            if (compound.func_150297_b("multiparts", 9)) {
                NBTTagList taglist = compound.func_150295_c("multiparts", 10);
                for (int i = 0; i < taglist.func_74745_c(); ++i) {
                    NBTTagCompound tag = taglist.func_150305_b(i);
                    this.parts[i + 1].func_70020_e(tag);
                    this.partRot.set(i, new ProcedureUtils.Vec2f(this.parts[i + 1].field_70177_z, this.parts[i + 1].field_70125_A));
                }
                this.needsSync = true;
            }
        }

        @Override
        public void func_70014_b(NBTTagCompound compound) {
            super.func_70014_b(compound);
            compound.func_74768_a("phase", this.getPhase().getID());
            NBTTagList taglist = new NBTTagList();
            for (int i = 1; i < this.parts.length; ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                this.parts[i].func_189511_e(tag);
                taglist.func_74742_a((NBTBase)tag);
            }
            if (!taglist.func_82582_d()) {
                compound.func_74782_a("multiparts", (NBTBase)taglist);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_70112_a(double distance) {
            double d0 = this.func_174813_aQ().func_72320_b();
            if (d0 < 1.0) {
                d0 = 1.0;
            }
            return distance < (d0 = d0 * 64.0 * Entity.func_184183_bd()) * d0;
        }
    }
}

