/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import org.lwjgl.util.glu.Sphere;

@ElementsNarutomodMod.ModElement.Tag
public class EntitySpecialEffect
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 50;
    public static final int ENTITYID_RANGED = 51;
    private static final int DEFAULT_DURATION = 600;

    public EntitySpecialEffect(ElementsNarutomodMod instance) {
        super(instance, 242);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "specialeffectentity"), 50).name("specialeffectentity").tracker(128, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderSpecialEffect(renderManager));
    }

    public static EntityCustom spawn(World worldIn, Type type, int color, float radius, int lifespan, double x, double y, double z) {
        EntityCustom entity = new EntityCustom(worldIn, type, color, radius, lifespan);
        entity.func_70107_b(x, y, z);
        worldIn.func_72838_d((Entity)entity);
        return entity;
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderSpecialEffect
    extends Render<EntityCustom> {
        private final ResourceLocation TEXTURE;
        public int sphereIdOutside;
        public int sphereIdInside;
        public final Sphere sphere;

        public RenderSpecialEffect(RenderManager renderManagerIn) {
            super(renderManagerIn);
            this.TEXTURE = new ResourceLocation("narutomod:textures/white_square.png");
            this.sphere = new Sphere();
            this.initSphere();
        }

        private void initSphere() {
            this.sphere.setDrawStyle(100012);
            this.sphere.setNormals(100000);
            this.sphere.setOrientation(100020);
            this.sphereIdOutside = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.sphereIdOutside, (int)4864);
            this.func_110776_a(this.TEXTURE);
            this.sphere.draw(1.0f, 32, 32);
            GlStateManager.func_187415_K();
            this.sphere.setOrientation(100021);
            this.sphereIdInside = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.sphereIdInside, (int)4864);
            this.func_110776_a(this.TEXTURE);
            this.sphere.draw(1.0f, 32, 32);
            GlStateManager.func_187415_K();
        }

        public boolean shouldRender(EntityCustom livingEntity, ICamera camera, double camX, double camY, double camZ) {
            return true;
        }

        public void doRender(EntityCustom entity, double x, double y, double z, float entityYaw, float partialTicks) {
            switch (entity.getEffectType()) {
                case ROTATING_LINES_COLOR_END: {
                    this.renderRotatingLines(entity, x, y, z, entityYaw, partialTicks);
                    break;
                }
                case EXPANDING_SPHERES_FADE_TO_BLACK: {
                    this.renderExpandingSphere(entity, x, y, z, entityYaw, partialTicks);
                }
            }
            super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        }

        private void renderRotatingLines(EntityCustom entity, double x, double y, double z, float entityYaw, float partialTicks) {
            float f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)(y + (double)(entity.field_70131_O / 2.0f)), (double)z);
            GlStateManager.func_179114_b((float)entityYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderHelper.func_74518_a();
            float f1 = f = ((float)entity.getAge() + partialTicks) / (float)entity.getLifespan();
            Random random = new Random(432L);
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179118_c();
            GlStateManager.func_179089_o();
            GlStateManager.func_179132_a((boolean)false);
            float r = entity.getRadius();
            int j = entity.getColor();
            int red = j >> 16 & 0xFF;
            int green = j >> 8 & 0xFF;
            int blue = j & 0xFF;
            int i = 0;
            while ((float)i < 120.0f) {
                GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f + f * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                float f2 = (random.nextFloat() + f1) * 0.5f * r;
                float f3 = (random.nextFloat() + f1) * 0.12f * r;
                bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(255, 255, 255, (int)(255.0f * (1.0f - f1))).func_181675_d();
                bufferbuilder.func_181662_b(-0.866 * (double)f3, (double)f2, (double)(-0.5f * f3)).func_181669_b(red, green, blue, 0).func_181675_d();
                bufferbuilder.func_181662_b(0.866 * (double)f3, (double)f2, (double)(-0.5f * f3)).func_181669_b(red, green, blue, 0).func_181675_d();
                bufferbuilder.func_181662_b(0.0, (double)f2, (double)(1.0f * f3)).func_181669_b(red, green, blue, 0).func_181675_d();
                bufferbuilder.func_181662_b(-0.866 * (double)f3, (double)f2, (double)(-0.5f * f3)).func_181669_b(red, green, blue, 0).func_181675_d();
                tessellator.func_78381_a();
                ++i;
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179129_p();
            GlStateManager.func_179084_k();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179141_d();
            RenderHelper.func_74519_b();
            GlStateManager.func_179121_F();
        }

        private void renderExpandingSphere(EntityCustom entity, double x, double y, double z, float entityYaw, float partialTicks) {
            int life = entity.getLifespan();
            float maxscale = entity.getRadius();
            float age = (float)entity.getAge() + partialTicks;
            float f = 1.0f;
            if (age > 0.6f * (float)life) {
                f = 1.0f - (age - 0.6f * (float)life) / (0.4f * (float)life);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            int i = 0;
            while (age - (float)i > 0.0f) {
                if (age <= maxscale || (float)i > age - maxscale) {
                    float scale = (age - (float)i) * 0.7f;
                    float c = 1.0f - 0.05f * (float)i;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179131_c((float)c, (float)c, (float)c, (float)0.101f);
                    GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                    GlStateManager.func_179148_o((int)this.sphereIdOutside);
                    GlStateManager.func_179148_o((int)this.sphereIdInside);
                    GlStateManager.func_179121_F();
                }
                ++i;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179084_k();
            GlStateManager.func_179118_c();
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(EntityCustom entity) {
            return null;
        }
    }

    public static class EntityCustom
    extends Entity {
        private static final DataParameter<Integer> TYPEID = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Integer> LIFESPAN = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187192_b);

        public EntityCustom(World world) {
            super(world);
            this.func_70105_a(1.0f, 1.0f);
            this.field_70158_ak = true;
            this.field_70178_ae = true;
        }

        public EntityCustom(World world, float radius, int lifespan) {
            this(world, Type.ROTATING_LINES_COLOR_END, 0xFF00FF, radius, lifespan);
        }

        public EntityCustom(World world, Type type, int color, float radius, int lifespan) {
            this(world);
            this.setEffectType(type);
            this.setRadius(radius);
            this.setLifespan(lifespan);
            this.setColor(color);
        }

        protected void func_70088_a() {
            this.func_184212_Q().func_187214_a(TYPEID, (Object)0);
            this.func_184212_Q().func_187214_a(AGE, (Object)0);
            this.func_184212_Q().func_187214_a(RADIUS, (Object)Float.valueOf(200.0f));
            this.func_184212_Q().func_187214_a(LIFESPAN, (Object)600);
            this.func_184212_Q().func_187214_a(COLOR, (Object)0xFF00FF);
        }

        private Type getEffectType() {
            return Type.getTypeFromId((Integer)this.func_184212_Q().func_187225_a(TYPEID));
        }

        private void setEffectType(Type type) {
            this.func_184212_Q().func_187227_b(TYPEID, (Object)type.getID());
        }

        public int getAge() {
            return (Integer)this.func_184212_Q().func_187225_a(AGE);
        }

        protected void setAge(int age) {
            this.func_184212_Q().func_187227_b(AGE, (Object)age);
        }

        public float getRadius() {
            return ((Float)this.func_184212_Q().func_187225_a(RADIUS)).floatValue();
        }

        protected void setRadius(float r) {
            this.func_184212_Q().func_187227_b(RADIUS, (Object)Float.valueOf(r));
        }

        public int getLifespan() {
            return (Integer)this.func_184212_Q().func_187225_a(LIFESPAN);
        }

        protected void setLifespan(int lifespan) {
            this.func_184212_Q().func_187227_b(LIFESPAN, (Object)lifespan);
        }

        public int getColor() {
            return (Integer)this.func_184212_Q().func_187225_a(COLOR);
        }

        protected void setColor(int color) {
            this.func_184212_Q().func_187227_b(COLOR, (Object)color);
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            return false;
        }

        public void func_70106_y() {
            if (this.getAge() >= this.getLifespan() || this.getAge() < 0) {
                this.field_70128_L = true;
            }
        }

        public void func_70071_h_() {
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.setAge(this.getAge() + 1);
            this.field_70177_z += 30.0f;
            this.func_70106_y();
        }

        public boolean shouldRenderInPass(int pass) {
            return true;
        }

        protected void func_70037_a(NBTTagCompound compound) {
            this.setEffectType(Type.getTypeFromId(compound.func_74762_e("type")));
            this.setAge(compound.func_74762_e("age"));
            this.setRadius(compound.func_74760_g("radius"));
            this.setLifespan(compound.func_74762_e("lifespan"));
        }

        protected void func_70014_b(NBTTagCompound compound) {
            compound.func_74768_a("type", this.getEffectType().getID());
            compound.func_74768_a("age", this.getAge());
            compound.func_74776_a("radius", this.getRadius());
            compound.func_74768_a("lifespan", this.getLifespan());
        }
    }

    public static enum Type {
        ROTATING_LINES_COLOR_END(0),
        EXPANDING_SPHERES_FADE_TO_BLACK(1);

        private final int id;
        private static final Map<Integer, Type> TYPES;

        private Type(int i) {
            this.id = i;
        }

        public int getID() {
            return this.id;
        }

        public static Type getTypeFromId(int i) {
            return TYPES.get(i);
        }

        static {
            TYPES = Maps.newHashMap();
            for (Type type : Type.values()) {
                TYPES.put(type.getID(), type);
            }
        }
    }
}

