/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.Particles;
import net.narutomod.entity.EntityBeamBase;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureAirPunch;
import net.narutomod.procedure.ProcedureSync;

@ElementsNarutomodMod.ModElement.Tag
public class EntityTenseiBakuGold
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 342;
    public static final int ENTITYID_RANGED = 343;

    public EntityTenseiBakuGold(ElementsNarutomodMod instance) {
        super(instance, 697);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "tensei_baku_gold"), 342).name("tensei_baku_gold").tracker(128, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new CustomRender(renderManager));
    }

    @SideOnly(value=Side.CLIENT)
    public class CustomRender
    extends Render<EC> {
        private final ResourceLocation texture;

        public CustomRender(RenderManager renderManagerIn) {
            super(renderManagerIn);
            this.texture = new ResourceLocation("narutomod:textures/beam_gold.png");
        }

        public boolean shouldRender(EC livingEntity, ICamera camera, double camX, double camY, double camZ) {
            return true;
        }

        protected float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
            float f;
            for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
            }
            while (f >= 180.0f) {
                f -= 360.0f;
            }
            return prevYawOffset + partialTicks * f;
        }

        public void doRender(EC bullet, double x, double y, double z, float yaw, float pt) {
            float f9;
            float f8;
            float f7;
            int j;
            float f = ((float)bullet.field_70173_aa + pt) * 0.01f;
            double max_l = bullet.getBeamLength();
            this.func_180548_c(bullet);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179114_b((float)this.interpolateRotation(bullet.field_70126_B, bullet.field_70177_z, pt), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(90.0f - bullet.field_70127_C - (bullet.field_70125_A - bullet.field_70127_C) * pt), (float)1.0f, (float)0.0f, (float)0.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            float f5 = 0.0f - f;
            float f6 = (float)max_l / 32.0f - f;
            float f10 = Math.min(((float)bullet.field_70173_aa + pt) / 20.0f, 1.0f);
            f10 *= f10;
            float f11 = 1.5f + (1.0f - f10) * 10.0f;
            bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181709_i);
            for (j = 0; j <= 8; ++j) {
                f7 = MathHelper.func_76126_a((float)((float)(j % 8) * ((float)Math.PI * 2) / 8.0f)) * 0.5f;
                f8 = MathHelper.func_76134_b((float)((float)(j % 8) * ((float)Math.PI * 2) / 8.0f)) * 0.5f;
                f9 = (float)(j % 8) / 8.0f;
                bufferbuilder.func_181662_b((double)f7, 0.0, (double)f8).func_187315_a((double)f9, (double)f5).func_181666_a(1.0f, 1.0f, 1.0f, 0.7f).func_181675_d();
                bufferbuilder.func_181662_b((double)(f7 * f11), (double)((float)max_l * f10), (double)(f8 * f11)).func_187315_a((double)f9, (double)f6).func_181666_a(1.0f, 1.0f, 1.0f, 0.7f * f10).func_181675_d();
            }
            for (j = 0; f10 > 0.98f && j <= 8; ++j) {
                f7 = MathHelper.func_76126_a((float)((float)(j % 8) * ((float)Math.PI * 2) / 8.0f)) * 0.6f;
                f8 = MathHelper.func_76134_b((float)((float)(j % 8) * ((float)Math.PI * 2) / 8.0f)) * 0.6f;
                f9 = (float)(j % 8) / 8.0f;
                bufferbuilder.func_181662_b((double)f7, 0.0, (double)f8).func_187315_a((double)f9, (double)f5).func_181666_a(1.0f, 1.0f, 1.0f, 0.11f).func_181675_d();
                bufferbuilder.func_181662_b((double)(f7 * f11), (double)((float)max_l * f10), (double)(f8 * f11)).func_187315_a((double)f9, (double)f6).func_181666_a(1.0f, 1.0f, 1.0f, 0.11f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return this.texture;
        }
    }

    public static class EC
    extends EntityBeamBase.Base {
        private final int growTime = 20;
        private final AirPunch beam = new AirPunch();
        private float power;

        public EC(World worldIn) {
            super(worldIn);
        }

        public EC(EntityLivingBase shooter, float powerIn) {
            super(shooter);
            this.power = powerIn;
            this.updatePosition();
            this.shoot(powerIn);
        }

        @Override
        protected void updatePosition() {
            EntityLivingBase shooter = this.getShooter();
            if (shooter != null) {
                Vec3d vec = shooter.func_70040_Z().func_72441_c(shooter.field_70165_t, shooter.field_70163_u + 1.2, shooter.field_70161_v);
                this.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K && this.shootingEntity instanceof EntityPlayer) {
                ProcedureSync.EntityNBTTag.removeAndSync(this.shootingEntity, NarutomodModVariables.forceBowPose);
            }
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K && this.ticksAlive == 1 && this.shootingEntity instanceof EntityPlayer) {
                ProcedureSync.EntityNBTTag.setAndSync(this.shootingEntity, NarutomodModVariables.forceBowPose, true);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.shoot(this.power);
                if (this.ticksAlive > this.growTime) {
                    this.beam.execute2((EntityLivingBase)this.shootingEntity, this.getBeamLength(), 3.0);
                }
            }
            if (this.ticksAlive > 100 + this.growTime) {
                this.func_70106_y();
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                entity.field_70170_p.func_72838_d((Entity)new EC(entity, power));
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u + 2.0, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:laser")), SoundCategory.PLAYERS, 4.0f, 1.0f);
                return true;
            }
        }

        public class AirPunch
        extends ProcedureAirPunch {
            public AirPunch() {
                this.blockDropChance = -1.0f;
                this.blockHardnessLimit = 100.0f;
                this.particlesPre = null;
            }

            @Override
            protected void attackEntityFrom(EntityLivingBase player, Entity target) {
                target.field_70172_ad = 10;
                target.func_70097_a(DamageSource.func_76354_b((Entity)EC.this, (Entity)player), EC.this.power * 0.6f);
            }

            @Override
            @Nullable
            protected EntityItem processAffectedBlock(EntityLivingBase player, BlockPos pos, EnumFacing facing) {
                if (player.func_70681_au().nextFloat() < 0.005f) {
                    player.field_70170_p.func_184133_a(null, pos, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:explosion")), SoundCategory.BLOCKS, 4.0f, player.func_70681_au().nextFloat() * 0.5f + 0.75f);
                }
                return super.processAffectedBlock(player, pos, facing);
            }

            @Override
            protected void breakBlockParticles(World world, BlockPos pos) {
                Particles.spawnParticle(world, Particles.Types.SMOKE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Integer.MIN_VALUE, 60);
            }

            @Override
            protected float getBreakChance(BlockPos pos, EntityLivingBase player, double range) {
                return 1.0f;
            }
        }
    }
}

