/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.PlayerInput;
import net.narutomod.PlayerRender;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemNinjutsu;
import net.narutomod.procedure.ProcedureOnLivingUpdate;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityTransformationJutsu
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 383;
    public static final int ENTITYID_RANGED = 384;

    public EntityTransformationJutsu(ElementsNarutomodMod instance) {
        super(instance, 762);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "transformation_jutsu"), 383).name("transformation_jutsu").tracker(64, 3, true).build());
    }

    public static class EC
    extends Entity
    implements PlayerInput.Hook.IHandler {
        private EntityLivingBase user;
        private EntityLivingBase target;
        private EntityLivingBase clone;
        private double chakraBurnPerSec;
        private PlayerInput.Hook userInput = new PlayerInput.Hook();

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
            this.field_70178_ae = true;
        }

        public EC(EntityLivingBase userIn, EntityLivingBase targetIn, double chakraBurnIn) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.target = targetIn;
            this.func_70107_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v);
            this.chakraBurnPerSec = chakraBurnIn;
        }

        protected void func_70088_a() {
        }

        public void func_70106_y() {
            if (!this.field_70170_p.field_72995_K) {
                if (this.user != null) {
                    ProcedureUtils.poofWithSmoke((Entity)this.user);
                    this.user.getEntityData().func_82580_o("TransformationEntityIdKey");
                    if (this.user instanceof EntityPlayer) {
                        PlayerRender.setSkinCloneTarget((EntityPlayer)this.user, null);
                        PlayerInput.Hook.copyInputFrom((EntityPlayerMP)this.user, this, false);
                        this.spectate((EntityPlayerMP)this.user, null);
                    }
                }
                if (this.clone != null) {
                    if (this.user != null) {
                        this.user.func_70606_j(this.clone.func_110143_aJ());
                    }
                    this.clone.func_70106_y();
                }
            }
            super.func_70106_y();
        }

        public void func_70071_h_() {
            if (this.user instanceof EntityPlayer && this.user.func_70089_S() && (this.field_70173_aa % 20 > 0 || Chakra.pathway(this.user).consume(this.chakraBurnPerSec))) {
                this.func_70107_b(this.user.field_70165_t, this.user.field_70163_u, this.user.field_70161_v);
                if (this.field_70173_aa == 1) {
                    if (this.target instanceof EntityPlayer) {
                        PlayerRender.setSkinCloneTarget((EntityPlayer)this.user, (EntityPlayer)this.target, false);
                    } else {
                        this.clone = (EntityLivingBase)EntityList.func_191304_a(this.target.getClass(), (World)this.field_70170_p);
                        this.clone.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.user.func_110138_aP());
                        this.clone.func_70606_j(this.user.func_110143_aJ());
                        this.clone.func_82149_j((Entity)this.user);
                        this.field_70170_p.func_72838_d((Entity)this.clone);
                        PlayerInput.Hook.copyInputFrom((EntityPlayerMP)this.user, this, true);
                        PlayerInput.Hook.haltTargetInput(this.clone, true);
                    }
                    ProcedureUtils.poofWithSmoke((Entity)this.user);
                } else if (this.clone != null) {
                    if (this.userInput.hasNewMovementInput()) {
                        this.userInput.handleMovement(this.clone);
                    }
                    if (this.userInput.hasNewMouseEvent()) {
                        this.userInput.handleMouseEvent(this.clone);
                    }
                    this.spectate((EntityPlayerMP)this.user, (Entity)this.clone);
                }
                if (this.clone != null && this.clone.func_110143_aJ() < this.clone.func_110138_aP() * 0.2f) {
                    this.func_70106_y();
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        private void spectate(EntityPlayerMP spectator, @Nullable Entity targetEntity) {
            ProcedureOnLivingUpdate.setNoClip((Entity)spectator, targetEntity != null, spectator == this.user);
            spectator.func_175399_e(targetEntity);
            if (targetEntity != null) {
                spectator.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 2, 0, false, false));
                spectator.getEntityData().func_74780_a(NarutomodModVariables.InvulnerableTime, 10.0);
                spectator.func_70634_a(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v);
            }
        }

        @Override
        public void handlePacket(@Nullable PlayerInput.Hook.MovementPacket movementPacket, @Nullable PlayerInput.Hook.MousePacket mousePacket) {
            if (movementPacket != null) {
                this.userInput.copyMovementInput(movementPacket);
            }
            if (mousePacket != null) {
                this.userInput.copyMouseInput(mousePacket);
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ECENTITYID = "TransformationEntityIdKey";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Entity entity1 = entity.field_70170_p.func_73045_a(entity.getEntityData().func_74762_e(ECENTITYID));
                if (entity1 instanceof EC) {
                    entity1.func_70106_y();
                } else {
                    RayTraceResult res = ProcedureUtils.objectEntityLookingAt((Entity)entity, 30.0);
                    if (res != null && res.field_72308_g instanceof EntityLivingBase) {
                        entity1 = new EC(entity, (EntityLivingBase)res.field_72308_g, ItemNinjutsu.TRANSFORM.chakraUsage * 0.1);
                        entity.field_70170_p.func_72838_d(entity1);
                        entity.getEntityData().func_74768_a(ECENTITYID, entity1.func_145782_y());
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

