/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.Particles;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.event.EventSphericalExplosion;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureAoeCommand;

@ElementsNarutomodMod.ModElement.Tag
public class EntityTruthSeekerBall
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 107;
    public static final int ENTITYID_RANGED = 108;

    public EntityTruthSeekerBall(ElementsNarutomodMod instance) {
        super(instance, 321);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "truthseekerball"), 107).name("truthseekerball").tracker(96, 3, true).build());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderCustom(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelTruthSeekerBall
        extends ModelBase {
            private final ModelRenderer bb_main;

            public ModelTruthSeekerBall() {
                this.field_78090_t = 16;
                this.field_78089_u = 16;
                this.bb_main = new ModelRenderer((ModelBase)this);
                this.bb_main.func_78793_a(0.0f, 2.0f, 0.0f);
                this.bb_main.field_78804_l.add(new ModelBox(this.bb_main, 0, 0, -2.0f, -4.0f, -2.0f, 4, 4, 4, 0.0f, false));
            }

            public void func_78088_a(Entity entityIn, float f0, float f1, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                this.bb_main.func_78785_a(scale);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderCustom
        extends Render<EntityCustom> {
            private final ResourceLocation texture;
            protected ModelBase mainModel;

            public RenderCustom(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.texture = new ResourceLocation("narutomod:textures/truthhseekerball.png");
                this.mainModel = new ModelTruthSeekerBall();
            }

            public void doRender(EntityCustom entity, double x, double y, double z, float entityYaw, float partialTicks) {
                this.func_180548_c(entity);
                GlStateManager.func_179094_E();
                GlStateManager.func_179129_p();
                float scale = entity.getEntityScale();
                GlStateManager.func_179137_b((double)x, (double)(y + (double)(0.125f * scale)), (double)z);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                if (!entity.isShieldOn()) {
                    GlStateManager.func_179114_b((float)(((float)entity.field_70173_aa + partialTicks) * 90.0f), (float)1.0f, (float)1.0f, (float)0.0f);
                }
                GlStateManager.func_179140_f();
                this.mainModel.func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GlStateManager.func_179145_e();
                GlStateManager.func_179089_o();
                GlStateManager.func_179121_F();
            }

            protected ResourceLocation getEntityTexture(EntityCustom entity) {
                return this.texture;
            }
        }
    }

    public static class EntityCustom
    extends EntityScalableProjectile.Base {
        private static final Vec3d[] VEC = new Vec3d[]{new Vec3d(0.0, 2.0387, -0.4395), new Vec3d(-0.4102, 1.7629, -0.4395), new Vec3d(0.4102, 1.7629, -0.4395), new Vec3d(-0.5859, 1.3113, -0.4395), new Vec3d(0.5859, 1.3113, -0.4395), new Vec3d(-0.5273, 0.8012, -0.4395), new Vec3d(0.5273, 0.8012, -0.4395), new Vec3d(-0.2344, 0.4082, -0.4395), new Vec3d(0.2344, 0.4082, -0.4395), new Vec3d(0.0, 3.5, 0.0)};
        private static final DataParameter<Boolean> SHIELD_ON = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187198_h);
        private Vec3d idleVec = VEC[0];
        protected boolean follow = true;
        private float shieldProgress;
        private int shieldToggleInProgressDirection;
        private float shieldSize = 8.0f;
        private boolean shieldOn;
        private ItemStack heldItem;
        private float hp;
        private int deathTicks;
        private Entity target;
        private int targetTime = -1;
        private final float inititalScale = 0.8f;
        private float maxScale = 0.8f;

        public EntityCustom(World world) {
            super(world);
            this.field_70178_ae = true;
            this.setOGSize(0.25f, 0.25f);
            this.setEntityScale(this.inititalScale);
            this.func_189654_d(true);
        }

        public EntityCustom(EntityLivingBase shooter, int posIndex, ItemStack helditem) {
            super(shooter);
            this.field_70178_ae = true;
            this.heldItem = helditem;
            this.setOGSize(0.25f, 0.25f);
            this.setEntityScale(this.inititalScale);
            this.idleVec = VEC[posIndex % VEC.length];
            Vec3d vec = this.getIdlePosition();
            this.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
            this.hp = 1000.0f;
        }

        @Override
        protected void func_70088_a() {
            super.func_70088_a();
            this.func_184212_Q().func_187214_a(SHIELD_ON, (Object)false);
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, (int)(this.field_70130_N * 100.0f), 0.5 * (double)this.field_70130_N, 0.5 * (double)this.field_70131_O, 0.5 * (double)this.field_70130_N, 0.0, new int[0]);
                if (this.shootingEntity != null) {
                    this.resetFlySpeed((Entity)this.shootingEntity);
                }
            }
        }

        private void slowFlySpeed(Entity entity) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.func_75093_a() > 0.01f) {
                ReflectionHelper.setPrivateValue(PlayerCapabilities.class, (Object)((EntityPlayer)entity).field_71075_bZ, (Object)Float.valueOf(0.01f), (int)5);
                ((EntityPlayer)entity).func_71016_p();
            }
        }

        private void resetFlySpeed(Entity entity) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.func_75093_a() < 0.05f) {
                ReflectionHelper.setPrivateValue(PlayerCapabilities.class, (Object)((EntityPlayer)entity).field_71075_bZ, (Object)Float.valueOf(0.05f), (int)5);
                ((EntityPlayer)entity).func_71016_p();
            }
        }

        public boolean func_180427_aV() {
            return true;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (!this.field_70170_p.field_72995_K && !this.func_190530_aW()) {
                if (ItemJutsu.isDamageSourceNinjutsu(source)) {
                    Entity entity = source.func_76364_f();
                    if (entity != null && !(entity instanceof EntityLivingBase)) {
                        entity.func_70106_y();
                    }
                } else if (source.func_76346_g() == null || !source.func_76346_g().equals((Object)this.shootingEntity)) {
                    if (this.field_70172_ad > 10 || !this.isLauchedAtTarget() && !this.isShieldOn()) {
                        return false;
                    }
                    this.hp -= amount;
                    this.field_70172_ad = 20;
                    if (this.hp <= 0.0f) {
                        this.onDeath();
                    }
                    return true;
                }
            }
            return false;
        }

        public float getHealth() {
            return this.hp;
        }

        public void onDeath() {
            ++this.deathTicks;
            this.setEntityScale(this.getEntityScale() * 0.9f);
            if (this.deathTicks > 5) {
                this.func_70106_y();
            }
        }

        private Vec3d getIdlePosition() {
            if (this.shootingEntity != null) {
                if (this.isShieldOn()) {
                    double y = this.shootingEntity.field_70131_O + this.shieldProgress * -1.8f;
                    return this.shootingEntity.func_174791_d().func_72441_c(0.0, y, 0.0);
                }
                return this.idleVec.func_178785_b(-this.shootingEntity.field_70761_aq * ((float)Math.PI / 180)).func_178787_e(this.shootingEntity.func_174791_d());
            }
            return this.func_174791_d();
        }

        public void setNextPosition(Vec3d vec, double speed) {
            if (this.func_70011_f(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c) > speed && this.targetTime >= 0) {
                this.setVelocity(vec.func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(speed));
            } else {
                this.setVelocity(vec.func_178788_d(this.func_174791_d()));
                if (this.targetTime >= 0 && vec.equals((Object)this.getIdlePosition())) {
                    this.setTarget(null, 0);
                }
            }
        }

        public void setTarget(@Nullable Entity targetIn, int time) {
            this.target = targetIn;
            this.targetTime = targetIn != null ? time : -1;
        }

        @Nullable
        public Entity getTarget() {
            return this.target;
        }

        public boolean isLauchedAtTarget() {
            return this.target != null && this.targetTime > 0;
        }

        public void setMaxScale(float scale) {
            this.maxScale = scale;
        }

        private void moveGrowAndShoot() {
            if (this.shootingEntity != null) {
                Vec3d vec = this.shootingEntity.func_174791_d().func_72441_c(0.0, (double)(this.shootingEntity.field_70131_O + 2.0f), 0.0);
                if (this.func_70011_f(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c) > 0.2) {
                    this.setVelocity(vec.func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(0.1));
                } else if (this.maxScale > 0.0f) {
                    this.setVelocity(Vec3d.field_186680_a);
                    float scale = this.getEntityScale();
                    if (scale < this.maxScale) {
                        this.setEntityScale(scale * 1.03f);
                    } else {
                        Vec3d vec2 = this.shootingEntity.func_70040_Z();
                        this.func_70186_c(vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, 0.95f, 0.0f);
                        this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:Kaguya_FinalTSB")), 5.0f, 1.0f);
                    }
                } else {
                    this.func_70106_y();
                }
            }
        }

        @Override
        public void func_70186_c(double x, double y, double z, float speed, float inaccuracy) {
            super.func_70186_c(x, y, z, speed, inaccuracy);
            this.targetTime = this.maxScale <= this.shieldSize ? (int)MathHelper.func_76133_a((double)(1600.0 / (double)speed)) : 200;
        }

        private void setVelocity(Vec3d vec) {
            this.field_70159_w = vec.field_72450_a;
            this.field_70181_x = vec.field_72448_b;
            this.field_70179_y = vec.field_72449_c;
            this.field_70160_al = true;
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.deathTicks > 0) {
                this.onDeath();
            }
            this.updateShieldProgress();
            if (!this.field_70128_L && this.follow && this.shootingEntity != null) {
                if (!this.isLaunched()) {
                    if (this.maxScale != this.getEntityScale()) {
                        this.moveGrowAndShoot();
                    } else if (this.target != null && this.targetTime > 0) {
                        if (this.target.func_70089_S()) {
                            this.setNextPosition(this.target.func_174824_e(1.0f), 1.5);
                            --this.targetTime;
                        } else {
                            this.targetTime = 0;
                        }
                    } else if ((double)this.func_70032_d((Entity)this.shootingEntity) < 70.0) {
                        this.setNextPosition(this.getIdlePosition(), 0.5);
                    }
                    if (this.isShieldOn()) {
                        this.shootingEntity.getEntityData().func_74780_a(NarutomodModVariables.InvulnerableTime, 2.0);
                    }
                    if (this.target != null) {
                        for (Entity entity : this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ().func_186662_g(0.1))) {
                            if (entity.equals((Object)this.shootingEntity) || entity.equals((Object)this)) continue;
                            this.func_70108_f(entity);
                        }
                    }
                } else if (this.targetTime > 0) {
                    --this.targetTime;
                } else {
                    this.haltMotion();
                }
            }
            if (!(this.field_70170_p.field_72995_K || this.shootingEntity != null && this.shootingEntity.func_70089_S() && (this.heldItem == null || !this.heldItem.func_190926_b() && (this.shootingEntity.func_184614_ca().equals(this.heldItem) || this.shootingEntity.func_184592_cb().equals(this.heldItem))))) {
                this.func_70106_y();
            }
            if (this.field_70172_ad > 0) {
                --this.field_70172_ad;
            }
        }

        public void toggleShield() {
            if (this.isShieldOn()) {
                this.shieldToggleInProgressDirection = -1;
            } else {
                this.shieldToggleInProgressDirection = 1;
                this.func_184212_Q().func_187227_b(SHIELD_ON, (Object)true);
                this.slowFlySpeed((Entity)this.shootingEntity);
            }
        }

        public boolean isShieldOn() {
            return (Boolean)this.func_184212_Q().func_187225_a(SHIELD_ON);
        }

        private void updateShieldProgress() {
            if (this.shieldToggleInProgressDirection != 0) {
                this.shieldProgress += 0.05f * (float)this.shieldToggleInProgressDirection;
                if (this.shieldProgress >= 1.0f) {
                    this.shieldProgress = 1.0f;
                    this.shieldToggleInProgressDirection = 0;
                }
                if (this.shieldProgress <= 0.0f) {
                    this.shieldProgress = 0.0f;
                    this.shieldToggleInProgressDirection = 0;
                    this.func_184212_Q().func_187227_b(SHIELD_ON, (Object)false);
                    this.resetFlySpeed((Entity)this.shootingEntity);
                }
                float f = 1.0f + this.shieldProgress * this.shieldSize;
                this.setEntityScale(f);
                this.maxScale = f;
            }
        }

        protected void eventOnTick(World world, int x, int y, int z, int radius, Entity entity, int tick) {
            float damage = radius * 10;
            ProcedureAoeCommand.set(world, x, y, z, 0.0, radius).exclude(entity).exclude(EntityCustom.class).resetHurtResistanceTime().damageEntities(DamageSource.field_76377_j.func_151518_m(), damage);
        }

        @Override
        protected void onImpact(RayTraceResult result) {
            if (result.field_72308_g != null && (result.field_72308_g.equals((Object)this.shootingEntity) || result.field_72308_g instanceof EntityCustom)) {
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                float radius = this.getEntityScale() * 4.0f + 15.0f;
                Particles.spawnParticle(this.field_70170_p, Particles.Types.EXPANDING_SPHERE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 192.0, (int)(radius * 10.0f), (int)(radius * 4.0f), 0);
                new EventSphericalExplosion(this.field_70170_p, (Entity)this.shootingEntity, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, (int)radius, 0L, false, 0.0f, false, true){

                    @Override
                    protected void doOnTick(int currentTick) {
                        this.eventOnTick(this.getWorld(), this.getX0(), this.getY0(), this.getZ0(), this.getRadius(), this.getEntity(), currentTick);
                    }
                };
                if (this.getEntityScale() >= 25.0f && result.field_72308_g instanceof EntityLivingBase) {
                    ((EntityLivingBase)result.field_72308_g).func_70606_j(0.0f);
                }
                if (this.maxScale > this.shieldSize) {
                    this.onDeath();
                } else {
                    this.targetTime = 0;
                    this.haltMotion();
                }
            }
        }

        @Override
        public void renderParticles() {
        }

        @Override
        protected void checkOnGround() {
        }

        public boolean func_70104_M() {
            return this.isShieldOn();
        }

        @Nullable
        public AxisAlignedBB func_70046_E() {
            return this.isShieldOn() ? this.func_174813_aQ() : null;
        }

        public void func_70108_f(Entity entityIn) {
            if (!(this.func_184223_x(entityIn) || entityIn.field_70145_X || entityIn.func_184207_aI())) {
                double d0 = entityIn.field_70165_t - this.field_70165_t;
                double d1 = entityIn.field_70161_v - this.field_70161_v;
                entityIn.func_70024_g(d0 * 0.15, 0.0, d1 * 0.15);
                if (this.target != null) {
                    entityIn.field_70172_ad = 10;
                    if (entityIn instanceof EntityLivingBase) {
                        entityIn.func_70097_a(ItemJutsu.causeSenjutsuDamage(this, this.shootingEntity), 10.0f);
                    } else if (!(entityIn instanceof EntityCustom) || this.shootingEntity != null && !this.shootingEntity.equals((Object)((EntityCustom)entityIn).shootingEntity)) {
                        entityIn.func_174812_G();
                    }
                }
            }
        }
    }
}

