/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemSteamArmor;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityUnrivaledStrength
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 286;
    public static final int ENTITYID_RANGED = 287;

    public EntityUnrivaledStrength(ElementsNarutomodMod instance) {
        super(instance, 606);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "unrivaled_strength"), 286).name("unrivaled_strength").tracker(64, 3, true).build());
    }

    public static class EC
    extends Entity {
        private EntityLivingBase user;
        private int duration;
        private boolean isWearingSteamArmor;
        private Entity target;
        private int attackTime;

        public EC(World worldIn) {
            super(worldIn);
            this.func_70105_a(0.01f, 0.01f);
            this.field_70178_ae = true;
        }

        public EC(EntityLivingBase userIn, float power) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.isWearingSteamArmor = ItemSteamArmor.isWearingFullSet(userIn);
            if (this.isWearingSteamArmor) {
                this.duration = (int)(power * 60.0f);
                power *= 1.5f;
            } else {
                this.duration = (int)(power * 20.0f);
            }
            this.func_70107_b(this.user.field_70165_t, this.user.field_70163_u, this.user.field_70161_v);
            this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:kairikimuso")), 1.0f, 1.0f);
            PotionEffect effect = userIn.func_70660_b(MobEffects.field_76420_g);
            userIn.func_70690_d(new PotionEffect(MobEffects.field_76420_g, this.duration, (int)power + (effect != null ? effect.func_76458_c() : -1), false, false));
            effect = userIn.func_70660_b(MobEffects.field_76424_c);
            userIn.func_70690_d(new PotionEffect(MobEffects.field_76424_c, this.duration, (int)(power * 2.0f) + (effect != null ? effect.func_76458_c() : -1), false, false));
            effect = userIn.func_70660_b(MobEffects.field_76430_j);
            userIn.func_70690_d(new PotionEffect(MobEffects.field_76430_j, this.duration, (int)(power * 0.2f) + (effect != null ? effect.func_76458_c() : -1), false, false));
        }

        protected void func_70088_a() {
        }

        public void func_70071_h_() {
            if (this.user != null) {
                this.func_70107_b(this.user.field_70165_t, this.user.field_70163_u, this.user.field_70161_v);
                if (!this.isWearingSteamArmor) {
                    int i;
                    boolean flag;
                    boolean bl = flag = this.field_70173_aa <= 10;
                    if (flag) {
                        for (i = 0; i < 50; ++i) {
                            Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1, 0.0, 1.0, 0.0, this.field_70146_Z.nextDouble() - 0.5, this.field_70146_Z.nextDouble() * 0.5, this.field_70146_Z.nextDouble() - 0.5, 0x20FFFFFF, 20 + this.field_70146_Z.nextInt(11), 0);
                        }
                    } else {
                        for (i = 0; i < 20; ++i) {
                            Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1, 0.0, 1.0, 0.0, (this.field_70146_Z.nextDouble() - 0.5) * 0.2, 0.0, (this.field_70146_Z.nextDouble() - 0.5) * 0.2, 0x20FFFFFF, 10 + this.field_70146_Z.nextInt(11), 0, 0, this.user.func_145782_y());
                        }
                    }
                    for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(flag ? 7.0 : 4.0))) {
                        if (entity.equals((Object)this.user)) continue;
                        entity.field_70172_ad = 10;
                        entity.func_70097_a(DamageSource.field_190095_e, 1.0f);
                    }
                } else {
                    Vec3d vec = new Vec3d(0.0, 0.0, -0.5).func_178785_b(-this.user.field_70761_aq * (float)Math.PI / 180.0f).func_72441_c(this.field_70165_t, this.field_70163_u + 1.4, this.field_70161_v);
                    Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 10, 0.0, 0.0, 0.0, (this.field_70146_Z.nextDouble() - 0.5) * 0.1, 0.0, (this.field_70146_Z.nextDouble() - 0.5) * 0.1, 0x20FFFFFF, 10 + this.field_70146_Z.nextInt(11), 0, 0, this.user.func_145782_y());
                }
                if (this.user.field_110158_av == 1 && this.user instanceof EntityPlayer) {
                    RayTraceResult res = ProcedureUtils.objectEntityLookingAt((Entity)this.user, 3.0, this);
                    if (res != null && res.field_72308_g instanceof EntityLivingBase) {
                        ProcedureUtils.pushEntity((Entity)this.user, res.field_72308_g, 15.0, 1.5f);
                    } else {
                        res = ProcedureUtils.objectEntityLookingAt((Entity)this.user, 12.0, 3.0, this);
                        if (res != null && res.field_72308_g instanceof EntityLivingBase) {
                            this.target = res.field_72308_g;
                            this.attackTime = 0;
                            this.user.field_70177_z = ProcedureUtils.getYawFromVec(this.target.func_174791_d().func_178788_d(this.user.func_174791_d()));
                            double d0 = this.target.field_70165_t - this.user.field_70165_t;
                            double d1 = this.target.field_70163_u - this.user.field_70163_u;
                            double d2 = this.target.field_70161_v - this.user.field_70161_v;
                            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                            ProcedureUtils.setVelocity((Entity)this.user, d0 * 0.4, d1 * 0.4 + d3 * 0.02, d2 * 0.4);
                        }
                    }
                }
                if (this.attackTime < 12 && this.target != null && this.target.func_70068_e((Entity)this.user) < 25.0) {
                    ((EntityPlayer)this.user).func_71059_n(this.target);
                    ProcedureUtils.pushEntity((Entity)this.user, this.target, 15.0, 1.5f);
                    this.target = null;
                }
                ++this.attackTime;
            }
            if (this.field_70173_aa % 5 == 4) {
                this.func_184185_a(SoundEvents.field_187646_bt, 0.2f, this.field_70146_Z.nextFloat() * 0.5f + 0.4f);
            }
            if (!(this.field_70170_p.field_72995_K || this.user != null && this.field_70173_aa <= this.duration)) {
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                entity.field_70170_p.func_72838_d((Entity)new EC(entity, power));
                return true;
            }
        }
    }
}

