/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.event.EventSetBlocks;
import net.narutomod.item.ItemJutsu;
import net.narutomod.potion.PotionHeaviness;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityWoodPrison
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 228;
    public static final int ENTITYID_RANGED = 229;

    public EntityWoodPrison(ElementsNarutomodMod instance) {
        super(instance, 542);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "wood_prison"), 228).name("wood_prison").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new CustomRender(renderManager));
    }

    public static class EC
    extends Entity {
        private BlockPos blockpos;
        private int radius;
        private int tHeight;

        public EC(World worldIn) {
            super(worldIn);
            this.func_70105_a(0.01f, 0.01f);
            this.field_70178_ae = false;
        }

        public EC(World worldIn, Vec3d targetVecIn, float power) {
            this(worldIn);
            this.func_70107_b(targetVecIn.field_72450_a, targetVecIn.field_72448_b, targetVecIn.field_72449_c);
            this.blockpos = new BlockPos(targetVecIn);
            this.radius = MathHelper.func_76123_f((float)(power * 0.5f));
            this.tHeight = MathHelper.func_76123_f((float)(power - 0.5f));
        }

        protected void func_70088_a() {
        }

        public void func_70071_h_() {
            if (this.blockpos != null) {
                for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - (double)this.radius, this.field_70163_u, this.field_70161_v - (double)this.radius, this.field_70165_t + (double)this.radius, this.field_70163_u + (double)this.tHeight, this.field_70161_v + (double)this.radius))) {
                    entity.func_70690_d(new PotionEffect(PotionHeaviness.potion, 100, 3, false, false));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 1200, 2, false, false));
                }
                HashMap map = Maps.newHashMap();
                for (BlockPos pos : Iterables.concat((Iterable[])new Iterable[]{BlockPos.func_177975_b((BlockPos)this.blockpos.func_177982_a(-this.radius, -3, -this.radius), (BlockPos)this.blockpos.func_177982_a(-this.radius, this.tHeight, this.radius)), BlockPos.func_177975_b((BlockPos)this.blockpos.func_177982_a(-this.radius, -3, -this.radius), (BlockPos)this.blockpos.func_177982_a(this.radius, this.tHeight, -this.radius)), BlockPos.func_177975_b((BlockPos)this.blockpos.func_177982_a(this.radius, -3, -this.radius), (BlockPos)this.blockpos.func_177982_a(this.radius, this.tHeight, this.radius)), BlockPos.func_177975_b((BlockPos)this.blockpos.func_177982_a(-this.radius, -3, this.radius), (BlockPos)this.blockpos.func_177982_a(this.radius, this.tHeight, this.radius)), BlockPos.func_177975_b((BlockPos)this.blockpos.func_177982_a(-this.radius, this.tHeight, -this.radius), (BlockPos)this.blockpos.func_177982_a(this.radius, this.tHeight, this.radius))})) {
                    if (this.field_70170_p.func_180495_p(pos).func_185890_d((IBlockAccess)this.field_70170_p, pos) != null) continue;
                    map.put(pos.func_185334_h(), pos.func_177956_o() - this.blockpos.func_177956_o() == this.tHeight ? Blocks.field_150376_bx.func_176223_P() : Blocks.field_180407_aO.func_176223_P());
                }
                if (!map.isEmpty()) {
                    new EventSetBlocks(this.field_70170_p, map, 0L, 1200, true, false){

                        @Override
                        public void onAddTick(int tick) {
                            if (tick % 30 == 1) {
                                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:woodspawn")), 1.0f, field_70146_Z.nextFloat() * 0.4f + 0.8f);
                            }
                        }
                    };
                }
                this.func_70106_y();
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                RayTraceResult result = ProcedureUtils.raytraceBlocks((Entity)entity, Math.max(2.0 * (double)power, 20.0));
                if (result != null && result.field_72313_a != RayTraceResult.Type.MISS) {
                    entity.field_70170_p.func_72838_d((Entity)new EC(entity.field_70170_p, result.field_72307_f, power));
                    return true;
                }
                return false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class CustomRender
    extends Render<EC> {
        public CustomRender(RenderManager renderManagerIn) {
            super(renderManagerIn);
        }

        public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return null;
        }
    }
}

