/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.ModConfig;
import net.narutomod.entity.EntityHaku;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntityWaterDragon;
import net.narutomod.entity.EntityWaterPrison;
import net.narutomod.event.EventSetBlocks;
import net.narutomod.item.ItemSuiton;
import net.narutomod.item.ItemZabuzaSword;

@ElementsNarutomodMod.ModElement.Tag
public class EntityZabuzaMomochi
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 154;
    public static final int ENTITYID_RANGED = 155;

    public EntityZabuzaMomochi(ElementsNarutomodMod instance) {
        super(instance, 411);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "zabuza_momochi"), 154).name("zabuza_momochi").tracker(64, 3, true).egg(-6710887, -16764058).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        int i = MathHelper.func_76125_a((int)ModConfig.SPAWN_WEIGHT_ZABUZA, (int)0, (int)20);
        if (i > 0) {
            EntityRegistry.addSpawn(EntityCustom.class, (int)i, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76772_c, Biomes.field_76770_e, Biomes.field_76767_f, Biomes.field_76768_g, Biomes.field_76780_h, Biomes.field_76781_i, Biomes.field_76782_w, Biomes.field_150588_X, Biomes.field_76775_o, Biomes.field_76774_n, Biomes.field_76787_r, Biomes.field_150577_O, Biomes.field_185441_Q, Biomes.field_185443_S, Biomes.field_185444_T, Biomes.field_150590_f, Biomes.field_150599_m, Biomes.field_185446_X, Biomes.field_185435_ag, Biomes.field_185445_W});
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderCustom(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelBiped64
        extends ModelBiped {
            public ModelBiped64() {
                this.field_78090_t = 64;
                this.field_78089_u = 64;
                this.field_187075_l = ModelBiped.ArmPose.EMPTY;
                this.field_187076_m = ModelBiped.ArmPose.EMPTY;
                this.field_78116_c = new ModelRenderer((ModelBase)this);
                this.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_78116_c.field_78804_l.add(new ModelBox(this.field_78116_c, 0, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f, false));
                this.field_78116_c.field_78804_l.add(new ModelBox(this.field_78116_c, 24, 0, -2.0f, -10.0f, 3.0f, 4, 4, 4, 0.0f, false));
                this.field_178720_f = new ModelRenderer((ModelBase)this);
                this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_178720_f.field_78804_l.add(new ModelBox(this.field_178720_f, 32, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.25f, false));
                this.field_78115_e = new ModelRenderer((ModelBase)this);
                this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 16, 16, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.0f, false));
                this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 16, 32, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.25f, false));
                this.field_178723_h = new ModelRenderer((ModelBase)this);
                this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
                this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 16, -3.0f, -2.0f, -2.0f, 4, 12, 4, 0.0f, false));
                this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 32, -3.0f, -2.0f, -2.0f, 4, 12, 4, 0.25f, false));
                this.field_178724_i = new ModelRenderer((ModelBase)this);
                this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
                this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 32, 48, -1.0f, -2.0f, -2.0f, 4, 12, 4, 0.0f, false));
                this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 48, 48, -1.0f, -2.0f, -2.0f, 4, 12, 4, 0.25f, false));
                this.field_178721_j = new ModelRenderer((ModelBase)this);
                this.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
                this.field_178721_j.field_78804_l.add(new ModelBox(this.field_178721_j, 0, 16, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f, false));
                this.field_178721_j.field_78804_l.add(new ModelBox(this.field_178721_j, 0, 32, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.25f, false));
                this.field_178722_k = new ModelRenderer((ModelBase)this);
                this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
                this.field_178722_k.field_78804_l.add(new ModelBox(this.field_178722_k, 16, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f, false));
                this.field_178722_k.field_78804_l.add(new ModelBox(this.field_178722_k, 0, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.25f, false));
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderCustom
        extends EntityNinjaMob.RenderBase<EntityCustom> {
            private final ResourceLocation texture;

            public RenderCustom(RenderManager renderManager) {
                super(renderManager, new ModelBiped64());
                this.texture = new ResourceLocation("narutomod:textures/zabuzamomochi.png");
            }

            protected ResourceLocation getEntityTexture(EntityCustom entity) {
                return this.texture;
            }
        }
    }

    public static class EntityCustom
    extends EntityNinjaMob.Base
    implements IRangedAttackMob,
    IMob {
        private final int MIST_CD = 1200;
        private final int WATERPRISON_CD = 400;
        private final int WATERDRAGON_CD = 300;
        private final int WATERCLONE_CD = 100;
        private final int BLOCKING_CD = 20;
        private final double MIST_CHAKRA = 100.0;
        private final double WATERPRISON_CHAKRA = 200.0;
        private final double WATERDRAGON_CHAKRA = 200.0;
        private final double WATERCLONE_CHAKRA = 500.0;
        private int mistLastUsed = -1200;
        private int prisonLastUsed = -360;
        private int cloneLastUsed = -60;
        private int lastBlockTime;
        private int lastCallForHelp;
        private EntityCustom original;
        private int clones;
        private EntityHaku.EntityCustom haku;
        private EntityLivingBase avoidTarget;
        private final EntityAINearestAttackableTarget aiTargetPlayer = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true, false);
        private final EntityAIHurtByTarget aiTargetHurt = new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]);
        private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);

        public EntityCustom(World world) {
            super(world, 120, 7000.0);
            this.func_70105_a(0.6f, 2.0f);
            this.setAttackTargetsTasks();
            Arrays.fill(this.field_82174_bp, 0.0f);
        }

        public EntityCustom(EntityCustom cloneFrom) {
            this(cloneFrom.field_70170_p);
            this.original = cloneFrom;
            ++this.original.clones;
            this.func_82149_j((Entity)cloneFrom);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
            this.func_70606_j(10.0f);
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityNinjaMob.AIDefendEntity(this, (EntityLivingBase)this.original));
            this.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
        }

        public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
            livingdata = super.func_180482_a(difficulty, livingdata);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemZabuzaSword.block));
            this.spawnHaku();
            return livingdata;
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity(this, EntityLivingBase.class, (Predicate)new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    return p_apply_1_ != null && p_apply_1_.equals((Object)avoidTarget);
                }
            }, 10.0f, 1.25, 1.25){

                public boolean func_75250_a() {
                    if (this.func_110143_aJ() > this.func_110138_aP() * 0.6f && avoidTarget != null) {
                        avoidTarget = null;
                        this.setAttackTargetsTasks();
                        return false;
                    }
                    return super.func_75250_a();
                }
            });
            this.field_70714_bg.func_75776_a(2, new EntityNinjaMob.AIAttackRangedJutsu<EntityCustom>(this, 300, 12.0f));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityNinjaMob.AILeapAtTarget((EntityLiving)this, 1.0f));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee(this, 1.5, true){

                protected double func_179512_a(EntityLivingBase attackTarget) {
                    return 5.3 + (double)attackTarget.field_70130_N;
                }
            });
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 15.0f, 1.0f));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 8.0f));
        }

        public void removeTargetsTasks() {
            this.field_70715_bh.func_85156_a((EntityAIBase)this.aiTargetHurt);
            this.func_70624_b(null);
        }

        public void setAttackTargetsTasks() {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiTargetHurt);
        }

        @Override
        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(100.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        }

        protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
            if (!this.isClone()) {
                this.func_70099_a(this.func_184614_ca(), 0.0f);
                this.func_70099_a(this.getItemFromInventory(0), 0.0f);
            }
        }

        public boolean isClone() {
            return this.original != null;
        }

        public boolean func_184191_r(Entity entityIn) {
            return super.func_184191_r(entityIn) || EntityNinjaMob.TeamZabuza.contains(entityIn.getClass());
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (!this.func_175446_cd() && !source.func_76363_c()) {
                if (this.func_184614_ca().func_190926_b() && source.func_76346_g() instanceof EntityLivingBase) {
                    this.swapWithInventory(EntityEquipmentSlot.MAINHAND, 0);
                }
                if (!this.func_184614_ca().func_190926_b() && !this.func_184585_cz()) {
                    this.func_184598_c(EnumHand.MAIN_HAND);
                    this.field_184628_bn = this.func_184607_cu().func_77988_m() - 5;
                    this.lastBlockTime = this.field_70173_aa;
                }
            }
            return super.func_70097_a(source, amount);
        }

        @Override
        protected void func_70619_bc() {
            super.func_70619_bc();
            EntityLivingBase target = this.func_70638_az();
            if (target != null && target.func_70089_S()) {
                double distanceToTarget = this.func_70032_d((Entity)target);
                if (!this.isClone() && this.field_70173_aa > this.mistLastUsed + 1200 && this.consumeChakra(100.0)) {
                    new ItemSuiton.EntityMist.Jutsu().createJutsu(this.func_184592_cb(), (EntityLivingBase)this, 1.0f);
                    this.mistLastUsed = this.field_70173_aa;
                }
                if (this.isClone() && !EntityWaterPrison.isEntityTrapped(target) && distanceToTarget >= 2.0 && this.field_70173_aa > this.prisonLastUsed + 400 && this.getChakra() >= 200.0) {
                    this.func_70671_ap().func_75651_a((Entity)target, 90.0f, 30.0f);
                    if (new EntityWaterPrison.EC.Jutsu().createJutsu((EntityLivingBase)this, target, 300) != null) {
                        this.swapWithInventory(EntityEquipmentSlot.MAINHAND, 0);
                        this.consumeChakra(200.0);
                        this.prisonLastUsed = this.field_70173_aa;
                    }
                }
                if (!this.isClone() && this.clones < 1 && this.field_70173_aa > this.cloneLastUsed + 100 && this.consumeChakra(500.0)) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:kagebunshin")), 1.0f, 1.0f);
                    this.field_70170_p.func_72838_d((Entity)new EntityCustom(this));
                    this.cloneLastUsed = this.field_70173_aa;
                }
            }
            if (!this.isClone() && this.func_110143_aJ() <= this.func_110138_aP() * 0.4f && this.func_70643_av() != null && this.field_70173_aa > this.lastCallForHelp + 40) {
                this.avoidTarget = this.func_70643_av();
                this.removeTargetsTasks();
                this.callHelp();
                this.lastCallForHelp = this.field_70173_aa;
            }
        }

        private void callHelp() {
            for (Class<? extends EntityNinjaMob.Base> oclass : EntityNinjaMob.TeamZabuza) {
                for (EntityNinjaMob.Base ninja : this.field_70170_p.func_72872_a(oclass, this.func_174813_aQ().func_72314_b(64.0, 8.0, 64.0))) {
                    if (ninja == this || ninja.func_184191_r((Entity)this.avoidTarget)) continue;
                    ninja.func_70624_b(this.avoidTarget);
                }
            }
        }

        protected void func_70609_aI() {
            if (!this.field_70170_p.field_72995_K && this.isClone()) {
                this.func_184185_a(SoundEvents.field_187547_bF, 1.0f, 1.0f);
                new EventSetBlocks(this.field_70170_p, (Map<BlockPos, IBlockState>)ImmutableMap.of((Object)new BlockPos((Entity)this).func_177984_a(), (Object)Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(1))), 0L, 10, false, false);
                this.func_70106_y();
            } else {
                super.func_70609_aI();
            }
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K && this.isClone()) {
                --this.original.clones;
            }
        }

        public void func_184724_a(boolean swingingArms) {
        }

        public void func_82196_d(EntityLivingBase target, float flval) {
            if (!this.field_70170_p.field_72995_K && this.getChakra() >= 200.0) {
                new EntityWaterDragon.EC.Jutsu().createJutsu((EntityLivingBase)this, 1.0f);
                this.consumeChakra(200.0);
                this.standStillFor(60);
            }
        }

        @Override
        public boolean func_70601_bi() {
            return super.func_70601_bi() && this.field_70170_p.func_72872_a(EntityCustom.class, this.func_174813_aQ().func_186662_g(128.0)).isEmpty();
        }

        public boolean func_184222_aU() {
            return this.isClone();
        }

        public void func_184178_b(EntityPlayerMP player) {
            super.func_184178_b(player);
            if (ModConfig.AGGRESSIVE_BOSSES) {
                this.func_70624_b((EntityLivingBase)player);
            }
        }

        public void func_184203_c(EntityPlayerMP player) {
            super.func_184203_c(player);
            if (this.bossInfo.func_186757_c().contains(player)) {
                this.bossInfo.func_186761_b(player);
            }
        }

        private void trackAttackedPlayers() {
            EntityLivingBase entity = this.func_94060_bK();
            if (entity instanceof EntityPlayerMP || (entity = ModConfig.AGGRESSIVE_BOSSES ? this.func_110144_aD() : this.func_70638_az()) instanceof EntityPlayerMP) {
                this.bossInfo.func_186760_a((EntityPlayerMP)entity);
            }
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.func_184585_cz() && this.field_70173_aa > this.lastBlockTime + this.BLOCKING_CD) {
                this.func_184602_cy();
            }
            if (!this.isClone()) {
                this.trackAttackedPlayers();
                this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
                if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 20 && this.haku == null) {
                    this.spawnHaku();
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_94061_f(EntityWaterPrison.isEntityTrapping((EntityLivingBase)this));
                if (!this.original.func_70089_S() || this.original.func_70638_az() == null && this.original.avoidTarget == null) {
                    this.func_70606_j(0.0f);
                }
            }
        }

        private void spawnHaku() {
            if (!this.isClone()) {
                this.haku = (EntityHaku.EntityCustom)this.field_70170_p.func_72857_a(EntityHaku.EntityCustom.class, this.func_174813_aQ().func_72314_b(128.0, 32.0, 128.0), (Entity)this);
                if (this.haku == null) {
                    this.haku = new EntityHaku.EntityCustom(this.field_70170_p);
                    this.haku.setLeader((EntityLivingBase)this);
                    this.haku.func_70107_b(this.field_70165_t + (this.field_70146_Z.nextBoolean() ? 3.0 : -3.0), this.field_70163_u, this.field_70161_v + (this.field_70146_Z.nextBoolean() ? 3.0 : -3.0));
                    this.field_70170_p.func_72838_d((Entity)this.haku);
                } else {
                    this.haku.setLeader((EntityLivingBase)this);
                }
            }
        }

        @Override
        public void func_70014_b(NBTTagCompound compound) {
            super.func_70014_b(compound);
            if (this.isClone()) {
                compound.func_186854_a("originalUUID", this.original.func_110124_au());
            }
        }

        @Override
        public void func_70037_a(NBTTagCompound compound) {
            super.func_70037_a(compound);
            if (this.field_70170_p instanceof WorldServer && compound.func_186855_b("originalUUID")) {
                Entity entity = ((WorldServer)this.field_70170_p).func_175733_a(compound.func_186857_a("originalUUID"));
                if (entity instanceof EntityCustom) {
                    this.original = (EntityCustom)entity;
                } else {
                    this.func_70106_y();
                }
            }
        }
    }
}

