/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.event;

import com.google.common.collect.Maps;
import java.util.Map;

public enum EnumEventType {
    NO_EVENT(0),
    CYLINDRICAL_EXPLOSION(1),
    SPHERICAL_EXPLOSION(2),
    DELAYED_SPAWN(3),
    VILLAGE_SIEGE(4),
    SET_BLOCKS(6),
    VANILLA_EXPLOSION(7),
    DELAYED_CALLBACK(8),
    SOMETHING_ELSE(-1);

    private final int index;
    private static final Map<Integer, EnumEventType> EVENT_TYPES;

    private EnumEventType(int idx) {
        this.index = idx;
    }

    public int getIndex() {
        return this.index;
    }

    public static EnumEventType getTypeFromIndex(int index) {
        return EVENT_TYPES.get(index);
    }

    static {
        EVENT_TYPES = Maps.newHashMap();
        for (EnumEventType type : EnumEventType.values()) {
            EVENT_TYPES.put(type.getIndex(), type);
        }
    }
}

