/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.event;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.narutomod.event.EnumEventType;
import net.narutomod.event.SpecialEvent;

public class EventCylindricalExplosion
extends SpecialEvent {
    private int radius;
    private int height;
    private int tx;
    private int ty;
    private int tz;
    private int tr;
    private boolean mobGriefing;
    private final BlockPos.MutableBlockPos[] posList = new BlockPos.MutableBlockPos[]{new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos()};

    public EventCylindricalExplosion() {
    }

    public EventCylindricalExplosion(World worldIn, Entity entityIn, int x, int yTop, int z, int yBottom, int radiusIn, long startTime) {
        super(EnumEventType.CYLINDRICAL_EXPLOSION, worldIn, entityIn, x, yBottom, z, startTime);
        if (!worldIn.field_72995_K) {
            this.mobGriefing = ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entityIn);
            this.radius = radiusIn;
            this.ty = yTop;
            this.height = this.ty - this.y0;
        }
    }

    @Override
    protected void onUpdate() {
        if (!this.shouldExecute()) {
            return;
        }
        super.onUpdate();
        if (this.sound && this.tick % 10 == 0) {
            this.world.func_184148_a(null, (double)this.x0, (double)this.y0, (double)this.z0, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:ground_charge")), SoundCategory.NEUTRAL, 50.0f, rand.nextFloat() * 0.7f + 0.3f);
        }
        int i = 0;
        while (i < 1024) {
            this.posList[0].func_181079_c(this.x0 + this.tx, this.y0 + this.ty, this.z0 + this.tz);
            this.posList[1].func_181079_c(this.x0 - this.tx, this.y0 + this.ty, this.z0 + this.tz);
            this.posList[2].func_181079_c(this.x0 + this.tx, this.y0 + this.ty, this.z0 - this.tz);
            this.posList[3].func_181079_c(this.x0 - this.tx, this.y0 + this.ty, this.z0 - this.tz);
            this.posList[4].func_181079_c(this.x0 + this.tz, this.y0 + this.ty, this.z0 + this.tx);
            this.posList[5].func_181079_c(this.x0 + this.tz, this.y0 + this.ty, this.z0 - this.tx);
            this.posList[6].func_181079_c(this.x0 - this.tz, this.y0 + this.ty, this.z0 + this.tx);
            this.posList[7].func_181079_c(this.x0 - this.tz, this.y0 + this.ty, this.z0 - this.tx);
            this.posList[8].func_181079_c(this.x0 + this.tx - 1, this.y0 + this.ty, this.z0 + this.tz);
            this.posList[9].func_181079_c(this.x0 - this.tx + 1, this.y0 + this.ty, this.z0 + this.tz);
            this.posList[10].func_181079_c(this.x0 + this.tx - 1, this.y0 + this.ty, this.z0 - this.tz);
            this.posList[11].func_181079_c(this.x0 - this.tx + 1, this.y0 + this.ty, this.z0 - this.tz);
            this.posList[12].func_181079_c(this.x0 + this.tz, this.y0 + this.ty, this.z0 + this.tx - 1);
            this.posList[13].func_181079_c(this.x0 + this.tz, this.y0 + this.ty, this.z0 - this.tx + 1);
            this.posList[14].func_181079_c(this.x0 - this.tz, this.y0 + this.ty, this.z0 + this.tx - 1);
            this.posList[15].func_181079_c(this.x0 - this.tz, this.y0 + this.ty, this.z0 - this.tx + 1);
            for (BlockPos.MutableBlockPos pos : this.posList) {
                if (this.world.func_175623_d((BlockPos)pos)) continue;
                if (this.mobGriefing) {
                    this.world.func_175698_g((BlockPos)pos);
                }
                if (this.particles) {
                    ((WorldServer)this.world).func_175739_a(EnumParticleTypes.EXPLOSION_LARGE, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1, 1.0, 1.0, 1.0, 3.0, new int[0]);
                    ((WorldServer)this.world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1, 1.0, 1.0, 1.0, 0.0, new int[0]);
                }
                ++i;
            }
            --this.ty;
            if (this.ty < this.y0) {
                this.ty = this.y0 + this.height;
                ++this.tz;
                this.tx = (int)Math.round(Math.sqrt(this.tr * this.tr - this.tz * this.tz));
            }
            if (this.tz > (int)Math.round((double)this.tr / 1.41421356)) {
                this.tz = 0;
                this.tx = ++this.tr;
            }
            if (this.tr <= this.radius) continue;
            this.clear();
            return;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("radius", this.radius);
        compound.func_74768_a("height", this.height);
        compound.func_74768_a("tx", this.tx);
        compound.func_74768_a("ty", this.ty);
        compound.func_74768_a("tz", this.tz);
        compound.func_74768_a("tr", this.tr);
        compound.func_74757_a("mobGriefing", this.mobGriefing);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.radius = compound.func_74762_e("radius");
        this.height = compound.func_74762_e("height");
        this.tx = compound.func_74762_e("tx");
        this.ty = compound.func_74762_e("ty");
        this.tz = compound.func_74762_e("tz");
        this.tr = compound.func_74762_e("tr");
        this.mobGriefing = compound.func_74767_n("mobGriefing");
    }

    @Override
    public String toString() {
        return super.toString() + " {radius:" + this.radius + ",height:" + this.height + ",mobGriefing:" + this.mobGriefing + "}";
    }
}

