/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.event;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.narutomod.event.EnumEventType;
import net.narutomod.event.SpecialEvent;
import net.narutomod.procedure.ProcedureAoeCommand;
import net.narutomod.procedure.ProcedureCameraShake;

public class EventSphericalExplosion
extends SpecialEvent {
    private int radius;
    private int tx;
    private int ty;
    private int tz;
    private int tr;
    private boolean mobGriefing;
    private boolean useBlockExplosionResistance;
    private float fireChance;
    private final BlockPos.MutableBlockPos[] posList = new BlockPos.MutableBlockPos[]{new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos(), new BlockPos.MutableBlockPos()};

    public EventSphericalExplosion() {
    }

    public EventSphericalExplosion(World worldIn, Entity excludeEntity, int x, int y, int z, int radiusIn, long startTime) {
        this(worldIn, excludeEntity, x, y, z, radiusIn, startTime, 0.0f);
    }

    public EventSphericalExplosion(World worldIn, Entity excludeEntity, int x, int y, int z, int radiusIn, long startTime, float fireChanceIn) {
        this(worldIn, excludeEntity, x, y, z, radiusIn, startTime, fireChanceIn, true, true);
    }

    public EventSphericalExplosion(World worldIn, Entity excludeEntity, int x, int y, int z, int radiusIn, long startTime, float fireChanceIn, boolean particlesIn, boolean soundIn) {
        this(worldIn, excludeEntity, x, y, z, radiusIn, startTime, true, fireChanceIn, particlesIn, soundIn);
    }

    public EventSphericalExplosion(World worldIn, Entity excludeEntity, int x, int y, int z, int radiusIn, long startTime, boolean useResistance, float fireChanceIn, boolean particlesIn, boolean soundIn) {
        super(EnumEventType.SPHERICAL_EXPLOSION, worldIn, excludeEntity, x, y, z, startTime, particlesIn, soundIn);
        if (!worldIn.field_72995_K) {
            this.mobGriefing = ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)excludeEntity);
            this.ty = this.radius = radiusIn;
            this.useBlockExplosionResistance = useResistance;
            this.fireChance = fireChanceIn;
        }
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    protected void onUpdate() {
        if (!this.shouldExecute()) {
            return;
        }
        super.onUpdate();
        this.doOnTick(this.tick);
        if (this.sound) {
            if (this.tick == 1) {
                this.world.func_184148_a(null, (double)this.x0, (double)this.y0, (double)this.z0, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 10.0f, rand.nextFloat() * 0.5f + 0.5f);
            } else if (this.tick % 40 == 10) {
                this.world.func_184148_a(null, (double)this.x0, (double)this.y0, (double)this.z0, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:explosion")), SoundCategory.BLOCKS, Math.max(10.0f - (float)(this.tick / 40), 1.0f), rand.nextFloat() * 0.5f + 0.5f);
            }
        }
        if (this.radius > 20) {
            float f = 1.0f - (float)(this.tr / this.radius);
            ProcedureCameraShake.sendToClients(this.world.field_73011_w.getDimension(), this.x0, this.y0, this.z0, 8.0f * MathHelper.func_76129_c((float)f) + (float)this.tr, 80, 8.0f * f);
        }
        int i = 0;
        while (i < 1024) {
            this.posList[0].func_181079_c(this.x0 + this.tx, this.y0 + this.ty, this.z0 + this.tz);
            this.posList[1].func_181079_c(this.x0 - this.tx, this.y0 + this.ty, this.z0 + this.tz);
            this.posList[2].func_181079_c(this.x0 + this.tx, this.y0 + this.ty, this.z0 - this.tz);
            this.posList[3].func_181079_c(this.x0 - this.tx, this.y0 + this.ty, this.z0 - this.tz);
            this.posList[4].func_181079_c(this.x0 + this.tz, this.y0 + this.ty, this.z0 + this.tx);
            this.posList[5].func_181079_c(this.x0 + this.tz, this.y0 + this.ty, this.z0 - this.tx);
            this.posList[6].func_181079_c(this.x0 - this.tz, this.y0 + this.ty, this.z0 + this.tx);
            this.posList[7].func_181079_c(this.x0 - this.tz, this.y0 + this.ty, this.z0 - this.tx);
            this.posList[8].func_181079_c(this.x0 + this.tx - 1, this.y0 + this.ty, this.z0 + this.tz);
            this.posList[9].func_181079_c(this.x0 - this.tx + 1, this.y0 + this.ty, this.z0 + this.tz);
            this.posList[10].func_181079_c(this.x0 + this.tx - 1, this.y0 + this.ty, this.z0 - this.tz);
            this.posList[11].func_181079_c(this.x0 - this.tx + 1, this.y0 + this.ty, this.z0 - this.tz);
            this.posList[12].func_181079_c(this.x0 + this.tz, this.y0 + this.ty, this.z0 + this.tx - 1);
            this.posList[13].func_181079_c(this.x0 + this.tz, this.y0 + this.ty, this.z0 - this.tx + 1);
            this.posList[14].func_181079_c(this.x0 - this.tz, this.y0 + this.ty, this.z0 + this.tx - 1);
            this.posList[15].func_181079_c(this.x0 - this.tz, this.y0 + this.ty, this.z0 - this.tx + 1);
            for (BlockPos.MutableBlockPos pos : this.posList) {
                IBlockState blockstate = this.world.func_180495_p((BlockPos)pos);
                if (blockstate.func_185904_a() == Material.field_151579_a) continue;
                if (!((double)rand.nextFloat() <= 1.75 - pos.func_185332_f(this.x0, this.y0, this.z0) / (double)this.radius)) continue;
                if (this.mobGriefing && blockstate.func_185887_b(this.world, (BlockPos)pos) >= 0.0f) {
                    float f = (float)this.radius * (0.7f + rand.nextFloat() * 0.6f);
                    float f1 = blockstate.func_177230_c().func_149638_a(null);
                    f1 = this.useBlockExplosionResistance ? f1 : (f1 >= 3600000.0f ? f1 : 0.0f);
                    if ((f -= (f1 + 0.3f) * 0.3f) > 0.0f) {
                        blockstate.func_177230_c().func_180653_a(this.world, (BlockPos)pos, blockstate, 0.5f / (float)this.radius, 0);
                        this.world.func_175698_g((BlockPos)pos);
                    }
                }
                if (this.particles) {
                    ((WorldServer)this.world).func_175739_a(EnumParticleTypes.EXPLOSION_LARGE, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1, 1.0, 1.0, 1.0, 3.0, new int[0]);
                    ((WorldServer)this.world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1, 1.0, 1.0, 1.0, 0.0, new int[0]);
                }
                ++i;
            }
            int i1 = (int)Math.round(Math.sqrt(this.radius * this.radius - this.tr * this.tr));
            --this.ty;
            if (this.y0 + this.ty >= 255) continue;
            if (this.ty < -i1 || this.y0 + this.ty < 0) {
                this.ty = i1;
                ++this.tz;
                this.tx = (int)Math.round(Math.sqrt(this.tr * this.tr - this.tz * this.tz));
            }
            if (this.tz > (int)Math.round((double)this.tr / 1.41421356)) {
                this.tz = 0;
                this.tx = ++this.tr;
            }
            if (this.tr <= this.radius) continue;
            if (this.mobGriefing && this.fireChance > 0.01f) {
                ProcedureAoeCommand.set(this.world, this.x0, this.y0, this.z0, 0.0, (double)this.radius * 1.1).setFire(this.fireChance);
            }
            this.clear();
            return;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("radius", this.radius);
        compound.func_74768_a("tx", this.tx);
        compound.func_74768_a("ty", this.ty);
        compound.func_74768_a("tz", this.tz);
        compound.func_74768_a("tr", this.tr);
        compound.func_74757_a("mobGriefing", this.mobGriefing);
        compound.func_74757_a("useBlockExplosionResistance", this.useBlockExplosionResistance);
        compound.func_74776_a("fireChance", this.fireChance);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.radius = compound.func_74762_e("radius");
        this.tx = compound.func_74762_e("tx");
        this.ty = compound.func_74762_e("ty");
        this.tz = compound.func_74762_e("tz");
        this.tr = compound.func_74762_e("tr");
        this.mobGriefing = compound.func_74767_n("mobGriefing");
        this.useBlockExplosionResistance = compound.func_74767_n("useBlockExplosionResistance");
        this.fireChance = compound.func_74760_g("fireChance");
    }

    @Override
    public String toString() {
        return super.toString() + " {radius:" + this.radius + ",mobGriefing:" + this.mobGriefing + ",fireChance:" + this.fireChance + "}";
    }
}

