/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.event;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.narutomod.event.EnumEventType;
import net.narutomod.event.SpecialEvent;
import net.narutomod.item.ItemNinjaArmorKonoha;
import net.narutomod.item.ItemNinjaArmorSuna;
import net.narutomod.procedure.ProcedureUtils;

public class EventVillageSiege
extends SpecialEvent {
    private Entity mobToSpawn;
    private int radius;
    private int spawnInterval;
    private static final List<Class<? extends EntityLiving>> MOBTYPES = Lists.newArrayList((Object[])new Class[]{EntityZombie.class, EntitySkeleton.class});
    private static final List<ItemStack> HELMETTYPES = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(ItemNinjaArmorKonoha.helmet), new ItemStack(ItemNinjaArmorSuna.helmet)});
    private static final List<ItemStack> VESTTYPES = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(ItemNinjaArmorKonoha.body), new ItemStack(ItemNinjaArmorSuna.body)});
    private static final List<ItemStack> PANTSTYPES = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(ItemNinjaArmorKonoha.legs), new ItemStack(ItemNinjaArmorSuna.legs)});

    public EventVillageSiege() {
    }

    public EventVillageSiege(World worldIn, Entity mob, int centerX, int centerY, int centerZ, long startTime, int radiusIn, int spawnIntervalIn) {
        super(EnumEventType.VILLAGE_SIEGE, worldIn, mob, centerX, centerY, centerZ, startTime);
        if (!worldIn.field_72995_K) {
            this.mobToSpawn = mob;
            this.radius = radiusIn;
            this.spawnInterval = spawnIntervalIn;
        }
    }

    @Override
    protected void onUpdate() {
        if (!this.shouldExecute()) {
            return;
        }
        super.onUpdate();
        if (this.tick == 1) {
            ProcedureUtils.sendMessageToAllNear(I18n.func_74838_a((String)"chattext.specialevent.villagesiege"), this.x0, this.y0, this.z0, this.radius + 10, this.world.field_73011_w.getDimension());
            this.doOnTick(0);
        }
        if (this.world.func_72935_r()) {
            this.doOnTick(this.tick);
            this.clear();
            return;
        }
        double r = rand.nextDouble() * 0.6 + 0.5;
        if (this.tick % this.spawnInterval == 0) {
            if (rand.nextDouble() <= r - 0.0) {
                double a = Math.PI * (rand.nextDouble() - 0.5) * 2.0;
                double x = (double)this.x0 + Math.cos(a) * (r *= (double)this.radius);
                double z = (double)this.z0 + Math.sin(a) * r;
                for (double y = 253.0; y > 0.0; y -= 1.0) {
                    if (this.world.func_175623_d(new BlockPos(x, y, z))) continue;
                    Entity mob = this.mobToSpawn instanceof EntityLiving ? this.mobToSpawn : this.newEntityFromClassName(MOBTYPES.get(rand.nextInt(MOBTYPES.size())).getName());
                    mob.func_70107_b(x, y + 1.0, z);
                    ((EntityLiving)mob).func_180482_a(this.world.func_175649_E(new BlockPos(mob)), null);
                    int i = rand.nextInt(VESTTYPES.size());
                    ((EntityLiving)mob).func_184201_a(EntityEquipmentSlot.HEAD, HELMETTYPES.get(i));
                    ((EntityLiving)mob).func_184201_a(EntityEquipmentSlot.CHEST, VESTTYPES.get(i));
                    ((EntityLiving)mob).func_184201_a(EntityEquipmentSlot.LEGS, PANTSTYPES.get(i));
                    this.world.func_72838_d(mob);
                    return;
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.mobToSpawn != null) {
            compound.func_74778_a("EntityClass", this.mobToSpawn.getClass().getName());
        }
        compound.func_74768_a("radius", this.radius);
        compound.func_74768_a("spawnInterval", this.spawnInterval);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b("EntityClass")) {
            this.mobToSpawn = this.newEntityFromClassName(compound.func_74779_i("EntityClass"));
        }
        this.radius = compound.func_74762_e("radius");
        this.spawnInterval = compound.func_74762_e("spawnInterval");
    }

    @Override
    public String toString() {
        return super.toString() + " {radius:" + this.radius + ",spawnInterval:" + this.spawnInterval + "}";
    }
}

