/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.event;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.narutomod.SaveData;
import net.narutomod.event.EnumEventType;
import net.narutomod.event.EventCylindricalExplosion;
import net.narutomod.event.EventDelayedCallback;
import net.narutomod.event.EventDelayedSpawn;
import net.narutomod.event.EventSetBlocks;
import net.narutomod.event.EventSphericalExplosion;
import net.narutomod.event.EventVanillaExplosion;
import net.narutomod.event.EventVillageSiege;

public abstract class SpecialEvent {
    private static final Map<Integer, Class<? extends SpecialEvent>> REGISTERED_EVENTS = ImmutableMap.builder().put((Object)EnumEventType.CYLINDRICAL_EXPLOSION.getIndex(), EventCylindricalExplosion.class).put((Object)EnumEventType.SPHERICAL_EXPLOSION.getIndex(), EventSphericalExplosion.class).put((Object)EnumEventType.DELAYED_SPAWN.getIndex(), EventDelayedSpawn.class).put((Object)EnumEventType.VILLAGE_SIEGE.getIndex(), EventVillageSiege.class).put((Object)EnumEventType.SET_BLOCKS.getIndex(), EventSetBlocks.class).put((Object)EnumEventType.VANILLA_EXPLOSION.getIndex(), EventVanillaExplosion.class).put((Object)EnumEventType.DELAYED_CALLBACK.getIndex(), EventDelayedCallback.class).build();
    private static final Map<Integer, SpecialEvent> eventsMap = Maps.newHashMap();
    protected static final Random rand = new Random();
    protected EnumEventType type = EnumEventType.NO_EVENT;
    protected int id;
    protected World world = null;
    protected UUID entityUuid = null;
    protected long startTime = 0L;
    protected int tick = 0;
    protected int x0;
    protected int y0;
    protected int z0;
    protected boolean particles;
    protected boolean sound;
    private boolean clear;

    public static void setMassExplosionEvent(World worldIn, int x, int yt, int z, int yb, int r) {
        if (!worldIn.field_72995_K && r > 0) {
            new EventCylindricalExplosion(worldIn, null, x, yt, z, yb, r, 0L);
        }
    }

    public static void setSphericalExplosionEvent(World worldIn, int x, int y, int z, int r, Entity excludeEntity) {
        if (!worldIn.field_72995_K && r > 0) {
            new EventSphericalExplosion(worldIn, excludeEntity, x, y, z, r, 0L);
        }
    }

    public static void setSphericalExplosionEvent(World worldIn, int x, int y, int z, int r, Entity excludeEntity, float fireChance) {
        if (!worldIn.field_72995_K && r > 0) {
            new EventSphericalExplosion(worldIn, excludeEntity, x, y, z, r, 0L, fireChance);
        }
    }

    public static void setDelayedSpawnEvent(World worldIn, Entity entityIn, int xOffset, int yOffset, int zOffset, long timeToSpawn) {
        if (!worldIn.field_72995_K) {
            new EventDelayedSpawn(worldIn, entityIn, xOffset, yOffset, zOffset, timeToSpawn);
        }
    }

    public static void setVillageSiegeEvent(World worldIn, int centerX, int centerY, int centerZ, long startTime, int radius, Entity mob, int spawnInterval) {
        if (!worldIn.field_72995_K) {
            new EventVillageSiege(worldIn, mob, centerX, centerY, centerZ, startTime, radius, spawnInterval);
        }
    }

    public SpecialEvent() {
    }

    public SpecialEvent(EnumEventType typeIn, World worldIn, Entity entityIn, int x, int y, int z, long timeToExecute) {
        this(typeIn, worldIn, entityIn, x, y, z, timeToExecute, true, true);
    }

    public SpecialEvent(EnumEventType typeIn, World worldIn, Entity entityIn, int x, int y, int z, long timeToExecute, boolean particles, boolean sounds) {
        if (!worldIn.field_72995_K) {
            this.type = typeIn;
            this.id = rand.nextInt();
            this.particles = particles;
            this.sound = sounds;
            this.world = worldIn;
            if (entityIn != null && entityIn.isAddedToWorld()) {
                this.entityUuid = entityIn.func_110124_au();
            }
            this.x0 = x;
            this.y0 = y;
            this.z0 = z;
            this.startTime = timeToExecute < this.world.func_82737_E() ? this.world.func_82737_E() : timeToExecute;
            eventsMap.put(this.id, this);
            Save.getInstance().func_76185_a();
        }
    }

    public void clear() {
        this.clear = true;
    }

    public boolean isCleared() {
        return this.clear;
    }

    public int getID() {
        return this.id;
    }

    public static SpecialEvent getEventFromId(int id) {
        return eventsMap.get(id);
    }

    public World getWorld() {
        return this.world;
    }

    public int getX0() {
        return this.x0;
    }

    public int getY0() {
        return this.y0;
    }

    public int getZ0() {
        return this.z0;
    }

    public Entity getEntity() {
        return ((WorldServer)this.world).func_175733_a(this.entityUuid);
    }

    protected boolean shouldExecute() {
        return this.world != null && this.world.func_82737_E() >= this.startTime;
    }

    protected void onUpdate() {
        if (this.type == EnumEventType.NO_EVENT) {
            this.clear();
            return;
        }
        ++this.tick;
    }

    protected void doOnTick(int currentTick) {
    }

    protected Entity newEntityFromClassName(String name) {
        try {
            Constructor<?> constructor = Class.forName(name).getConstructor(World.class);
            Object newobj = constructor.newInstance(this.world);
            if (newobj instanceof Entity) {
                return (Entity)newobj;
            }
        }
        catch (Exception e) {
            System.err.println("Entity class " + name + " not found or contructor(World) does not exist.");
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("Type", this.type.getIndex());
        compound.func_74768_a("ID", this.id);
        compound.func_74768_a("World", this.world.field_73011_w.getDimension());
        if (this.entityUuid != null) {
            compound.func_186854_a("EntityUUID", this.entityUuid);
        }
        compound.func_74772_a("Start", this.startTime);
        compound.func_74768_a("Tick", this.tick);
        compound.func_74768_a("x0", this.x0);
        compound.func_74768_a("y0", this.y0);
        compound.func_74768_a("z0", this.z0);
        compound.func_74757_a("Sound", this.sound);
        compound.func_74757_a("Particles", this.particles);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.type = EnumEventType.getTypeFromIndex(compound.func_74762_e("Type"));
        this.id = compound.func_74762_e("ID");
        this.world = DimensionManager.getWorld((int)compound.func_74762_e("World"));
        if (this.world != null) {
            if (compound.func_186855_b("EntityUUID")) {
                this.entityUuid = compound.func_186857_a("EntityUUID");
            }
            this.startTime = compound.func_74763_f("Start");
            this.tick = compound.func_74762_e("Tick");
            this.x0 = compound.func_74762_e("x0");
            this.y0 = compound.func_74762_e("y0");
            this.z0 = compound.func_74762_e("z0");
            this.sound = compound.func_74767_n("Sound");
            this.particles = compound.func_74767_n("Particles");
        } else {
            this.clear();
        }
    }

    public static void writeEventsToNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (SpecialEvent event : eventsMap.values()) {
            if (event == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            event.writeToNBT(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (!nbttaglist.func_82582_d()) {
            compound.func_74782_a("SpecialEvents", (NBTBase)nbttaglist);
        }
    }

    public static void readEventsFromNBT(NBTTagCompound compound) {
        if (compound.func_150297_b("SpecialEvents", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("SpecialEvents", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int type = nbttagcompound.func_74762_e("Type");
                try {
                    SpecialEvent event = REGISTERED_EVENTS.get(type).getConstructor(new Class[0]).newInstance(new Object[0]);
                    event.readFromNBT(nbttagcompound);
                    eventsMap.put(event.id, event);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unregistered special event type " + type, e);
                }
            }
        }
    }

    public static void executeEvents() {
        Iterator<SpecialEvent> iter = eventsMap.values().iterator();
        while (iter.hasNext()) {
            SpecialEvent event = iter.next();
            if (event == null) continue;
            if (event.clear) {
                iter.remove();
                Save.getInstance().func_76185_a();
                continue;
            }
            event.onUpdate();
        }
    }

    public String toString() {
        return "Event:{Type:" + (Object)((Object)this.type) + ",ID:" + this.id + ",Dim:" + (this.world != null ? Integer.valueOf(this.world.field_73011_w.getDimension()) : "n") + ",EntityUUID:" + (this.entityUuid != null ? this.entityUuid.toString() : "none") + ",startTime:" + this.startTime + ",worldTime:" + (this.world != null ? Long.valueOf(this.world.func_82737_E()) : "n") + ",at:(" + this.x0 + "," + this.y0 + "," + this.z0 + ")}";
    }

    public static class Save
    extends WorldSavedData
    implements SaveData.ISaveData {
        private static final String DATA_NAME = "narutomod_specialevents";
        private static Save instance = null;

        public Save() {
            super(DATA_NAME);
        }

        public Save(String name) {
            super(name);
            instance = this;
        }

        @Override
        public Save loadData() {
            return Save.getInstance();
        }

        @Override
        public void resetData() {
            eventsMap.clear();
            instance = null;
        }

        public static Save getInstance() {
            MapStorage storage;
            if (instance == null && (instance = (Save)(storage = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T()).func_75742_a(Save.class, DATA_NAME)) == null) {
                instance = new Save();
                storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            }
            return instance;
        }

        public void func_76184_a(NBTTagCompound compound) {
            SpecialEvent.readEventsFromNBT(compound);
        }

        public NBTTagCompound func_189551_b(NBTTagCompound compound) {
            SpecialEvent.writeEventsToNBT(compound);
            return compound;
        }
    }
}

