/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.gui;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.item.ItemTeamScroll;
import net.narutomod.procedure.ProcedureTeamManagerJoin;
import net.narutomod.procedure.ProcedureTeamManagerLeave;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@ElementsNarutomodMod.ModElement.Tag
public class GuiTeamManager
extends ElementsNarutomodMod.ModElement {
    public static int GUIID = 41;
    public static HashMap guistate = new HashMap();

    public GuiTeamManager(ElementsNarutomodMod instance) {
        super(instance, 553);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(GUIButtonPressedMessage.Handler.class, GUIButtonPressedMessage.class, Side.SERVER);
        this.elements.addNetworkMessage(GUISlotChangedMessage.Handler.class, GUISlotChangedMessage.class, Side.SERVER);
    }

    private static void handleButtonAction(EntityPlayer entity, int buttonID, int x, int y, int z) {
        HashMap<String, Object> $_dependencies;
        World world = entity.field_70170_p;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", entity);
            $_dependencies.put("world", world);
            ProcedureTeamManagerLeave.executeProcedure($_dependencies);
        }
        if (buttonID == 1) {
            $_dependencies = new HashMap();
            $_dependencies.put("entity", entity);
            $_dependencies.put("world", world);
            ProcedureTeamManagerJoin.executeProcedure($_dependencies);
        }
    }

    private static void handleSlotAction(EntityPlayer entity, int slotID, int changeType, int meta, int x, int y, int z) {
        World world = entity.field_70170_p;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
    }

    public static class GUISlotChangedMessage
    implements IMessage {
        int slotID;
        int x;
        int y;
        int z;
        int changeType;
        int meta;

        public GUISlotChangedMessage() {
        }

        public GUISlotChangedMessage(int slotID, int x, int y, int z, int changeType, int meta) {
            this.slotID = slotID;
            this.x = x;
            this.y = y;
            this.z = z;
            this.changeType = changeType;
            this.meta = meta;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.slotID);
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
            buf.writeInt(this.changeType);
            buf.writeInt(this.meta);
        }

        public void fromBytes(ByteBuf buf) {
            this.slotID = buf.readInt();
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
            this.changeType = buf.readInt();
            this.meta = buf.readInt();
        }

        public static class Handler
        implements IMessageHandler<GUISlotChangedMessage, IMessage> {
            public IMessage onMessage(GUISlotChangedMessage message, MessageContext context) {
                EntityPlayerMP entity = context.getServerHandler().field_147369_b;
                entity.func_71121_q().func_152344_a(() -> {
                    int slotID = message.slotID;
                    int changeType = message.changeType;
                    int meta = message.meta;
                    int x = message.x;
                    int y = message.y;
                    int z = message.z;
                    GuiTeamManager.handleSlotAction((EntityPlayer)entity, slotID, changeType, meta, x, y, z);
                });
                return null;
            }
        }
    }

    public static class GUIButtonPressedMessage
    implements IMessage {
        int buttonID;
        int x;
        int y;
        int z;

        public GUIButtonPressedMessage() {
        }

        public GUIButtonPressedMessage(int buttonID, int x, int y, int z) {
            this.buttonID = buttonID;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.buttonID);
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
        }

        public void fromBytes(ByteBuf buf) {
            this.buttonID = buf.readInt();
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
        }

        public static class Handler
        implements IMessageHandler<GUIButtonPressedMessage, IMessage> {
            public IMessage onMessage(GUIButtonPressedMessage message, MessageContext context) {
                EntityPlayerMP entity = context.getServerHandler().field_147369_b;
                entity.func_71121_q().func_152344_a(() -> {
                    int buttonID = message.buttonID;
                    int x = message.x;
                    int y = message.y;
                    int z = message.z;
                    GuiTeamManager.handleButtonAction((EntityPlayer)entity, buttonID, x, y, z);
                });
                return null;
            }
        }
    }

    public static class GuiWindow
    extends GuiContainer {
        private World world;
        private int x;
        private int y;
        private int z;
        private EntityPlayer entity;
        private GuiButton joinButton;
        private GuiButton leaveButton;

        public GuiWindow(World world, int x, int y, int z, EntityPlayer entity) {
            super((Container)new GuiContainerMod(world, x, y, z, entity));
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.entity = entity;
            this.field_146999_f = 257;
            this.field_147000_g = 156;
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_146976_a(float par1, int par2, int par3) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_73735_i = 0.0f;
            this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("narutomod:textures/scroll_empty.png"));
            GuiWindow.func_146110_a((int)(this.field_147003_i + 1), (int)(this.field_147009_r + -50), (float)0.0f, (float)0.0f, (int)256, (int)256, (float)256.0f, (float)256.0f);
        }

        public void func_73876_c() {
            super.func_73876_c();
            ItemStack helditem = this.entity.func_184614_ca();
            if (helditem.func_77973_b() == ItemTeamScroll.block) {
                Collection<String> names = ItemTeamScroll.ItemCustom.getTeamMembers(this.world, helditem);
                this.joinButton.field_146124_l = names.size() < 3 && !names.contains(this.entity.func_70005_c_());
                this.leaveButton.field_146124_l = names.contains(this.entity.func_70005_c_());
            } else {
                this.joinButton.field_146124_l = false;
                this.leaveButton.field_146124_l = false;
            }
        }

        protected void func_146979_b(int par1, int par2) {
            ItemStack helditem = this.entity.func_184614_ca();
            if (helditem.func_77973_b() == ItemTeamScroll.block) {
                this.field_146289_q.func_78276_b("Team " + ItemTeamScroll.ItemCustom.getTeamDisplayName(this.world, helditem), 61, 34, -14935012);
                int i = 0;
                int j = 66;
                for (String name : ItemTeamScroll.ItemCustom.getTeamMembers(this.world, helditem)) {
                    if (i >= 3) break;
                    this.field_146289_q.func_78276_b(name, 61, j, -13682508);
                    j += 16;
                    ++i;
                }
            }
        }

        public void func_146281_b() {
            super.func_146281_b();
            Keyboard.enableRepeatEvents((boolean)false);
        }

        public void func_73866_w_() {
            super.func_73866_w_();
            this.field_147003_i = (this.field_146294_l - 257) / 2;
            this.field_147009_r = (this.field_146295_m - 156) / 2;
            Keyboard.enableRepeatEvents((boolean)true);
            this.field_146292_n.clear();
            this.leaveButton = new GuiButton(0, this.field_147003_i + 205, this.field_147009_r + 106, 44, 20, "Leave");
            this.joinButton = new GuiButton(1, this.field_147003_i + 205, this.field_147009_r + 82, 44, 20, "Join");
            this.field_146292_n.add(this.leaveButton);
            this.field_146292_n.add(this.joinButton);
            ItemStack helditem = this.entity.func_184614_ca();
        }

        protected void func_146284_a(GuiButton button) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new GUIButtonPressedMessage(button.field_146127_k, this.x, this.y, this.z));
            GuiTeamManager.handleButtonAction(this.entity, button.field_146127_k, this.x, this.y, this.z);
        }

        public boolean func_73868_f() {
            return false;
        }
    }

    public static class GuiContainerMod
    extends Container
    implements Supplier<Map<Integer, Slot>> {
        private IInventory internal;
        private World world;
        private EntityPlayer entity;
        private int x;
        private int y;
        private int z;
        private Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();

        public GuiContainerMod(World world, int x, int y, int z, EntityPlayer player) {
            this.world = world;
            this.entity = player;
            this.x = x;
            this.y = y;
            this.z = z;
            this.internal = new InventoryBasic("", true, 0);
        }

        @Override
        public Map<Integer, Slot> get() {
            return this.customSlots;
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.internal.func_70300_a(player);
        }

        public void func_75134_a(EntityPlayer playerIn) {
            super.func_75134_a(playerIn);
            if (this.internal instanceof InventoryBasic && playerIn instanceof EntityPlayerMP) {
                this.func_193327_a(playerIn, playerIn.field_70170_p, this.internal);
            }
        }

        private void slotChanged(int slotid, int ctype, int meta) {
            if (this.world != null && this.world.field_72995_K) {
                NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new GUISlotChangedMessage(slotid, this.x, this.y, this.z, ctype, meta));
                GuiTeamManager.handleSlotAction(this.entity, slotid, ctype, meta, this.x, this.y, this.z);
            }
        }
    }
}

