/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.gui.overlay;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.PlayerTracker;
import net.narutomod.entity.EntityAltCamView;
import net.narutomod.item.ItemByakugan;

@ElementsNarutomodMod.ModElement.Tag
public class OverlayByakuganView
extends ElementsNarutomodMod.ModElement {
    public static boolean byakuganActivated = false;
    private static float renderDistanceChunks;

    public OverlayByakuganView(ElementsNarutomodMod instance) {
        super(instance, 102);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(CustomDataMessage.Handler.class, CustomDataMessage.class, Side.CLIENT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new GUIRenderEventClass());
    }

    public static void sendCustomData(Entity player, boolean activated, float fov) {
        if (player != null && player instanceof EntityPlayerMP) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new CustomDataMessage(activated, fov), (EntityPlayerMP)player);
        }
    }

    public static class GUIRenderEventClass {
        private final List<EntityLivingBase> glowList = Lists.newArrayList();
        private float prevrenderDistanceChunks;
        private int prevRenderDistance;
        private boolean first_on = true;
        private EntityAltCamView.EntityCustom camEntity = null;

        @SubscribeEvent(priority=EventPriority.NORMAL)
        @SideOnly(value=Side.CLIENT)
        public void eventHandler(RenderGameOverlayEvent event) {
            if (!event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
                Minecraft mc = Minecraft.func_71410_x();
                EntityPlayerSP player = mc.field_71439_g;
                if (((ItemStack)player.field_71071_by.field_70460_b.get(3)).func_77973_b() == ItemByakugan.helmet && byakuganActivated) {
                    int sWidth = event.getResolution().func_78326_a();
                    int sHeight = event.getResolution().func_78328_b();
                    int color = 0x1AFFFFFF;
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179115_u();
                    GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.INVERT);
                    GuiIngame.func_73734_a((int)0, (int)0, (int)sWidth, (int)sHeight, (int)color);
                    GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.COPY);
                    GlStateManager.func_179134_v();
                    GlStateManager.func_179118_c();
                    GuiIngame.func_73734_a((int)(sWidth / 2 - 5), (int)(sHeight / 2), (int)(sWidth / 2 + 5), (int)(sHeight / 2 + 1), (int)-1);
                    GuiIngame.func_73734_a((int)(sWidth / 2), (int)(sHeight / 2 - 5), (int)(sWidth / 2 + 1), (int)(sHeight / 2 + 5), (int)-1);
                    this.setFOV((EntityPlayer)player);
                    for (EntityLivingBase entitylb : mc.field_71441_e.func_72872_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g((double)(mc.field_71474_y.field_151451_c * 8)))) {
                        if (entitylb.func_184202_aL() || entitylb.equals((Object)player)) continue;
                        entitylb.func_184195_f(true);
                        this.glowList.add(entitylb);
                    }
                } else {
                    this.resetFOV((EntityPlayer)player);
                    if (!this.glowList.isEmpty()) {
                        for (EntityLivingBase entitylb : this.glowList) {
                            if (entitylb.func_82150_aj()) continue;
                            entitylb.func_184195_f(false);
                        }
                        this.glowList.clear();
                    }
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void setFOV(EntityPlayer player) {
            double xp = PlayerTracker.getNinjaLevel(player) / 3.0;
            if (this.first_on) {
                Minecraft mc = Minecraft.func_71410_x();
                this.prevRenderDistance = mc.field_71474_y.field_151451_c;
                mc.field_71474_y.field_151451_c = MathHelper.func_76125_a((int)((int)xp * 11 / 16), (int)16, (int)32);
                this.camEntity = new EntityAltCamView.EntityCustom(player);
                mc.field_71441_e.func_72838_d((Entity)this.camEntity);
                mc.func_175607_a((Entity)this.camEntity);
                this.first_on = false;
            }
            if (this.camEntity != null) {
                Vec3d vec3d1 = player.func_174824_e(1.0f).func_178787_e(player.func_70040_Z().func_186678_a((double)((110.0f - renderDistanceChunks) * Math.min((float)xp, 70.0f) / 10.0f + 1.0f)));
                this.camEntity.func_70012_b(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, player.field_70177_z, player.field_70125_A);
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void resetFOV(EntityPlayer player) {
            if (!this.first_on) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_175607_a((Entity)player);
                if (this.camEntity != null) {
                    player.field_70170_p.func_72900_e((Entity)this.camEntity);
                    this.camEntity = null;
                }
                mc.field_71474_y.field_151451_c = this.prevRenderDistance;
                this.first_on = true;
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void onMouseEvent(MouseEvent event) {
            if ((event.getButton() == 0 || event.getButton() == 1) && event.isButtonstate()) {
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71476_x != null && mc.field_71476_x.field_72308_g instanceof EntityPlayer && mc.field_71476_x.field_72308_g.equals((Object)mc.field_71439_g)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    public static class CustomDataMessage
    implements IMessage {
        boolean activated;
        float fov;

        public CustomDataMessage() {
        }

        public CustomDataMessage(boolean activated, float fov) {
            this.activated = activated;
            this.fov = fov;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.activated);
            buf.writeFloat(this.fov);
        }

        public void fromBytes(ByteBuf buf) {
            this.activated = buf.readBoolean();
            this.fov = buf.readFloat();
        }

        public static class Handler
        implements IMessageHandler<CustomDataMessage, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(CustomDataMessage message, MessageContext context) {
                if (!byakuganActivated && !message.activated) {
                    Minecraft.func_71410_x().field_71474_y.field_74334_X = message.fov;
                } else {
                    byakuganActivated = message.activated;
                    renderDistanceChunks = message.fov;
                }
                return null;
            }
        }
    }
}

