/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.entity.EntityAdamantinePrison;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemOnBody;
import net.narutomod.item.ItemSummoningContract;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemAdamantineNyoi
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:adamantine_nyoi")
    public static final Item block = null;
    public static final int ENTITYID = 425;
    public static final ItemJutsu.JutsuEnum WEAPON = new ItemJutsu.JutsuEnum(0, "tooltip.adamantinenyoi.block", 'D', (ItemJutsu.IJutsuCallback)new RangedItem.Jutsu());
    public static final ItemJutsu.JutsuEnum EXTEND = new ItemJutsu.JutsuEnum(1, "tooltip.adamantinenyoi.extend", 'D', 50.0, (ItemJutsu.IJutsuCallback)new EntityExtend.Jutsu());
    public static final ItemJutsu.JutsuEnum PRISON = new ItemJutsu.JutsuEnum(2, "adamantine_prison", 'D', 50.0, (ItemJutsu.IJutsuCallback)new EntityAdamantinePrison.EC.Jutsu());

    public ItemAdamantineNyoi(ElementsNarutomodMod instance) {
        super(instance, 851);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(WEAPON, EXTEND, PRISON));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityExtend.class).id(new ResourceLocation("narutomod", "adamantine_nyoi"), 425).name("adamantine_nyoi").tracker(96, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:adamantine_nyoi", "inventory"));
    }

    public static ItemStack createStackBoundTo(EntityPlayer player) {
        ItemStack stack = ProcedureUtils.getMatchingItemStack(player, ItemSummoningContract.block);
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_150297_b("AdamantineNyoiItemstack", 10)) {
            stack = new ItemStack(stack.func_77978_p().func_74775_l("AdamantineNyoiItemstack"));
        } else {
            stack = new ItemStack(block);
            RangedItem item = (RangedItem)stack.func_77973_b();
            item.setOwner(stack, (EntityLivingBase)player);
            item.setIsAffinity(stack, true);
            item.addJutsuXp(stack, WEAPON, item.getRequiredXp(stack, WEAPON));
            item.addJutsuXp(stack, EXTEND, item.getRequiredXp(stack, EXTEND));
            item.addJutsuXp(stack, PRISON, item.getRequiredXp(stack, PRISON));
        }
        stack.func_77978_p().func_74772_a("1stGottenTime", player.field_70170_p.func_82737_E());
        return stack;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityExtend.class, renderManager -> new RenderCustom(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderCustom
        extends Render<EntityExtend> {
            protected final ItemStack item;
            private final RenderItem itemRenderer;

            public RenderCustom(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.item = new ItemStack(block);
                this.itemRenderer = Minecraft.func_71410_x().func_175599_af();
            }

            public boolean shouldRender(EntityExtend livingEntity, ICamera camera, double camX, double camY, double camZ) {
                return true;
            }

            public void doRender(EntityExtend entity, double x, double y, double z, float entityYaw, float partialTicks) {
                EntityExtend entity1 = entity.getFront();
                float offset = 1.0f;
                if (entity1 != null) {
                    double d = (double)entity.field_70170_p.func_82737_E() + (double)partialTicks;
                    if (d <= entity1.renderTick) {
                        return;
                    }
                    entity1.renderTick = d;
                    if (!entity.equals((Object)entity1)) {
                        entity = entity1;
                        x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks - this.field_76990_c.field_78730_l;
                        y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks - this.field_76990_c.field_78731_m;
                        z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks - this.field_76990_c.field_78728_n;
                    }
                } else {
                    int i = entity.getSegmentIndex();
                    if (i != entity.segment.length / 2 && i != entity.segment.length - 1) {
                        return;
                    }
                    offset = 1.0f - (float)i / (float)entity.segment.length * 2.0f;
                }
                float scale = entity.getEntityScale();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
                GlStateManager.func_179114_b((float)(-ProcedureUtils.interpolateRotation(entity.field_70126_B, entity.field_70177_z, partialTicks)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(scale * 0.0625f), (float)(scale * 2.0f * 1.875f * offset));
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)(scale * 2.0f));
                this.func_110776_a(TextureMap.field_110575_b);
                this.itemRenderer.func_181564_a(this.item, ItemCameraTransforms.TransformType.GROUND);
                GlStateManager.func_179121_F();
            }

            protected ResourceLocation getEntityTexture(EntityExtend entity) {
                return TextureMap.field_110575_b;
            }
        }
    }

    public static class EntityExtend
    extends EntityScalableProjectile.Base {
        private static final DataParameter<Integer> FRONT = EntityDataManager.func_187226_a(EntityExtend.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Integer> SHOOTERID = EntityDataManager.func_187226_a(EntityExtend.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Integer> SEGMENT = EntityDataManager.func_187226_a(EntityExtend.class, (DataSerializer)DataSerializers.field_187192_b);
        private final EntityExtend[] segment = new EntityExtend[60];
        private final int lifeSpan = 300;
        private final float lengthMultiplier = 2.0f;
        private double renderTick;
        private boolean checked;
        private final float damage = 18.0f;
        private final ProcedureUtils.CollisionHelper collisionhelper = new ProcedureUtils.CollisionHelper(this);

        public EntityExtend(World a) {
            super(a);
            this.setOGSize(0.125f, 0.125f);
            this.func_189654_d(true);
        }

        public EntityExtend(EntityLivingBase shooter) {
            super(shooter);
            this.setShooter(shooter);
            this.setOGSize(0.125f, 0.125f);
            this.setFront(this);
            this.setSegmentIndex(0);
            this.segment[0] = this;
            for (int i = 1; i < this.segment.length; ++i) {
                this.segment[i] = new EntityExtend(this.field_70170_p);
                this.segment[i].setSegmentIndex(i);
                this.segment[i].setFront(this);
            }
            this.field_70177_z = shooter.field_70177_z;
            this.field_70125_A = shooter.field_70125_A;
            this.setSegmentPosition();
        }

        @Override
        protected void func_70088_a() {
            super.func_70088_a();
            this.func_184212_Q().func_187214_a(FRONT, (Object)-1);
            this.func_184212_Q().func_187214_a(SHOOTERID, (Object)-1);
            this.func_184212_Q().func_187214_a(SEGMENT, (Object)-1);
        }

        @Nullable
        public EntityExtend getFront() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(FRONT)).intValue());
            return entity instanceof EntityExtend ? (EntityExtend)entity : null;
        }

        public void setFront(EntityExtend entity) {
            this.field_70180_af.func_187227_b(FRONT, (Object)entity.func_145782_y());
        }

        private void setShooter(EntityLivingBase shooter) {
            this.func_184212_Q().func_187227_b(SHOOTERID, (Object)shooter.func_145782_y());
        }

        public EntityLivingBase getShooter() {
            if (!this.field_70170_p.field_72995_K) {
                return this.shootingEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(SHOOTERID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        private void setSegmentIndex(int i) {
            this.func_184212_Q().func_187227_b(SEGMENT, (Object)i);
        }

        private int getSegmentIndex() {
            return (Integer)this.func_184212_Q().func_187225_a(SEGMENT);
        }

        private float updateRotation(float p_75652_1_, float p_75652_2_, float p_75652_3_) {
            float f = MathHelper.func_76142_g((float)(p_75652_2_ - p_75652_1_));
            if (f > p_75652_3_) {
                f = p_75652_3_;
            }
            if (f < -p_75652_3_) {
                f = -p_75652_3_;
            }
            return p_75652_1_ + f;
        }

        private void setSegmentPosition() {
            final EntityLivingBase shooter = this.getShooter();
            if (!this.field_70170_p.field_72995_K && shooter != null) {
                float scale = this.getEntityScale();
                Vec3d vec0 = shooter.func_70040_Z();
                Vec3d frontLook = Vec3d.func_189986_a((float)this.updateRotation(this.field_70125_A, ProcedureUtils.getPitchFromVec(vec0), 5.0f), (float)this.updateRotation(this.field_70177_z, ProcedureUtils.getYawFromVec(vec0), 5.0f));
                Vec3d frontVec = frontLook.func_178787_e(shooter.func_174791_d().func_72441_c(0.0, 1.1 - (double)(scale * 0.0625f), 0.0));
                if (this.segment[0] != null) {
                    int i;
                    for (i = 1; i < this.segment.length; ++i) {
                        this.segment[i].checked = false;
                    }
                    for (i = 1; i < this.segment.length; ++i) {
                        Vec3d vec = frontLook.func_186678_a((double)(scale * this.lengthMultiplier * 3.75f * (float)i / (float)this.segment.length)).func_178787_e(frontVec);
                        this.segment[i].setEntityScale(scale);
                        if (this.segment[i].isAddedToWorld() && this.ticksAlive < this.lifeSpan - 30 && !this.segment[i].checked) {
                            this.segment[i].checked = true;
                            Vec3d vec1 = vec.func_178788_d(this.segment[i].func_174791_d());
                            this.segment[i].collisionhelper.collideWithAll(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, new Predicate<Entity>(){

                                public boolean apply(@Nullable Entity p_apply_1_) {
                                    return ItemJutsu.canTarget(p_apply_1_) && !(p_apply_1_ instanceof EntityExtend) && !p_apply_1_.equals((Object)shooter);
                                }
                            });
                            Vec3d vec2 = this.segment[i].collisionhelper.getUpdatedMotion();
                            float f = MathHelper.func_76129_c((float)((float)vec2.func_72433_c() * scale));
                            for (Map.Entry<Entity, EnumFacing> entry : this.segment[i].collisionhelper.getEntitiesHitMap().entrySet()) {
                                entry.getKey().func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)shooter), f * this.damage * 1.75f);
                                ProcedureUtils.CollisionHelper.reposHitEntity(this.segment[i].func_174813_aQ().func_191194_a(vec2), entry.getKey(), entry.getValue());
                                entry.getKey().func_70024_g(vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
                                entry.getKey().field_70133_I = true;
                            }
                            if (this.segment[i].collisionhelper.anyBlockHits()) {
                                if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)shooter)) {
                                    for (BlockPos pos : this.segment[i].collisionhelper.getHitBlocks()) {
                                        float f1 = this.field_70170_p.func_180495_p(pos).func_185887_b(this.field_70170_p, pos);
                                        if (!(f1 >= 0.0f) || !(f1 <= f)) continue;
                                        this.field_70170_p.func_175655_b(pos, this.field_70146_Z.nextFloat() < 0.1f);
                                    }
                                }
                                for (EnumFacing face : EnumFacing.field_82609_l) {
                                    if (!this.segment[i].collisionhelper.hitOnSide(face)) continue;
                                    vec2 = vec2.func_72441_c(-0.5 * (double)face.func_176730_m().func_177958_n(), -0.5 * (double)face.func_176730_m().func_177956_o(), -0.5 * (double)face.func_176730_m().func_177952_p());
                                }
                                frontLook = this.segment[i].func_174791_d().func_178787_e(vec2).func_178788_d(frontVec).func_72432_b();
                                frontVec = frontLook.func_178787_e(shooter.func_174791_d().func_72441_c(0.0, 1.1 - (double)(scale * 0.0625f), 0.0));
                                i = 1;
                                continue;
                            }
                        }
                        this.segment[i].func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, this.field_70177_z, this.field_70125_A);
                    }
                }
                this.func_70012_b(frontVec.field_72450_a, frontVec.field_72448_b, frontVec.field_72449_c, ProcedureUtils.getYawFromVec(frontLook), ProcedureUtils.getPitchFromVec(frontLook));
            }
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                if (this.getSegmentIndex() == 0) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:poof")), 1.0f, 1.0f);
                }
                Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 5, (double)this.field_70130_N * 0.5, (double)this.field_70131_O * 0.3, (double)this.field_70130_N * 0.5, 0.0, 0.0, 0.0, -788529153, (int)(this.getEntityScale() * 10.0f));
                if (this.segment[0] != null) {
                    for (int i = 1; i < this.segment.length; ++i) {
                        this.segment[i].func_70106_y();
                    }
                }
            }
        }

        @Override
        public void func_70071_h_() {
            EntityExtend front = this.getFront();
            boolean isFront = this.equals((Object)front);
            if (!this.field_70170_p.field_72995_K && isFront && !this.segment[1].isAddedToWorld()) {
                for (int i = 1; i < this.segment.length; ++i) {
                    this.field_70170_p.func_72838_d((Entity)this.segment[i]);
                }
            }
            super.func_70071_h_();
            if (isFront && this.ticksAlive >= this.lifeSpan - 30) {
                float f = this.getEntityScale();
                this.setEntityScale(f - (f - 1.0f) * (1.0f - (float)(this.lifeSpan - this.ticksAlive) / 30.0f));
            }
            if (isFront) {
                this.setSegmentPosition();
            }
            if (!this.field_70170_p.field_72995_K && (this.ticksAlive >= this.lifeSpan || front == null || front.field_70128_L)) {
                this.func_70106_y();
            }
        }

        @Override
        public void onImpact(RayTraceResult result) {
        }

        public boolean func_180427_aV() {
            return true;
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                ((RangedItem)stack.func_77973_b()).setCurrentJutsuCooldown(stack, 300L);
                return true;
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base
    implements ItemOnBody.Interface {
        private static final UUID REACH_MODIFIER = UUID.fromString("2181075f-90e8-4444-9143-788f588ef58f");
        private static final float DAMAGE = 18.0f;

        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.OTHER, list);
            this.func_77655_b("adamantine_nyoi");
            this.setRegistryName("adamantine_nyoi");
            this.func_77637_a(null);
            this.defaultCooldownMap[ItemAdamantineNyoi.WEAPON.index] = 0L;
            this.defaultCooldownMap[ItemAdamantineNyoi.EXTEND.index] = 0L;
            this.defaultCooldownMap[ItemAdamantineNyoi.PRISON.index] = 0L;
        }

        public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
            Multimap multimap = super.func_111205_h(slot);
            if (slot == EntityEquipmentSlot.MAINHAND) {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Ranged item modifier", 17.0, 0));
                multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Ranged item modifier", -2.4, 0));
                multimap.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(REACH_MODIFIER, "Tool modifier", 1.5, 0));
            }
            return multimap;
        }

        @Override
        public void onUsingTick(ItemStack stack, EntityLivingBase player, int timeLeft) {
            super.onUsingTick(stack, player, timeLeft);
            if (this.getCurrentJutsu(stack) == EXTEND && !player.field_70170_p.field_72995_K) {
                float power = this.getPower(stack, player, timeLeft);
                if (power >= this.getMaxPower(stack, player)) {
                    player.func_184597_cx();
                } else {
                    EntityExtend entity = this.getStaffEntity(player.field_70170_p, stack);
                    if (entity == null) {
                        entity = new EntityExtend(player);
                        player.field_70170_p.func_72838_d((Entity)entity);
                        this.setStaffEntity(stack, entity);
                    }
                    entity.setEntityScale(power);
                }
            }
        }

        @Override
        protected void onUsingEffects(EntityLivingBase player) {
        }

        @Override
        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (!world.field_72995_K && world.func_82737_E() > itemstack.func_77978_p().func_74763_f("1stGottenTime") + 6000L) {
                ItemStack stack;
                if (entity instanceof EntityPlayer && (stack = ProcedureUtils.getMatchingItemStack((EntityPlayer)entity, ItemSummoningContract.block)) != null && stack.func_77942_o()) {
                    stack.func_77978_p().func_74782_a("AdamantineNyoiItemstack", (NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
                }
                ProcedureUtils.poofWithSmoke(entity);
                itemstack.func_190918_g(1);
            }
        }

        private void setStaffEntity(ItemStack stack, EntityExtend entity) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74768_a("staffEntityId", entity.func_145782_y());
            }
        }

        @Nullable
        private EntityExtend getStaffEntity(World world, ItemStack stack) {
            Entity entity = world.func_73045_a(stack.func_77978_p().func_74762_e("staffEntityId"));
            return entity instanceof EntityExtend && !entity.field_70128_L ? (EntityExtend)entity : null;
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            return this.getCurrentJutsu(stack) == EXTEND ? this.getPower(stack, entity, timeLeft, 1.0f, 30.0f) : 1.0f;
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            float ret = super.getMaxPower(stack, entity);
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            return jutsu == EXTEND ? Math.min(ret, 15.0f) : ret;
        }

        @Override
        public EnumAction func_77661_b(ItemStack itemstack) {
            return this.getCurrentJutsu(itemstack) == WEAPON ? EnumAction.BLOCK : EnumAction.BOW;
        }

        public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
            return stack.func_77973_b() == block && this.getCurrentJutsu(stack) == WEAPON;
        }

        @Override
        public ItemOnBody.BodyPart showOnBody() {
            return ItemOnBody.BodyPart.LEFT_ARM;
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                return false;
            }
        }
    }
}

