/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.entity.EntityBijuManager;
import net.narutomod.entity.EntityJinchurikiClone;
import net.narutomod.potion.PotionChakraEnhancedStrength;
import net.narutomod.potion.PotionReach;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemBijuCloak
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:biju_cloakhelmet")
    public static final Item helmet = null;
    @GameRegistry.ObjectHolder(value="narutomod:biju_cloakbody")
    public static final Item body = null;
    @GameRegistry.ObjectHolder(value="narutomod:biju_cloaklegs")
    public static final Item legs = null;
    private final AttributeModifier CLOAK_MODIFIER = new AttributeModifier(UUID.fromString("e884e4a0-7f08-422d-9aac-119972cd764d"), "bijucloak.maxhealth", 180.0, 0);
    @SideOnly(value=Side.CLIENT)
    private ModelBijuCloak[] bijuModel;

    public ItemBijuCloak(ElementsNarutomodMod instance) {
        super(instance, 577);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void init(FMLInitializationEvent event) {
        this.bijuModel = new ModelBijuCloak[10];
        for (int i = 0; i < 10; ++i) {
            this.bijuModel[i] = new ModelBijuCloak(i);
        }
    }

    @Override
    public void initElements() {
        ItemArmor.ArmorMaterial enuma = EnumHelper.addArmorMaterial((String)"BIJU_CLOAK", (String)"narutomod:sasuke_", (int)1024, (int[])new int[]{1024, 1024, 1024, 1024}, (int)0, null, (float)5.0f);
        this.elements.items.add(() -> ((Item)new ItemArmor(enuma, 0, EntityEquipmentSlot.HEAD){

            @SideOnly(value=Side.CLIENT)
            public ModelBiped getArmorModel(EntityLivingBase living, ItemStack stack, EntityEquipmentSlot slot, ModelBiped defaultModel) {
                ModelBijuCloak armorModel = ItemBijuCloak.this.bijuModel[stack.func_77960_j()];
                armorModel.field_78117_n = living.func_70093_af();
                armorModel.field_78093_q = living.func_184218_aH();
                armorModel.field_78091_s = living.func_70631_g_();
                int tails = ItemBijuCloak.getTails(stack);
                ((ModelBijuCloak)armorModel).earRight[0].field_78806_j = tails != 1;
                ((ModelBijuCloak)armorModel).earLeft[0].field_78806_j = ((ModelBijuCloak)armorModel).earRight[0].field_78806_j;
                armorModel.bodyShine = tails == 9 && ItemBijuCloak.getCloakLevel(stack) == 2 && ItemBijuCloak.getCloakXp(stack) >= 800;
                armorModel.layerShine = true;
                return armorModel;
            }

            public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
                int cloakLevel;
                super.func_77663_a(itemstack, world, entity, par4, par5);
                if (!world.field_72995_K && entity instanceof EntityPlayer && (cloakLevel = EntityBijuManager.cloakLevel((EntityPlayer)entity)) <= 0) {
                    itemstack.func_190918_g(1);
                }
            }

            public int func_77612_l() {
                return 0;
            }

            public boolean func_77645_m() {
                return false;
            }

            public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
                return ItemBijuCloak.getTexture(stack);
            }
        }.func_77655_b("biju_cloakhelmet").setRegistryName("biju_cloakhelmet")).func_77637_a(null));
        this.elements.items.add(() -> ((Item)new ItemArmor(enuma, 0, EntityEquipmentSlot.CHEST){

            @SideOnly(value=Side.CLIENT)
            public ModelBiped getArmorModel(EntityLivingBase living, ItemStack stack, EntityEquipmentSlot slot, ModelBiped defaultModel) {
                ModelBijuCloak armorModel = ItemBijuCloak.this.bijuModel[stack.func_77960_j()];
                armorModel.field_78117_n = living.func_70093_af();
                armorModel.field_78093_q = living.func_184218_aH();
                armorModel.field_78091_s = living.func_70631_g_();
                armorModel.bodyShine = ItemBijuCloak.getTails(stack) == 9 && ItemBijuCloak.getCloakLevel(stack) == 2 && ItemBijuCloak.getCloakXp(stack) >= 800;
                ((ModelBijuCloak)armorModel).allTails.field_78806_j = !armorModel.bodyShine;
                armorModel.layerShine = true;
                return armorModel;
            }

            public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
                super.func_77663_a(itemstack, world, entity, par4, par5);
                if (entity instanceof EntityPlayer) {
                    EntityPlayer livingEntity = (EntityPlayer)entity;
                    int cloakLevel = EntityBijuManager.cloakLevel(livingEntity);
                    if (cloakLevel > 0) {
                        ItemStack helmetStack = livingEntity.func_184582_a(EntityEquipmentSlot.HEAD);
                        ItemStack legStack = livingEntity.func_184582_a(EntityEquipmentSlot.LEGS);
                        if (helmetStack.func_77973_b() == helmet && itemstack.func_77973_b() == body && legStack.func_77973_b() == legs) {
                            ItemBijuCloak.this.setWearingFullSet(itemstack, true);
                            if (!world.field_72995_K) {
                                ItemBijuCloak.setCloakLevel(helmetStack, cloakLevel);
                                ItemBijuCloak.setCloakLevel(itemstack, cloakLevel);
                                ItemBijuCloak.setCloakLevel(legStack, cloakLevel);
                                int wearingTicks = ItemBijuCloak.getWearingTicks((Entity)livingEntity);
                                int cloakXp = EntityBijuManager.getCloakXp(livingEntity);
                                int n = wearingTicks = wearingTicks > 0 ? ++wearingTicks : 1;
                                if (wearingTicks <= cloakXp * 5 + 200 && Chakra.pathway(livingEntity).getAmount() > 0.0) {
                                    ItemBijuCloak.setCloakXp(helmetStack, cloakXp += wearingTicks / 20);
                                    ItemBijuCloak.setCloakXp(itemstack, cloakXp);
                                    ItemBijuCloak.setCloakXp(legStack, cloakXp);
                                    ItemBijuCloak.setWearingTicks((Entity)livingEntity, wearingTicks);
                                    if (cloakXp >= 800 || cloakLevel == 1 && cloakXp >= 400) {
                                        ItemBijuCloak.revertOriginal(livingEntity, itemstack);
                                        ItemBijuCloak.applyEffects((EntityLivingBase)livingEntity, cloakLevel, ItemBijuCloak.getTails(itemstack) != 1 && cloakLevel == 1);
                                    } else {
                                        ItemBijuCloak.this.spawnClone(livingEntity, itemstack);
                                    }
                                } else {
                                    if (cloakXp < 400 || cloakLevel == 2 && cloakXp < 800) {
                                        ItemBijuCloak.revertOriginal(livingEntity, itemstack);
                                    }
                                    EntityBijuManager.toggleBijuCloak(livingEntity);
                                    itemstack.func_190918_g(1);
                                }
                            }
                        } else {
                            ItemBijuCloak.this.setWearingFullSet(itemstack, false);
                        }
                    } else if (!world.field_72995_K) {
                        itemstack.func_190918_g(1);
                    }
                } else if (entity instanceof EntityJinchurikiClone.EntityCustom && !world.field_72995_K && entity.func_70089_S()) {
                    ItemBijuCloak.setWearingTicks(entity, ItemBijuCloak.getWearingTicks(entity) + 1);
                    int i = ItemBijuCloak.getCloakLevel(itemstack);
                    ItemBijuCloak.applyEffects((EntityLivingBase)entity, i, ItemBijuCloak.getTails(itemstack) != 1 && i == 1);
                }
            }

            public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
                Multimap multimap = super.getAttributeModifiers(slot, stack);
                if (slot == EntityEquipmentSlot.CHEST && ItemBijuCloak.this.isWearingFullSet(stack)) {
                    multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)ItemBijuCloak.this.CLOAK_MODIFIER);
                }
                return multimap;
            }

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                super.func_77624_a(stack, worldIn, tooltip, flagIn);
                tooltip.add(I18n.func_74838_a((String)"key.mcreator.specialjutsu2") + ": " + I18n.func_74838_a((String)"entity.jinchuriki_clone.name"));
                int i = ItemBijuCloak.getCloakLevel(stack);
                if (i == 2) {
                    tooltip.add(I18n.func_74838_a((String)"key.mcreator.specialjutsu3") + ": " + I18n.func_74838_a((String)"entity.tailbeastball.name"));
                }
                tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)("tooltip.bijucloak.level" + i)));
                tooltip.add("JXP: " + TextFormatting.GREEN + ItemBijuCloak.getCloakXp(stack) + TextFormatting.RESET);
            }

            public int func_77612_l() {
                return 0;
            }

            public boolean func_77645_m() {
                return false;
            }

            public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
                return ItemBijuCloak.getTexture(stack);
            }
        }.func_77655_b("biju_cloakbody").setRegistryName("biju_cloakbody")).func_77637_a(null));
        this.elements.items.add(() -> ((Item)new ItemArmor(enuma, 0, EntityEquipmentSlot.LEGS){

            @SideOnly(value=Side.CLIENT)
            public ModelBiped getArmorModel(EntityLivingBase living, ItemStack stack, EntityEquipmentSlot slot, ModelBiped defaultModel) {
                ModelBijuCloak armorModel = ItemBijuCloak.this.bijuModel[stack.func_77960_j()];
                armorModel.field_78117_n = living.func_70093_af();
                armorModel.field_78093_q = living.func_184218_aH();
                armorModel.field_78091_s = living.func_70631_g_();
                armorModel.bodyShine = ItemBijuCloak.getTails(stack) == 9 && ItemBijuCloak.getCloakLevel(stack) == 2 && ItemBijuCloak.getCloakXp(stack) >= 800;
                armorModel.layerShine = true;
                return armorModel;
            }

            public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
                int cloakLevel;
                super.func_77663_a(itemstack, world, entity, par4, par5);
                if (!world.field_72995_K && entity instanceof EntityPlayer && (cloakLevel = EntityBijuManager.cloakLevel((EntityPlayer)entity)) <= 0) {
                    itemstack.func_190918_g(1);
                }
            }

            public int func_77612_l() {
                return 0;
            }

            public boolean func_77645_m() {
                return false;
            }

            public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
                return ItemBijuCloak.getTexture(stack);
            }
        }.func_77655_b("biju_cloaklegs").setRegistryName("biju_cloaklegs")).func_77637_a(null));
    }

    private static String getTexture(ItemStack stack) {
        int i = ItemBijuCloak.getTails(stack);
        int j = ItemBijuCloak.getCloakLevel(stack);
        int k = ItemBijuCloak.getCloakXp(stack);
        return i == 1 && j == 1 ? "narutomod:textures/bijucloak_sand.png" : (j == 2 ? (i == 9 && k >= 800 ? (k < 4800 ? "narutomod:textures/bijucloak_kurama.png" : "narutomod:textures/bijucloak_kcm2.png") : "narutomod:textures/bijucloakl2.png") : "narutomod:textures/bijucloakl1.png");
    }

    public static void clearCloakItems(EntityPlayer player) {
        player.field_71071_by.func_174925_a(helmet, -1, -1, null);
        player.field_71071_by.func_174925_a(body, -1, -1, null);
        player.field_71071_by.func_174925_a(legs, -1, -1, null);
        player.getEntityData().func_82580_o("lungeAttackData");
    }

    public static void applyEffects(EntityLivingBase entity, int level) {
        ItemBijuCloak.applyEffects(entity, level, true);
    }

    public static void applyEffects(EntityLivingBase entity, int level, boolean smoke) {
        if (smoke) {
            Particles.spawnParticle(entity.field_70170_p, Particles.Types.SMOKE, entity.field_70165_t, entity.field_70163_u + 0.8, entity.field_70161_v, 40, 0.2, 0.4, 0.2, 0.0, 0.0, 0.0, 545783835, 20, (int)(4.0 / (entity.func_70681_au().nextDouble() * 0.8 + 0.2)), 0, entity.func_145782_y());
        }
        if (!entity.field_70170_p.field_72995_K && entity.field_70173_aa % 10 == 4) {
            entity.func_70690_d(new PotionEffect(PotionChakraEnhancedStrength.potion, 12, level * 32, false, false));
            entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 12, level * 24, false, false));
            entity.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 12, 5, false, false));
            entity.func_70690_d(new PotionEffect(PotionReach.potion, 12, level - 1, false, false));
            if (entity.func_110143_aJ() < entity.func_110138_aP() && entity.func_110143_aJ() > 0.0f) {
                entity.func_70691_i((float)level);
            }
            if (level == 2) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 12, 2, false, false));
            }
        }
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            RayTraceResult res;
            Entity target;
            NBTTagCompound compound = entity.getEntityData().func_74764_b("lungeAttackData") ? entity.getEntityData().func_74775_l("lungeAttackData") : new NBTTagCompound();
            int attackTime = compound.func_74762_e("attackTime");
            Entity entity2 = target = compound.func_74764_b("targetId") ? entity.field_70170_p.func_73045_a(compound.func_74762_e("targetId")) : null;
            if (entity.field_110158_av == 1 && (res = ProcedureUtils.objectEntityLookingAt((Entity)entity, 15.0, 3.0)) != null && res.field_72308_g instanceof EntityLivingBase && res.field_72308_g.func_70089_S()) {
                target = res.field_72308_g;
                compound.func_74768_a("targetId", target.func_145782_y());
                attackTime = 0;
                entity.field_70177_z = ProcedureUtils.getYawFromVec(target.func_174791_d().func_178788_d(entity.func_174791_d()));
                double d0 = target.field_70165_t - entity.field_70165_t;
                double d1 = target.field_70163_u - entity.field_70163_u;
                double d2 = target.field_70161_v - entity.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                ProcedureUtils.setVelocity((Entity)entity, d0 * 0.5, d1 * 0.5 + d3 * 0.025, d2 * 0.5);
            }
            if (attackTime < 12 && target != null && target.func_70068_e((Entity)entity) < 25.0) {
                ((EntityPlayer)entity).func_71059_n(target);
                compound.func_82580_o("targetId");
            }
            compound.func_74768_a("attackTime", ++attackTime);
            entity.getEntityData().func_74782_a("lungeAttackData", (NBTBase)compound);
        }
    }

    private static int getTails(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("Tails");
    }

    private static void setCloakLevel(ItemStack itemstack, int level) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("BijuCloakLevel", level);
    }

    private static int getCloakLevel(ItemStack itemstack) {
        return itemstack.func_77942_o() ? itemstack.func_77978_p().func_74762_e("BijuCloakLevel") : 0;
    }

    private static void setCloakXp(ItemStack itemstack, int xp) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("BijuCloakXp", xp);
    }

    private static int getCloakXp(ItemStack itemstack) {
        return itemstack.func_77942_o() ? itemstack.func_77978_p().func_74762_e("BijuCloakXp") : 0;
    }

    public static void setWearingTicks(Entity entity, int ticks) {
        ProcedureSync.EntityNBTTag.setAndSync(entity, "WearingBijuCloakTicks", ticks);
    }

    public static int getWearingTicks(Entity entity) {
        return entity.getEntityData().func_74762_e("WearingBijuCloakTicks");
    }

    private void setWearingFullSet(ItemStack itemstack, boolean b) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74757_a("WearingFullSetBijuCloak", b);
    }

    private boolean isWearingFullSet(ItemStack itemstack) {
        return itemstack.func_77942_o() && itemstack.func_77978_p().func_74767_n("WearingFullSetBijuCloak");
    }

    private void setClone(ItemStack itemstack, EntityJinchurikiClone.EntityCustom clone) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("CloneID", clone.func_145782_y());
    }

    @Nullable
    private static EntityJinchurikiClone.EntityCustom getClone(World world, ItemStack itemstack) {
        if (ItemBijuCloak.hasClone(itemstack)) {
            Entity entity = world.func_73045_a(itemstack.func_77978_p().func_74762_e("CloneID"));
            return entity instanceof EntityJinchurikiClone.EntityCustom ? (EntityJinchurikiClone.EntityCustom)entity : null;
        }
        return null;
    }

    private static int getCloneId(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("CloneID") ? stack.func_77978_p().func_74762_e("CloneID") : -1;
    }

    private static boolean hasClone(ItemStack stack) {
        return ItemBijuCloak.getCloneId(stack) > 0;
    }

    private void spawnClone(EntityPlayer original, ItemStack stack) {
        if (!original.field_70170_p.field_72995_K && !ItemBijuCloak.hasClone(stack)) {
            EntityJinchurikiClone.EntityCustom entity = new EntityJinchurikiClone.EntityCustom((EntityLivingBase)original);
            entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(this.CLOAK_MODIFIER);
            entity.func_70606_j(original.func_110143_aJ());
            original.field_70170_p.func_72838_d((Entity)entity);
            this.setClone(stack, entity);
        }
    }

    public static void revertOriginal(EntityPlayer player, ItemStack stack) {
        EntityJinchurikiClone.EntityCustom clone = ItemBijuCloak.getClone(player.field_70170_p, stack);
        if (clone != null) {
            clone.func_70106_y();
            stack.func_77978_p().func_82580_o("CloneID");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)helmet, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_cloakhelmet", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)body, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_cloakbody", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)body, (int)1, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_cloakbody", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)body, (int)2, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_cloakbody", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)body, (int)3, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_cloakbody", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)body, (int)4, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_cloakbody", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)body, (int)5, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_cloakbody", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)body, (int)6, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_cloakbody", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)body, (int)7, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_cloakbody", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)body, (int)8, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_cloakbody", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)body, (int)9, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_cloakbody", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)legs, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_cloaklegs", "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelBijuCloak
    extends ModelBiped {
        private final ModelRenderer[] earLeft = new ModelRenderer[6];
        private final ModelRenderer[] earRight = new ModelRenderer[6];
        private final ModelRenderer sandEar;
        private final ModelRenderer cube_r1;
        private final ModelRenderer allTails;
        private final ModelRenderer[][] tail = new ModelRenderer[9][8];
        private final ModelRenderer bipedBodyWear;
        private final ModelRenderer tailWears;
        private final ModelRenderer[][] tailWear = new ModelRenderer[1][8];
        private final ModelRenderer bipedRightArmWear;
        private final ModelRenderer sandArm;
        private final ModelRenderer bipedLeftArmWear;
        private final ModelRenderer bipedRightLegWear;
        private final ModelRenderer bipedLeftLegWear;
        private final float[][] tailSwayX = new float[9][8];
        private final float[][] tailSwayZ = new float[9][8];
        private final float[] leftEarSwayX = new float[6];
        private final float[] leftEarSwayZ = new float[6];
        private final float[] rightEarSwayX = new float[6];
        private final float[] rightEarSwayZ = new float[6];
        private int[] tailShowMap = new int[]{0, 1, 6, 25, 30, 31, 504, 127, 510, 511};
        private boolean bodyShine;
        private boolean layerShine;
        private boolean narutoRunPose;
        private final Random rand = new Random();

        public ModelBijuCloak(int tails) {
            int i;
            this.field_78090_t = 128;
            this.field_78089_u = 64;
            this.field_78116_c = new ModelRenderer((ModelBase)this);
            this.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_78116_c.field_78804_l.add(new ModelBox(this.field_78116_c, 0, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.6f, false));
            this.earLeft[0] = new ModelRenderer((ModelBase)this);
            this.earLeft[0].func_78793_a(3.5f, -8.25f, -0.5f);
            this.field_78116_c.func_78792_a(this.earLeft[0]);
            this.setRotationAngle(this.earLeft[0], -0.5236f, 0.0f, 0.7854f);
            this.earLeft[0].field_78804_l.add(new ModelBox(this.earLeft[0], 32, 0, -0.5f, -1.5f, -0.5f, 1, 2, 1, 0.8f, false));
            this.earLeft[1] = new ModelRenderer((ModelBase)this);
            this.earLeft[1].func_78793_a(0.0f, -1.0f, 0.0f);
            this.earLeft[0].func_78792_a(this.earLeft[1]);
            this.setRotationAngle(this.earLeft[1], 0.0f, 0.0f, -0.1745f);
            this.earLeft[1].field_78804_l.add(new ModelBox(this.earLeft[1], 32, 0, -0.5f, -1.5f, -0.5f, 1, 2, 1, 0.7f, false));
            this.earLeft[2] = new ModelRenderer((ModelBase)this);
            this.earLeft[2].func_78793_a(0.0f, -1.0f, 0.0f);
            this.earLeft[1].func_78792_a(this.earLeft[2]);
            this.setRotationAngle(this.earLeft[2], 0.0f, 0.0f, -0.1745f);
            this.earLeft[2].field_78804_l.add(new ModelBox(this.earLeft[2], 32, 0, -0.5f, -1.5f, -0.5f, 1, 2, 1, 0.6f, false));
            this.earLeft[3] = new ModelRenderer((ModelBase)this);
            this.earLeft[3].func_78793_a(0.0f, -1.0f, 0.0f);
            this.earLeft[2].func_78792_a(this.earLeft[3]);
            this.setRotationAngle(this.earLeft[3], 0.0f, 0.0f, -0.1745f);
            this.earLeft[3].field_78804_l.add(new ModelBox(this.earLeft[3], 32, 0, -0.5f, -1.5f, -0.5f, 1, 2, 1, 0.4f, false));
            this.earLeft[4] = new ModelRenderer((ModelBase)this);
            this.earLeft[4].func_78793_a(0.0f, -1.0f, 0.0f);
            this.earLeft[3].func_78792_a(this.earLeft[4]);
            this.setRotationAngle(this.earLeft[4], 0.0f, 0.0f, -0.1745f);
            this.earLeft[4].field_78804_l.add(new ModelBox(this.earLeft[4], 32, 0, -0.5f, -1.5f, -0.5f, 1, 2, 1, 0.2f, false));
            this.earLeft[5] = new ModelRenderer((ModelBase)this);
            this.earLeft[5].func_78793_a(0.0f, -1.0f, 0.0f);
            this.earLeft[4].func_78792_a(this.earLeft[5]);
            this.setRotationAngle(this.earLeft[5], 0.0f, 0.0f, -0.1745f);
            this.earLeft[5].field_78804_l.add(new ModelBox(this.earLeft[5], 32, 0, -0.5f, -1.5f, -0.5f, 1, 2, 1, -0.1f, false));
            this.earRight[0] = new ModelRenderer((ModelBase)this);
            this.earRight[0].func_78793_a(-3.5f, -8.25f, -0.5f);
            this.field_78116_c.func_78792_a(this.earRight[0]);
            this.setRotationAngle(this.earRight[0], -0.5236f, 0.0f, -0.7854f);
            this.earRight[0].field_78804_l.add(new ModelBox(this.earRight[0], 32, 0, -0.5f, -1.5f, -0.5f, 1, 2, 1, 0.8f, false));
            this.earRight[1] = new ModelRenderer((ModelBase)this);
            this.earRight[1].func_78793_a(0.0f, -1.0f, 0.0f);
            this.earRight[0].func_78792_a(this.earRight[1]);
            this.setRotationAngle(this.earRight[1], 0.0f, 0.0f, 0.1745f);
            this.earRight[1].field_78804_l.add(new ModelBox(this.earRight[1], 32, 0, -0.5f, -1.5f, -0.5f, 1, 2, 1, 0.7f, false));
            this.earRight[2] = new ModelRenderer((ModelBase)this);
            this.earRight[2].func_78793_a(0.0f, -1.0f, 0.0f);
            this.earRight[1].func_78792_a(this.earRight[2]);
            this.setRotationAngle(this.earRight[2], 0.0f, 0.0f, 0.1745f);
            this.earRight[2].field_78804_l.add(new ModelBox(this.earRight[2], 32, 0, -0.5f, -1.5f, -0.5f, 1, 2, 1, 0.6f, false));
            this.earRight[3] = new ModelRenderer((ModelBase)this);
            this.earRight[3].func_78793_a(0.0f, -1.0f, 0.0f);
            this.earRight[2].func_78792_a(this.earRight[3]);
            this.setRotationAngle(this.earRight[3], 0.0f, 0.0f, 0.1745f);
            this.earRight[3].field_78804_l.add(new ModelBox(this.earRight[3], 32, 0, -0.5f, -1.5f, -0.5f, 1, 2, 1, 0.4f, false));
            this.earRight[4] = new ModelRenderer((ModelBase)this);
            this.earRight[4].func_78793_a(0.0f, -1.0f, 0.0f);
            this.earRight[3].func_78792_a(this.earRight[4]);
            this.setRotationAngle(this.earRight[4], 0.0f, 0.0f, 0.1745f);
            this.earRight[4].field_78804_l.add(new ModelBox(this.earRight[4], 32, 0, -0.5f, -1.5f, -0.5f, 1, 2, 1, 0.2f, false));
            this.earRight[5] = new ModelRenderer((ModelBase)this);
            this.earRight[5].func_78793_a(0.0f, -1.0f, 0.0f);
            this.earRight[4].func_78792_a(this.earRight[5]);
            this.setRotationAngle(this.earRight[5], 0.0f, 0.0f, 0.1745f);
            this.earRight[5].field_78804_l.add(new ModelBox(this.earRight[5], 32, 0, -0.5f, -1.5f, -0.5f, 1, 2, 1, -0.1f, false));
            this.field_178720_f = new ModelRenderer((ModelBase)this);
            this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_178720_f.field_78804_l.add(new ModelBox(this.field_178720_f, 64, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.6f, false));
            this.sandEar = new ModelRenderer((ModelBase)this);
            this.sandEar.func_78793_a(-4.425f, -8.0f, 0.0f);
            this.field_178720_f.func_78792_a(this.sandEar);
            this.setRotationAngle(this.sandEar, 0.0f, 0.0f, -0.2618f);
            this.cube_r1 = new ModelRenderer((ModelBase)this);
            this.cube_r1.func_78793_a(0.0f, 0.0f, 0.0f);
            this.sandEar.func_78792_a(this.cube_r1);
            this.setRotationAngle(this.cube_r1, -0.7782f, -0.0998f, -0.1434f);
            this.cube_r1.field_78804_l.add(new ModelBox(this.cube_r1, 118, 0, -1.0f, -2.8f, -2.0f, 2, 6, 3, 0.0f, false));
            this.field_78115_e = new ModelRenderer((ModelBase)this);
            this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 16, 16, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.6f, false));
            this.allTails = new ModelRenderer((ModelBase)this);
            this.field_78115_e.func_78792_a(this.allTails);
            this.tail[0][0] = new ModelRenderer((ModelBase)this);
            this.tail[0][0].func_78793_a(0.0f, 10.5f, 2.0f);
            this.allTails.func_78792_a(this.tail[0][0]);
            this.setRotationAngle(this.tail[0][0], -1.0472f, 0.0f, 0.0f);
            this.tail[0][0].field_78804_l.add(new ModelBox(this.tail[0][0], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[0][1] = new ModelRenderer((ModelBase)this);
            this.tail[0][1].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[0][0].func_78792_a(this.tail[0][1]);
            this.setRotationAngle(this.tail[0][1], 0.2618f, 0.0f, 0.0f);
            this.tail[0][1].field_78804_l.add(new ModelBox(this.tail[0][1], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[0][2] = new ModelRenderer((ModelBase)this);
            this.tail[0][2].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[0][1].func_78792_a(this.tail[0][2]);
            this.setRotationAngle(this.tail[0][2], 0.2618f, 0.0f, 0.0f);
            this.tail[0][2].field_78804_l.add(new ModelBox(this.tail[0][2], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.6f, false));
            this.tail[0][3] = new ModelRenderer((ModelBase)this);
            this.tail[0][3].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[0][2].func_78792_a(this.tail[0][3]);
            this.setRotationAngle(this.tail[0][3], 0.2618f, 0.0f, 0.0f);
            this.tail[0][3].field_78804_l.add(new ModelBox(this.tail[0][3], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[0][4] = new ModelRenderer((ModelBase)this);
            this.tail[0][4].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[0][3].func_78792_a(this.tail[0][4]);
            this.setRotationAngle(this.tail[0][4], 0.2618f, 0.0f, 0.0f);
            this.tail[0][4].field_78804_l.add(new ModelBox(this.tail[0][4], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[0][5] = new ModelRenderer((ModelBase)this);
            this.tail[0][5].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[0][4].func_78792_a(this.tail[0][5]);
            this.setRotationAngle(this.tail[0][5], 0.2618f, 0.0f, 0.0f);
            this.tail[0][5].field_78804_l.add(new ModelBox(this.tail[0][5], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.3f, false));
            this.tail[0][6] = new ModelRenderer((ModelBase)this);
            this.tail[0][6].func_78793_a(0.0f, -4.0f, 0.0f);
            this.tail[0][5].func_78792_a(this.tail[0][6]);
            this.setRotationAngle(this.tail[0][6], 0.2618f, 0.0f, 0.0f);
            this.tail[0][6].field_78804_l.add(new ModelBox(this.tail[0][6], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.6f, false));
            this.tail[0][7] = new ModelRenderer((ModelBase)this);
            this.tail[0][7].func_78793_a(0.0f, -3.75f, 0.0f);
            this.tail[0][6].func_78792_a(this.tail[0][7]);
            this.setRotationAngle(this.tail[0][7], 0.2618f, 0.0f, 0.0f);
            this.tail[0][7].field_78804_l.add(new ModelBox(this.tail[0][7], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -1.0f, false));
            this.tail[1][0] = new ModelRenderer((ModelBase)this);
            this.tail[1][0].func_78793_a(0.0f, 10.5f, 2.0f);
            this.allTails.func_78792_a(this.tail[1][0]);
            this.setRotationAngle(this.tail[1][0], -1.0472f, -0.5236f, -0.2618f);
            this.tail[1][0].field_78804_l.add(new ModelBox(this.tail[1][0], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[1][1] = new ModelRenderer((ModelBase)this);
            this.tail[1][1].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[1][0].func_78792_a(this.tail[1][1]);
            this.setRotationAngle(this.tail[1][1], 0.2618f, 0.0f, 0.0f);
            this.tail[1][1].field_78804_l.add(new ModelBox(this.tail[1][1], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[1][2] = new ModelRenderer((ModelBase)this);
            this.tail[1][2].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[1][1].func_78792_a(this.tail[1][2]);
            this.setRotationAngle(this.tail[1][2], 0.2618f, 0.0f, 0.0f);
            this.tail[1][2].field_78804_l.add(new ModelBox(this.tail[1][2], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.6f, false));
            this.tail[1][3] = new ModelRenderer((ModelBase)this);
            this.tail[1][3].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[1][2].func_78792_a(this.tail[1][3]);
            this.setRotationAngle(this.tail[1][3], 0.2618f, 0.0f, 0.0f);
            this.tail[1][3].field_78804_l.add(new ModelBox(this.tail[1][3], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[1][4] = new ModelRenderer((ModelBase)this);
            this.tail[1][4].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[1][3].func_78792_a(this.tail[1][4]);
            this.setRotationAngle(this.tail[1][4], 0.2618f, 0.0f, 0.0f);
            this.tail[1][4].field_78804_l.add(new ModelBox(this.tail[1][4], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[1][5] = new ModelRenderer((ModelBase)this);
            this.tail[1][5].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[1][4].func_78792_a(this.tail[1][5]);
            this.setRotationAngle(this.tail[1][5], 0.2618f, 0.0f, 0.0f);
            this.tail[1][5].field_78804_l.add(new ModelBox(this.tail[1][5], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.3f, false));
            this.tail[1][6] = new ModelRenderer((ModelBase)this);
            this.tail[1][6].func_78793_a(0.0f, -4.0f, 0.0f);
            this.tail[1][5].func_78792_a(this.tail[1][6]);
            this.setRotationAngle(this.tail[1][6], 0.2618f, 0.0f, 0.0f);
            this.tail[1][6].field_78804_l.add(new ModelBox(this.tail[1][6], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.6f, false));
            this.tail[1][7] = new ModelRenderer((ModelBase)this);
            this.tail[1][7].func_78793_a(0.0f, -3.75f, 0.0f);
            this.tail[1][6].func_78792_a(this.tail[1][7]);
            this.setRotationAngle(this.tail[1][7], 0.2618f, 0.0f, 0.0f);
            this.tail[1][7].field_78804_l.add(new ModelBox(this.tail[1][7], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -1.0f, false));
            this.tail[2][0] = new ModelRenderer((ModelBase)this);
            this.tail[2][0].func_78793_a(0.0f, 10.5f, 2.0f);
            this.allTails.func_78792_a(this.tail[2][0]);
            this.setRotationAngle(this.tail[2][0], -1.0472f, 0.5236f, 0.2618f);
            this.tail[2][0].field_78804_l.add(new ModelBox(this.tail[2][0], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[2][1] = new ModelRenderer((ModelBase)this);
            this.tail[2][1].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[2][0].func_78792_a(this.tail[2][1]);
            this.setRotationAngle(this.tail[2][1], 0.2618f, 0.0f, 0.0f);
            this.tail[2][1].field_78804_l.add(new ModelBox(this.tail[2][1], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[2][2] = new ModelRenderer((ModelBase)this);
            this.tail[2][2].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[2][1].func_78792_a(this.tail[2][2]);
            this.setRotationAngle(this.tail[2][2], 0.2618f, 0.0f, 0.0f);
            this.tail[2][2].field_78804_l.add(new ModelBox(this.tail[2][2], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.6f, false));
            this.tail[2][3] = new ModelRenderer((ModelBase)this);
            this.tail[2][3].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[2][2].func_78792_a(this.tail[2][3]);
            this.setRotationAngle(this.tail[2][3], 0.2618f, 0.0f, 0.0f);
            this.tail[2][3].field_78804_l.add(new ModelBox(this.tail[2][3], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[2][4] = new ModelRenderer((ModelBase)this);
            this.tail[2][4].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[2][3].func_78792_a(this.tail[2][4]);
            this.setRotationAngle(this.tail[2][4], 0.2618f, 0.0f, 0.0f);
            this.tail[2][4].field_78804_l.add(new ModelBox(this.tail[2][4], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[2][5] = new ModelRenderer((ModelBase)this);
            this.tail[2][5].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[2][4].func_78792_a(this.tail[2][5]);
            this.setRotationAngle(this.tail[2][5], 0.2618f, 0.0f, 0.0f);
            this.tail[2][5].field_78804_l.add(new ModelBox(this.tail[2][5], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.3f, false));
            this.tail[2][6] = new ModelRenderer((ModelBase)this);
            this.tail[2][6].func_78793_a(0.0f, -4.0f, 0.0f);
            this.tail[2][5].func_78792_a(this.tail[2][6]);
            this.setRotationAngle(this.tail[2][6], 0.2618f, 0.0f, 0.0f);
            this.tail[2][6].field_78804_l.add(new ModelBox(this.tail[2][6], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.6f, false));
            this.tail[2][7] = new ModelRenderer((ModelBase)this);
            this.tail[2][7].func_78793_a(0.0f, -3.75f, 0.0f);
            this.tail[2][6].func_78792_a(this.tail[2][7]);
            this.setRotationAngle(this.tail[2][7], 0.2618f, 0.0f, 0.0f);
            this.tail[2][7].field_78804_l.add(new ModelBox(this.tail[2][7], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -1.0f, false));
            this.tail[3][0] = new ModelRenderer((ModelBase)this);
            this.tail[3][0].func_78793_a(0.0f, 10.5f, 2.0f);
            this.allTails.func_78792_a(this.tail[3][0]);
            this.setRotationAngle(this.tail[3][0], -1.0472f, -1.0472f, -0.5236f);
            this.tail[3][0].field_78804_l.add(new ModelBox(this.tail[3][0], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[3][1] = new ModelRenderer((ModelBase)this);
            this.tail[3][1].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[3][0].func_78792_a(this.tail[3][1]);
            this.setRotationAngle(this.tail[3][1], 0.2618f, 0.0f, 0.0f);
            this.tail[3][1].field_78804_l.add(new ModelBox(this.tail[3][1], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[3][2] = new ModelRenderer((ModelBase)this);
            this.tail[3][2].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[3][1].func_78792_a(this.tail[3][2]);
            this.setRotationAngle(this.tail[3][2], 0.2618f, 0.0f, 0.0f);
            this.tail[3][2].field_78804_l.add(new ModelBox(this.tail[3][2], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.6f, false));
            this.tail[3][3] = new ModelRenderer((ModelBase)this);
            this.tail[3][3].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[3][2].func_78792_a(this.tail[3][3]);
            this.setRotationAngle(this.tail[3][3], 0.2618f, 0.0f, 0.0f);
            this.tail[3][3].field_78804_l.add(new ModelBox(this.tail[3][3], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[3][4] = new ModelRenderer((ModelBase)this);
            this.tail[3][4].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[3][3].func_78792_a(this.tail[3][4]);
            this.setRotationAngle(this.tail[3][4], 0.2618f, 0.0f, 0.0f);
            this.tail[3][4].field_78804_l.add(new ModelBox(this.tail[3][4], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[3][5] = new ModelRenderer((ModelBase)this);
            this.tail[3][5].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[3][4].func_78792_a(this.tail[3][5]);
            this.setRotationAngle(this.tail[3][5], 0.2618f, 0.0f, 0.0f);
            this.tail[3][5].field_78804_l.add(new ModelBox(this.tail[3][5], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.3f, false));
            this.tail[3][6] = new ModelRenderer((ModelBase)this);
            this.tail[3][6].func_78793_a(0.0f, -4.0f, 0.0f);
            this.tail[3][5].func_78792_a(this.tail[3][6]);
            this.setRotationAngle(this.tail[3][6], 0.2618f, 0.0f, 0.0f);
            this.tail[3][6].field_78804_l.add(new ModelBox(this.tail[3][6], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.6f, false));
            this.tail[3][7] = new ModelRenderer((ModelBase)this);
            this.tail[3][7].func_78793_a(0.0f, -3.75f, 0.0f);
            this.tail[3][6].func_78792_a(this.tail[3][7]);
            this.setRotationAngle(this.tail[3][7], 0.2618f, 0.0f, 0.0f);
            this.tail[3][7].field_78804_l.add(new ModelBox(this.tail[3][7], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -1.0f, false));
            this.tail[4][0] = new ModelRenderer((ModelBase)this);
            this.tail[4][0].func_78793_a(0.0f, 10.5f, 2.0f);
            this.allTails.func_78792_a(this.tail[4][0]);
            this.setRotationAngle(this.tail[4][0], -1.0472f, 1.0472f, 0.5236f);
            this.tail[4][0].field_78804_l.add(new ModelBox(this.tail[4][0], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[4][1] = new ModelRenderer((ModelBase)this);
            this.tail[4][1].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[4][0].func_78792_a(this.tail[4][1]);
            this.setRotationAngle(this.tail[4][1], 0.2618f, 0.0f, 0.0f);
            this.tail[4][1].field_78804_l.add(new ModelBox(this.tail[4][1], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[4][2] = new ModelRenderer((ModelBase)this);
            this.tail[4][2].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[4][1].func_78792_a(this.tail[4][2]);
            this.setRotationAngle(this.tail[4][2], 0.2618f, 0.0f, 0.0f);
            this.tail[4][2].field_78804_l.add(new ModelBox(this.tail[4][2], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.6f, false));
            this.tail[4][3] = new ModelRenderer((ModelBase)this);
            this.tail[4][3].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[4][2].func_78792_a(this.tail[4][3]);
            this.setRotationAngle(this.tail[4][3], 0.2618f, 0.0f, 0.0f);
            this.tail[4][3].field_78804_l.add(new ModelBox(this.tail[4][3], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[4][4] = new ModelRenderer((ModelBase)this);
            this.tail[4][4].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[4][3].func_78792_a(this.tail[4][4]);
            this.setRotationAngle(this.tail[4][4], 0.2618f, 0.0f, 0.0f);
            this.tail[4][4].field_78804_l.add(new ModelBox(this.tail[4][4], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[4][5] = new ModelRenderer((ModelBase)this);
            this.tail[4][5].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[4][4].func_78792_a(this.tail[4][5]);
            this.setRotationAngle(this.tail[4][5], 0.2618f, 0.0f, 0.0f);
            this.tail[4][5].field_78804_l.add(new ModelBox(this.tail[4][5], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.3f, false));
            this.tail[4][6] = new ModelRenderer((ModelBase)this);
            this.tail[4][6].func_78793_a(0.0f, -4.0f, 0.0f);
            this.tail[4][5].func_78792_a(this.tail[4][6]);
            this.setRotationAngle(this.tail[4][6], 0.2618f, 0.0f, 0.0f);
            this.tail[4][6].field_78804_l.add(new ModelBox(this.tail[4][6], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.6f, false));
            this.tail[4][7] = new ModelRenderer((ModelBase)this);
            this.tail[4][7].func_78793_a(0.0f, -3.75f, 0.0f);
            this.tail[4][6].func_78792_a(this.tail[4][7]);
            this.setRotationAngle(this.tail[4][7], 0.2618f, 0.0f, 0.0f);
            this.tail[4][7].field_78804_l.add(new ModelBox(this.tail[4][7], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -1.0f, false));
            this.tail[5][0] = new ModelRenderer((ModelBase)this);
            this.tail[5][0].func_78793_a(0.0f, 10.5f, 2.0f);
            this.allTails.func_78792_a(this.tail[5][0]);
            this.setRotationAngle(this.tail[5][0], -1.5718f, -0.2618f, 0.0f);
            this.tail[5][0].field_78804_l.add(new ModelBox(this.tail[5][0], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[5][1] = new ModelRenderer((ModelBase)this);
            this.tail[5][1].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[5][0].func_78792_a(this.tail[5][1]);
            this.setRotationAngle(this.tail[5][1], 0.2618f, 0.0f, 0.0f);
            this.tail[5][1].field_78804_l.add(new ModelBox(this.tail[5][1], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[5][2] = new ModelRenderer((ModelBase)this);
            this.tail[5][2].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[5][1].func_78792_a(this.tail[5][2]);
            this.setRotationAngle(this.tail[5][2], 0.2618f, 0.0f, 0.0f);
            this.tail[5][2].field_78804_l.add(new ModelBox(this.tail[5][2], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.6f, false));
            this.tail[5][3] = new ModelRenderer((ModelBase)this);
            this.tail[5][3].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[5][2].func_78792_a(this.tail[5][3]);
            this.setRotationAngle(this.tail[5][3], 0.2618f, 0.0f, 0.0f);
            this.tail[5][3].field_78804_l.add(new ModelBox(this.tail[5][3], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[5][4] = new ModelRenderer((ModelBase)this);
            this.tail[5][4].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[5][3].func_78792_a(this.tail[5][4]);
            this.setRotationAngle(this.tail[5][4], 0.2618f, 0.0f, 0.0f);
            this.tail[5][4].field_78804_l.add(new ModelBox(this.tail[5][4], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[5][5] = new ModelRenderer((ModelBase)this);
            this.tail[5][5].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[5][4].func_78792_a(this.tail[5][5]);
            this.setRotationAngle(this.tail[5][5], 0.2618f, 0.0f, 0.0f);
            this.tail[5][5].field_78804_l.add(new ModelBox(this.tail[5][5], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.3f, false));
            this.tail[5][6] = new ModelRenderer((ModelBase)this);
            this.tail[5][6].func_78793_a(0.0f, -4.0f, 0.0f);
            this.tail[5][5].func_78792_a(this.tail[5][6]);
            this.setRotationAngle(this.tail[5][6], 0.2618f, 0.0f, 0.0f);
            this.tail[5][6].field_78804_l.add(new ModelBox(this.tail[5][6], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.6f, false));
            this.tail[5][7] = new ModelRenderer((ModelBase)this);
            this.tail[5][7].func_78793_a(0.0f, -3.75f, 0.0f);
            this.tail[5][6].func_78792_a(this.tail[5][7]);
            this.setRotationAngle(this.tail[5][7], 0.2618f, 0.0f, 0.0f);
            this.tail[5][7].field_78804_l.add(new ModelBox(this.tail[5][7], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -1.0f, false));
            this.tail[6][0] = new ModelRenderer((ModelBase)this);
            this.tail[6][0].func_78793_a(0.0f, 10.5f, 2.0f);
            this.allTails.func_78792_a(this.tail[6][0]);
            this.setRotationAngle(this.tail[6][0], -1.5718f, 0.2618f, 0.0f);
            this.tail[6][0].field_78804_l.add(new ModelBox(this.tail[6][0], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[6][1] = new ModelRenderer((ModelBase)this);
            this.tail[6][1].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[6][0].func_78792_a(this.tail[6][1]);
            this.setRotationAngle(this.tail[6][1], 0.2618f, 0.0f, 0.0f);
            this.tail[6][1].field_78804_l.add(new ModelBox(this.tail[6][1], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[6][2] = new ModelRenderer((ModelBase)this);
            this.tail[6][2].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[6][1].func_78792_a(this.tail[6][2]);
            this.setRotationAngle(this.tail[6][2], 0.2618f, 0.0f, 0.0f);
            this.tail[6][2].field_78804_l.add(new ModelBox(this.tail[6][2], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.6f, false));
            this.tail[6][3] = new ModelRenderer((ModelBase)this);
            this.tail[6][3].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[6][2].func_78792_a(this.tail[6][3]);
            this.setRotationAngle(this.tail[6][3], 0.2618f, 0.0f, 0.0f);
            this.tail[6][3].field_78804_l.add(new ModelBox(this.tail[6][3], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[6][4] = new ModelRenderer((ModelBase)this);
            this.tail[6][4].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[6][3].func_78792_a(this.tail[6][4]);
            this.setRotationAngle(this.tail[6][4], 0.2618f, 0.0f, 0.0f);
            this.tail[6][4].field_78804_l.add(new ModelBox(this.tail[6][4], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[6][5] = new ModelRenderer((ModelBase)this);
            this.tail[6][5].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[6][4].func_78792_a(this.tail[6][5]);
            this.setRotationAngle(this.tail[6][5], 0.2618f, 0.0f, 0.0f);
            this.tail[6][5].field_78804_l.add(new ModelBox(this.tail[6][5], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.3f, false));
            this.tail[6][6] = new ModelRenderer((ModelBase)this);
            this.tail[6][6].func_78793_a(0.0f, -4.0f, 0.0f);
            this.tail[6][5].func_78792_a(this.tail[6][6]);
            this.setRotationAngle(this.tail[6][6], 0.2618f, 0.0f, 0.0f);
            this.tail[6][6].field_78804_l.add(new ModelBox(this.tail[6][6], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.6f, false));
            this.tail[6][7] = new ModelRenderer((ModelBase)this);
            this.tail[6][7].func_78793_a(0.0f, -3.75f, 0.0f);
            this.tail[6][6].func_78792_a(this.tail[6][7]);
            this.setRotationAngle(this.tail[6][7], 0.2618f, 0.0f, 0.0f);
            this.tail[6][7].field_78804_l.add(new ModelBox(this.tail[6][7], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -1.0f, false));
            this.tail[7][0] = new ModelRenderer((ModelBase)this);
            this.tail[7][0].func_78793_a(0.0f, 10.5f, 2.0f);
            this.allTails.func_78792_a(this.tail[7][0]);
            this.setRotationAngle(this.tail[7][0], -1.5718f, 0.7854f, 0.0f);
            this.tail[7][0].field_78804_l.add(new ModelBox(this.tail[7][0], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[7][1] = new ModelRenderer((ModelBase)this);
            this.tail[7][1].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[7][0].func_78792_a(this.tail[7][1]);
            this.setRotationAngle(this.tail[7][1], 0.2618f, 0.0f, 0.0f);
            this.tail[7][1].field_78804_l.add(new ModelBox(this.tail[7][1], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[7][2] = new ModelRenderer((ModelBase)this);
            this.tail[7][2].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[7][1].func_78792_a(this.tail[7][2]);
            this.setRotationAngle(this.tail[7][2], 0.2618f, 0.0f, 0.0f);
            this.tail[7][2].field_78804_l.add(new ModelBox(this.tail[7][2], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.6f, false));
            this.tail[7][3] = new ModelRenderer((ModelBase)this);
            this.tail[7][3].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[7][2].func_78792_a(this.tail[7][3]);
            this.setRotationAngle(this.tail[7][3], 0.2618f, 0.0f, 0.0f);
            this.tail[7][3].field_78804_l.add(new ModelBox(this.tail[7][3], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[7][4] = new ModelRenderer((ModelBase)this);
            this.tail[7][4].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[7][3].func_78792_a(this.tail[7][4]);
            this.setRotationAngle(this.tail[7][4], 0.2618f, 0.0f, 0.0f);
            this.tail[7][4].field_78804_l.add(new ModelBox(this.tail[7][4], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[7][5] = new ModelRenderer((ModelBase)this);
            this.tail[7][5].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[7][4].func_78792_a(this.tail[7][5]);
            this.setRotationAngle(this.tail[7][5], 0.2618f, 0.0f, 0.0f);
            this.tail[7][5].field_78804_l.add(new ModelBox(this.tail[7][5], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.3f, false));
            this.tail[7][6] = new ModelRenderer((ModelBase)this);
            this.tail[7][6].func_78793_a(0.0f, -4.0f, 0.0f);
            this.tail[7][5].func_78792_a(this.tail[7][6]);
            this.setRotationAngle(this.tail[7][6], 0.2618f, 0.0f, 0.0f);
            this.tail[7][6].field_78804_l.add(new ModelBox(this.tail[7][6], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.6f, false));
            this.tail[7][7] = new ModelRenderer((ModelBase)this);
            this.tail[7][7].func_78793_a(0.0f, -3.75f, 0.0f);
            this.tail[7][6].func_78792_a(this.tail[7][7]);
            this.setRotationAngle(this.tail[7][7], 0.2618f, 0.0f, 0.0f);
            this.tail[7][7].field_78804_l.add(new ModelBox(this.tail[7][7], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -1.0f, false));
            this.tail[8][0] = new ModelRenderer((ModelBase)this);
            this.tail[8][0].func_78793_a(0.0f, 10.5f, 2.0f);
            this.allTails.func_78792_a(this.tail[8][0]);
            this.setRotationAngle(this.tail[8][0], -1.5718f, -0.7854f, 0.0f);
            this.tail[8][0].field_78804_l.add(new ModelBox(this.tail[8][0], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[8][1] = new ModelRenderer((ModelBase)this);
            this.tail[8][1].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[8][0].func_78792_a(this.tail[8][1]);
            this.setRotationAngle(this.tail[8][1], 0.2618f, 0.0f, 0.0f);
            this.tail[8][1].field_78804_l.add(new ModelBox(this.tail[8][1], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[8][2] = new ModelRenderer((ModelBase)this);
            this.tail[8][2].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[8][1].func_78792_a(this.tail[8][2]);
            this.setRotationAngle(this.tail[8][2], 0.2618f, 0.0f, 0.0f);
            this.tail[8][2].field_78804_l.add(new ModelBox(this.tail[8][2], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.6f, false));
            this.tail[8][3] = new ModelRenderer((ModelBase)this);
            this.tail[8][3].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[8][2].func_78792_a(this.tail[8][3]);
            this.setRotationAngle(this.tail[8][3], 0.2618f, 0.0f, 0.0f);
            this.tail[8][3].field_78804_l.add(new ModelBox(this.tail[8][3], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.3f, false));
            this.tail[8][4] = new ModelRenderer((ModelBase)this);
            this.tail[8][4].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[8][3].func_78792_a(this.tail[8][4]);
            this.setRotationAngle(this.tail[8][4], 0.2618f, 0.0f, 0.0f);
            this.tail[8][4].field_78804_l.add(new ModelBox(this.tail[8][4], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.0f, false));
            this.tail[8][5] = new ModelRenderer((ModelBase)this);
            this.tail[8][5].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tail[8][4].func_78792_a(this.tail[8][5]);
            this.setRotationAngle(this.tail[8][5], 0.2618f, 0.0f, 0.0f);
            this.tail[8][5].field_78804_l.add(new ModelBox(this.tail[8][5], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.3f, false));
            this.tail[8][6] = new ModelRenderer((ModelBase)this);
            this.tail[8][6].func_78793_a(0.0f, -4.0f, 0.0f);
            this.tail[8][5].func_78792_a(this.tail[8][6]);
            this.setRotationAngle(this.tail[8][6], 0.2618f, 0.0f, 0.0f);
            this.tail[8][6].field_78804_l.add(new ModelBox(this.tail[8][6], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.6f, false));
            this.tail[8][7] = new ModelRenderer((ModelBase)this);
            this.tail[8][7].func_78793_a(0.0f, -3.75f, 0.0f);
            this.tail[8][6].func_78792_a(this.tail[8][7]);
            this.setRotationAngle(this.tail[8][7], 0.2618f, 0.0f, 0.0f);
            this.tail[8][7].field_78804_l.add(new ModelBox(this.tail[8][7], 16, 32, -2.0f, -5.5f, -2.0f, 4, 6, 4, -1.0f, false));
            this.bipedBodyWear = new ModelRenderer((ModelBase)this);
            this.bipedBodyWear.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bipedBodyWear.field_78804_l.add(new ModelBox(this.bipedBodyWear, 80, 16, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.65f, false));
            this.bipedBodyWear.field_78804_l.add(new ModelBox(this.bipedBodyWear, 80, 32, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.7f, false));
            this.tailWears = new ModelRenderer((ModelBase)this);
            this.tailWears.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bipedBodyWear.func_78792_a(this.tailWears);
            this.tailWear[0][0] = new ModelRenderer((ModelBase)this);
            this.tailWear[0][0].func_78793_a(0.0f, 10.5f, 2.0f);
            this.tailWears.func_78792_a(this.tailWear[0][0]);
            this.setRotationAngle(this.tailWear[0][0], -1.0472f, 0.0f, 0.0f);
            this.tailWear[0][0].field_78804_l.add(new ModelBox(this.tailWear[0][0], 102, 4, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.01f, false));
            this.tailWear[0][1] = new ModelRenderer((ModelBase)this);
            this.tailWear[0][1].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tailWear[0][0].func_78792_a(this.tailWear[0][1]);
            this.setRotationAngle(this.tailWear[0][1], 0.2618f, 0.0f, 0.0f);
            this.tailWear[0][1].field_78804_l.add(new ModelBox(this.tailWear[0][1], 102, 4, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.31f, false));
            this.tailWear[0][2] = new ModelRenderer((ModelBase)this);
            this.tailWear[0][2].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tailWear[0][1].func_78792_a(this.tailWear[0][2]);
            this.setRotationAngle(this.tailWear[0][2], 0.2618f, 0.0f, 0.0f);
            this.tailWear[0][2].field_78804_l.add(new ModelBox(this.tailWear[0][2], 102, 4, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.61f, false));
            this.tailWear[0][3] = new ModelRenderer((ModelBase)this);
            this.tailWear[0][3].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tailWear[0][2].func_78792_a(this.tailWear[0][3]);
            this.setRotationAngle(this.tailWear[0][3], 0.2618f, 0.0f, 0.0f);
            this.tailWear[0][3].field_78804_l.add(new ModelBox(this.tailWear[0][3], 102, 4, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.31f, false));
            this.tailWear[0][4] = new ModelRenderer((ModelBase)this);
            this.tailWear[0][4].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tailWear[0][3].func_78792_a(this.tailWear[0][4]);
            this.setRotationAngle(this.tailWear[0][4], 0.2618f, 0.0f, 0.0f);
            this.tailWear[0][4].field_78804_l.add(new ModelBox(this.tailWear[0][4], 102, 4, -2.0f, -5.5f, -2.0f, 4, 6, 4, 0.01f, false));
            this.tailWear[0][5] = new ModelRenderer((ModelBase)this);
            this.tailWear[0][5].func_78793_a(0.0f, -5.0f, 0.0f);
            this.tailWear[0][4].func_78792_a(this.tailWear[0][5]);
            this.setRotationAngle(this.tailWear[0][5], 0.2618f, 0.0f, 0.0f);
            this.tailWear[0][5].field_78804_l.add(new ModelBox(this.tailWear[0][5], 102, 4, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.29f, false));
            this.tailWear[0][6] = new ModelRenderer((ModelBase)this);
            this.tailWear[0][6].func_78793_a(0.0f, -4.0f, 0.0f);
            this.tailWear[0][5].func_78792_a(this.tailWear[0][6]);
            this.setRotationAngle(this.tailWear[0][6], 0.2618f, 0.0f, 0.0f);
            this.tailWear[0][6].field_78804_l.add(new ModelBox(this.tailWear[0][6], 102, 4, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.59f, false));
            this.tailWear[0][7] = new ModelRenderer((ModelBase)this);
            this.tailWear[0][7].func_78793_a(0.0f, -3.75f, 0.0f);
            this.tailWear[0][6].func_78792_a(this.tailWear[0][7]);
            this.setRotationAngle(this.tailWear[0][7], 0.2618f, 0.0f, 0.0f);
            this.tailWear[0][7].field_78804_l.add(new ModelBox(this.tailWear[0][7], 102, 4, -2.0f, -5.5f, -2.0f, 4, 6, 4, -0.99f, false));
            this.field_178723_h = new ModelRenderer((ModelBase)this);
            this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 16, -3.0f, -2.0f, -2.0f, 4, 12, 4, 0.6f, false));
            this.bipedRightArmWear = new ModelRenderer((ModelBase)this);
            this.bipedRightArmWear.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.bipedRightArmWear.field_78804_l.add(new ModelBox(this.bipedRightArmWear, 104, 16, -3.0f, -2.0f, -2.0f, 4, 12, 4, 0.65f, false));
            this.bipedRightArmWear.field_78804_l.add(new ModelBox(this.bipedRightArmWear, 104, 32, -3.0f, -2.0f, -2.0f, 4, 12, 4, 0.7f, false));
            this.sandArm = new ModelRenderer((ModelBase)this);
            if (tails == 1) {
                this.sandArm.func_78793_a(-1.6421f, 7.959f, -3.46f);
                this.bipedRightArmWear.func_78792_a(this.sandArm);
                ModelRenderer sandHand = new ModelRenderer((ModelBase)this);
                sandHand.func_78793_a(-2.3579f, 3.041f, 1.46f);
                this.sandArm.func_78792_a(sandHand);
                ModelRenderer finger = new ModelRenderer((ModelBase)this);
                finger.func_78793_a(0.0f, 0.0f, 0.0f);
                sandHand.func_78792_a(finger);
                this.setRotationAngle(finger, 0.0f, 0.0f, 0.1309f);
                ModelRenderer cube_r3 = new ModelRenderer((ModelBase)this);
                cube_r3.func_78793_a(0.0f, 0.0f, 0.0f);
                finger.func_78792_a(cube_r3);
                this.setRotationAngle(cube_r3, -0.0999f, -0.5148f, 0.2009f);
                cube_r3.field_78804_l.add(new ModelBox(cube_r3, 120, 35, -0.075f, -3.0f, -1.0f, 2, 4, 2, 0.0f, false));
                ModelRenderer cube_r4 = new ModelRenderer((ModelBase)this);
                cube_r4.func_78793_a(1.1324f, 2.5785f, 0.6538f);
                finger.func_78792_a(cube_r4);
                this.setRotationAngle(cube_r4, 0.1719f, -0.4971f, -0.3492f);
                cube_r4.field_78804_l.add(new ModelBox(cube_r4, 120, 42, -1.0f, -2.3f, -1.0f, 2, 4, 2, -0.25f, false));
                ModelRenderer finger3 = new ModelRenderer((ModelBase)this);
                finger3.func_78793_a(4.9282f, 0.7341f, 1.2245f);
                sandHand.func_78792_a(finger3);
                this.setRotationAngle(finger3, 0.0f, 0.5672f, 0.0f);
                ModelRenderer cube_r5 = new ModelRenderer((ModelBase)this);
                cube_r5.func_78793_a(0.9968f, -0.7341f, 0.5755f);
                finger3.func_78792_a(cube_r5);
                this.setRotationAngle(cube_r5, 0.0999f, -0.5148f, -0.2009f);
                cube_r5.field_78804_l.add(new ModelBox(cube_r5, 120, 35, -1.925f, -3.0f, -1.0f, 2, 4, 2, 0.0f, true));
                ModelRenderer cube_r6 = new ModelRenderer((ModelBase)this);
                cube_r6.func_78793_a(-0.1356f, 1.8444f, -0.0783f);
                finger3.func_78792_a(cube_r6);
                this.setRotationAngle(cube_r6, -0.1719f, -0.4971f, 0.3492f);
                cube_r6.field_78804_l.add(new ModelBox(cube_r6, 120, 42, -1.0f, -2.3f, -1.0f, 2, 4, 2, -0.25f, true));
                ModelRenderer finger2 = new ModelRenderer((ModelBase)this);
                finger2.func_78793_a(0.0f, 0.0f, 4.0f);
                sandHand.func_78792_a(finger2);
                this.setRotationAngle(finger2, 0.0f, 0.0f, 0.1309f);
                ModelRenderer cube_r7 = new ModelRenderer((ModelBase)this);
                cube_r7.func_78793_a(0.0f, 0.0f, 0.0f);
                finger2.func_78792_a(cube_r7);
                this.setRotationAngle(cube_r7, 0.0999f, 0.5148f, 0.2009f);
                cube_r7.field_78804_l.add(new ModelBox(cube_r7, 120, 35, -0.075f, -3.0f, -1.0f, 2, 4, 2, 0.0f, false));
                ModelRenderer cube_r8 = new ModelRenderer((ModelBase)this);
                cube_r8.func_78793_a(1.1324f, 2.5785f, -0.6538f);
                finger2.func_78792_a(cube_r8);
                this.setRotationAngle(cube_r8, -0.1719f, 0.4971f, -0.3492f);
                cube_r8.field_78804_l.add(new ModelBox(cube_r8, 120, 42, -1.0f, -2.3f, -1.0f, 2, 4, 2, -0.25f, false));
                ModelRenderer bump2 = new ModelRenderer((ModelBase)this);
                bump2.func_78793_a(0.4421f, -2.584f, 3.21f);
                this.sandArm.func_78792_a(bump2);
                ModelRenderer cube_r9 = new ModelRenderer((ModelBase)this);
                cube_r9.func_78793_a(0.0f, 0.0f, 0.2f);
                bump2.func_78792_a(cube_r9);
                this.setRotationAngle(cube_r9, -0.4102f, -0.4102f, -0.7854f);
                cube_r9.field_78804_l.add(new ModelBox(cube_r9, 95, 0, -2.0f, -2.0f, -2.0f, 4, 4, 4, 0.6f, false));
                ModelRenderer bump = new ModelRenderer((ModelBase)this);
                bump.func_78793_a(0.4421f, -8.584f, 3.21f);
                this.sandArm.func_78792_a(bump);
                this.setRotationAngle(bump, 0.0f, 0.0f, 0.48f);
                ModelRenderer cube_r10 = new ModelRenderer((ModelBase)this);
                cube_r10.func_78793_a(0.0f, 0.0f, 0.0f);
                bump.func_78792_a(cube_r10);
                this.setRotationAngle(cube_r10, -0.4102f, -0.4102f, -0.7854f);
                cube_r10.field_78804_l.add(new ModelBox(cube_r10, 95, 0, -1.9203f, -2.0731f, -1.8318f, 4, 4, 4, 0.6f, false));
                ModelRenderer sparefingers = new ModelRenderer((ModelBase)this);
                sparefingers.func_78793_a(0.0f, 0.0f, 0.0f);
                this.sandArm.func_78792_a(sparefingers);
                ModelRenderer cube_r11 = new ModelRenderer((ModelBase)this);
                cube_r11.func_78793_a(0.0f, 0.0f, 0.0f);
                sparefingers.func_78792_a(cube_r11);
                this.setRotationAngle(cube_r11, -1.6095f, -1.0268f, 1.3404f);
                cube_r11.field_78804_l.add(new ModelBox(cube_r11, 120, 42, -0.25f, -2.0f, -1.0f, 2, 4, 2, -0.25f, false));
                ModelRenderer cube_r12 = new ModelRenderer((ModelBase)this);
                cube_r12.func_78793_a(-1.3089f, -4.5636f, 3.7447f);
                sparefingers.func_78792_a(cube_r12);
                this.setRotationAngle(cube_r12, 0.1512f, 0.1609f, 0.7314f);
                cube_r12.field_78804_l.add(new ModelBox(cube_r12, 120, 42, -2.475f, -2.0f, -1.0f, 2, 4, 2, -0.25f, false));
                ModelRenderer cube_r13 = new ModelRenderer((ModelBase)this);
                cube_r13.func_78793_a(0.5218f, 0.2381f, 6.7784f);
                sparefingers.func_78792_a(cube_r13);
                this.setRotationAngle(cube_r13, 1.6292f, 0.9065f, 1.702f);
                cube_r13.field_78804_l.add(new ModelBox(cube_r13, 120, 42, -1.0f, -3.0f, -2.175f, 2, 4, 2, -0.25f, false));
                ModelRenderer cube_r14 = new ModelRenderer((ModelBase)this);
                cube_r14.func_78793_a(2.5926f, -1.7054f, 6.8658f);
                sparefingers.func_78792_a(cube_r14);
                this.setRotationAngle(cube_r14, 1.1536f, 0.8762f, 0.7801f);
                cube_r14.field_78804_l.add(new ModelBox(cube_r14, 120, 42, -2.15f, -5.25f, -0.625f, 2, 4, 2, -0.25f, false));
            }
            this.field_178724_i = new ModelRenderer((ModelBase)this);
            this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
            this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 32, 48, -1.0f, -2.0f, -2.0f, 4, 12, 4, 0.6f, false));
            this.bipedLeftArmWear = new ModelRenderer((ModelBase)this);
            this.bipedLeftArmWear.func_78793_a(5.0f, 2.0f, 0.0f);
            this.bipedLeftArmWear.field_78804_l.add(new ModelBox(this.bipedLeftArmWear, 96, 48, -1.0f, -2.0f, -2.0f, 4, 12, 4, 0.65f, false));
            this.bipedLeftArmWear.field_78804_l.add(new ModelBox(this.bipedLeftArmWear, 112, 48, -1.0f, -2.0f, -2.0f, 4, 12, 4, 0.7f, false));
            this.field_178721_j = new ModelRenderer((ModelBase)this);
            this.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.field_178721_j.field_78804_l.add(new ModelBox(this.field_178721_j, 0, 16, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.6f, false));
            this.bipedRightLegWear = new ModelRenderer((ModelBase)this);
            this.bipedRightLegWear.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.bipedRightLegWear.field_78804_l.add(new ModelBox(this.bipedRightLegWear, 64, 16, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.65f, false));
            this.bipedRightLegWear.field_78804_l.add(new ModelBox(this.bipedRightLegWear, 64, 32, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.7f, false));
            this.field_178722_k = new ModelRenderer((ModelBase)this);
            this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
            this.field_178722_k.field_78804_l.add(new ModelBox(this.field_178722_k, 16, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.6f, false));
            this.bipedLeftLegWear = new ModelRenderer((ModelBase)this);
            this.bipedLeftLegWear.func_78793_a(1.9f, 12.0f, 0.0f);
            this.bipedLeftLegWear.field_78804_l.add(new ModelBox(this.bipedLeftLegWear, 80, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.65f, false));
            this.bipedLeftLegWear.field_78804_l.add(new ModelBox(this.bipedLeftLegWear, 64, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.7f, false));
            for (i = 1; i < 6; ++i) {
                this.leftEarSwayX[i] = (this.rand.nextFloat() * 0.2618f + 0.0873f) * (this.rand.nextBoolean() ? -1.0f : 1.0f);
                this.leftEarSwayZ[i] = (this.rand.nextFloat() * 0.2618f + 0.0873f) * (this.rand.nextBoolean() ? -1.0f : 1.0f);
                this.rightEarSwayX[i] = (this.rand.nextFloat() * 0.2618f + 0.0873f) * (this.rand.nextBoolean() ? -1.0f : 1.0f);
                this.rightEarSwayZ[i] = (this.rand.nextFloat() * 0.2618f + 0.0873f) * (this.rand.nextBoolean() ? -1.0f : 1.0f);
            }
            for (i = 0; i < 9; ++i) {
                for (int j = 1; j < 8; ++j) {
                    this.tailSwayX[i][j] = (this.rand.nextFloat() * 0.1745f + 0.1745f) * (this.rand.nextBoolean() ? -1.0f : 1.0f);
                    this.tailSwayZ[i][j] = (this.rand.nextFloat() * 0.2618f + 0.2618f) * (this.rand.nextBoolean() ? -1.0f : 1.0f);
                }
            }
            this.setModelVisibilities(tails);
        }

        private void setModelVisibilities(int numberoftails) {
            int j = this.tailShowMap[numberoftails];
            for (int i = 0; i < 9; ++i) {
                this.tail[i][0].field_78806_j = (j & 1 << i) != 0;
            }
            if (numberoftails != 1) {
                this.sandArm.field_78806_j = false;
            } else {
                this.earLeft[0].field_78806_j = false;
                this.earRight[0].field_78806_j = false;
            }
        }

        public void func_78088_a(Entity entity, float f0, float f1, float f2, float f3, float f4, float f5) {
            this.field_178720_f.field_78806_j = false;
            this.field_78115_e.field_78806_j = this.field_78115_e.field_78806_j && !this.field_178721_j.field_78806_j && !this.field_178722_k.field_78806_j;
            GlStateManager.func_179094_E();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)(f2 * 0.01f), (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)MathHelper.func_76131_a((float)((float)ItemBijuCloak.getWearingTicks(entity) / 80.0f), (float)0.0f, (float)1.0f));
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int k = entity.func_70070_b();
            if (this.bodyShine) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            } else {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(k % 65536), (float)(k / 65536));
            }
            Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
            super.func_78088_a(entity, f0, f1, f2, f3, f4, f5);
            Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            if (this.layerShine) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            } else {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(k % 65536), (float)(k / 65536));
            }
            if (entity.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            ModelBijuCloak.func_178685_a((ModelRenderer)this.field_78115_e, (ModelRenderer)this.bipedBodyWear);
            ModelBijuCloak.func_178685_a((ModelRenderer)this.field_178723_h, (ModelRenderer)this.bipedRightArmWear);
            ModelBijuCloak.func_178685_a((ModelRenderer)this.field_178724_i, (ModelRenderer)this.bipedLeftArmWear);
            ModelBijuCloak.func_178685_a((ModelRenderer)this.field_178721_j, (ModelRenderer)this.bipedRightLegWear);
            ModelBijuCloak.func_178685_a((ModelRenderer)this.field_178722_k, (ModelRenderer)this.bipedLeftLegWear);
            this.field_178720_f.field_78806_j = this.field_78116_c.field_78806_j;
            this.bipedBodyWear.field_78806_j = this.field_78115_e.field_78806_j;
            this.bipedRightArmWear.field_78806_j = this.field_178723_h.field_78806_j;
            this.bipedLeftArmWear.field_78806_j = this.field_178724_i.field_78806_j;
            this.bipedRightLegWear.field_78806_j = this.field_178721_j.field_78806_j;
            this.bipedLeftLegWear.field_78806_j = this.field_178722_k.field_78806_j;
            this.field_178720_f.func_78785_a(f5);
            this.bipedBodyWear.func_78785_a(f5);
            this.bipedRightArmWear.func_78785_a(f5);
            this.bipedLeftArmWear.func_78785_a(f5);
            this.bipedRightLegWear.func_78785_a(f5);
            this.bipedLeftLegWear.func_78785_a(f5);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179121_F();
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
            int i;
            if (this.narutoRunPose) {
                this.field_78117_n = true;
            }
            super.func_78087_a(f, f1, f2, f3, f4, f5, e);
            for (i = 1; i < 6; ++i) {
                this.earLeft[i].field_78795_f = -0.1745f + MathHelper.func_76126_a((float)(f2 * 0.15f)) * this.leftEarSwayX[i];
                this.earLeft[i].field_78808_h = MathHelper.func_76134_b((float)(f2 * 0.15f)) * this.leftEarSwayZ[i];
                this.earRight[i].field_78795_f = 0.1745f + MathHelper.func_76126_a((float)(f2 * 0.15f)) * this.rightEarSwayX[i];
                this.earRight[i].field_78808_h = MathHelper.func_76134_b((float)(f2 * 0.15f)) * this.rightEarSwayZ[i];
            }
            for (i = 0; i < 9; ++i) {
                for (int j = 2; j < 8; ++j) {
                    this.tail[i][j].field_78795_f = 0.2618f + MathHelper.func_76126_a((float)(f2 * 0.15f)) * this.tailSwayX[i][j];
                    this.tail[i][j].field_78808_h = MathHelper.func_76134_b((float)(f2 * 0.15f)) * this.tailSwayZ[i][j];
                    if (i != 0) continue;
                    this.tailWear[i][j].field_78795_f = this.tail[i][j].field_78795_f;
                    this.tailWear[i][j].field_78808_h = this.tail[i][j].field_78808_h;
                }
            }
            if (this.narutoRunPose) {
                this.field_178723_h.field_78795_f = 1.4835f;
                this.field_178723_h.field_78796_g = -0.3927f;
                this.field_178724_i.field_78795_f = 1.4835f;
                this.field_178724_i.field_78796_g = 0.3927f;
            }
        }

        public void setNarutoRunPose(boolean b) {
            this.narutoRunPose = b;
        }
    }
}

