/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityEarthGolem;
import net.narutomod.entity.EntityEarthSandwich;
import net.narutomod.entity.EntityEarthSpears;
import net.narutomod.entity.EntitySwampPit;
import net.narutomod.event.EventSetBlocks;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureOnLivingUpdate;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemDoton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:doton")
    public static final Item block = null;
    public static final int ENTITYID = 134;
    public static final int ENTITY2ID = 10134;
    private static final List<Material> earthenMaterials = Arrays.asList(Material.field_151578_c, Material.field_151576_e, Material.field_151595_p, Material.field_151571_B);
    public static final ItemJutsu.JutsuEnum HIDINGINROCK = new ItemJutsu.JutsuEnum(0, "entityhidinginrock", 'C', 10.0, (ItemJutsu.IJutsuCallback)new EntityHidingInRock.Jutsu());
    public static final ItemJutsu.JutsuEnum EARTHWALL = new ItemJutsu.JutsuEnum(1, "entityearthwall", 'B', 20.0, (ItemJutsu.IJutsuCallback)new EntityEarthWall.Jutsu());
    public static final ItemJutsu.JutsuEnum SANDWICH = new ItemJutsu.JutsuEnum(2, "earth_sandwich", 'B', 100.0, (ItemJutsu.IJutsuCallback)new EntityEarthSandwich.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum SWAMPPIT = new ItemJutsu.JutsuEnum(3, "swamp_pit", 'A', 100.0, (ItemJutsu.IJutsuCallback)new EntitySwampPit.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum SPEARS = new ItemJutsu.JutsuEnum(4, "earth_spears", 'C', 20.0, (ItemJutsu.IJutsuCallback)new EntityEarthSpears.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum GOLEM = new ItemJutsu.JutsuEnum(5, "earth_golem", 'B', 100.0, (ItemJutsu.IJutsuCallback)new EntityEarthGolem.EC.Jutsu());

    public ItemDoton(ElementsNarutomodMod instance) {
        super(instance, 378);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(HIDINGINROCK, EARTHWALL, SANDWICH, SWAMPPIT, SPEARS, GOLEM));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityEarthWall.class).id(new ResourceLocation("narutomod", "entityearthwall"), 134).name("entityearthwall").tracker(64, 1, true).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityHidingInRock.class).id(new ResourceLocation("narutomod", "entityhidinginrock"), 10134).name("entityhidinginrock").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:doton", "inventory"));
    }

    private static boolean isEarthenMaterial(Material material) {
        return earthenMaterials.contains(material);
    }

    public static class EntityEarthWall
    extends Entity {
        private final int blockChunk = 128;
        private final int duration = 200;
        private double wallHeight;
        private List<BlockPos> affectedList;
        private List<BlockPos> tempList;
        private final List<BlockPos> allBlocks;
        private boolean dieOnDone;
        private int vindex;
        private int removeTime;

        public EntityEarthWall(World a) {
            super(a);
            this.func_70105_a(0.01f, 0.01f);
            this.affectedList = Lists.newArrayList();
            this.allBlocks = Lists.newArrayList();
            this.dieOnDone = true;
        }

        public EntityEarthWall(World worldIn, double x, double y, double z, float yaw, double widthIn, double heightIn, double thickness, boolean autoIn) {
            this(worldIn);
            this.dieOnDone = autoIn;
            this.wallHeight = heightIn;
            if (thickness < 1.0) {
                thickness = 1.0;
            }
            thickness = (thickness - 1.0) / 2.0;
            this.func_70107_b(x, y, z);
            Vec3d vec = new Vec3d(x, y, z);
            Vec3d vec3d = vec.func_178787_e(Vec3d.func_189986_a((float)0.0f, (float)(yaw - 90.0f)).func_186678_a(widthIn /= 2.0));
            Vec3d vec3d1 = vec.func_178787_e(Vec3d.func_189986_a((float)0.0f, (float)(yaw + 90.0f)).func_186678_a(widthIn));
            for (AxisAlignedBB aabb : this.field_70170_p.func_184144_a(null, this.func_174813_aQ().func_72314_b(widthIn, this.wallHeight, widthIn))) {
                RayTraceResult r;
                BlockPos pos = new BlockPos(ProcedureUtils.BB.getCenter(aabb));
                if (autoIn) {
                    r = aabb.func_72314_b(thickness, this.wallHeight, thickness).func_72327_a(vec3d, vec3d1);
                    if (r == null || !this.isNeighborEarthenMaterial(pos) || !this.field_70170_p.func_175623_d(pos.func_177984_a())) continue;
                    this.affectedList.add(pos);
                    continue;
                }
                r = aabb.func_72314_b(thickness, 0.0, thickness).func_72321_a(0.0, this.wallHeight, 0.0).func_72327_a(vec3d, vec3d1);
                if (r == null || !this.isNeighborEarthenMaterial(pos) || aabb.field_72337_e != y && this.field_70170_p.func_180495_p(pos.func_177984_a()).func_185896_q()) continue;
                this.affectedList.add(pos);
            }
            this.tempList = Lists.newArrayList();
        }

        public EntityEarthWall(World worldIn, double x, double y, double z, float yaw, double widthIn) {
            this(worldIn, x, y, z, yaw, widthIn, widthIn * 0.6, widthIn * 0.25, true);
        }

        private boolean isNeighborEarthenMaterial(BlockPos pos) {
            return this.getNeightborEarthenBlock(pos).func_177230_c() != Blocks.field_150350_a;
        }

        private IBlockState getNeightborEarthenBlock(BlockPos pos) {
            IBlockState bstate = Blocks.field_150350_a.func_176223_P();
            if (ItemDoton.isEarthenMaterial(this.field_70170_p.func_180495_p(pos).func_185904_a())) {
                bstate = this.field_70170_p.func_180495_p(pos);
            } else {
                for (EnumFacing face : EnumFacing.values()) {
                    if (bstate.func_177230_c() != Blocks.field_150350_a || !ItemDoton.isEarthenMaterial(this.field_70170_p.func_180495_p(pos.func_177972_a(face)).func_185904_a())) continue;
                    bstate = this.field_70170_p.func_180495_p(pos.func_177972_a(face));
                }
            }
            if (bstate.func_177230_c() instanceof BlockOre || bstate.func_177230_c() instanceof BlockRedstoneOre || bstate.func_177230_c() == Blocks.field_150357_h) {
                bstate = Blocks.field_150348_b.func_176223_P();
            }
            return bstate;
        }

        protected void func_70088_a() {
        }

        private void moveUpEntitiesInAABB(AxisAlignedBB aabb, double offset) {
            for (Entity entity : this.field_70170_p.func_72839_b(null, aabb)) {
                entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + offset + 1.5, entity.field_70161_v);
            }
        }

        public void func_70071_h_() {
            if (!this.affectedList.isEmpty()) {
                if (this.field_70173_aa % 30 == 1) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:rocks")), 5.0f, this.field_70146_Z.nextFloat() * 0.5f + 0.3f);
                }
                BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
                int i = 0;
                while (i < this.blockChunk && this.vindex < (int)this.wallHeight) {
                    Iterator<BlockPos> iter = this.affectedList.iterator();
                    while (i < this.blockChunk && iter.hasNext()) {
                        pos.func_189533_g((Vec3i)iter.next().func_177984_a());
                        iter.remove();
                        this.tempList.add(pos.func_185334_h());
                        if (pos.func_177956_o() >= 255 || !this.field_70170_p.func_175623_d((BlockPos)pos)) continue;
                        this.moveUpEntitiesInAABB(new AxisAlignedBB((BlockPos)pos), 1.0);
                        IBlockState state = this.getNeightborEarthenBlock(pos.func_177977_b());
                        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 5, 0.0, 0.0, 0.0, 0.15, new int[]{Block.func_149682_b((Block)state.func_177230_c())});
                        this.field_70170_p.func_180501_a((BlockPos)pos, state, 3);
                        this.allBlocks.add(pos.func_185334_h());
                        ++i;
                    }
                    if (!this.affectedList.isEmpty()) continue;
                    this.affectedList = Lists.newArrayList(this.tempList);
                    this.tempList.clear();
                    ++this.vindex;
                }
                pos.func_185344_t();
                if (this.vindex >= (int)this.wallHeight) {
                    this.affectedList.clear();
                }
            } else if (!this.field_70170_p.field_72995_K && this.dieOnDone) {
                this.removeTime = 1200;
                this.func_70106_y();
            }
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K && !this.allBlocks.isEmpty()) {
                HashMap map = Maps.newHashMap();
                for (BlockPos pos : this.allBlocks) {
                    map.put(pos, Blocks.field_150350_a.func_176223_P());
                }
                this.allBlocks.clear();
                new EventSetBlocks(this.field_70170_p, map, this.field_70170_p.func_82737_E() + (long)this.removeTime, 0, false, false);
            }
        }

        public boolean isBlockBreakable(BlockPos pos) {
            IBlockState blockstate = this.field_70170_p.func_180495_p(pos);
            float hardness = blockstate.func_185887_b(this.field_70170_p, pos);
            return !blockstate.func_185896_q() && (blockstate.func_185904_a().func_76224_d() || hardness >= 0.0f && hardness <= 5.0f);
        }

        public boolean isDone() {
            return !this.field_70170_p.field_72995_K && (this.affectedList.isEmpty() || this.vindex > (int)this.wallHeight);
        }

        public List<BlockPos> getAllBlocks() {
            return this.allBlocks;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                RayTraceResult rt;
                if (power >= 5.0f && (rt = ProcedureUtils.raytraceBlocks((Entity)entity, 30.0)) != null && rt.field_72313_a == RayTraceResult.Type.BLOCK) {
                    entity.field_70170_p.func_72838_d((Entity)new EntityEarthWall(entity.field_70170_p, rt.field_72307_f.field_72450_a, rt.field_72307_f.field_72448_b, rt.field_72307_f.field_72449_c, entity.field_70177_z, power));
                    return true;
                }
                return false;
            }
        }
    }

    public static class EntityHidingInRock
    extends Entity {
        private final int waitTime = 60;
        private EntityLivingBase user;

        public EntityHidingInRock(World worldIn) {
            super(worldIn);
            this.func_70105_a(0.01f, 0.01f);
        }

        public EntityHidingInRock(EntityLivingBase userIn) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.func_70107_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v);
        }

        protected void func_70088_a() {
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (this.user != null) {
                this.user.getEntityData().func_82580_o("HidingInRockIdKey");
            }
            if (this.isUserIntangible()) {
                this.setUserIntangible(false);
            }
        }

        private boolean isUserInEarth() {
            BlockPos pos = new BlockPos((Entity)this.user);
            return ItemDoton.isEarthenMaterial(this.field_70170_p.func_180495_p(pos).func_185904_a()) || ItemDoton.isEarthenMaterial(this.field_70170_p.func_180495_p(pos.func_177984_a()).func_185904_a());
        }

        private boolean isUserIntangible() {
            return this.user != null && ProcedureOnLivingUpdate.isNoClip((Entity)this.user);
        }

        private void setUserIntangible(boolean intangibleIn) {
            ProcedureOnLivingUpdate.setNoClip((Entity)this.user, intangibleIn);
            if (this.user instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
                String string = I18n.func_74838_a((String)"chattext.intangible");
                ((EntityPlayer)this.user).func_146105_b((ITextComponent)new TextComponentString(string + intangibleIn), true);
            }
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.user != null && this.user.func_70089_S()) {
                boolean flag1;
                this.func_70107_b(this.user.field_70165_t, this.user.field_70163_u, this.user.field_70161_v);
                boolean flag = this.field_70173_aa % 20 != 0;
                boolean bl = flag1 = this.user instanceof EntityPlayer && (flag || Chakra.pathway((EntityPlayer)this.user).getAmount() >= ItemDoton.HIDINGINROCK.chakraUsage);
                if (this.field_70173_aa > this.waitTime && !this.isUserInEarth() || !flag1) {
                    this.func_70106_y();
                } else {
                    this.setUserIntangible(true);
                    if (!flag && flag1) {
                        Chakra.pathway((EntityPlayer)this.user).consume(ItemDoton.HIDINGINROCK.chakraUsage);
                    }
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ID_KEY = "HidingInRockIdKey";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (!ProcedureOnLivingUpdate.isNoClip((Entity)entity)) {
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:jutsu")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    entity.field_70170_p.func_72838_d((Entity)new EntityHidingInRock(entity));
                    entity.getEntityData().func_74757_a(ID_KEY, true);
                    return true;
                }
                return false;
            }

            @Override
            public boolean isActivated(EntityLivingBase entity) {
                return entity.getEntityData().func_74767_n(ID_KEY);
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.DOTON, list);
            this.func_77655_b("doton");
            this.setRegistryName("doton");
            this.func_77637_a(TabModTab.tab);
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            float base = 2.0f;
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == EARTHWALL) {
                return this.getPower(stack, entity, timeLeft, base, 15.0f);
            }
            if (jutsu == SANDWICH) {
                return this.getPower(stack, entity, timeLeft, base, 150.0f);
            }
            if (jutsu == SWAMPPIT) {
                return this.getPower(stack, entity, timeLeft, 1.0f, 100.0f);
            }
            if (jutsu == SPEARS) {
                return this.getPower(stack, entity, timeLeft, 0.5f, 20.0f);
            }
            if (jutsu == GOLEM) {
                return this.getPower(stack, entity, timeLeft, 0.0f, 150.0f);
            }
            return base;
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            float f = super.getMaxPower(stack, entity);
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == EARTHWALL) {
                return Math.min(f, 50.0f);
            }
            if (jutsu == SANDWICH) {
                return Math.min(f, 20.0f);
            }
            if (jutsu == GOLEM) {
                return Math.min(f, 5.0f);
            }
            if (jutsu == SWAMPPIT) {
                return Math.min(f, 30.0f);
            }
            if (jutsu == SPEARS) {
                return Math.min(f, 100.0f);
            }
            return f;
        }

        @Override
        public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
            if (this.getCurrentJutsu(stack) != HIDINGINROCK) {
                super.onUsingTick(stack, player, count);
            }
        }
    }
}

