/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.Particles;
import net.narutomod.PlayerRender;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityBeamBase;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.procedure.ProcedureAirPunch;
import net.narutomod.procedure.ProcedureAoeCommand;
import net.narutomod.procedure.ProcedureOnLeftClickEmpty;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemEightGates
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:eightgates")
    public static final Item block = null;
    public static final int ENTITYID = 67;
    public static final int ENTITYID2 = 1067;
    public static final int ENTITYID3 = 1167;
    private static final ResourceLocation HIRUDORA_TEXTURE = new ResourceLocation("narutomod:textures/HirudoraTiger.png");
    private static final ResourceLocation SEKIZO_TEXTURE = new ResourceLocation("narutomod:textures/longcube_white.png");
    private static final ResourceLocation NGDRAGON_TEXTURE = new ResourceLocation("narutomod:textures/dragon_red.png");
    private static final int NGD_SUSPEND_TIME = 20;
    private static Random rng = new Random();

    public ItemEightGates(ElementsNarutomodMod instance) {
        super(instance, 282);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntitySekizo.class).id(new ResourceLocation("narutomod", "entitysekizo"), 67).name("entitysekizo").tracker(64, 1, true).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityNGDragon.class).id(new ResourceLocation("narutomod", "entityngdragon"), 1067).name("entityngdragon").tracker(96, 1, true).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityHirudora.class).id(new ResourceLocation("narutomod", "entityhirudora"), 1167).name("entityhirudora").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:eightgates", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntitySekizo.class, renderManager -> new RenderSekizo(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntityNGDragon.class, renderManager -> new RenderNGDragon(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntityHirudora.class, renderManager -> new RenderHirudora(renderManager));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new RangedItem.AttackHook());
        ProcedureOnLeftClickEmpty.addQualifiedItem(block, EnumHand.MAIN_HAND);
        ProcedureOnLeftClickEmpty.addQualifiedItem(block, EnumHand.OFF_HAND);
    }

    public static void logBattleXP(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() != block) {
            stack = player.func_184592_cb();
        }
        if (stack.func_77973_b() == block && ((RangedItem)ItemEightGates.block).getMaxOpenableGate(stack) < 1.0f) {
            ((RangedItem)ItemEightGates.block).addBattleXP(stack, 1);
        }
    }

    public static void addBattleXP(EntityPlayer player, int add) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() != block) {
            stack = player.func_184592_cb();
        }
        if (stack.func_77973_b() == block) {
            ((RangedItem)ItemEightGates.block).addBattleXP(stack, add);
        }
    }

    private static void closeGates(EntityLivingBase entity) {
        ItemStack stack = entity.func_184614_ca();
        if (stack.func_77973_b() != block) {
            stack = entity.func_184592_cb();
        }
        if (stack.func_77973_b() == block) {
            ((RangedItem)stack.func_77973_b()).closeGates(stack, entity);
        }
    }

    public static int getGatesOpened(EntityLivingBase entity) {
        ItemStack stack = entity.func_184614_ca();
        if (stack.func_77973_b() != block) {
            stack = entity.func_184592_cb();
        }
        if (stack.func_77973_b() == block) {
            return (int)((RangedItem)stack.func_77973_b()).getGateOpened(stack);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelWhiteTiger
    extends ModelBase {
        private final ModelRenderer head;
        private final ModelRenderer jaw;
        private final ModelRenderer leftear;
        private final ModelRenderer rightear;
        private final ModelRenderer eyes;

        public ModelWhiteTiger() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.head = new ModelRenderer((ModelBase)this);
            this.head.func_78793_a(0.0f, 0.0f, 0.0f);
            this.head.field_78804_l.add(new ModelBox(this.head, 0, 0, -4.0f, 8.0f, -8.0f, 8, 8, 16, 0.0f, false));
            this.head.field_78804_l.add(new ModelBox(this.head, 0, 24, -3.0f, 11.0f, -12.0f, 6, 3, 4, 0.0f, false));
            this.head.field_78804_l.add(new ModelBox(this.head, 0, 0, -1.0f, 10.75f, -12.25f, 2, 1, 1, 0.0f, false));
            this.jaw = new ModelRenderer((ModelBase)this);
            this.jaw.func_78793_a(0.0f, 14.0f, -8.0f);
            this.setRotationAngle(this.jaw, 0.6109f, 0.0f, 0.0f);
            this.head.func_78792_a(this.jaw);
            this.jaw.field_78804_l.add(new ModelBox(this.jaw, 20, 24, -3.0f, 0.0f, -4.0f, 6, 2, 4, 0.0f, false));
            this.leftear = new ModelRenderer((ModelBase)this);
            this.leftear.func_78793_a(4.0f, 9.0f, -6.0f);
            this.setRotationAngle(this.leftear, 0.0f, 0.5236f, 0.0f);
            this.head.func_78792_a(this.leftear);
            this.leftear.field_78804_l.add(new ModelBox(this.leftear, 38, 0, -1.0f, -2.0f, 0.0f, 1, 4, 4, 0.0f, false));
            this.rightear = new ModelRenderer((ModelBase)this);
            this.rightear.func_78793_a(-4.0f, 8.0f, -6.0f);
            this.setRotationAngle(this.rightear, 0.0f, -0.5236f, 0.0f);
            this.head.func_78792_a(this.rightear);
            this.rightear.field_78804_l.add(new ModelBox(this.rightear, 38, 0, 0.0f, -1.0f, 0.0f, 1, 4, 4, 0.0f, true));
            this.eyes = new ModelRenderer((ModelBase)this);
            this.eyes.func_78793_a(0.0f, 0.0f, 0.0f);
            this.eyes.field_78804_l.add(new ModelBox(this.eyes, 0, 33, -3.0f, 9.0f, -8.1f, 6, 2, 0, 0.0f, false));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.head.func_78785_a(f5);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            this.eyes.func_78785_a(f5);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179118_c();
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelNightguyDragon
    extends ModelBase {
        private final ModelRenderer head;
        private final ModelRenderer teethUpper;
        private final ModelRenderer bone;
        private final ModelRenderer bone2;
        private final ModelRenderer bone3;
        private final ModelRenderer jaw;
        private final ModelRenderer teethLower;
        private final ModelRenderer hornRight;
        private final ModelRenderer hornRight0;
        private final ModelRenderer hornRight1;
        private final ModelRenderer hornRight2;
        private final ModelRenderer hornRight3;
        private final ModelRenderer hornRight4;
        private final ModelRenderer hornLeft;
        private final ModelRenderer hornLeft0;
        private final ModelRenderer hornLeft1;
        private final ModelRenderer hornLeft2;
        private final ModelRenderer hornLeft3;
        private final ModelRenderer hornLeft4;
        private final ModelRenderer[] whiskerLeft = new ModelRenderer[6];
        private final ModelRenderer[] whiskerRight = new ModelRenderer[6];
        private final ModelRenderer spine;
        private final ModelRenderer spine2;
        private final ModelRenderer spine3;
        private final ModelRenderer spine4;
        private final ModelRenderer spine5;
        private final ModelRenderer spine6;
        private final ModelRenderer spine7;
        private final ModelRenderer spine8;
        private final ModelRenderer eyes;

        public ModelNightguyDragon() {
            this.field_78090_t = 256;
            this.field_78089_u = 256;
            this.head = new ModelRenderer((ModelBase)this);
            this.head.func_78793_a(0.0f, 0.0f, 0.0f);
            this.head.field_78804_l.add(new ModelBox(this.head, 176, 44, -6.0f, 6.0f, -26.0f, 12, 5, 16, 1.0f, false));
            this.head.field_78804_l.add(new ModelBox(this.head, 112, 30, -8.0f, -1.0f, -11.0f, 16, 16, 16, 1.0f, false));
            this.head.field_78804_l.add(new ModelBox(this.head, 112, 0, 2.0f, 4.0f, -28.0f, 4, 4, 6, 0.0f, true));
            this.head.field_78804_l.add(new ModelBox(this.head, 112, 0, -6.0f, 4.0f, -28.0f, 4, 4, 6, 0.0f, false));
            this.teethUpper = new ModelRenderer((ModelBase)this);
            this.teethUpper.func_78793_a(0.0f, 24.0f, 0.0f);
            this.head.func_78792_a(this.teethUpper);
            this.teethUpper.field_78804_l.add(new ModelBox(this.teethUpper, 152, 146, -6.0f, -12.0f, -26.0f, 12, 2, 16, 0.5f, false));
            this.bone = new ModelRenderer((ModelBase)this);
            this.bone.func_78793_a(9.0f, 7.0f, -11.0f);
            this.head.func_78792_a(this.bone);
            this.setRotationAngle(this.bone, 0.0f, -0.7854f, 0.0f);
            this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 200, 0.0f, -8.0f, 0.0f, 10, 16, 0, 0.0f, false));
            this.bone2 = new ModelRenderer((ModelBase)this);
            this.bone2.func_78793_a(-9.0f, 7.0f, -11.0f);
            this.head.func_78792_a(this.bone2);
            this.setRotationAngle(this.bone2, 0.0f, 0.7854f, 0.0f);
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 200, -10.0f, -8.0f, 0.0f, 10, 16, 0, 0.0f, true));
            this.bone3 = new ModelRenderer((ModelBase)this);
            this.bone3.func_78793_a(0.0f, -2.0f, -11.0f);
            this.head.func_78792_a(this.bone3);
            this.setRotationAngle(this.bone3, -0.8727f, 0.0f, 0.0f);
            this.bone3.field_78804_l.add(new ModelBox(this.bone3, 0, 50, -8.0f, -10.0f, 0.0f, 16, 10, 0, 0.0f, false));
            this.jaw = new ModelRenderer((ModelBase)this);
            this.jaw.func_78793_a(0.0f, 11.0f, -9.0f);
            this.head.func_78792_a(this.jaw);
            this.setRotationAngle(this.jaw, 0.5236f, 0.0f, 0.0f);
            this.jaw.field_78804_l.add(new ModelBox(this.jaw, 176, 65, -6.0f, 0.0f, -16.75f, 12, 4, 16, 1.0f, false));
            this.teethLower = new ModelRenderer((ModelBase)this);
            this.teethLower.func_78793_a(0.0f, 13.0f, 9.0f);
            this.jaw.func_78792_a(this.teethLower);
            this.teethLower.field_78804_l.add(new ModelBox(this.teethLower, 112, 144, -6.0f, -16.0f, -25.75f, 12, 2, 16, 0.5f, false));
            this.hornRight = new ModelRenderer((ModelBase)this);
            this.hornRight.func_78793_a(-6.0f, -2.0f, -13.0f);
            this.head.func_78792_a(this.hornRight);
            this.setRotationAngle(this.hornRight, 0.0873f, -0.5236f, 0.0f);
            this.hornRight.field_78804_l.add(new ModelBox(this.hornRight, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 1.0f, false));
            this.hornRight0 = new ModelRenderer((ModelBase)this);
            this.hornRight0.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornRight.func_78792_a(this.hornRight0);
            this.setRotationAngle(this.hornRight0, 0.0873f, 0.0873f, 0.0f);
            this.hornRight0.field_78804_l.add(new ModelBox(this.hornRight0, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.8f, false));
            this.hornRight1 = new ModelRenderer((ModelBase)this);
            this.hornRight1.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornRight0.func_78792_a(this.hornRight1);
            this.setRotationAngle(this.hornRight1, 0.0873f, 0.0873f, 0.0f);
            this.hornRight1.field_78804_l.add(new ModelBox(this.hornRight1, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.6f, false));
            this.hornRight2 = new ModelRenderer((ModelBase)this);
            this.hornRight2.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornRight1.func_78792_a(this.hornRight2);
            this.setRotationAngle(this.hornRight2, 0.0873f, 0.0873f, 0.0f);
            this.hornRight2.field_78804_l.add(new ModelBox(this.hornRight2, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.4f, false));
            this.hornRight3 = new ModelRenderer((ModelBase)this);
            this.hornRight3.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornRight2.func_78792_a(this.hornRight3);
            this.setRotationAngle(this.hornRight3, 0.0873f, 0.0873f, 0.0f);
            this.hornRight3.field_78804_l.add(new ModelBox(this.hornRight3, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.2f, false));
            this.hornRight4 = new ModelRenderer((ModelBase)this);
            this.hornRight4.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornRight3.func_78792_a(this.hornRight4);
            this.setRotationAngle(this.hornRight4, 0.0873f, 0.0873f, 0.0f);
            this.hornRight4.field_78804_l.add(new ModelBox(this.hornRight4, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.0f, false));
            this.hornLeft = new ModelRenderer((ModelBase)this);
            this.hornLeft.func_78793_a(6.0f, -2.0f, -13.0f);
            this.head.func_78792_a(this.hornLeft);
            this.setRotationAngle(this.hornLeft, 0.0873f, 0.5236f, 0.0f);
            this.hornLeft.field_78804_l.add(new ModelBox(this.hornLeft, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 1.0f, true));
            this.hornLeft0 = new ModelRenderer((ModelBase)this);
            this.hornLeft0.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornLeft.func_78792_a(this.hornLeft0);
            this.setRotationAngle(this.hornLeft0, 0.0873f, -0.0873f, 0.0f);
            this.hornLeft0.field_78804_l.add(new ModelBox(this.hornLeft0, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.8f, true));
            this.hornLeft1 = new ModelRenderer((ModelBase)this);
            this.hornLeft1.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornLeft0.func_78792_a(this.hornLeft1);
            this.setRotationAngle(this.hornLeft1, 0.0873f, -0.0873f, 0.0f);
            this.hornLeft1.field_78804_l.add(new ModelBox(this.hornLeft1, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.6f, true));
            this.hornLeft2 = new ModelRenderer((ModelBase)this);
            this.hornLeft2.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornLeft1.func_78792_a(this.hornLeft2);
            this.setRotationAngle(this.hornLeft2, 0.0873f, -0.0873f, 0.0f);
            this.hornLeft2.field_78804_l.add(new ModelBox(this.hornLeft2, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.4f, true));
            this.hornLeft3 = new ModelRenderer((ModelBase)this);
            this.hornLeft3.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornLeft2.func_78792_a(this.hornLeft3);
            this.setRotationAngle(this.hornLeft3, 0.0873f, -0.0873f, 0.0f);
            this.hornLeft3.field_78804_l.add(new ModelBox(this.hornLeft3, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.2f, true));
            this.hornLeft4 = new ModelRenderer((ModelBase)this);
            this.hornLeft4.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornLeft3.func_78792_a(this.hornLeft4);
            this.setRotationAngle(this.hornLeft4, 0.0873f, -0.0873f, 0.0f);
            this.hornLeft4.field_78804_l.add(new ModelBox(this.hornLeft4, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.0f, true));
            this.whiskerLeft[0] = new ModelRenderer((ModelBase)this);
            this.whiskerLeft[0].func_78793_a(6.0f, 6.0f, -24.0f);
            this.head.func_78792_a(this.whiskerLeft[0]);
            this.setRotationAngle(this.whiskerLeft[0], 0.0f, 1.0472f, 0.0f);
            this.whiskerLeft[0].field_78804_l.add(new ModelBox(this.whiskerLeft[0], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.8f, true));
            this.whiskerLeft[1] = new ModelRenderer((ModelBase)this);
            this.whiskerLeft[1].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerLeft[0].func_78792_a(this.whiskerLeft[1]);
            this.setRotationAngle(this.whiskerLeft[1], -0.0873f, -0.1745f, 0.0f);
            this.whiskerLeft[1].field_78804_l.add(new ModelBox(this.whiskerLeft[1], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.7f, true));
            this.whiskerLeft[2] = new ModelRenderer((ModelBase)this);
            this.whiskerLeft[2].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerLeft[1].func_78792_a(this.whiskerLeft[2]);
            this.setRotationAngle(this.whiskerLeft[2], -0.0873f, -0.1745f, 0.0f);
            this.whiskerLeft[2].field_78804_l.add(new ModelBox(this.whiskerLeft[2], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.6f, true));
            this.whiskerLeft[3] = new ModelRenderer((ModelBase)this);
            this.whiskerLeft[3].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerLeft[2].func_78792_a(this.whiskerLeft[3]);
            this.setRotationAngle(this.whiskerLeft[3], -0.0873f, -0.1745f, 0.0f);
            this.whiskerLeft[3].field_78804_l.add(new ModelBox(this.whiskerLeft[3], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.5f, true));
            this.whiskerLeft[4] = new ModelRenderer((ModelBase)this);
            this.whiskerLeft[4].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerLeft[3].func_78792_a(this.whiskerLeft[4]);
            this.setRotationAngle(this.whiskerLeft[4], -0.0873f, -0.1745f, 0.0f);
            this.whiskerLeft[4].field_78804_l.add(new ModelBox(this.whiskerLeft[4], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.4f, true));
            this.whiskerLeft[5] = new ModelRenderer((ModelBase)this);
            this.whiskerLeft[5].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerLeft[4].func_78792_a(this.whiskerLeft[5]);
            this.setRotationAngle(this.whiskerLeft[5], -0.0873f, -0.1745f, 0.0f);
            this.whiskerLeft[5].field_78804_l.add(new ModelBox(this.whiskerLeft[5], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.2f, true));
            this.whiskerRight[0] = new ModelRenderer((ModelBase)this);
            this.whiskerRight[0].func_78793_a(-6.0f, 6.0f, -24.0f);
            this.head.func_78792_a(this.whiskerRight[0]);
            this.setRotationAngle(this.whiskerRight[0], 0.0f, -1.0472f, 0.0f);
            this.whiskerRight[0].field_78804_l.add(new ModelBox(this.whiskerRight[0], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.8f, false));
            this.whiskerRight[1] = new ModelRenderer((ModelBase)this);
            this.whiskerRight[1].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerRight[0].func_78792_a(this.whiskerRight[1]);
            this.setRotationAngle(this.whiskerRight[1], -0.0873f, 0.1745f, 0.0f);
            this.whiskerRight[1].field_78804_l.add(new ModelBox(this.whiskerRight[1], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.7f, false));
            this.whiskerRight[2] = new ModelRenderer((ModelBase)this);
            this.whiskerRight[2].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerRight[1].func_78792_a(this.whiskerRight[2]);
            this.setRotationAngle(this.whiskerRight[2], -0.0873f, 0.1745f, 0.0f);
            this.whiskerRight[2].field_78804_l.add(new ModelBox(this.whiskerRight[2], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.6f, false));
            this.whiskerRight[3] = new ModelRenderer((ModelBase)this);
            this.whiskerRight[3].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerRight[2].func_78792_a(this.whiskerRight[3]);
            this.setRotationAngle(this.whiskerRight[3], -0.0873f, 0.1745f, 0.0f);
            this.whiskerRight[3].field_78804_l.add(new ModelBox(this.whiskerRight[3], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.5f, false));
            this.whiskerRight[4] = new ModelRenderer((ModelBase)this);
            this.whiskerRight[4].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerRight[3].func_78792_a(this.whiskerRight[4]);
            this.setRotationAngle(this.whiskerRight[4], -0.0873f, 0.1745f, 0.0f);
            this.whiskerRight[4].field_78804_l.add(new ModelBox(this.whiskerRight[4], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.4f, false));
            this.whiskerRight[5] = new ModelRenderer((ModelBase)this);
            this.whiskerRight[5].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerRight[4].func_78792_a(this.whiskerRight[5]);
            this.setRotationAngle(this.whiskerRight[5], -0.0873f, 0.1745f, 0.0f);
            this.whiskerRight[5].field_78804_l.add(new ModelBox(this.whiskerRight[5], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.2f, false));
            this.spine = new ModelRenderer((ModelBase)this);
            this.spine.func_78793_a(0.0f, 6.5f, 7.0f);
            this.setRotationAngle(this.spine, 0.0f, -0.7854f, 0.0f);
            this.spine.field_78804_l.add(new ModelBox(this.spine, 192, 104, -5.0f, -4.5f, 0.0f, 10, 10, 10, 2.0f, false));
            this.spine.field_78804_l.add(new ModelBox(this.spine, 48, 0, -1.0f, -10.5f, 2.0f, 2, 4, 6, 1.0f, false));
            this.spine2 = new ModelRenderer((ModelBase)this);
            this.spine2.func_78793_a(0.0f, 0.0f, 11.0f);
            this.spine.func_78792_a(this.spine2);
            this.setRotationAngle(this.spine2, 0.0f, 0.7854f, 0.0f);
            this.spine2.field_78804_l.add(new ModelBox(this.spine2, 192, 104, -5.0f, -4.5f, 0.0f, 10, 10, 10, 2.0f, false));
            this.spine2.field_78804_l.add(new ModelBox(this.spine2, 48, 0, -1.0f, -10.5f, 2.0f, 2, 4, 6, 1.0f, false));
            this.spine3 = new ModelRenderer((ModelBase)this);
            this.spine3.func_78793_a(0.0f, 0.0f, 11.0f);
            this.spine2.func_78792_a(this.spine3);
            this.setRotationAngle(this.spine3, 0.0f, 0.7854f, 0.0f);
            this.spine3.field_78804_l.add(new ModelBox(this.spine3, 192, 104, -5.0f, -4.5f, 0.0f, 10, 10, 10, 2.0f, false));
            this.spine3.field_78804_l.add(new ModelBox(this.spine3, 48, 0, -1.0f, -10.5f, 2.0f, 2, 4, 6, 1.0f, false));
            this.spine4 = new ModelRenderer((ModelBase)this);
            this.spine4.func_78793_a(0.0f, 0.0f, 11.0f);
            this.spine3.func_78792_a(this.spine4);
            this.setRotationAngle(this.spine4, 0.0f, 0.3927f, 0.0f);
            this.spine4.field_78804_l.add(new ModelBox(this.spine4, 192, 104, -5.0f, -4.5f, 0.0f, 10, 10, 10, 2.0f, false));
            this.spine4.field_78804_l.add(new ModelBox(this.spine4, 48, 0, -1.0f, -10.5f, 2.0f, 2, 4, 6, 1.0f, false));
            this.spine5 = new ModelRenderer((ModelBase)this);
            this.spine5.func_78793_a(0.0f, 0.0f, 11.0f);
            this.spine4.func_78792_a(this.spine5);
            this.setRotationAngle(this.spine5, 0.0f, -0.7854f, 0.0f);
            this.spine5.field_78804_l.add(new ModelBox(this.spine5, 192, 104, -5.0f, -4.5f, 0.0f, 10, 10, 10, 2.0f, false));
            this.spine5.field_78804_l.add(new ModelBox(this.spine5, 48, 0, -1.0f, -10.5f, 2.0f, 2, 4, 6, 1.0f, false));
            this.spine6 = new ModelRenderer((ModelBase)this);
            this.spine6.func_78793_a(0.0f, 0.0f, 11.0f);
            this.spine5.func_78792_a(this.spine6);
            this.setRotationAngle(this.spine6, 0.0f, -0.7854f, 0.0f);
            this.spine6.field_78804_l.add(new ModelBox(this.spine6, 192, 104, -5.0f, -4.5f, 0.0f, 10, 10, 10, 1.0f, false));
            this.spine6.field_78804_l.add(new ModelBox(this.spine6, 48, 0, -1.0f, -10.5f, 2.0f, 2, 4, 6, 0.5f, false));
            this.spine7 = new ModelRenderer((ModelBase)this);
            this.spine7.func_78793_a(0.0f, 0.0f, 11.0f);
            this.spine6.func_78792_a(this.spine7);
            this.setRotationAngle(this.spine7, 0.0f, -0.7854f, 0.0f);
            this.spine7.field_78804_l.add(new ModelBox(this.spine7, 192, 104, -5.0f, -4.5f, 0.0f, 10, 10, 10, 0.5f, false));
            this.spine7.field_78804_l.add(new ModelBox(this.spine7, 48, 0, -1.0f, -10.5f, 2.0f, 2, 4, 6, 0.25f, false));
            this.spine8 = new ModelRenderer((ModelBase)this);
            this.spine8.func_78793_a(0.0f, 0.0f, 11.0f);
            this.spine7.func_78792_a(this.spine8);
            this.setRotationAngle(this.spine8, 0.0f, 0.7854f, 0.0f);
            this.spine8.field_78804_l.add(new ModelBox(this.spine8, 192, 104, -5.0f, -4.5f, 0.0f, 10, 10, 10, 0.0f, false));
            this.spine8.field_78804_l.add(new ModelBox(this.spine8, 48, 0, -1.0f, -10.5f, 2.0f, 2, 4, 6, 0.0f, false));
            this.eyes = new ModelRenderer((ModelBase)this);
            this.eyes.func_78793_a(0.0f, 0.0f, 0.0f);
            this.eyes.field_78804_l.add(new ModelBox(this.eyes, 130, 50, -6.6f, 2.6f, -12.1f, 3, 2, 0, 0.0f, false));
            this.eyes.field_78804_l.add(new ModelBox(this.eyes, 130, 50, 3.6f, 2.6f, -12.1f, 3, 2, 0, 0.0f, true));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            this.head.func_78785_a(f5);
            this.spine.func_78785_a(f5);
            this.eyes.func_78785_a(f5);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179118_c();
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_78087_a(float limbSwing, float f1, float ageInTicks, float f3, float f4, float f5, Entity e) {
            super.func_78087_a(limbSwing, f1, ageInTicks, f3, f4, f5, e);
            for (int i = 2; i < 6; ++i) {
                this.whiskerLeft[i].field_78808_h = 0.0873f * ageInTicks;
                this.whiskerRight[i].field_78808_h = -0.0873f * ageInTicks;
            }
            if (((EntityNGDragon)e).getTicksAlive() > 20) {
                float f6 = MathHelper.func_76134_b((float)(limbSwing * 0.6662f));
                float f7 = MathHelper.func_76126_a((float)(limbSwing * 0.6662f));
                this.spine.field_78796_g = f6 * 0.1f * f1;
                this.spine2.field_78796_g = f6 * 0.1f * f1;
                this.spine3.field_78796_g = f7 * 0.1f * f1;
                this.spine4.field_78796_g = f7 * 0.1f * f1;
                this.spine5.field_78796_g = f6 * 0.1f * f1;
                this.spine6.field_78796_g = f6 * 0.1f * f1;
                this.spine7.field_78796_g = f7 * 0.1f * f1;
                this.spine8.field_78796_g = f7 * 0.1f * f1;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelLongCube
    extends EntityBeamBase.Model {
        private final ModelRenderer bone;
        private final ModelRenderer bb_main;
        protected float scale = 1.0f;

        public ModelLongCube(float length) {
            this.field_78090_t = 32;
            this.field_78089_u = 32;
            this.bone = new ModelRenderer((ModelBase)this);
            this.bone.func_78793_a(0.0f, 0.0f, 0.0f);
            int len = (int)(16.0f * length);
            this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 0, -0.5f, -16.0f, -0.5f, 1, len, 1, 0.0f, false));
            this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 0, -1.0f, -16.0f, -1.0f, 2, len, 2, 0.0f, false));
            this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 0, -1.5f, -16.0f, -1.5f, 3, len, 3, 0.0f, false));
            this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 0, -2.0f, -16.0f, -2.0f, 4, len, 4, 0.0f, false));
            this.bb_main = new ModelRenderer((ModelBase)this);
            this.bb_main.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bb_main.field_78804_l.add(new ModelBox(this.bb_main, 0, 0, -4.0f, -16.0f, -4.0f, 8, len, 8, 0.0f, false));
        }

        @Override
        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)((this.scale - 1.0f) * 1.5f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            this.bone.func_78785_a(f5);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            this.bb_main.func_78785_a(f5);
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderNGDragon
    extends Render<EntityNGDragon> {
        private final ModelNightguyDragon model;

        public RenderNGDragon(RenderManager renderManager) {
            super(renderManager);
            this.model = new ModelNightguyDragon();
            this.field_76989_e = 0.1f;
        }

        public void doRender(EntityNGDragon entity, double x, double y, double z, float yaw, float pt) {
            float f5 = entity.prevLimbSwingAmount + (entity.limbSwingAmount - entity.prevLimbSwingAmount) * pt;
            float f6 = entity.limbSwing - entity.limbSwingAmount * (1.0f - pt);
            this.model.func_78087_a(f6, f5, (float)entity.field_70173_aa + pt, 0.0f, 0.0f, 0.0625f, entity);
            this.func_180548_c(entity);
            GlStateManager.func_179094_E();
            float scale = entity.getEntityScale();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + scale), (float)((float)z));
            GlStateManager.func_179114_b((float)(-entity.field_70126_B - (entity.field_70177_z - entity.field_70126_B) * pt), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * pt - 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(EntityNGDragon entity) {
            return NGDRAGON_TEXTURE;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderSekizo
    extends EntityBeamBase.Renderer<EntitySekizo> {
        public RenderSekizo(RenderManager renderManager) {
            super(renderManager);
        }

        @Override
        public EntityBeamBase.Model getMainModel(EntitySekizo entity) {
            float length = MathHelper.func_76131_a((float)(entity.getBeamLength() * (float)entity.ticksAlive / 30.0f), (float)1.0f, (float)entity.getBeamLength());
            ModelLongCube model = new ModelLongCube(length);
            model.scale = 1.0f + length * 0.15f;
            return model;
        }

        @Override
        protected ResourceLocation getEntityTexture(EntitySekizo entity) {
            return SEKIZO_TEXTURE;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderHirudora
    extends Render<EntityHirudora> {
        private final ModelWhiteTiger model;

        public RenderHirudora(RenderManager renderManager) {
            super(renderManager);
            this.model = new ModelWhiteTiger();
            this.field_76989_e = 0.1f;
        }

        public void doRender(EntityHirudora entity, double x, double y, double z, float yaw, float pt) {
            float scale = entity.getEntityScale();
            this.func_180548_c(entity);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + scale), (float)((float)z));
            GlStateManager.func_179114_b((float)(-entity.field_70126_B - (entity.field_70177_z - entity.field_70126_B) * pt), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * pt - 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(EntityHirudora entity) {
            return HIRUDORA_TEXTURE;
        }
    }

    public static class EntityNGDragon
    extends EntityScalableProjectile.Base {
        private float fullScale = 6.0f;
        public float prevLimbSwingAmount;
        public float limbSwingAmount;
        public float limbSwing;

        public EntityNGDragon(World a) {
            super(a);
            this.setOGSize(1.0f, 1.0f);
        }

        public EntityNGDragon(EntityLivingBase shooter) {
            super(shooter);
            this.setOGSize(1.0f, 1.0f);
            this.setWaitPosition();
        }

        private void setWaitPosition() {
            this.func_70012_b(this.shootingEntity.field_70165_t, this.shootingEntity.field_70163_u, this.shootingEntity.field_70161_v, this.shootingEntity.field_70177_z, this.shootingEntity.field_70125_A);
        }

        public void func_174812_G() {
        }

        private void updateLimbSwing() {
            this.prevLimbSwingAmount = this.limbSwingAmount;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d9 = this.field_70163_u - this.field_70167_r;
            double d7 = this.field_70161_v - this.field_70166_s;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d9 * d9 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.limbSwingAmount += (f10 - this.limbSwingAmount) * 0.4f;
            this.limbSwing += this.limbSwingAmount;
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.shootingEntity != null) {
                this.shootingEntity.getEntityData().func_74780_a(NarutomodModVariables.InvulnerableTime, 40.0);
                if (this.ticksAlive <= 20) {
                    this.setWaitPosition();
                    this.setEntityScale(this.fullScale * MathHelper.func_76131_a((float)((float)this.ticksAlive / 20.0f), (float)(1.0f / this.fullScale), (float)1.0f));
                } else {
                    if (!this.isLaunched()) {
                        Vec3d vec = this.shootingEntity instanceof EntityLiving && ((EntityLiving)this.shootingEntity).func_70638_az() != null ? ((EntityLiving)this.shootingEntity).func_70638_az().func_174791_d().func_178788_d(this.func_174791_d()) : this.shootingEntity.func_70040_Z();
                        this.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.2f, 0.0f);
                        this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:dragon_roar")), 2.0f, 1.0f);
                    }
                    this.shootingEntity.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
            }
            this.updateLimbSwing();
            if (!(this.field_70170_p.field_72995_K || this.ticksInAir <= 30 && this.shootingEntity != null && this.shootingEntity.func_70089_S())) {
                this.func_70106_y();
            }
        }

        @Override
        public void renderParticles() {
            if (this.isLaunched()) {
                Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 200, (double)(this.field_70130_N / 2.0f), (double)(this.field_70131_O / 2.0f), (double)(this.field_70130_N / 2.0f), 0.0, 0.0, 0.0, -2139095040, 40, 0);
            } else {
                Particles.spawnParticle(this.field_70170_p, Particles.Types.FLAME, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 100, 0.0, 0.0, 0.0, (double)(this.field_70146_Z.nextFloat() - 0.5f) * 0.8, (double)((this.field_70146_Z.nextFloat() - 0.6f) * 1.0f), (double)(this.field_70146_Z.nextFloat() - 0.5f) * 0.8, 0x40FF0000, 60);
            }
        }

        @Override
        protected void onImpact(RayTraceResult result) {
            if (result.field_72308_g != null && result.field_72308_g.equals((Object)this.shootingEntity)) {
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.shootingEntity != null) {
                    float f = (float)ProcedureUtils.getModifiedAttackDamage(this.shootingEntity);
                    DamageSource ds = DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.shootingEntity).func_76348_h().func_151518_m();
                    if (result.field_72308_g instanceof EntityLivingBase) {
                        result.field_72308_g.func_70097_a(ds, f * 64.0f);
                        ProcedureUtils.pushEntity(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), result.field_72308_g, 30.0, 2.0f);
                    }
                    ProcedureAoeCommand.set(this, 0.0, 5.0).exclude((Entity)this.shootingEntity).damageEntities(ds, f * 16.0f);
                }
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 10.0f, false, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shootingEntity));
                if (EntityScalableProjectile.forwardsRaycastBlocks(this) != null) {
                    this.func_70106_y();
                }
            }
            this.field_70159_w *= (double)0.4f;
            this.field_70181_x *= (double)0.4f;
            this.field_70179_y *= (double)0.4f;
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K && this.shootingEntity != null) {
                ItemEightGates.closeGates(this.shootingEntity);
            }
        }

        @Override
        protected void checkOnGround() {
        }

        public float func_180428_a(Explosion explosionIn, World worldIn, BlockPos pos, IBlockState blockStateIn) {
            return Math.max(blockStateIn.func_177230_c().getExplosionResistance(worldIn, pos, (Entity)this, explosionIn) - 1999.0f, 0.1f);
        }
    }

    public static class EntityHirudora
    extends EntityScalableProjectile.Base {
        private float fullScale = 6.0f;
        private final float damageMultiplier = 3.0f;

        public EntityHirudora(World a) {
            super(a);
            this.setOGSize(1.0f, 0.5f);
        }

        public EntityHirudora(EntityLivingBase shooter) {
            super(shooter);
            this.setOGSize(1.0f, 0.5f);
            this.setWaitPosition();
        }

        private void setWaitPosition() {
            Vec3d vec = this.shootingEntity.func_174791_d().func_72441_c(0.0, 0.5, 0.0);
            float yaw = this.shootingEntity.field_70759_as;
            float pitch = this.shootingEntity.field_70125_A;
            if (this.shootingEntity instanceof EntityLiving && ((EntityLiving)this.shootingEntity).func_70638_az() != null) {
                ProcedureUtils.Vec2f vec1 = ProcedureUtils.getYawPitchFromVec(((EntityLiving)this.shootingEntity).func_70638_az().func_174791_d().func_178788_d(vec));
                yaw = vec1.x;
                pitch = vec1.y;
            }
            this.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, yaw, pitch);
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.shootingEntity != null) {
                if (this.ticksAlive <= 20) {
                    this.setWaitPosition();
                    this.setEntityScale(1.0f + (this.fullScale - 1.0f) * (float)this.ticksAlive / 20.0f);
                } else {
                    if (!this.isLaunched()) {
                        Vec3d vec = this.shootingEntity instanceof EntityLiving && ((EntityLiving)this.shootingEntity).func_70638_az() != null ? ((EntityLiving)this.shootingEntity).func_70638_az().func_174791_d().func_178788_d(this.func_174791_d()) : this.shootingEntity.func_70040_Z();
                        this.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.2f, 0.0f);
                    } else {
                        this.setEntityScale(this.getEntityScale() * 1.05f);
                    }
                    if (this.ticksInAir % 10 == 0) {
                        this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:roar")), 2.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.7f);
                    }
                }
            }
            if (!(this.field_70170_p.field_72995_K || this.ticksInAir <= 30 && this.shootingEntity != null && this.shootingEntity.func_70089_S())) {
                this.func_70106_y();
            }
        }

        @Override
        public void renderParticles() {
            for (int i = 0; i < 100; ++i) {
                Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O * 0.5f), this.field_70161_v, 1, 0.0, (double)(this.field_70131_O * 0.5f), 0.0, (this.field_70146_Z.nextDouble() - 0.5) * 1.5, (this.field_70146_Z.nextDouble() - 0.5) * 1.5, (this.field_70146_Z.nextDouble() - 0.5) * 1.5, 0x20FFFFFF, 30 + this.field_70146_Z.nextInt(20), 0);
            }
        }

        @Override
        protected void onImpact(RayTraceResult result) {
            if (result.field_72308_g != null && result.field_72308_g.equals((Object)this.shootingEntity)) {
                return;
            }
            if (result.field_72313_a == RayTraceResult.Type.BLOCK && this.ticksInAir <= 15) {
                return;
            }
            if (!this.field_70170_p.field_72995_K && this.shootingEntity != null) {
                ProcedureAoeCommand.set(this, 0.0, 0.5 * (double)this.getEntityScale()).exclude((Entity)this.shootingEntity).damageEntities(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.shootingEntity).func_76348_h(), (float)ProcedureUtils.getModifiedAttackDamage(this.shootingEntity) * this.damageMultiplier);
                this.shootingEntity.getEntityData().func_74780_a(NarutomodModVariables.InvulnerableTime, 40.0);
                this.field_70170_p.func_72885_a((Entity)this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, 70.0f, false, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shootingEntity));
                this.func_70106_y();
            }
        }

        @Override
        protected void checkOnGround() {
        }
    }

    public static class EntitySekizo
    extends EntityBeamBase.Base {
        private AirPunch airPunch = new AirPunch();
        private double range;
        public float damage;

        public EntitySekizo(World a) {
            super(a);
        }

        public EntitySekizo(EntityLivingBase shooter) {
            super(shooter);
        }

        public void shoot(double range, float dmg) {
            super.shoot(range);
            this.range = range;
            this.damage = dmg;
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.ticksAlive == 10 && !this.field_70170_p.field_72995_K) {
                this.airPunch.execute((EntityLivingBase)this.shootingEntity, this.range, 5.0);
            }
            if (this.ticksAlive > 60) {
                this.func_70106_y();
            }
        }

        protected class AirPunch
        extends ProcedureAirPunch {
            protected AirPunch() {
            }

            @Override
            protected void attackEntityFrom(EntityLivingBase player, Entity target) {
                super.attackEntityFrom(player, target);
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player).func_76348_h(), EntitySekizo.this.damage);
            }

            @Override
            protected float getBreakChance(BlockPos pos, EntityLivingBase player, double range) {
                this.blockDropChance = 0.2f;
                return 1.0f;
            }
        }
    }

    public static class RangedItem
    extends Item {
        private final UUID GATE_MODIFIER = UUID.fromString("f6944d0f-5c81-45db-9261-6a9ad9fe4840");
        private static final String GATE_KEY = "gateOpened";
        private static final String SEKIZO_KEY = "sekizoPunchCount";
        private static final String OWNER_KEY = "ownerUUID";
        private static final String XP_KEY = "battleExperience";
        private final Properties[] GATE = new Properties[]{new Properties(0, "", 0, 0, 0, 0, 0, 0, 0, 0.0f, false), new Properties(1, I18n.func_74838_a((String)"chattext.eightgates.gate1"), 220, 0, 0, 3, 2, 0, 10, -1.0f, false), new Properties(2, I18n.func_74838_a((String)"chattext.eightgates.gate2"), 240, 0, 0, 4, 16, 0, 40, -5.0f, false), new Properties(3, I18n.func_74838_a((String)"chattext.eightgates.gate3"), 280, 20, 0x10FFFFFF, 5, 32, 1, 60, -3.0f, false), new Properties(4, I18n.func_74838_a((String)"chattext.eightgates.gate4"), 360, 25, 0x18FFFFFF, 7, 64, 2, 60, 0.4f, false), new Properties(5, I18n.func_74838_a((String)"chattext.eightgates.gate5"), 520, 30, 0x20FFFFFF, 15, 68, 2, 60, 0.6f, false), new Properties(6, I18n.func_74838_a((String)"chattext.eightgates.gate6"), 840, 30, 0x3000FF00, 31, 72, 3, 60, 0.8f, false), new Properties(7, I18n.func_74838_a((String)"chattext.eightgates.gate7"), 1480, 30, 0x300000FF, 84, 76, 3, 60, 1.0f, false), new Properties(8, I18n.func_74838_a((String)"chattext.eightgates.gate8"), 2760, 30, 0x30FF0000, 349, 80, 4, 60, 1.2f, true)};
        private static int inc = 0;

        public RangedItem() {
            this.func_77656_e(0);
            this.func_77664_n();
            this.func_77655_b("eightgates");
            this.setRegistryName("eightgates");
            this.field_77777_bU = 1;
            this.func_77637_a(TabModTab.tab);
        }

        private int getUseCount(ItemStack stack, int timeLeft) {
            return this.func_77626_a(stack) - timeLeft;
        }

        public void func_77615_a(ItemStack itemstack, World world, EntityLivingBase entityLivingBase, int timeLeft) {
            if (!world.field_72995_K && entityLivingBase instanceof EntityPlayer && !entityLivingBase.func_70093_af()) {
                EntityPlayer entity = (EntityPlayer)entityLivingBase;
                switch ((int)this.getGateOpened(itemstack)) {
                    case 8: {
                        EntityNGDragon bullet = new EntityNGDragon((EntityLivingBase)entity);
                        world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:yagai")), SoundCategory.NEUTRAL, 2.0f, 1.0f);
                        world.func_72838_d((Entity)bullet);
                        if (!entity.func_184812_l_()) {
                            entity.func_184811_cZ().func_185145_a(itemstack.func_77973_b(), 200);
                        }
                        entity.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"entity.entityngdragon.name")), true);
                        break;
                    }
                    case 7: {
                        this.attackHirudora((EntityLivingBase)entity);
                        entity.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"entity.entityhirudora.name")), true);
                        if (entity.func_184812_l_()) break;
                        entity.func_184811_cZ().func_185145_a(itemstack.func_77973_b(), 400);
                    }
                }
            }
        }

        public void attackHirudora(EntityLivingBase attacker) {
            EntityHirudora bullet = new EntityHirudora(attacker);
            attacker.field_70170_p.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:hirudora")), SoundCategory.NEUTRAL, 2.0f, 1.0f);
            attacker.field_70170_p.func_72838_d((Entity)bullet);
        }

        private int getSekizoPunchNum(ItemStack stack, int tick) {
            int punch;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            int i = (punch = stack.func_77978_p().func_74762_e(SEKIZO_KEY)) >= 0 && punch < 4 ? punch + 1 : -1;
            stack.func_77978_p().func_74768_a(SEKIZO_KEY, i);
            return punch;
        }

        public int attackSekizo(ItemStack itemstack, EntityLivingBase attacker) {
            World world = attacker.field_70170_p;
            int punchnum = this.getSekizoPunchNum(itemstack, attacker.field_70173_aa);
            if (punchnum >= 0) {
                EntitySekizo bullet = new EntitySekizo(attacker);
                bullet.shoot(30.0, (float)ProcedureUtils.getModifiedAttackDamage(attacker) * 1.0f * (float)Math.pow(2.0, punchnum));
                world.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:sekizo")), SoundCategory.NEUTRAL, 2.0f, 1.0f);
                world.func_72838_d((Entity)bullet);
            }
            return punchnum;
        }

        public void attackAsakujaku(EntityLivingBase attacker) {
            Vec3d vec3d1 = attacker.func_70040_Z();
            this.attackAsakujaku(attacker, vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c);
        }

        public void attackAsakujaku(final EntityLivingBase attacker, double x, double y, double z) {
            World world = attacker.field_70170_p;
            Vec3d vec3d = attacker.func_174824_e(1.0f);
            for (int i = 0; i < 10; ++i) {
                EntitySmallFireball bullet = new EntitySmallFireball(world, attacker, x, y, z){

                    public void func_70071_h_() {
                        super.func_70071_h_();
                        if (this.field_70173_aa > 12) {
                            this.func_70106_y();
                        }
                    }

                    public void func_70227_a(RayTraceResult result) {
                        if (!this.field_70170_p.field_72995_K) {
                            if (result.field_72308_g != null) {
                                if (result.field_72308_g.equals((Object)this.field_70235_a) || result.field_72308_g instanceof EntitySmallFireball) {
                                    return;
                                }
                                result.field_72308_g.func_70097_a(DamageSource.func_76362_a((EntityFireball)this, (Entity)this.field_70235_a), (float)ProcedureUtils.getModifiedAttackDamage(attacker) * 0.5f);
                                result.field_72308_g.func_70015_d(10);
                            }
                            boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.field_70235_a);
                            this.field_70170_p.func_72885_a((Entity)this.field_70235_a, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, false, flag);
                            this.func_70106_y();
                        }
                    }

                    protected float func_82341_c() {
                        return 1.1f;
                    }
                };
                bullet.func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                world.func_72838_d((Entity)bullet);
            }
        }

        public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer attacker, Entity target) {
            if (!attacker.field_70170_p.field_72995_K) {
                int gateOpened = (int)this.getGateOpened(itemstack);
                switch (gateOpened) {
                    case 6: {
                        this.attackAsakujaku((EntityLivingBase)attacker);
                        attacker.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"entity.entityasakujaku.name")), true);
                        break;
                    }
                    case 8: {
                        int k = this.attackSekizo(itemstack, (EntityLivingBase)attacker);
                        if (k >= 0) {
                            attacker.func_146105_b((ITextComponent)new TextComponentString(I18n.func_74837_a((String)"entity.entitysekizo.name", (Object[])new Object[]{k + 1})), true);
                            break;
                        }
                    }
                    case 7: {
                        if (!attacker.equals((Object)target)) break;
                        target = ProcedureUtils.objectEntityLookingAt((Entity)attacker, (double)(15.0 + 5.0 * (double)(gateOpened - 7)), (double)2.0).field_72308_g;
                        if (target instanceof EntityLivingBase) {
                            Vec3d vec = target.func_174791_d().func_178788_d(attacker.func_174791_d()).func_72432_b();
                            attacker.field_70177_z = ProcedureUtils.getYawFromVec(vec);
                            attacker.field_70125_A = ProcedureUtils.getPitchFromVec(vec);
                            attacker.func_70634_a(target.field_70165_t - vec.field_72450_a, target.field_70163_u - vec.field_72448_b + 0.5, target.field_70161_v - vec.field_72449_c);
                            attacker.func_71059_n(target);
                            break;
                        }
                        return true;
                    }
                }
            }
            return super.onLeftClickEntity(itemstack, attacker, target);
        }

        private float getMaxOpenableGate(ItemStack stack) {
            int xp = this.getBattleXP(stack);
            for (int i = 8; i > 0; --i) {
                if (xp < this.GATE[i].xpRequired) continue;
                return i;
            }
            return 0.0f;
        }

        public float getGateOpened(ItemStack stack) {
            return stack.func_77942_o() ? stack.func_77978_p().func_74760_g(GATE_KEY) : 0.0f;
        }

        private void setGateOpened(ItemStack stack, EntityLivingBase entity, float gate) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            gate = MathHelper.func_76131_a((float)gate, (float)0.0f, (float)(entity instanceof EntityPlayer ? (((EntityPlayer)entity).func_184812_l_() ? 8.0f : this.getMaxOpenableGate(stack)) : 7.0f));
            stack.func_77978_p().func_74776_a(GATE_KEY, gate);
        }

        private void setBattleXp(ItemStack stack, int xp) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74768_a(XP_KEY, xp);
        }

        private void addBattleXP(ItemStack stack, int add) {
            this.setBattleXp(stack, this.getBattleXP(stack) + add);
        }

        private int getBattleXP(ItemStack stack) {
            return stack.func_77942_o() ? stack.func_77978_p().func_74762_e(XP_KEY) : 0;
        }

        public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
            if (player.func_70093_af()) {
                float increments = 0.05f;
                float gateOpened = this.getGateOpened(stack);
                if (gateOpened >= 4.0f) {
                    for (int i = 0; i < (int)gateOpened * 10; ++i) {
                        Particles.spawnParticle(player.field_70170_p, Particles.Types.SMOKE, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1, 1.0, 0.0, 1.0, (field_77697_d.nextDouble() - 0.5) * 2.0, 0.5, (field_77697_d.nextDouble() - 0.5) * 2.0, 0x10FFFFFF, 30, 0);
                    }
                    if (gateOpened < 4.0f + increments) {
                        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:opengate")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    }
                    if (gateOpened >= 8.0f - increments && gateOpened < 8.0f) {
                        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:eightgatesrelease")), SoundCategory.NEUTRAL, 2.0f, 1.0f);
                    }
                    if (gateOpened >= 4.0f + increments && player.field_70173_aa % 10 == 0) {
                        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:explosion")), SoundCategory.NEUTRAL, 0.1f, 0.9f - field_77697_d.nextFloat() * 0.3f);
                    }
                }
                if (player instanceof EntityPlayer) {
                    if (gateOpened >= 3.0f && PlayerRender.getColorMultiplier((EntityPlayer)player) == 0) {
                        PlayerRender.setColorMultiplier((EntityPlayer)player, -1330642944);
                    }
                    ((EntityPlayer)player).func_146105_b((ITextComponent)new TextComponentString(this.GATE[(int)gateOpened].name), true);
                }
                if (gateOpened < 8.0f) {
                    player.getEntityData().func_74780_a(NarutomodModVariables.InvulnerableTime, 4.0);
                }
                this.setGateOpened(stack, player, gateOpened + increments);
            }
        }

        public EntityLivingBase getOwner(ItemStack stack) {
            UUID id = ProcedureUtils.getOwnerId(stack);
            return id == null ? null : ProcedureUtils.searchLivingMatchingId(id);
        }

        protected void setOwner(ItemStack stack, EntityLivingBase owner) {
            ProcedureUtils.setOriginalOwner(owner, stack);
            stack.func_151001_c(stack.func_82833_r() + " (" + owner.func_70005_c_() + ")");
        }

        private boolean isOwner(ItemStack stack, EntityLivingBase entity) {
            if (ProcedureUtils.getOwnerId(stack) == null) {
                this.setOwner(stack, entity);
            }
            return ProcedureUtils.isOriginalOwner(entity, stack) || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_();
        }

        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase player = (EntityLivingBase)entity;
                if (!this.isOwner(itemstack, player)) {
                    return;
                }
                float gateOpened = this.getGateOpened(itemstack);
                if (player.func_184614_ca().equals(itemstack) || player.func_184592_cb().equals(itemstack)) {
                    this.GATE[(int)gateOpened].activate(player);
                    if (gateOpened >= 1.0f && gateOpened >= this.getMaxOpenableGate(itemstack) && entity.field_70173_aa % 40 == 8) {
                        this.addBattleXP(itemstack, 1);
                    }
                } else {
                    this.closeGates(itemstack, player);
                }
            }
        }

        private void closeGates(ItemStack itemstack, EntityLivingBase player) {
            float gateOpened = this.getGateOpened(itemstack);
            if (gateOpened > 0.0f) {
                this.setGateOpened(itemstack, player, 0.0f);
                this.GATE[(int)gateOpened].deActivate(player);
                itemstack.func_77978_p().func_82580_o(SEKIZO_KEY);
                if (player instanceof EntityPlayer && !((EntityPlayer)player).func_184812_l_()) {
                    ((EntityPlayer)player).func_184811_cZ().func_185145_a(itemstack.func_77973_b(), (int)gateOpened * 200);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String printAttributeModifiers(ItemStack stack) {
            ++inc;
            EntityLivingBase owner = this.getOwner(stack);
            if (owner == null) return "";
            IAttributeInstance iattributeinstance = owner.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (iattributeinstance == null) return inc + "-null";
            if (iattributeinstance.func_111122_c().isEmpty()) return inc + "-empty";
            Iterator iterator = iattributeinstance.func_111122_c().iterator();
            if (!iterator.hasNext()) return "";
            AttributeModifier attributemodifier = (AttributeModifier)iterator.next();
            return inc + "-" + attributemodifier.toString();
        }

        public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
            Multimap multimap = super.getAttributeModifiers(slot, stack);
            int gateOpened = (int)this.getGateOpened(stack);
            if ((slot == EntityEquipmentSlot.MAINHAND || slot == EntityEquipmentSlot.OFFHAND) && gateOpened > 0) {
                double health = this.GATE[gateOpened].health;
                multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(this.GATE_MODIFIER, "8gates.maxhealth", health, 0));
            }
            return multimap;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(I18n.func_74838_a((String)"tooltip.eightgates.opengates"));
            int max = (int)this.getMaxOpenableGate(itemstack);
            for (int i = 1; i <= 8; ++i) {
                list.add((i <= max ? TextFormatting.GRAY : TextFormatting.DARK_GRAY) + this.GATE[i].name + " " + TextFormatting.ITALIC + I18n.func_74837_a((String)"tooltip.eightgates.requiredxp", (Object[])new Object[]{this.GATE[i].xpRequired}) + TextFormatting.RESET);
            }
            list.add(TextFormatting.GREEN + I18n.func_74837_a((String)"tooltip.eightgates.currentxp", (Object[])new Object[]{this.getBattleXP(itemstack)}) + TextFormatting.WHITE);
        }

        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            ItemStack stack = entity.func_184586_b(hand);
            if (this.isOwner(stack, (EntityLivingBase)entity)) {
                entity.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }

        public EnumAction func_77661_b(ItemStack itemstack) {
            return EnumAction.BOW;
        }

        public int func_77626_a(ItemStack itemstack) {
            return 72000;
        }

        public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
            return false;
        }

        public static class AttackHook {
            @SubscribeEvent
            public void onLivingAttack(LivingAttackEvent event) {
                if (event.getSource().func_76346_g() instanceof EntityLivingBase && event.getSource().func_76346_g() == event.getSource().func_76364_f()) {
                    EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
                    int gateOpened = ItemEightGates.getGatesOpened(attacker);
                    EntityLivingBase target = event.getEntityLiving();
                    if (gateOpened >= 5) {
                        if (gateOpened >= 7) {
                            target.field_70170_p.func_184148_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.NEUTRAL, 1.0f, target.func_70681_au().nextFloat() * 0.5f + 0.5f);
                        }
                        Vec3d vec = attacker.func_174791_d().func_178788_d(target.func_174791_d()).func_72432_b();
                        int j = 25;
                        for (int i = 1; i <= j; ++i) {
                            Vec3d vec1 = vec.func_186678_a(0.06 * (double)i);
                            Particles.spawnParticle(attacker.field_70170_p, Particles.Types.SONIC_BOOM, target.field_70165_t, target.field_70163_u + 1.4, target.field_70161_v, 1, 0.0, 0.0, 0.0, vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, 0xFFFFFF | (int)((1.0f - (float)i / (float)j) * 64.0f) << 24, i * 2, (int)(5.0f * (1.0f + (float)i / (float)j * 0.5f)));
                        }
                    }
                    if (gateOpened >= 2) {
                        ProcedureUtils.pushEntity((Entity)attacker, (Entity)target, 10.0, 0.2f * (float)gateOpened + 2.0f);
                    }
                }
            }

            @SubscribeEvent
            public void onDeath(LivingDeathEvent event) {
                ItemEightGates.closeGates(event.getEntityLiving());
            }
        }
    }

    public static class Properties {
        final int gate;
        final String name;
        final int xpRequired;
        final int particles;
        final int particleColor;
        final int strength;
        final int speed;
        final int resistance;
        final int health;
        final float damage;
        final boolean canFly;

        protected Properties(int gt, String nm, int xp, int pt, int col, int str, int spd, int res, int hth, float dmg, boolean fly) {
            if (gt < 0 || gt > 8) {
                throw new IllegalArgumentException("Eight gates dude! Can't be negative or greater than 8.");
            }
            this.gate = gt;
            this.name = nm;
            this.xpRequired = xp;
            this.particles = pt;
            this.particleColor = col;
            this.strength = str;
            this.speed = spd;
            this.resistance = res;
            this.health = hth;
            this.damage = dmg;
            this.canFly = fly;
        }

        public void activate(EntityLivingBase entity) {
            if (this.gate >= 1 && this.gate <= 8 && !entity.field_70170_p.field_72995_K) {
                if (this.particles > 0) {
                    Particles.spawnParticle(entity.field_70170_p, Particles.Types.SMOKE, entity.field_70165_t, entity.field_70163_u + 0.8, entity.field_70161_v, this.particles, 0.2, 0.4, 0.2, 0.0, 0.1, 0.0, this.particleColor, 40, 5, 240, entity.func_145782_y());
                }
                entity.field_70143_R = 0.0f;
                entity.func_184589_d(MobEffects.field_76443_y);
                if (entity.field_70173_aa % 10 == 0) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 42, 3, false, false));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 12, 8, false, false));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 12, 3, false, false));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 12, this.strength, false, false));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 12, this.resistance, false, false));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 12, this.speed, false, false));
                    if (!(!(entity.func_110143_aJ() > 0.0f) || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_())) {
                        if (this.damage >= 0.0f) {
                            if (entity.field_70173_aa % 80 == 0) {
                                entity.field_70172_ad = 10;
                                entity.func_70097_a(ProcedureUtils.SPECIAL_DAMAGE, this.damage * 8.0f);
                            }
                        } else {
                            entity.func_70606_j(entity.func_110143_aJ() - this.damage);
                        }
                    }
                }
                if (this.canFly && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75101_c) {
                    ((EntityPlayer)entity).field_71075_bZ.field_75101_c = true;
                    ((EntityPlayer)entity).func_71016_p();
                }
            }
        }

        public void deActivate(EntityLivingBase entity) {
            if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
                PlayerRender.setColorMultiplier((EntityPlayer)entity, 0);
            }
            if (!(entity.field_70170_p.field_72995_K || this.gate <= 1 || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_())) {
                if (this.gate == 8) {
                    ProcedureUtils.setDeathAnimations(entity, 2, 200);
                }
                entity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 400, 2, false, false));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, this.gate * 600, (this.gate - 2) * 2));
                entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, this.gate * 600, this.gate - 2));
                if (this.canFly && entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    player.func_71016_p();
                }
            }
        }
    }
}

