/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.block.BlockAmaterasuBlock;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityUnrivaledStrength;
import net.narutomod.event.EventSetBlocks;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemKaton;
import net.narutomod.item.ItemSuiton;
import net.narutomod.potion.PotionCorrosion;
import net.narutomod.procedure.ProcedureAirPunch;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemFutton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:futton")
    public static final Item block = null;
    public static final int ENTITYID = 281;
    public static final ItemJutsu.JutsuEnum MIST = new ItemJutsu.JutsuEnum(0, "futton_mist", 'S', 50.0, (ItemJutsu.IJutsuCallback)new EntityBoilingMist.Jutsu());
    public static final ItemJutsu.JutsuEnum STRENGTH = new ItemJutsu.JutsuEnum(1, "unrivaled_strength", 'S', 100.0, (ItemJutsu.IJutsuCallback)new EntityUnrivaledStrength.EC.Jutsu());

    public ItemFutton(ElementsNarutomodMod instance) {
        super(instance, 600);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(MIST, STRENGTH));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityBoilingMist.class).id(new ResourceLocation("narutomod", "futton_mist"), 281).name("futton_mist").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:futton", "inventory"));
    }

    public static class EntityBoilingMist
    extends Entity {
        private final AirPunch airPunch = new AirPunch();
        private EntityLivingBase user;
        private float power;

        public EntityBoilingMist(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
        }

        public EntityBoilingMist(EntityLivingBase userIn, float powerIn) {
            this(userIn.field_70170_p);
            this.func_70105_a(0.01f, 0.01f);
            this.user = userIn;
            this.power = powerIn;
            this.func_70107_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v);
        }

        protected void func_70088_a() {
        }

        public void func_70071_h_() {
            if (this.user != null) {
                this.func_70107_b(this.user.field_70165_t, this.user.field_70163_u, this.user.field_70161_v);
                this.airPunch.execute(this.user, this.power, (double)this.power * 0.25);
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > (int)(this.power * this.power * 0.5f)) {
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                entity.field_70170_p.func_72838_d((Entity)new EntityBoilingMist(entity, power));
                return true;
            }
        }

        public class AirPunch
        extends ProcedureAirPunch {
            public AirPunch() {
                this.blockHardnessLimit = 1.0f;
                this.particlesDuring = null;
            }

            @Override
            protected void preExecuteParticles(EntityLivingBase player) {
                Vec3d vec0 = player.func_70040_Z();
                Vec3d vec = vec0.func_186678_a(2.0).func_72441_c(player.field_70165_t, player.field_70163_u + 1.5, player.field_70161_v);
                for (int i = 1; i <= 50; ++i) {
                    Vec3d vec1 = vec0.func_186678_a((EntityBoilingMist.this.field_70146_Z.nextDouble() * 0.8 + 0.2) * this.getRange(0) * 0.06);
                    Particles.spawnParticle(player.field_70170_p, Particles.Types.SMOKE, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1, 0.0, 0.0, 0.0, vec1.field_72450_a + (EntityBoilingMist.this.field_70146_Z.nextDouble() - 0.5) * this.getFarRadius(0) * 0.15, vec1.field_72448_b + (EntityBoilingMist.this.field_70146_Z.nextDouble() - 0.5) * this.getFarRadius(0) * 0.15, vec1.field_72449_c + (EntityBoilingMist.this.field_70146_Z.nextDouble() - 0.5) * this.getFarRadius(0) * 0.15, 0x20FFFFFF, 80 + EntityBoilingMist.this.field_70146_Z.nextInt(20), 0, 0, -1, 0);
                }
            }

            @Override
            protected void attackEntityFrom(EntityLivingBase player, Entity target) {
                if (target instanceof EntityLivingBase) {
                    target.func_184185_a(SoundEvents.field_187646_bt, 1.0f, this.rand.nextFloat() + 0.5f);
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(PotionCorrosion.potion, 200, 15));
                }
            }

            @Override
            protected EntityItem processAffectedBlock(EntityLivingBase player, BlockPos pos, EnumFacing facing) {
                if (ForgeEventFactory.getMobGriefingEvent((World)player.field_70170_p, (Entity)player)) {
                    Material mat = player.field_70170_p.func_180495_p(pos).func_185904_a();
                    if (mat == Material.field_151588_w || mat == Material.field_151598_x) {
                        player.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, this.rand.nextFloat() + 0.5f);
                        HashMap map = Maps.newHashMap();
                        map.put(pos, Blocks.field_150355_j.func_176223_P());
                        new EventSetBlocks(player.field_70170_p, map, 0L, 100, true, false);
                    } else if (mat == Material.field_151581_o && player.field_70170_p.func_180495_p(pos).func_177230_c() != BlockAmaterasuBlock.block) {
                        player.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, this.rand.nextFloat() + 0.5f);
                        player.field_70170_p.func_175698_g(pos);
                    }
                }
                return null;
            }

            @Override
            protected float getBreakChance(BlockPos pos, EntityLivingBase player, double range) {
                return 0.0f;
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.FUTTON, list);
            this.func_77655_b("futton");
            this.setRegistryName("futton");
            this.func_77637_a(TabModTab.tab);
            this.defaultCooldownMap[ItemFutton.MIST.index] = 0L;
            this.defaultCooldownMap[ItemFutton.STRENGTH.index] = 0L;
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == MIST) {
                return this.getPower(stack, entity, timeLeft, 0.1f, 30.0f);
            }
            return this.getPower(stack, entity, timeLeft, 1.0f, 100.0f);
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            float f = super.getMaxPower(stack, entity);
            if (jutsu == MIST) {
                return Math.min(f, 30.0f);
            }
            return Math.min(f, 20.0f);
        }

        @Override
        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            ItemStack stack = entity.func_184586_b(hand);
            if (entity.func_184812_l_() || ProcedureUtils.hasItemInInventory(entity, ItemKaton.block) && ProcedureUtils.hasItemInInventory(entity, ItemSuiton.block)) {
                return super.func_77659_a(world, entity, hand);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.futton.musthave") + TextFormatting.RESET);
        }
    }
}

