/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityIceDome;
import net.narutomod.entity.EntityIcePrison;
import net.narutomod.entity.EntityIceSpear;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntitySpike;
import net.narutomod.item.ItemFuton;
import net.narutomod.item.ItemIceSenbon;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemSuiton;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemHyoton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:hyoton")
    public static final Item block = null;
    public static final int ENTITYID = 219;
    public static final ItemJutsu.JutsuEnum KILLSPIKES = new ItemJutsu.JutsuEnum(0, "ice_spike", 'S', 150, 20.0, new EntityIceSpike.Jutsu());
    public static final ItemJutsu.JutsuEnum ICESPEARS = new ItemJutsu.JutsuEnum(1, "ice_spear", 'S', 150, 20.0, new EntityIceSpear.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum ICEDOME = new ItemJutsu.JutsuEnum(2, "ice_dome", 'S', 200, 100.0, new EntityIceDome.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum ICEPRISON = new ItemJutsu.JutsuEnum(3, "ice_prison", 'S', 150, 50.0, new EntityIcePrison.EC.Jutsu());

    public ItemHyoton(ElementsNarutomodMod instance) {
        super(instance, 531);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(KILLSPIKES, ICESPEARS, ICEDOME, ICEPRISON));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityIceSpike.class).id(new ResourceLocation("narutomod", "ice_spike"), 219).name("ice_spike").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:hyoton", "inventory"));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new RangedItem.DamageHook());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityIceSpike.class, renderManager -> new CustomRender(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class CustomRender
        extends EntitySpike.Renderer<EntityIceSpike> {
            private final ResourceLocation texture;

            public CustomRender(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.texture = new ResourceLocation("narutomod:textures/spike_ice.png");
            }

            @Override
            protected ResourceLocation getEntityTexture(EntityIceSpike entity) {
                return this.texture;
            }
        }
    }

    public static class EntityIceSpike
    extends EntitySpike.Base {
        private final int growTime = 10;
        private final float maxScale = 3.0f;
        private final float damage = 20.0f;
        private EntityLivingBase user;

        public EntityIceSpike(World worldIn) {
            super(worldIn);
            this.setColor(-1056964609);
            this.field_70178_ae = true;
        }

        public EntityIceSpike(EntityLivingBase userIn) {
            this(userIn.field_70170_p);
            this.user = userIn;
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.ticksAlive <= this.growTime) {
                float f = this.maxScale * (float)this.ticksAlive;
                ((Object)((Object)this)).getClass();
                this.setEntityScale(MathHelper.func_76131_a((float)(f / 10.0f), (float)0.0f, (float)this.maxScale));
                for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) {
                    if (entity.equals((Object)this.user)) continue;
                    entity.field_70172_ad = 10;
                    DamageSource damageSource = DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.user);
                    float f2 = this.ticksAlive - 1;
                    ((Object)((Object)this)).getClass();
                    entity.func_70097_a(damageSource, this.damage * (1.0f - f2 / 10.0f));
                }
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Vec3d vec3d2;
                World world = entity.field_70170_p;
                Vec3d vec3d = entity.func_174824_e(1.0f);
                RayTraceResult res = world.func_147447_a(vec3d, vec3d2 = vec3d.func_178787_e(entity.func_70040_Z().func_186678_a(30.0)), false, true, true);
                if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK && res.field_178784_b == EnumFacing.UP) {
                    world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:spiked")), SoundCategory.NEUTRAL, 5.0f, entity.func_70681_au().nextFloat() * 0.4f + 0.8f);
                    float f = MathHelper.func_76129_c((float)(power * 9.0f / 5.0f));
                    for (int i = 0; i < Math.round(power); ++i) {
                        EntityIceSpike entity1 = new EntityIceSpike(entity);
                        Vec3d vec = res.field_72307_f.func_72441_c((entity.func_70681_au().nextDouble() - 0.5) * (double)f, 0.0, (entity.func_70681_au().nextDouble() - 0.5) * (double)f);
                        while (!world.func_180495_p(new BlockPos(vec)).func_185896_q()) {
                            vec = vec.func_178786_a(0.0, 1.0, 0.0);
                        }
                        while (world.func_180495_p(new BlockPos(vec).func_177984_a()).func_185896_q()) {
                            vec = vec.func_72441_c(0.0, 1.0, 0.0);
                        }
                        entity1.func_70012_b(vec.field_72450_a, vec.field_72448_b + 0.5, vec.field_72449_c, entity.func_70681_au().nextFloat() * 360.0f, (entity.func_70681_au().nextFloat() - 0.5f) * 60.0f);
                        world.func_72838_d((Entity)entity1);
                    }
                    return true;
                }
                return false;
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.HYOTON, list);
            this.func_77655_b("hyoton");
            this.setRegistryName("hyoton");
            this.func_77637_a(TabModTab.tab);
            this.defaultCooldownMap[ItemHyoton.KILLSPIKES.index] = 0L;
            this.defaultCooldownMap[ItemHyoton.ICESPEARS.index] = 0L;
            this.defaultCooldownMap[ItemHyoton.ICEDOME.index] = 0L;
            this.defaultCooldownMap[ItemHyoton.ICEPRISON.index] = 0L;
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == KILLSPIKES) {
                return this.getPower(stack, entity, timeLeft, 1.0f, 10.0f);
            }
            if (jutsu == ICESPEARS) {
                return this.getPower(stack, entity, timeLeft, 1.0f, 40.0f);
            }
            return 1.0f;
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            float f = super.getMaxPower(stack, entity);
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == KILLSPIKES) {
                return Math.min(f, 300.0f);
            }
            if (jutsu == ICESPEARS) {
                return Math.min(f, 50.0f);
            }
            return f;
        }

        @Override
        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            if (entity.func_184812_l_() || ProcedureUtils.hasItemInInventory(entity, ItemFuton.block) && ProcedureUtils.hasItemInInventory(entity, ItemSuiton.block)) {
                return super.func_77659_a(world, entity, hand);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)entity.func_184586_b(hand));
        }

        private void setlastTickPos(Entity entity, BlockPos pos) {
            NBTTagCompound compound = entity.getEntityData().func_74775_l("lastTickBlockPos");
            if (compound == null) {
                compound = new NBTTagCompound();
            }
            compound.func_74768_a("X", pos.func_177958_n());
            compound.func_74768_a("Y", pos.func_177956_o());
            compound.func_74768_a("Z", pos.func_177952_p());
            entity.getEntityData().func_74782_a("lastTickBlockPos", (NBTBase)compound);
        }

        private BlockPos getLastTickPos(Entity entity) {
            NBTTagCompound compound = entity.getEntityData().func_74775_l("lastTickBlockPos");
            return compound != null ? new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z")) : BlockPos.field_177992_a;
        }

        @Override
        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                BlockPos pos = entity.func_180425_c();
                EntityLivingBase living = (EntityLivingBase)entity;
                living.func_70066_B();
                if (!pos.equals((Object)this.getLastTickPos(entity))) {
                    this.setlastTickPos(entity, pos);
                    EnchantmentFrostWalker.func_185266_a((EntityLivingBase)living, (World)world, (BlockPos)pos, (int)1);
                }
                if (living.field_70173_aa % 20 == 3) {
                    living.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 22, 3, false, false));
                    if (entity instanceof EntityPlayer && !ProcedureUtils.hasItemInInventory((EntityPlayer)entity, ItemIceSenbon.block)) {
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)entity), (ItemStack)new ItemStack(ItemIceSenbon.block));
                    }
                }
            }
        }

        @Override
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.hyoton.musthave") + TextFormatting.RESET);
        }

        public static class DamageHook {
            @SubscribeEvent
            public void onDamage(LivingAttackEvent event) {
                EntityLivingBase entity = event.getEntityLiving();
                DamageSource source = event.getSource();
                if (source == DamageSource.field_76368_d && entity.func_70055_a(Material.field_151588_w) && entity instanceof EntityPlayer && ProcedureUtils.hasItemInInventory((EntityPlayer)entity, block)) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

