/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.PlayerTracker;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityBijuManager;
import net.narutomod.entity.EntityEarthBlocks;
import net.narutomod.entity.EntityParticle;
import net.narutomod.entity.EntitySandBind;
import net.narutomod.entity.EntitySandBullet;
import net.narutomod.entity.EntitySandGathering;
import net.narutomod.entity.EntitySandLevitation;
import net.narutomod.entity.EntityShieldBase;
import net.narutomod.item.ItemDoton;
import net.narutomod.item.ItemFuton;
import net.narutomod.item.ItemGourd;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureOnLeftClickEmpty;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemJiton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:jiton")
    public static final Item block = null;
    public static final int ENTITYID = 201;
    public static final int ENTITYID_RANGED = 200;
    public static final ItemJutsu.JutsuEnum SANDSHIELD = new ItemJutsu.JutsuEnum(0, "entityjitonshield", 'S', 150, 20.0, new EntitySandShield.Jutsu());
    public static final ItemJutsu.JutsuEnum SANDBULLET = new ItemJutsu.JutsuEnum(1, "sand_bullet", 'S', 100, 20.0, new EntitySandBullet.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum SANDBIND = new ItemJutsu.JutsuEnum(2, "sand_bind", 'S', 200, 100.0, new EntitySandBind.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum SANDFLY = new ItemJutsu.JutsuEnum(3, "sand_levitation", 'S', 200, 0.25, new EntitySandLevitation.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum GATHERING = new ItemJutsu.JutsuEnum(4, "sand_gathering", 'S', 200, 100.0, new EntitySandGathering.EC.Jutsu());

    public ItemJiton(ElementsNarutomodMod instance) {
        super(instance, 518);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(SANDSHIELD, SANDBULLET, SANDBIND, SANDFLY, GATHERING));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntitySandShield.class).id(new ResourceLocation("narutomod", "entityjitonshield"), 201).name("entityjitonshield").tracker(64, 1, true).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(SandParticle.class).id(new ResourceLocation("narutomod", "jitonparticle"), 200).name("jitonparticle").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:jiton", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntitySandShield.class, renderManager -> new RenderCustom(renderManager));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ProcedureOnLeftClickEmpty.addQualifiedItem(block, EnumHand.MAIN_HAND);
    }

    public static void setSandType(ItemStack stack, Type type) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("MaterialType", type.getID());
    }

    public static Type getSandType(ItemStack stack) {
        return stack.func_77942_o() ? Type.getTypeFromId(stack.func_77978_p().func_74762_e("MaterialType")) : Type.IRON;
    }

    public static class SwarmTarget {
        private World world;
        private int total;
        private Vec3d startPos;
        private AxisAlignedBB startBB;
        private AxisAlignedBB targetBB;
        private float speed;
        private float inaccuracy;
        private List<Entity> particles;
        private int spawned;
        private int ticks;
        private Random rand;
        private boolean dieOnTargetReached;
        private Vec3d spawnMotion;
        private AxisAlignedBB border;
        private float scale;
        private int color;

        public SwarmTarget(World worldIn, int totalIn, Vec3d startPosIn, Vec3d targetPosIn) {
            this(worldIn, totalIn, startPosIn, targetPosIn, Vec3d.field_186680_a, 0.0f, 0.0f, false, 1.0f);
        }

        public SwarmTarget(World worldIn, int totalIn, Vec3d startPosIn, Vec3d targetPosIn, float speedIn, int colorIn) {
            this(worldIn, totalIn, startPosIn, targetPosIn, new Vec3d(0.05, 0.2, 0.05), speedIn, 0.02f, false, 1.0f, colorIn);
        }

        public SwarmTarget(World worldIn, int totalIn, Vec3d startPosIn, Vec3d targetPosIn, Vec3d initialMotion, float speedIn, float inaccuracyIn, boolean dieOnReached, float scaleIn) {
            this(worldIn, totalIn, startPosIn, targetPosIn, initialMotion, speedIn, inaccuracyIn, dieOnReached, scaleIn, Type.IRON.getColor());
        }

        public SwarmTarget(World worldIn, int totalIn, Vec3d startPosIn, Vec3d targetPos, Vec3d initialMotion, float speedIn, float inaccuracyIn, boolean dieOnReached, float scaleIn, int colorIn) {
            this.world = worldIn;
            this.total = totalIn;
            this.startPos = startPosIn;
            this.setTarget(targetPos, speedIn, inaccuracyIn, dieOnReached);
            this.particles = Lists.newArrayList();
            this.rand = new Random();
            this.spawnMotion = initialMotion;
            this.scale = scaleIn;
            this.color = colorIn;
            this.spawnNewParticles();
            this.border = this.particles.get(0).func_174813_aQ();
        }

        public SwarmTarget(World worldIn, int totalIn, Vec3d startPosIn, AxisAlignedBB targetBBIn, Vec3d initialMotion, float speedIn, float inaccuracyIn, boolean dieOnReached, float scaleIn, int colorIn) {
            this.world = worldIn;
            this.total = totalIn;
            this.startPos = startPosIn;
            this.setTarget(targetBBIn, speedIn, inaccuracyIn, dieOnReached);
            this.particles = Lists.newArrayList();
            this.rand = new Random();
            this.spawnMotion = initialMotion;
            this.scale = scaleIn;
            this.color = colorIn;
            this.spawnNewParticles();
            this.border = this.particles.get(0).func_174813_aQ();
        }

        public SwarmTarget(World worldIn, int totalIn, AxisAlignedBB startBBIn, Vec3d targetPos, Vec3d initialMotion, float speedIn, float inaccuracyIn, boolean dieOnReached, float scaleIn, int colorIn) {
            this.world = worldIn;
            this.total = totalIn;
            this.startBB = startBBIn;
            this.setTarget(targetPos, speedIn, inaccuracyIn, dieOnReached);
            this.particles = Lists.newArrayList();
            this.rand = new Random();
            this.spawnMotion = initialMotion;
            this.scale = scaleIn;
            this.color = colorIn;
            this.spawnNewParticles();
            this.border = this.particles.get(0).func_174813_aQ();
        }

        public SwarmTarget(World worldIn, int totalIn, AxisAlignedBB startBBIn, AxisAlignedBB targetBBIn, Vec3d initialMotion, float speedIn, float inaccuracyIn, boolean dieOnReached, float scaleIn, int colorIn) {
            this.world = worldIn;
            this.total = totalIn;
            this.startBB = startBBIn;
            this.setTarget(targetBBIn, speedIn, inaccuracyIn, dieOnReached);
            this.particles = Lists.newArrayList();
            this.rand = new Random();
            this.spawnMotion = initialMotion;
            this.scale = scaleIn;
            this.color = colorIn;
            this.spawnNewParticles();
            this.border = this.particles.get(0).func_174813_aQ();
        }

        protected Entity createParticle(double x, double y, double z, double mx, double my, double mz, int c, float sc, int life) {
            return new SandParticle(this.world, x, y, z, mx, my, mz, c, sc, life);
        }

        private void spawnNewParticles() {
            int i = 0;
            while (this.spawned < this.total && i < 5) {
                Vec3d vec = this.startPos != null ? this.startPos : this.randomPosInBB(this.startBB);
                Entity p = this.createParticle(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, (this.rand.nextDouble() - 0.5) * 2.0 * this.spawnMotion.field_72450_a, this.spawnMotion.field_72448_b, (this.rand.nextDouble() - 0.5) * 2.0 * this.spawnMotion.field_72449_c, this.color, this.scale + (this.rand.nextFloat() - 0.5f) * this.scale * 0.2f, 3600);
                this.world.func_72838_d(p);
                this.particles.add(p);
                ++i;
                ++this.spawned;
            }
        }

        public AxisAlignedBB getBorders() {
            return this.border;
        }

        private void updateBorderWith(Entity particle) {
            AxisAlignedBB bb = particle.func_174813_aQ();
            double minX = bb.field_72340_a < this.border.field_72340_a ? bb.field_72340_a : this.border.field_72340_a;
            double minY = bb.field_72338_b < this.border.field_72338_b ? bb.field_72338_b : this.border.field_72338_b;
            double minZ = bb.field_72339_c < this.border.field_72339_c ? bb.field_72339_c : this.border.field_72339_c;
            double maxX = bb.field_72336_d > this.border.field_72336_d ? bb.field_72336_d : this.border.field_72336_d;
            double maxY = bb.field_72337_e > this.border.field_72337_e ? bb.field_72337_e : this.border.field_72337_e;
            double maxZ = bb.field_72334_f > this.border.field_72334_f ? bb.field_72334_f : this.border.field_72334_f;
            this.border = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        }

        public boolean allParticlesReachedTarget() {
            return this.targetBB.func_72318_a(ProcedureUtils.BB.getCenter(this.border));
        }

        public boolean allParticlesSpawned() {
            return this.spawned >= this.total;
        }

        protected void playFlyingSound(double x, double y, double z, float volume, float pitch) {
            this.world.func_184148_a(null, x, y, z, SoundEvents.field_187753_eE, SoundCategory.BLOCKS, volume, pitch);
        }

        public void onUpdate() {
            if (!this.particles.isEmpty()) {
                Entity ep = this.particles.get(0);
                this.playFlyingSound(ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, (float)this.particles.size() * this.speed * 0.0025f, this.rand.nextFloat() * 0.4f + 0.8f);
                this.border = ep.func_174813_aQ();
                Iterator<Entity> iter = this.particles.iterator();
                while (iter.hasNext()) {
                    ep = iter.next();
                    if (ep.func_70089_S()) {
                        Vec3d vec = this.getTargetPos().func_178788_d(ep.func_174791_d());
                        if (this.dieOnTargetReached && vec.func_72433_c() < 0.1 + (double)this.inaccuracy) {
                            ep.func_70106_y();
                            continue;
                        }
                        vec = vec.func_72432_b().func_186678_a((double)this.speed * 0.1);
                        ep.field_70159_w += vec.field_72450_a + this.rand.nextGaussian() * (double)this.inaccuracy;
                        ep.field_70181_x += vec.field_72448_b + this.rand.nextGaussian() * (double)this.inaccuracy;
                        ep.field_70179_y += vec.field_72449_c + this.rand.nextGaussian() * (double)this.inaccuracy;
                        this.updateBorderWith(ep);
                        continue;
                    }
                    iter.remove();
                }
                this.spawnNewParticles();
            }
            ++this.ticks;
        }

        public boolean shouldRemove() {
            return this.particles.isEmpty();
        }

        public void forceRemove() {
            Iterator<Entity> iter = this.particles.iterator();
            while (iter.hasNext()) {
                Entity ep = iter.next();
                if (ep.func_70089_S()) {
                    ep.func_70106_y();
                }
                iter.remove();
            }
        }

        public void setSpeed(float speedIn, float inaccuracyIn) {
            this.speed = speedIn;
            this.inaccuracy = inaccuracyIn;
        }

        public void setTarget(Vec3d newTarget, boolean dieOnReached) {
            this.setTarget(this.convert2AABB(newTarget, this.inaccuracy), dieOnReached);
        }

        public void setTarget(AxisAlignedBB newTargetBB, boolean dieOnReached) {
            this.targetBB = newTargetBB;
            this.dieOnTargetReached = dieOnReached;
        }

        public void setTarget(Vec3d newTargetPos, float speedIn, float inaccuracyIn, boolean dieOnReached) {
            this.setTarget(this.convert2AABB(newTargetPos, inaccuracyIn), speedIn, inaccuracyIn, dieOnReached);
        }

        public void setTarget(AxisAlignedBB newTargetBB, float speedIn, float inaccuracyIn, boolean dieOnReached) {
            this.setTarget(newTargetBB, dieOnReached);
            this.setSpeed(speedIn, inaccuracyIn);
        }

        private AxisAlignedBB convert2AABB(Vec3d vec, float width) {
            return new AxisAlignedBB(vec.field_72450_a - (double)(width * 0.5f), vec.field_72448_b - (double)(width * 0.5f), vec.field_72449_c - (double)(width * 0.5f), vec.field_72450_a + (double)(width * 0.5f), vec.field_72448_b + (double)(width * 0.5f), vec.field_72449_c + (double)(width * 0.5f));
        }

        public int getTicks() {
            return this.ticks;
        }

        public Vec3d getTargetPos() {
            return this.randomPosOnBB(this.targetBB);
        }

        private Vec3d randomPosInBB(AxisAlignedBB aabb) {
            return new Vec3d(aabb.field_72340_a + this.rand.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a), aabb.field_72338_b + this.rand.nextDouble() * (aabb.field_72337_e - aabb.field_72338_b), aabb.field_72339_c + this.rand.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c));
        }

        private Vec3d randomPosOnBB(AxisAlignedBB aabb) {
            Vec3d vec0 = this.randomPosInBB(aabb);
            Vec3d[] vec1 = new Vec3d[]{new Vec3d(aabb.field_72340_a, vec0.field_72448_b, vec0.field_72449_c), new Vec3d(aabb.field_72336_d, vec0.field_72448_b, vec0.field_72449_c), new Vec3d(vec0.field_72450_a, aabb.field_72338_b, vec0.field_72449_c), new Vec3d(vec0.field_72450_a, aabb.field_72337_e, vec0.field_72449_c), new Vec3d(vec0.field_72450_a, vec0.field_72448_b, aabb.field_72339_c), new Vec3d(vec0.field_72450_a, vec0.field_72448_b, aabb.field_72334_f)};
            return vec1[this.rand.nextInt(6)];
        }
    }

    public static class SandParticle
    extends EntityParticle.Base {
        private int idleTime;
        private int deathTicks;

        public SandParticle(World w) {
            super(w);
        }

        public SandParticle(World worldIn, double x, double y, double z, double mX, double mY, double mZ, int color, float scale, int maxAgeIn) {
            super(worldIn, x, y, z, mX, mY, mZ, color, scale, maxAgeIn);
        }

        @Override
        public void onDeath() {
            if (++this.deathTicks >= 20 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            this.field_70181_x -= 0.05;
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            double d = this.getVelocity();
            int n = this.idleTime = d < 0.001 ? this.idleTime + 1 : 0;
            if (this.field_70170_p.field_72995_K) {
                this.setParticleTextureOffset(this.texU + (d > 0.01 ? 1 : 0) % 8);
                for (int i = 0; i < 10; ++i) {
                    Particles.spawnParticle(this.field_70170_p, Particles.Types.SAND, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 1, 0.0, 0.0, 0.0, this.field_70159_w * (this.field_70146_Z.nextDouble() * 0.2 + 0.9), this.field_70181_x * (this.field_70146_Z.nextDouble() * 0.2 + 0.9), this.field_70179_y * (this.field_70146_Z.nextDouble() * 0.2 + 0.9), this.getColorInt(), (int)(this.getScale(0.0f) * 8.0f), 5);
                }
            } else if (this.idleTime > 1000) {
                this.setAge(this.getMaxAge());
            }
        }

        @Override
        public float getScale(float partialTicks) {
            return MathHelper.func_76131_a((float)(((float)this.getAge() + partialTicks) / 10.0f), (float)0.2f, (float)1.0f) * this.getScale();
        }
    }

    public static class EntitySandShield
    extends EntityShieldBase {
        private final double chakraUsage = 0.5;
        private List<SwarmTarget> sandTargets = Lists.newArrayList();
        private int color;

        public EntitySandShield(World a) {
            super(a);
            this.func_70105_a(3.0f, 3.0f);
        }

        public EntitySandShield(EntityLivingBase user, Type sandType) {
            super(user);
            this.func_70105_a(3.0f, 3.0f);
            double d = user instanceof EntityPlayer ? 2.5 * PlayerTracker.getNinjaLevel((EntityPlayer)user) : 100.0;
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(d);
            this.func_70606_j(this.func_110138_aP());
            this.color = sandType.getColor();
        }

        public void func_70106_y() {
            if (!this.sandTargets.isEmpty()) {
                this.func_70606_j(0.0f);
            } else {
                super.func_70106_y();
            }
        }

        @Override
        protected void func_70609_aI() {
            if (!this.sandTargets.isEmpty()) {
                Iterator<SwarmTarget> iter = this.sandTargets.iterator();
                while (iter.hasNext()) {
                    SwarmTarget st = iter.next();
                    if (!st.shouldRemove()) {
                        st.setTarget(this.getGourdMouthPos(), 0.6f, 0.02f, true);
                        st.onUpdate();
                        continue;
                    }
                    iter.remove();
                }
            } else {
                this.func_70106_y();
            }
        }

        @Override
        public void func_70645_a(DamageSource cause) {
            if (!this.field_70729_aU) {
                ItemStack stack;
                this.func_70105_a(0.1f, 0.1f);
                this.func_184226_ay();
                EntityLivingBase summoner = this.getSummoner();
                if (!this.field_70170_p.field_72995_K && summoner instanceof EntityPlayer && (stack = ProcedureUtils.getMatchingItemStack((EntityPlayer)summoner, block)) != null) {
                    ((RangedItem)stack.func_77973_b()).setJutsuCooldown(stack, SANDSHIELD, (long)(2400.0f * ((RangedItem)stack.func_77973_b()).getModifier(stack, summoner)));
                }
            }
            super.func_70645_a(cause);
        }

        @Override
        public boolean func_70097_a(DamageSource source, float amount) {
            if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() > 0.0f && source.func_76364_f() != null) {
                Entity entity = source.func_76364_f();
                this.moveSand(this.getTargetPosition(entity), this.getTargetPosition(entity), 2);
                if (entity instanceof EntityLivingBase) {
                    ProcedureUtils.pushEntity((Entity)this.getSummoner(), entity, 5.0, 1.5f);
                }
            }
            return super.func_70097_a(source, amount);
        }

        private void moveSand(Vec3d from, Vec3d to, int count) {
            if (!this.field_70170_p.field_72995_K) {
                this.sandTargets.add(new SwarmTarget(this.field_70170_p, count, from, to, 0.95f, this.color));
            }
        }

        private Vec3d getGourdMouthPos() {
            EntityLivingBase summoner = this.getSummoner();
            if (summoner != null) {
                return ItemGourd.getMouthPos(summoner);
            }
            return this.func_174791_d();
        }

        private Vec3d getTargetPosition(Entity target) {
            return target.func_174791_d().func_72441_c(0.0, (double)(target.field_70131_O / 2.0f), 0.0);
        }

        private void updateTargets() {
            Iterator<SwarmTarget> iter = this.sandTargets.iterator();
            while (iter.hasNext()) {
                SwarmTarget st = iter.next();
                if (st.shouldRemove()) {
                    iter.remove();
                    continue;
                }
                if (st.getTicks() == 20) {
                    st.setTarget(this.getGourdMouthPos(), 0.6f, 0.02f, true);
                }
                st.onUpdate();
            }
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K) {
                this.updateTargets();
                EntityLivingBase summoner = this.getSummoner();
                if (summoner == null || this.func_110143_aJ() > 0.0f && !Chakra.pathway(summoner).consume(this.chakraUsage)) {
                    this.func_70106_y();
                }
            }
        }

        protected void func_82167_n(Entity entity) {
            if (!this.field_70170_p.field_72995_K && !this.func_184223_x(entity) && ProcedureUtils.getVelocity(entity) > 0.22) {
                EntityEarthBlocks.BlocksMoveHelper.collideWithEntity((Entity)this, entity);
                this.moveSand(this.getTargetPosition(entity), this.getTargetPosition(entity), 100);
            }
            super.func_82167_n(entity);
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ID_KEY = "JitonSandShieldEntityIdKey";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Object entity1 = entity.field_70170_p.func_73045_a(entity.getEntityData().func_74762_e(ID_KEY));
                if (!(entity1 instanceof EntitySandShield)) {
                    entity1 = new EntitySandShield(entity, ItemJiton.getSandType(stack));
                    entity.field_70170_p.func_72838_d(entity1);
                    entity.getEntityData().func_74768_a(ID_KEY, entity1.func_145782_y());
                    return true;
                }
                return false;
            }
        }
    }

    public static enum Type {
        IRON(0, -13619152),
        SAND(1, -2568035),
        GOLD(2, -1448);

        private int id;
        private int color;
        private static final Map<Integer, Type> TYPES;

        private Type(int i, int col) {
            this.id = i;
            this.color = col;
        }

        public int getID() {
            return this.id;
        }

        public int getColor() {
            return this.color;
        }

        public static Type getTypeFromId(int i) {
            return i >= 0 && i <= 2 ? TYPES.get(i) : IRON;
        }

        static {
            TYPES = Maps.newHashMap();
            for (Type type : Type.values()) {
                TYPES.put(type.getID(), type);
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.JITON, list);
            this.func_77655_b("jiton");
            this.setRegistryName("jiton");
            this.func_77637_a(TabModTab.tab);
            this.defaultCooldownMap[ItemJiton.SANDSHIELD.index] = 0L;
            this.defaultCooldownMap[ItemJiton.SANDBULLET.index] = 0L;
            this.defaultCooldownMap[ItemJiton.SANDBIND.index] = 0L;
            this.defaultCooldownMap[ItemJiton.SANDFLY.index] = 0L;
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            if (this.getCurrentJutsu(stack) == SANDBULLET) {
                return this.getPower(stack, entity, timeLeft, 0.0f, 50.0f);
            }
            return 1.0f;
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            float f = super.getMaxPower(stack, entity);
            if (jutsu == SANDBULLET) {
                return Math.min(f, 5.0f);
            }
            return f;
        }

        @Override
        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            if ((entity.func_184812_l_() || ProcedureUtils.hasItemInInventory(entity, ItemFuton.block) && ProcedureUtils.hasItemInInventory(entity, ItemDoton.block)) && (entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == ItemGourd.body || EntityBijuManager.getTails(entity) == 1 && EntityBijuManager.cloakLevel(entity) > 0)) {
                return super.func_77659_a(world, entity, hand);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)entity.func_184586_b(hand));
        }

        @Override
        public void onUsingTick(ItemStack stack, EntityLivingBase player, int timeLeft) {
            super.onUsingTick(stack, player, timeLeft);
            if (!player.field_70170_p.field_72995_K && this.getCurrentJutsu(stack) == SANDBULLET && this.getPower(stack, player, timeLeft) < this.getMaxPower(stack, player)) {
                EntitySandBullet.addPos(stack, player, this.getPower(stack, player, timeLeft));
            }
        }

        @Override
        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (!world.field_72995_K && entity instanceof EntityPlayer && entity.field_70173_aa > 100) {
                EntityPlayer player = (EntityPlayer)entity;
                if (!ProcedureUtils.hasItemInInventory(player, ItemGourd.body)) {
                    if (!player.func_184811_cZ().func_185141_a(block)) {
                        player.func_184811_cZ().func_185145_a(block, (int)this.getModifiedCD(2400.0, player));
                    } else if (player.func_184811_cZ().func_185143_a(block, 1.0f) <= 0.1f) {
                        ItemStack stack = new ItemStack(ItemGourd.body);
                        ItemGourd.setMaterial(stack, ItemJiton.getSandType(itemstack));
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
                    }
                }
                if ((player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == ItemGourd.body || EntityBijuManager.getTails(player) == 1 && EntityBijuManager.cloakLevel(player) > 0) && this.getCurrentJutsu(itemstack) == SANDBULLET) {
                    EntitySandBullet.updateSwarms(itemstack);
                }
                this.enableJutsu(itemstack, GATHERING, ItemJiton.getSandType(itemstack) == Type.IRON);
            }
        }

        private double getModifiedCD(double cd, EntityPlayer player) {
            return cd * Chakra.getChakraModifier((EntityLivingBase)player);
        }

        public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer attacker, Entity target) {
            if (attacker.equals((Object)target)) {
                return !EntitySandBind.sandFuneral((EntityLivingBase)attacker);
            }
            return super.onLeftClickEntity(itemstack, attacker, target);
        }

        @Override
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.jiton.musthave") + TextFormatting.RESET);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCustom
    extends Render<EntitySandShield> {
        public RenderCustom(RenderManager renderManagerIn) {
            super(renderManagerIn);
        }

        public void doRender(EntitySandShield bullet, double d, double d1, double d2, float f, float f1) {
        }

        protected ResourceLocation getEntityTexture(EntitySandShield entity) {
            return null;
        }
    }
}

