/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.PlayerTracker;
import net.narutomod.procedure.ProcedureOnLivingUpdate;
import net.narutomod.procedure.ProcedureUpdateworldtick;

@ElementsNarutomodMod.ModElement.Tag
public class ItemJutsu
extends ElementsNarutomodMod.ModElement {
    public static final String NINJUTSU_TYPE = "ninjutsu_damage";
    public static final String SENJUTSU_TYPE = "senjutsu_damage";
    public static final DamageSource NINJUTSU_DAMAGE = new DamageSource("ninjutsu_damage");
    public static final DamageSource SENJUTSU_DAMAGE = new DamageSource("senjutsu_damage");

    public ItemJutsu(ElementsNarutomodMod instance) {
        super(instance, 369);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new Base.EquipmentHook());
    }

    public static DamageSource causeJutsuDamage(Entity source, @Nullable EntityLivingBase indirectEntityIn) {
        return new EntityDamageSourceIndirect(NINJUTSU_TYPE, source, (Entity)indirectEntityIn);
    }

    public static DamageSource causeSenjutsuDamage(Entity source, @Nullable EntityLivingBase indirectEntityIn) {
        return new EntityDamageSourceIndirect(SENJUTSU_TYPE, source, (Entity)indirectEntityIn).func_151518_m();
    }

    public static boolean isDamageSourceNinjutsu(DamageSource source) {
        return source.func_76355_l().equals(NINJUTSU_TYPE);
    }

    public static boolean canTarget(@Nullable Entity targetIn) {
        return targetIn != null && targetIn.func_70089_S() && !ProcedureOnLivingUpdate.isUntargetable(targetIn) && (!(targetIn instanceof EntityPlayer) || !((EntityPlayer)targetIn).func_175149_v());
    }

    public static void setCurrentJutsuCooldown(ItemStack stack, EntityLivingBase player, long cd) {
        if (stack.func_77973_b() instanceof Base) {
            ((Base)stack.func_77973_b()).setCurrentJutsuCooldown(stack, (long)((double)cd * (double)((Base)stack.func_77973_b()).getModifier(stack, player)));
        }
    }

    public static void logBattleXP(EntityPlayer player) {
        Base baseitem;
        ItemStack stack = player.func_184614_ca();
        if (!(stack.func_77973_b() instanceof Base)) {
            stack = player.func_184592_cb();
        }
        if (stack.func_77973_b() instanceof Base && (baseitem = (Base)stack.func_77973_b()).getCurrentJutsuXp(stack) < baseitem.getCurrentJutsuRequiredXp(stack)) {
            baseitem.addCurrentJutsuXp(stack, 1);
        }
    }

    public static void addBattleXP(EntityPlayer player, int xp) {
        ItemStack stack = player.func_184614_ca();
        if (!(stack.func_77973_b() instanceof Base)) {
            stack = player.func_184592_cb();
        }
        if (stack.func_77973_b() instanceof Base) {
            ((Base)stack.func_77973_b()).addCurrentJutsuXp(stack, xp);
        }
    }

    public static JutsuEnum getCurrentJutsu(ItemStack stack) {
        return ((Base)stack.func_77973_b()).getCurrentJutsu(stack);
    }

    public static double getMaxPower(EntityLivingBase entity, double jutsuCkakraUsage) {
        return Chakra.pathway(entity).getAmount() / jutsuCkakraUsage * 0.9999;
    }

    public static class JutsuEnum {
        public final int index;
        public final String unlocalizedName;
        public final char rank;
        public final int requiredXP;
        public final double chakraUsage;
        public final IJutsuCallback jutsu;
        private Type type;
        public float basePower = 0.0f;
        public float powerUpDelay = 50.0f;
        private static final List<JutsuEnum> jutsuList = Lists.newArrayList();

        public JutsuEnum(int idx, String string, int xp, IJutsuCallback jutsuIn) {
            this(idx, string, xp, 0.0, jutsuIn);
        }

        public JutsuEnum(int idx, String string, char rankIn, IJutsuCallback jutsuIn) {
            this(idx, string, rankIn, 0.0, jutsuIn);
        }

        public JutsuEnum(int idx, String string, char rankIn, double chakraUsageIn, IJutsuCallback jutsuIn) {
            this(idx, string, rankIn, rankIn == 'S' ? 400 : (rankIn == 'A' ? 250 : (rankIn == 'B' ? 200 : (rankIn == 'C' ? 150 : (rankIn == 'D' ? 100 : 900)))), chakraUsageIn, jutsuIn);
        }

        public JutsuEnum(int idx, String string, int xp, double chakraUsageIn, IJutsuCallback jutsuIn) {
            this(idx, string, ' ', xp, chakraUsageIn, jutsuIn);
        }

        public JutsuEnum(int idx, String string, char rankIn, int xp, double chakraUsageIn, IJutsuCallback jutsuIn) {
            this.index = idx;
            this.unlocalizedName = string;
            this.rank = rankIn == 'S' || rankIn == 'A' || rankIn == 'B' || rankIn == 'C' || rankIn == 'D' ? rankIn : (char)'\u0000';
            this.requiredXP = xp;
            this.chakraUsage = chakraUsageIn;
            this.jutsu = jutsuIn;
            jutsuList.add(this);
        }

        public String getName() {
            String s = this.unlocalizedName;
            if (!s.contains(".")) {
                s = "entity." + s + ".name";
            }
            return I18n.func_74838_a((String)s);
        }

        public static ImmutableList<JutsuEnum> getJutsuList() {
            return ImmutableList.copyOf(jutsuList);
        }

        public static ImmutableList<JutsuEnum> getJutsuList(char rankIn) {
            ArrayList list = Lists.newArrayList();
            for (JutsuEnum je : jutsuList) {
                if (je.rank != rankIn) continue;
                list.add(je);
            }
            return ImmutableList.copyOf((Collection)list);
        }

        public Type getType() {
            return this.type;
        }

        private JutsuEnum setType(Type typeIn) {
            this.type = typeIn;
            return this;
        }

        public String toString() {
            return "\nJutsu - " + (Object)((Object)this.type) + ": " + this.getName() + ", rank:" + this.rank;
        }

        public static enum Type {
            NINJUTSU,
            DOTON,
            FUTON,
            KATON,
            RAITON,
            SUITON,
            INTON,
            YOTON,
            JINTON,
            MOKUTON,
            JITON,
            IRYO,
            HYOTON,
            BAKUTON,
            SHAKUTON,
            BYAKUGAN,
            SHARINGAN,
            RINNEGAN,
            RANTON,
            FUTTON,
            YOOTON,
            SHIKOTSUMYAKU,
            KUCHIYOSE,
            TENSEIGAN,
            SENJUTSU,
            SIXPATHSENJUTSU,
            KEKKEIMORA,
            OTHER;

        }
    }

    public static interface IJutsuCallback {
        public boolean createJutsu(ItemStack var1, EntityLivingBase var2, float var3);

        default public boolean isActivated(ItemStack stack) {
            return false;
        }

        default public boolean isActivated(EntityLivingBase entity) {
            return false;
        }

        default public void deactivate(EntityLivingBase entity) {
        }

        default public float getPower(ItemStack stack) {
            return 0.0f;
        }

        default public JutsuData getData(EntityLivingBase entity) {
            return null;
        }

        public static class JutsuData {
            public final Entity entity;
            public final ItemStack stack;

            public JutsuData(Entity entityIn, ItemStack stackIn) {
                this.entity = entityIn;
                this.stack = stackIn;
            }
        }
    }

    public static interface IJutsu {
    }

    public static abstract class Base
    extends Item {
        private static final String JUTSU_INDEX_KEY = "JutsuIndexKey";
        private static final String CDMAP_KEY = "JutsuCDMapKey";
        private static final String XPMAP_KEY = "JutsuExperienceMapKey";
        private static final String OWNER_ID_KEY = "OwnerIdKey";
        private static final String AFFINITY_KEY = "IsNatureAffinityKey";
        private final ImmutableList<JutsuEnum> jutsuList;
        protected final long[] defaultCooldownMap;
        private final int[] jutsuXpMap;

        public Base(JutsuEnum.Type typeIn, JutsuEnum ... jutsuListIn) {
            if (jutsuListIn.length > 0) {
                this.func_77656_e(0);
                this.func_77664_n();
                this.field_77777_bU = 1;
                this.defaultCooldownMap = new long[jutsuListIn.length];
                this.jutsuXpMap = new int[jutsuListIn.length];
                for (int i = 0; i < jutsuListIn.length; ++i) {
                    this.defaultCooldownMap[i] = -1L;
                    this.jutsuXpMap[i] = 0;
                    jutsuListIn[i].setType(typeIn);
                }
            } else {
                throw new IllegalArgumentException("Empty jutsu list!");
            }
            this.jutsuList = ImmutableList.copyOf((Object[])jutsuListIn);
        }

        protected boolean executeJutsu(ItemStack stack, EntityLivingBase entity, float power) {
            JutsuEnum jutsuEnum = this.getCurrentJutsu(stack);
            Chakra.Pathway pw = Chakra.pathway(entity);
            double d = jutsuEnum.chakraUsage * (double)power;
            if (power <= 0.0f || pw.getAmount() < d) {
                return false;
            }
            if (jutsuEnum.jutsu.createJutsu(stack, entity, power)) {
                pw.consume(d);
                return true;
            }
            return false;
        }

        protected abstract float getPower(ItemStack var1, EntityLivingBase var2, int var3);

        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft, float basePower, float powerupDelay) {
            float f = powerupDelay * this.getModifier(stack, entity);
            return f > 0.0f ? Math.min(basePower + (float)(this.getMaxUseDuration() - timeLeft) / f, this.getMaxPower(stack, entity)) : 0.0f;
        }

        public float getModifier(ItemStack stack, EntityLivingBase entity) {
            return (float)Chakra.getChakraModifier(entity) * this.getCurrentJutsuXpModifier(stack, entity);
        }

        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            return (float)ItemJutsu.getMaxPower(entity, this.getCurrentJutsu((ItemStack)stack).chakraUsage);
        }

        public void onUsingTick(ItemStack stack, EntityLivingBase player, int timeLeft) {
            if ((!(player instanceof EntityPlayer) || PlayerTracker.isNinja((EntityPlayer)player)) && player instanceof EntityPlayer && !player.field_70170_p.field_72995_K) {
                ((EntityPlayer)player).func_146105_b((ITextComponent)new TextComponentString(String.format("%.1f", Float.valueOf(this.getPower(stack, player, timeLeft)))), true);
            }
            this.onUsingEffects(player);
        }

        protected void onUsingEffects(EntityLivingBase player) {
            if (!player.field_70170_p.field_72995_K) {
                Particles.spawnParticle(player.field_70170_p, Particles.Types.SMOKE, player.field_70165_t, player.field_70163_u, player.field_70161_v, 40, 0.2, 0.0, 0.2, 0.0, 0.5, 0.0, 275436031, 40, 5, 240, player.func_145782_y());
            }
            if (player.field_70173_aa % 10 == 0) {
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:charging_chakra")), SoundCategory.PLAYERS, 0.05f, field_77697_d.nextFloat() + 0.5f);
            }
        }

        public void func_77615_a(ItemStack itemstack, World world, EntityLivingBase entity, int timeLeft) {
            float power;
            if (!world.field_72995_K && this.executeJutsu(itemstack, entity, power = this.getPower(itemstack, entity, timeLeft))) {
                this.addCurrentJutsuXp(itemstack, 1);
            }
        }

        private void resetJutsuMaps(ItemStack stack) {
            this.resetCooldownMap(stack);
            this.resetJutsuXpMap(stack);
        }

        private void resetJutsuXpMap(ItemStack stack) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74783_a(XPMAP_KEY, this.jutsuXpMap);
        }

        private void resetCooldownMap(ItemStack stack) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            for (int i = 0; i < this.defaultCooldownMap.length; ++i) {
                stack.func_77978_p().func_74772_a(CDMAP_KEY + i, this.defaultCooldownMap[i]);
            }
        }

        private void validateMapTags(ItemStack stack, int index) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (index >= 0 && !stack.func_77978_p().func_74764_b(CDMAP_KEY + index)) {
                stack.func_77978_p().func_74772_a(CDMAP_KEY + index, this.defaultCooldownMap[index]);
            }
            if (!stack.func_77978_p().func_74764_b(XPMAP_KEY)) {
                stack.func_77978_p().func_74783_a(XPMAP_KEY, this.jutsuXpMap);
            }
        }

        private int[] getJutsuXpMap(ItemStack stack) {
            this.validateMapTags(stack, -1);
            int[] xpmap = stack.func_77978_p().func_74759_k(XPMAP_KEY);
            if (xpmap.length < this.jutsuList.size()) {
                int[] map2 = xpmap;
                xpmap = new int[this.jutsuList.size()];
                for (int i = 0; i < map2.length; ++i) {
                    xpmap[i] = map2[i];
                }
            }
            return xpmap;
        }

        private int getJutsuXp(ItemStack stack, int index) {
            return this.getJutsuXpMap(stack)[index];
        }

        public int getJutsuXp(ItemStack stack, JutsuEnum jutsuIn) {
            return this.jutsuList.contains((Object)jutsuIn) ? this.getJutsuXp(stack, jutsuIn.index) : 0;
        }

        public int getCurrentJutsuXp(ItemStack stack) {
            return this.getJutsuXp(stack, this.getCurrentJutsuIndex(stack));
        }

        private void addJutsuXp(ItemStack stack, int index, int xp) {
            int[] xpmap = this.getJutsuXpMap(stack);
            int n = index;
            xpmap[n] = xpmap[n] + xp;
            stack.func_77978_p().func_74783_a(XPMAP_KEY, xpmap);
        }

        public void addJutsuXp(ItemStack stack, JutsuEnum jutsuIn, int xp) {
            if (this.jutsuList.contains((Object)jutsuIn)) {
                this.addJutsuXp(stack, jutsuIn.index, Math.min(this.getRequiredXp(stack, jutsuIn.index) * 3 - this.getJutsuXp(stack, jutsuIn.index), xp));
            }
        }

        public void addCurrentJutsuXp(ItemStack stack, int xp) {
            this.addJutsuXp(stack, this.getCurrentJutsuIndex(stack), Math.min(this.getCurrentJutsuRequiredXp(stack) * 3 - this.getCurrentJutsuXp(stack), xp));
        }

        private int getRequiredXp(ItemStack stack, int index) {
            int requiredXp = ((JutsuEnum)this.jutsuList.get((int)index)).requiredXP;
            return this.isAffinity(stack) ? requiredXp : (int)((float)requiredXp * 2.5f);
        }

        public int getRequiredXp(ItemStack stack, JutsuEnum jutsuIn) {
            return this.jutsuList.contains((Object)jutsuIn) ? this.getRequiredXp(stack, jutsuIn.index) : -1;
        }

        public float getXpRatio(ItemStack stack, JutsuEnum jutsuIn) {
            return this.jutsuList.contains((Object)jutsuIn) ? (float)this.getJutsuXp(stack, jutsuIn.index) / (float)this.getRequiredXp(stack, jutsuIn.index) : 0.0f;
        }

        public int getCurrentJutsuRequiredXp(ItemStack stack) {
            return this.getRequiredXp(stack, this.getCurrentJutsuIndex(stack));
        }

        public float getCurrentJutsuXpModifier(ItemStack stack, EntityLivingBase entity) {
            boolean flag = !(entity instanceof EntityPlayer) || ((EntityPlayer)entity).func_184812_l_();
            int j = this.getCurrentJutsuRequiredXp(stack);
            int i = flag ? j : this.getCurrentJutsuXp(stack);
            return i != 0 ? (float)j / (float)i : 0.0f;
        }

        public boolean canUseAnyJutsu(ItemStack stack) {
            for (int i = 0; i < this.jutsuList.size(); ++i) {
                if (this.getJutsuXp(stack, i) < this.getRequiredXp(stack, i)) continue;
                return true;
            }
            return false;
        }

        protected long getCurrentJutsuCooldown(ItemStack stack) {
            return this.getJutsuCooldown(stack, this.getCurrentJutsuIndex(stack));
        }

        private long getJutsuCooldown(ItemStack stack, int index) {
            this.validateMapTags(stack, index);
            return stack.func_77978_p().func_74763_f(CDMAP_KEY + index);
        }

        public void setCurrentJutsuCooldown(ItemStack stack, long cd) {
            this.setJutsuCooldown(stack, this.getCurrentJutsuIndex(stack), cd);
        }

        private void setJutsuCooldown(ItemStack stack, int index, long cd) {
            this.validateMapTags(stack, index);
            stack.func_77978_p().func_74772_a(CDMAP_KEY + index, ProcedureUpdateworldtick.getTotalWorldTime() + cd);
        }

        public void setJutsuCooldown(ItemStack stack, JutsuEnum jutsuIn, long cd) {
            if (this.jutsuList.contains((Object)jutsuIn) && this.isJutsuEnabled(stack, jutsuIn.index)) {
                this.setJutsuCooldown(stack, jutsuIn.index, cd);
            }
        }

        private void enableJutsu(ItemStack stack, int index, boolean enable) {
            long l = this.getJutsuCooldown(stack, index);
            stack.func_77978_p().func_74772_a(CDMAP_KEY + index, enable ? (l < 0L ? 0L : l) : -1L);
        }

        public void enableJutsu(ItemStack stack, JutsuEnum jutsuIn, boolean enable) {
            if (this.jutsuList.contains((Object)jutsuIn)) {
                this.enableJutsu(stack, jutsuIn.index, enable);
            } else {
                System.err.println("Justu [" + jutsuIn.getName() + "] does not belong in " + (Object)((Object)this));
            }
        }

        private boolean isJutsuEnabled(ItemStack stack, int index) {
            return this.getJutsuCooldown(stack, index) >= 0L;
        }

        public boolean isJutsuEnabled(ItemStack stack, JutsuEnum jutsuIn) {
            return this.jutsuList.contains((Object)jutsuIn) && this.isJutsuEnabled(stack, jutsuIn.index);
        }

        public boolean isAnyJutsuEnabled(ItemStack stack) {
            for (JutsuEnum je : this.jutsuList) {
                if (!this.isJutsuEnabled(stack, je.index)) continue;
                return true;
            }
            return false;
        }

        public List<JutsuEnum> getActivatedJutsus(ItemStack stack) {
            ArrayList list = Lists.newArrayList();
            for (JutsuEnum je : this.jutsuList) {
                if (!je.jutsu.isActivated(stack)) continue;
                list.add(je);
            }
            return list;
        }

        private boolean canUseJutsu(ItemStack stack, int index, @Nullable EntityLivingBase entity) {
            return entity != null && this.isOwner(stack, entity) && this.isJutsuEnabled(stack, index) || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_();
        }

        protected boolean canUseJutsu(ItemStack stack, JutsuEnum jutsuIn, @Nullable EntityLivingBase entity) {
            return this.jutsuList.contains((Object)jutsuIn) && this.canUseJutsu(stack, jutsuIn.index, entity);
        }

        protected boolean canUseCurrentJutsu(ItemStack stack, @Nullable EntityLivingBase entity) {
            return this.canUseJutsu(stack, this.getCurrentJutsuIndex(stack), entity);
        }

        protected int getCurrentJutsuIndex(ItemStack stack) {
            return stack.func_77942_o() ? stack.func_77978_p().func_74762_e(JUTSU_INDEX_KEY) : 0;
        }

        protected JutsuEnum getCurrentJutsu(ItemStack stack) {
            return (JutsuEnum)this.jutsuList.get(this.getCurrentJutsuIndex(stack));
        }

        private void setNextJutsu(ItemStack stack, EntityLivingBase entity) {
            int i;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            int next = this.getCurrentJutsuIndex(stack);
            for (i = 0; i < this.jutsuList.size(); ++i) {
                if (++next >= this.jutsuList.size()) {
                    next = 0;
                }
                if (this.canUseJutsu(stack, next, entity)) break;
            }
            if (i < this.jutsuList.size()) {
                stack.func_77978_p().func_74768_a(JUTSU_INDEX_KEY, next);
                if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K) {
                    ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentString(((JutsuEnum)this.jutsuList.get(next)).getName()), true);
                }
            }
        }

        public void setIsAffinity(ItemStack stack, boolean b) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74757_a(AFFINITY_KEY, b);
        }

        private boolean isAffinity(ItemStack stack) {
            return stack.func_77942_o() ? stack.func_77978_p().func_74767_n(AFFINITY_KEY) : false;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(new TextComponentTranslation("tooltip.general.shift", new Object[0]).func_150261_e());
            for (JutsuEnum j : this.jutsuList) {
                if (!this.canUseJutsu(itemstack, j.index, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) continue;
                list.add((this.getCurrentJutsuIndex(itemstack) == j.index ? ">" : " ") + (j.index + 1) + ": " + j.getName() + " (XP: " + TextFormatting.GREEN + this.getJutsuXp(itemstack, j.index) + TextFormatting.GRAY + "/" + this.getRequiredXp(itemstack, j.index) + ")");
            }
        }

        public void setOwner(ItemStack stack, EntityLivingBase owner) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_186854_a(OWNER_ID_KEY, owner.func_110124_au());
            stack.func_151001_c(stack.func_82833_r() + " (" + owner.func_70005_c_() + ")");
        }

        @Nullable
        protected UUID getOwnerUuid(ItemStack stack) {
            return stack.func_77942_o() && stack.func_77978_p().func_186855_b(OWNER_ID_KEY) ? stack.func_77978_p().func_186857_a(OWNER_ID_KEY) : null;
        }

        @Nullable
        private EntityLivingBase getOwner(ItemStack stack) {
            UUID uuid = this.getOwnerUuid(stack);
            if (uuid != null) {
                Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(uuid);
                return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
            }
            return null;
        }

        protected boolean isOwner(ItemStack stack, EntityLivingBase entity) {
            if (!stack.func_77942_o() || !stack.func_77978_p().func_186855_b(OWNER_ID_KEY)) {
                this.setOwner(stack, entity);
                this.resetJutsuMaps(stack);
            }
            return stack.func_77978_p().func_186857_a(OWNER_ID_KEY).equals(entity.func_110124_au());
        }

        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            EntityLivingBase livingEntity;
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (entity instanceof EntityLivingBase && !this.isOwner(itemstack, livingEntity = (EntityLivingBase)entity)) {
                return;
            }
        }

        public static void switchNextJutsu(ItemStack stack, EntityLivingBase entity) {
            if (stack.func_77973_b() instanceof Base) {
                ((Base)stack.func_77973_b()).setNextJutsu(stack, entity);
            }
        }

        public EnumActionResult canActivateJutsu(ItemStack stack, JutsuEnum jutsuIn, EntityPlayer entity) {
            if (!entity.func_184812_l_()) {
                if (!this.jutsuList.contains((Object)jutsuIn) || !this.canUseJutsu(stack, jutsuIn.index, (EntityLivingBase)entity)) {
                    return EnumActionResult.FAIL;
                }
                if (this.getJutsuXp(stack, jutsuIn.index) < this.getRequiredXp(stack, jutsuIn.index) || !PlayerTracker.isNinja(entity)) {
                    return EnumActionResult.FAIL;
                }
                long cd = this.getJutsuCooldown(stack, jutsuIn.index);
                if (cd > entity.field_70170_p.func_82737_E()) {
                    return EnumActionResult.PASS;
                }
                if (cd < 0L) {
                    return EnumActionResult.FAIL;
                }
            }
            return EnumActionResult.SUCCESS;
        }

        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            ItemStack stack = entity.func_184586_b(hand);
            EnumActionResult res = this.canActivateJutsu(stack, this.getCurrentJutsu(stack), entity);
            if (res == EnumActionResult.PASS && !world.field_72995_K) {
                entity.func_146105_b((ITextComponent)new TextComponentTranslation("chattext.cooldown.formatted", new Object[]{(this.getCurrentJutsuCooldown(stack) - world.func_82737_E()) / 20L}), true);
            } else if (res == EnumActionResult.SUCCESS) {
                entity.func_184598_c(hand);
            }
            return new ActionResult(res, (Object)stack);
        }

        public EnumAction func_77661_b(ItemStack itemstack) {
            return EnumAction.BOW;
        }

        protected int getMaxUseDuration() {
            return 72000;
        }

        public int func_77626_a(ItemStack itemstack) {
            return this.getMaxUseDuration();
        }

        public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
            return false;
        }

        public int func_77612_l() {
            return 0;
        }

        public boolean func_77645_m() {
            return false;
        }

        public static class EquipmentHook {
            @SubscribeEvent
            public void onEquipmentChange(LivingEquipmentChangeEvent event) {
                EntityLivingBase entity = event.getEntityLiving();
                ItemStack stack = event.getTo();
                if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K && event.getSlot().func_188453_a() == EntityEquipmentSlot.Type.HAND && stack.func_77973_b() instanceof Base && (event.getSlot() == EntityEquipmentSlot.MAINHAND || !(entity.func_184614_ca().func_77973_b() instanceof Base))) {
                    ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentString(ItemJutsu.getCurrentJutsu(stack).getName()), true);
                }
            }
        }
    }
}

