/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.Particles;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityFirestream;
import net.narutomod.entity.EntityHidingInAsh;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.item.ItemJutsu;

@ElementsNarutomodMod.ModElement.Tag
public class ItemKaton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:katon")
    public static final Item block = null;
    public static final int ENTITYID = 123;
    public static final ItemJutsu.JutsuEnum GREATFIREBALL = new ItemJutsu.JutsuEnum(0, "katonfireball", 'C', 30.0, (ItemJutsu.IJutsuCallback)new EntityBigFireball.Jutsu());
    public static final ItemJutsu.JutsuEnum GFANNIHILATION = new ItemJutsu.JutsuEnum(1, "tooltip.katon.annihilation", 'B', 50.0, (ItemJutsu.IJutsuCallback)new EntityFirestream.EC.Jutsu1());
    public static final ItemJutsu.JutsuEnum HIDINGINASH = new ItemJutsu.JutsuEnum(2, "hiding_in_ash", 'B', 50.0, (ItemJutsu.IJutsuCallback)new EntityHidingInAsh.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum GREATFLAME = new ItemJutsu.JutsuEnum(3, "katonfirestream", 'C', 20.0, (ItemJutsu.IJutsuCallback)new EntityFirestream.EC.Jutsu2());

    public ItemKaton(ElementsNarutomodMod instance) {
        super(instance, 366);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(GREATFIREBALL, GFANNIHILATION, HIDINGINASH, GREATFLAME));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityBigFireball.class).id(new ResourceLocation("narutomod", "katonfireball"), 123).name("katonfireball").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:katon", "inventory"));
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityBigFireball.class, renderManager -> new RenderBigFireball(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderBigFireball
        extends Render<EntityBigFireball> {
            private final ResourceLocation texture;

            public RenderBigFireball(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.texture = new ResourceLocation("narutomod:textures/fireball.png");
            }

            public void doRender(EntityBigFireball entity, double x, double y, double z, float entityYaw, float partialTicks) {
                GlStateManager.func_179094_E();
                this.func_180548_c(entity);
                float scale = entity.getEntityScale();
                GlStateManager.func_179137_b((double)x, (double)(y + 0.375 * (double)scale), (double)z);
                GlStateManager.func_179091_B();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                GlStateManager.func_179114_b((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * -this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(12.0f * (partialTicks + (float)entity.field_70173_aa)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                bufferbuilder.func_181662_b(-0.375, -0.375, 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b(0.375, -0.375, 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b(0.375, 0.375, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b(-0.375, 0.375, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179145_e();
                GlStateManager.func_179101_C();
                GlStateManager.func_179121_F();
                super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
            }

            protected ResourceLocation getEntityTexture(EntityBigFireball entity) {
                return this.texture;
            }
        }
    }

    public static class EntityBigFireball
    extends EntityScalableProjectile.Base {
        private float fullScale = 1.0f;
        private final int timeToFullscale = 20;
        private int explosionSize;
        private float damage;

        public EntityBigFireball(World a) {
            super(a);
            this.setOGSize(0.8f, 0.8f);
        }

        public EntityBigFireball(EntityLivingBase shooter, float fullScale) {
            super(shooter);
            this.setOGSize(0.8f, 0.8f);
            this.fullScale = fullScale;
            this.explosionSize = Math.max((int)fullScale - 1, 0);
            this.damage = fullScale * 10.0f;
            Vec3d vec3d = shooter.func_70040_Z();
            this.func_70107_b(shooter.field_70165_t + vec3d.field_72450_a, shooter.field_70163_u + 1.2 + vec3d.field_72448_b, shooter.field_70161_v + vec3d.field_72449_c);
        }

        @Override
        protected void onImpact(RayTraceResult result) {
            if (result.field_72313_a == RayTraceResult.Type.BLOCK && this.fullScale >= 2.0f && this.ticksInAir <= 15) {
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.shootingEntity != null) {
                    this.shootingEntity.getEntityData().func_74780_a(NarutomodModVariables.InvulnerableTime, 40.0);
                }
                if (result.field_72308_g != null) {
                    if (result.field_72308_g.equals((Object)this.shootingEntity) || result.field_72308_g instanceof EntityBigFireball) {
                        return;
                    }
                    result.field_72308_g.func_70097_a(ItemJutsu.causeJutsuDamage(this, this.shootingEntity).func_76361_j(), this.damage);
                    result.field_72308_g.func_70015_d(10);
                }
                boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shootingEntity);
                this.field_70170_p.func_72885_a((Entity)this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionSize, flag, false);
                this.func_70106_y();
            }
        }

        @Override
        public void renderParticles() {
            Particles.spawnParticle(this.field_70170_p, Particles.Types.FLAME, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, (int)this.fullScale * 2, 0.3 * (double)this.field_70130_N, 0.3 * (double)this.field_70131_O, 0.3 * (double)this.field_70130_N, 0.0, 0.0, 0.0, 0xFFFF0000 | 64 + this.field_70146_Z.nextInt(128) << 8, 30);
        }

        @Override
        protected void checkOnGround() {
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K && (this.ticksInAir > 100 || this.func_70090_H())) {
                this.func_70106_y();
            } else {
                if (!this.field_70170_p.field_72995_K && this.ticksAlive <= this.timeToFullscale) {
                    float f = (this.fullScale - 1.0f) * (float)this.ticksAlive;
                    ((Object)((Object)this)).getClass();
                    this.setEntityScale(1.0f + f / 20.0f);
                }
                if (this.field_70146_Z.nextFloat() <= 0.2f) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:flamethrow")), 1.0f, this.field_70146_Z.nextFloat() * 0.5f + 0.6f);
                }
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (power >= 0.5f) {
                    this.createJutsu(entity, entity.func_70040_Z().field_72450_a, entity.func_70040_Z().field_72448_b, entity.func_70040_Z().field_72449_c, power);
                    return true;
                }
                return false;
            }

            public void createJutsu(EntityLivingBase entity, double x, double y, double z, float power) {
                EntityBigFireball entityarrow = new EntityBigFireball(entity, power);
                entityarrow.func_70186_c(x, y, z, 0.95f, 0.0f);
                entity.field_70170_p.func_72838_d((Entity)entityarrow);
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.KATON, list);
            this.setRegistryName("katon");
            this.func_77655_b("katon");
            this.func_77637_a(TabModTab.tab);
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            ItemJutsu.JutsuEnum je = this.getCurrentJutsu(stack);
            if (je == HIDINGINASH) {
                return this.getPower(stack, entity, timeLeft, 1.0f, 15.0f);
            }
            if (je == GREATFIREBALL) {
                return this.getPower(stack, entity, timeLeft, 0.5f, 30.0f);
            }
            return this.getPower(stack, entity, timeLeft, 1.0f, 30.0f);
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            float f = super.getMaxPower(stack, entity);
            if (jutsu == GREATFLAME) {
                return Math.min(f, 30.0f);
            }
            if (jutsu == GFANNIHILATION) {
                return Math.min(f, 20.0f);
            }
            if (jutsu == GREATFIREBALL) {
                return Math.min(f, 10.0f);
            }
            return f;
        }
    }
}

