/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketCollectItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemNuibariThrown;
import net.narutomod.item.ItemOnBody;
import net.narutomod.procedure.ProcedureSync;

@ElementsNarutomodMod.ModElement.Tag
public class ItemNuibariSword
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:nuibari_sword")
    public static final Item block = null;
    public static final int ENTITYID = 290;

    public ItemNuibariSword(ElementsNarutomodMod instance) {
        super(instance, 613);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "entitybulletnuibari_sword"), 290).name("entitybulletnuibari_sword").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:nuibari_sword", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderCustom(renderManager, Minecraft.func_71410_x().func_175599_af()));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EntityCustom.KnockbackHook());
    }

    private static int getSlotId(EntityPlayer entity) {
        for (int i = 0; i < entity.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)entity.field_71071_by.field_70462_a.get(i);
            if (stack == null || stack.func_77973_b() != block) continue;
            return i;
        }
        if (entity.func_184592_cb().func_77973_b() == block) {
            return 99;
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCustom
    extends Render<EntityCustom> {
        protected final Item item;
        private final RenderItem itemRenderer;

        public RenderCustom(RenderManager renderManagerIn, RenderItem itemRendererIn) {
            super(renderManagerIn);
            this.item = block;
            this.itemRenderer = itemRendererIn;
        }

        public boolean shouldRender(EntityCustom entity, ICamera camera, double camX, double camY, double camZ) {
            return true;
        }

        public void doRender(EntityCustom entity, double x, double y, double z, float entityYaw, float pt) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * pt), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-entity.field_70127_C - (entity.field_70125_A - entity.field_70127_C) * pt - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179091_B();
            this.func_110776_a(TextureMap.field_110575_b);
            this.itemRenderer.func_181564_a(this.getStackToRender(entity), ItemCameraTransforms.TransformType.GROUND);
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            this.renderLineToShooter(entity, pt);
        }

        private void renderLineToShooter(EntityCustom entity, float pt) {
            Vec3d vec0 = entity.getNeedleEyePos(pt);
            for (EntityLivingBase otherEntity : entity.skeweredEntities) {
                Vec3d vec1 = this.getPosVec((Entity)otherEntity, pt).func_72441_c(0.0, 1.0, 0.0);
                this.renderLine(vec0, vec1);
                vec0 = vec1;
            }
            EntityLivingBase shooter = entity.getShooter();
            if (shooter != null) {
                this.renderLine(vec0, this.getPosVec((Entity)shooter, pt).func_72441_c(0.0, 1.0, 0.0));
            }
        }

        private Vec3d getPosVec(Entity entity, float pt) {
            Vec3d vec1 = new Vec3d(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U);
            return entity.func_174791_d().func_178788_d(vec1).func_186678_a((double)pt).func_178787_e(vec1);
        }

        private void renderLine(Vec3d from, Vec3d to) {
            Vec3d vec3d = to.func_178788_d(from);
            float yaw = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.29577951308232);
            float pitch = (float)(-MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)MathHelper.func_76133_a((double)(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c))) * 57.29577951308232);
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_187441_d((float)1.0f);
            GlStateManager.func_179137_b((double)(from.field_72450_a - this.field_76990_c.field_78730_l), (double)(from.field_72448_b - this.field_76990_c.field_78731_m), (double)(from.field_72449_c - this.field_76990_c.field_78728_n));
            GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            double d = vec3d.func_72433_c();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179140_f();
            bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(150, 150, 150, 100).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, d).func_181669_b(150, 150, 150, 100).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }

        private ItemStack getStackToRender(EntityCustom entityIn) {
            return new ItemStack(this.item);
        }

        protected ResourceLocation getEntityTexture(EntityCustom entity) {
            return TextureMap.field_110575_b;
        }
    }

    public static class EntityCustom
    extends EntityThrowable {
        private static final String SKEWERED_TIME = "NuibariSkeweredTime";
        private static final DataParameter<Integer> SHOOTERID = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Integer> OTHERENTITYID = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Boolean> CLEARLIST = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187198_h);
        private List<EntityLivingBase> skeweredEntities = Lists.newArrayList();
        private double damage;
        private float health = 15.0f;

        public EntityCustom(World a) {
            super(a);
            this.func_70105_a(0.5f, 0.5f);
        }

        public EntityCustom(World worldIn, EntityLivingBase shooter) {
            super(worldIn, shooter);
            this.setShooter(shooter);
            this.func_70105_a(0.5f, 0.5f);
        }

        protected void func_70088_a() {
            super.func_70088_a();
            this.field_70180_af.func_187214_a(SHOOTERID, (Object)-1);
            this.field_70180_af.func_187214_a(OTHERENTITYID, (Object)-1);
            this.field_70180_af.func_187214_a(CLEARLIST, (Object)false);
        }

        public void setShooter(@Nullable EntityLivingBase shooter) {
            if (shooter != null) {
                this.field_70180_af.func_187227_b(SHOOTERID, (Object)shooter.func_145782_y());
            } else {
                this.field_70180_af.func_187227_b(SHOOTERID, (Object)-1);
                this.field_70192_c = null;
            }
        }

        @Nullable
        public EntityLivingBase getShooter() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(SHOOTERID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        private void skewerEntity(EntityLivingBase entity) {
            this.clearSkewerList(false);
            this.field_70180_af.func_187227_b(OTHERENTITYID, (Object)entity.func_145782_y());
        }

        @Nullable
        private EntityLivingBase getLastSkeweredEntity() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(OTHERENTITYID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        private void clearSkewerList(boolean clear) {
            if (clear) {
                this.field_70180_af.func_187227_b(OTHERENTITYID, (Object)-1);
                for (EntityLivingBase entity : this.skeweredEntities) {
                    ProcedureSync.EntityNBTTag.removeAndSync((Entity)entity, SKEWERED_TIME);
                }
            }
            this.field_70180_af.func_187227_b(CLEARLIST, (Object)clear);
        }

        private boolean shouldClearSkewerList() {
            return (Boolean)this.field_70180_af.func_187225_a(CLEARLIST);
        }

        public void func_184206_a(DataParameter<?> key) {
            super.func_184206_a(key);
            if (OTHERENTITYID.equals(key)) {
                EntityLivingBase entity = this.getLastSkeweredEntity();
                if (entity != null) {
                    this.skeweredEntities.add(entity);
                }
            } else if (CLEARLIST.equals(key) && this.shouldClearSkewerList()) {
                this.skeweredEntities.clear();
            }
        }

        protected void func_70184_a(RayTraceResult raytraceResultIn) {
            Entity entity = raytraceResultIn.field_72308_g;
            if (entity != null) {
                if (!entity.equals((Object)this.field_70192_c)) {
                    entity.getEntityData().func_74757_a("TempData_disableKnockback", true);
                    float f = MathHelper.func_76133_a((double)this.getVelocitySq()) * (float)this.getDamage();
                    if (entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.field_70192_c), f) || entity.equals((Object)this.getLastSkeweredEntity())) {
                        if (entity instanceof EntityLivingBase) {
                            if (entity.func_70089_S() && entity.func_174813_aQ().func_72320_b() < 2.0 && !entity.equals((Object)this.getLastSkeweredEntity())) {
                                this.skewerEntity((EntityLivingBase)entity);
                            }
                            this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                            this.field_70159_w *= 0.85;
                            this.field_70181_x *= 0.85;
                            this.field_70179_y *= 0.85;
                        }
                    } else {
                        this.field_70159_w *= -0.1;
                        this.field_70181_x *= -0.1;
                        this.field_70179_y *= -0.1;
                        this.field_70177_z += 180.0f;
                        this.field_70126_B += 180.0f;
                        ReflectionHelper.setPrivateValue(EntityThrowable.class, (Object)((Object)this), (Object)0, (int)9);
                    }
                }
            } else {
                BlockPos blockpos = raytraceResultIn.func_178782_a();
                ReflectionHelper.setPrivateValue(EntityThrowable.class, (Object)((Object)this), (Object)blockpos.func_177958_n(), (int)0);
                ReflectionHelper.setPrivateValue(EntityThrowable.class, (Object)((Object)this), (Object)blockpos.func_177956_o(), (int)1);
                ReflectionHelper.setPrivateValue(EntityThrowable.class, (Object)((Object)this), (Object)blockpos.func_177952_p(), (int)2);
                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                ReflectionHelper.setPrivateValue(EntityThrowable.class, (Object)((Object)this), (Object)iblockstate.func_177230_c(), (int)3);
                this.field_70159_w = (float)(raytraceResultIn.field_72307_f.field_72450_a - this.field_70165_t);
                this.field_70181_x = (float)(raytraceResultIn.field_72307_f.field_72448_b - this.field_70163_u);
                this.field_70179_y = (float)(raytraceResultIn.field_72307_f.field_72449_c - this.field_70161_v);
                float f2 = MathHelper.func_76133_a((double)this.getVelocitySq());
                this.field_70165_t -= this.field_70159_w / (double)f2 * 0.05;
                this.field_70163_u -= this.field_70181_x / (double)f2 * 0.05;
                this.field_70161_v -= this.field_70179_y / (double)f2 * 0.05;
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.field_174854_a = true;
                this.field_70191_b = 7;
                this.health = 15.0f;
                if (iblockstate.func_185904_a() != Material.field_151579_a) {
                    iblockstate.func_177230_c().func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
                }
            }
        }

        protected float func_70185_h() {
            return 0.05f;
        }

        private double getVelocitySq() {
            return this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y;
        }

        protected Vec3d getNeedleEyePos(float pt) {
            Vec3d vec0 = new Vec3d(this.field_70142_S + (this.field_70165_t - this.field_70142_S) * (double)pt, this.field_70137_T + (this.field_70163_u - this.field_70137_T) * (double)pt, this.field_70136_U + (this.field_70161_v - this.field_70136_U) * (double)pt);
            float f0 = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * pt;
            float f1 = -this.field_70127_C - (this.field_70125_A - this.field_70127_C) * pt - 90.0f;
            return new Vec3d(0.0, 2.08, 0.0).func_178789_a(-f1 * (float)Math.PI / 180.0f).func_178785_b(f0 * (float)Math.PI / 180.0f).func_178787_e(vec0);
        }

        public void retrieve(double x, double y, double z, float speed) {
            this.field_174854_a = false;
            this.func_70186_c(x, y, z, speed, 0.0f);
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            this.func_145775_I();
            if (this.field_70192_c != null && !this.field_70192_c.func_70089_S()) {
                this.setShooter(null);
            }
            if (this.field_174854_a) {
                if ((Integer)ReflectionHelper.getPrivateValue(EntityThrowable.class, (Object)((Object)this), (int)8) > 1198) {
                    ReflectionHelper.setPrivateValue(EntityThrowable.class, (Object)((Object)this), (Object)1000, (int)8);
                }
            } else if (this.field_70192_c != null && (double)this.func_70032_d((Entity)this.field_70192_c) > 50.0) {
                this.field_70159_w *= -0.4;
                this.field_70179_y *= -0.4;
            }
            if (!this.field_70170_p.field_72995_K) {
                ProcedureSync.EntityPositionAndRotation.sendToTracking((Entity)this);
            }
            EntityCustom lastEntity = this;
            Iterator<EntityLivingBase> iter = this.skeweredEntities.iterator();
            while (iter.hasNext()) {
                EntityLivingBase entity = iter.next();
                int i = entity.getEntityData().func_74762_e(SKEWERED_TIME);
                if (this.isTargetable((Entity)entity) && i < 300) {
                    double d;
                    if (!(entity instanceof EntityPlayer)) {
                        entity.getEntityData().func_74768_a(SKEWERED_TIME, ++i);
                    }
                    if ((d = (double)lastEntity.func_70032_d((Entity)entity)) > 2.0) {
                        Vec3d vec = lastEntity.func_174791_d().func_178788_d(entity.func_174791_d()).func_72432_b().func_186678_a(0.2 * d / 2.0);
                        entity.func_70024_g(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                        entity.field_70133_I = true;
                    }
                    lastEntity = entity;
                    continue;
                }
                iter.remove();
                entity.getEntityData().func_82580_o(SKEWERED_TIME);
            }
        }

        private boolean isTargetable(@Nullable Entity targetIn) {
            return ItemJutsu.canTarget(targetIn);
        }

        public void func_70100_b_(EntityPlayer entityIn) {
            if (!this.field_70170_p.field_72995_K && this.field_70191_b <= 0) {
                boolean flag = false;
                if (this.field_70192_c == null && this.field_174854_a) {
                    flag = entityIn.field_71071_by.func_70441_a(this.getArrowStack());
                } else if (entityIn.equals((Object)this.field_70192_c) && this.field_70173_aa > 15) {
                    flag = entityIn.func_174820_d(ItemNuibariThrown.getSlotId(entityIn), this.getArrowStack());
                }
                if (flag) {
                    ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, (Packet)new SPacketCollectItem(this.func_145782_y(), entityIn.func_145782_y(), 1));
                    this.func_70106_y();
                }
            }
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.clearSkewerList(true);
            }
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76346_g() instanceof EntityLivingBase) {
                if (!this.field_174854_a) {
                    Vec3d vec3d = source.func_76346_g().func_70040_Z();
                    this.field_70159_w = vec3d.field_72450_a;
                    this.field_70181_x = vec3d.field_72448_b;
                    this.field_70179_y = vec3d.field_72449_c;
                    this.func_70018_K();
                    return true;
                }
                this.health -= amount;
                if (this.health <= 0.0f) {
                    this.clearSkewerList(true);
                }
            }
            return false;
        }

        public boolean func_70067_L() {
            return !this.field_70128_L;
        }

        protected ItemStack getArrowStack() {
            return new ItemStack(block);
        }

        public void setDamage(double damageIn) {
            this.damage = damageIn;
        }

        public double getDamage() {
            return this.damage;
        }

        public static class KnockbackHook {
            @SubscribeEvent
            public void onKnockback(LivingKnockBackEvent event) {
                if (event.getEntity().getEntityData().func_74767_n("TempData_disableKnockback")) {
                    event.setCanceled(true);
                    event.getEntity().getEntityData().func_82580_o("TempData_disableKnockback");
                }
            }
        }
    }

    public static class RangedItem
    extends Item
    implements ItemOnBody.Interface {
        public RangedItem() {
            this.func_77656_e(0);
            this.func_77664_n();
            this.func_77655_b("nuibari_sword");
            this.setRegistryName("nuibari_sword");
            this.field_77777_bU = 1;
            this.func_77637_a(TabModTab.tab);
        }

        public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
            Multimap multimap = super.func_111205_h(slot);
            if (slot == EntityEquipmentSlot.MAINHAND) {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Ranged item modifier", 8.0, 0));
                multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Ranged item modifier", -2.0, 0));
            }
            return multimap;
        }

        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(I18n.func_74838_a((String)"tooltip.nuibari.general"));
        }

        public void func_77615_a(ItemStack itemstack, World world, EntityLivingBase entityLivingBase, int timeLeft) {
            if (!world.field_72995_K && entityLivingBase instanceof EntityPlayerMP) {
                EntityPlayerMP entity = (EntityPlayerMP)entityLivingBase;
                int slotID = ItemNuibariSword.getSlotId((EntityPlayer)entity);
                float f = ItemBow.func_185059_b((int)(this.func_77626_a(itemstack) - timeLeft));
                EntityCustom entityarrow = new EntityCustom(world, (EntityLivingBase)entity);
                entityarrow.func_70186_c(entity.func_70040_Z().field_72450_a, entity.func_70040_Z().field_72448_b, entity.func_70040_Z().field_72449_c, f * 2.0f, 0.0f);
                entityarrow.setDamage(16.0);
                world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + f);
                world.func_72838_d((Entity)entityarrow);
                ItemStack newstack = new ItemStack(ItemNuibariThrown.block);
                ((ItemNuibariThrown.RangedItem)newstack.func_77973_b()).setEntity(newstack, entityarrow);
                entity.func_174820_d(slotID, newstack);
            }
        }

        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            entity.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)entity.func_184586_b(hand));
        }

        public EnumAction func_77661_b(ItemStack itemstack) {
            return EnumAction.BOW;
        }

        public int func_77626_a(ItemStack itemstack) {
            return 72000;
        }
    }
}

