/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;

@ElementsNarutomodMod.ModElement.Tag
public class ItemOnBody
extends ElementsNarutomodMod.ModElement {
    private static Vec3d RIGHT_LEG_OFFSET = new Vec3d(0.125, -0.6875, 0.0);
    private static Vec3d LEFT_LEG_OFFSET = new Vec3d(-0.125, -0.6875, 0.0);
    private static Vec3d RIGHT_ARM_OFFSET = new Vec3d(0.3125, -0.125, 0.0);
    private static Vec3d LEFT_ARM_OFFSET = new Vec3d(-0.3125, -0.125, 0.0);

    public ItemOnBody(ElementsNarutomodMod instance) {
        super(instance, 711);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(InventoryTracker.Message.Handler.class, InventoryTracker.Message.class, Side.CLIENT);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new InventoryTracker.TrackingHook());
    }

    public static class InventoryTracker {
        private static final Map<Integer, InventoryTracker> TRACKERMAP = Maps.newHashMap();
        private final EntityPlayer player;
        private final Map<Integer, ItemStack> slotMap = Maps.newHashMap();
        private int currentItem;
        private boolean forceUpdate;

        public static void createOrSyncInventory(EntityPlayerMP playerIn) {
            InventoryTracker.getOrCreate((EntityPlayer)playerIn).sync();
        }

        public static InventoryTracker getOrCreate(EntityPlayer entity) {
            InventoryTracker inventoryTracker = TRACKERMAP.get(entity.func_145782_y());
            if (inventoryTracker == null) {
                inventoryTracker = new InventoryTracker(entity);
            }
            return inventoryTracker;
        }

        public static void clearEmpties() {
            Iterator<InventoryTracker> iter = TRACKERMAP.values().iterator();
            while (iter.hasNext()) {
                InventoryTracker it = iter.next();
                if (!it.slotMap.isEmpty()) continue;
                iter.remove();
            }
        }

        private InventoryTracker(EntityPlayer playerIn) {
            this.player = playerIn;
            TRACKERMAP.put(playerIn.func_145782_y(), this);
        }

        private boolean needsUpdate() {
            boolean update = false;
            for (int i = 0; i < this.player.field_71071_by.func_70302_i_(); ++i) {
                boolean flag;
                ItemStack stack1 = this.player.field_71071_by.func_70301_a(i);
                ItemStack stack2 = this.slotMap.get(i);
                boolean bl = flag = stack2 != null && ItemStack.func_77989_b((ItemStack)stack1, (ItemStack)stack2);
                if (!flag && (stack1.func_77973_b() instanceof Interface || stack2 != null && stack2.func_77973_b() instanceof Interface)) {
                    this.slotMap.put(i, stack1);
                    update = true;
                    continue;
                }
                if (!flag || stack2.func_77973_b() instanceof Interface) continue;
                this.slotMap.remove(i);
            }
            if (!this.slotMap.isEmpty() && (this.forceUpdate || this.currentItem != this.player.field_71071_by.field_70461_c)) {
                this.slotMap.put(this.currentItem, (ItemStack)this.player.field_71071_by.field_70462_a.get(this.currentItem));
                this.slotMap.put(this.player.field_71071_by.field_70461_c, this.player.field_71071_by.func_70448_g());
                update = true;
            }
            this.currentItem = this.player.field_71071_by.field_70461_c;
            return update;
        }

        private void sync() {
            if (this.needsUpdate()) {
                NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new Message(this), (Entity)this.player);
                this.forceUpdate = false;
            }
        }

        private void forceUpdate() {
            this.forceUpdate = true;
        }

        public static class TrackingHook {
            @SubscribeEvent
            public void onTracking(PlayerEvent.StartTracking event) {
                if (event.getTarget() instanceof EntityPlayerMP) {
                    InventoryTracker.getOrCreate(event.getEntityPlayer()).forceUpdate();
                }
            }

            @SubscribeEvent
            public void onJoin(EntityJoinWorldEvent event) {
                if (event.getEntity() instanceof EntityPlayerMP) {
                    TRACKERMAP.remove(event.getEntity().func_145782_y());
                }
            }
        }

        public static class Message
        implements IMessage {
            int id;
            int cur;
            int mapsize;
            Map<Integer, ItemStack> map;

            public Message() {
            }

            public Message(InventoryTracker invtracker) {
                this.id = invtracker.player.func_145782_y();
                this.cur = invtracker.currentItem;
                this.mapsize = invtracker.slotMap.size();
                this.map = invtracker.slotMap;
            }

            public void toBytes(ByteBuf buf) {
                PacketBuffer pbuf = new PacketBuffer(buf);
                pbuf.writeInt(this.id);
                pbuf.writeInt(this.cur);
                pbuf.writeInt(this.mapsize);
                for (Map.Entry<Integer, ItemStack> entry : this.map.entrySet()) {
                    pbuf.writeInt(entry.getKey().intValue());
                    pbuf.func_150788_a(entry.getValue());
                }
            }

            public void fromBytes(ByteBuf buf) {
                PacketBuffer pbuf = new PacketBuffer(buf);
                this.id = pbuf.readInt();
                this.cur = pbuf.readInt();
                this.mapsize = pbuf.readInt();
                this.map = Maps.newHashMap();
                try {
                    for (int i = 0; i < this.mapsize; ++i) {
                        int j = pbuf.readInt();
                        ItemStack stack = pbuf.func_150791_c();
                        this.map.put(j, stack);
                    }
                }
                catch (Exception e) {
                    new IOException("Inventory sync: ", e);
                }
            }

            public static class Handler
            implements IMessageHandler<Message, IMessage> {
                @SideOnly(value=Side.CLIENT)
                public IMessage onMessage(Message message, MessageContext context) {
                    Minecraft mc = Minecraft.func_71410_x();
                    mc.func_152344_a(() -> {
                        Entity entity = mc.field_71441_e.func_73045_a(message.id);
                        if (entity instanceof EntityOtherPlayerMP) {
                            EntityOtherPlayerMP othermp = (EntityOtherPlayerMP)entity;
                            if (othermp.field_71071_by.field_70461_c == 0 && message.cur != 0) {
                                ItemStack stack = message.map.get(0);
                                othermp.field_71071_by.func_70299_a(0, stack != null ? stack : ItemStack.field_190927_a);
                            }
                            othermp.field_71071_by.field_70461_c = message.cur;
                            for (Map.Entry<Integer, ItemStack> entry : message.map.entrySet()) {
                                othermp.field_71071_by.func_70299_a(entry.getKey().intValue(), entry.getValue());
                            }
                        }
                    });
                    return null;
                }
            }
        }
    }

    public static enum BodyPart {
        NONE,
        HEAD,
        TORSO,
        RIGHT_ARM,
        LEFT_ARM,
        RIGHT_LEG,
        LEFT_LEG;

    }

    public static interface Interface {
        default public Vec3d getOffset() {
            switch (this.showOnBody()) {
                case RIGHT_ARM: {
                    return RIGHT_ARM_OFFSET;
                }
                case RIGHT_LEG: {
                    return RIGHT_LEG_OFFSET;
                }
                case LEFT_ARM: {
                    return LEFT_ARM_OFFSET;
                }
                case LEFT_LEG: {
                    return LEFT_LEG_OFFSET;
                }
            }
            return Vec3d.field_186680_a;
        }

        default public boolean showSkinLayer() {
            return false;
        }

        default public BodyPart showOnBody() {
            return BodyPart.TORSO;
        }
    }
}

