/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityChidori;
import net.narutomod.entity.EntityFalseDarkness;
import net.narutomod.entity.EntityKirin;
import net.narutomod.entity.EntityLightningArc;
import net.narutomod.entity.EntityLightningBeast;
import net.narutomod.entity.EntityLightningPanther;
import net.narutomod.item.ItemFuton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemRaiton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:raiton")
    public static final Item block = null;
    public static final int ENTITYID = 129;
    public static final int ENTITY2ID = 10129;
    public static final ItemJutsu.JutsuEnum CHIDORI = new ItemJutsu.JutsuEnum(0, "chidori", 'A', 150.0, (ItemJutsu.IJutsuCallback)new EntityChidori.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum CHAKRAMODE = new ItemJutsu.JutsuEnum(1, "raitonchakramode", 'B', 10.0, (ItemJutsu.IJutsuCallback)new EntityChakraMode.Jutsu());
    public static final ItemJutsu.JutsuEnum CHASINGDOG = new ItemJutsu.JutsuEnum(2, "lightning_beast", 'C', 20.0, (ItemJutsu.IJutsuCallback)new EntityLightningBeast.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum GIAN = new ItemJutsu.JutsuEnum(3, "false_darkness", 'B', 100.0, (ItemJutsu.IJutsuCallback)new EntityFalseDarkness.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum KIRIN = new ItemJutsu.JutsuEnum(4, "kirin", 'S', 1500.0, (ItemJutsu.IJutsuCallback)new EntityKirin.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum BLACKPANTHER = new ItemJutsu.JutsuEnum(5, "lightning_panther", 'S', 50.0, (ItemJutsu.IJutsuCallback)new EntityLightningPanther.EC.Jutsu());

    public ItemRaiton(ElementsNarutomodMod instance) {
        super(instance, 373);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(CHIDORI, CHAKRAMODE, CHASINGDOG, GIAN, KIRIN, BLACKPANTHER));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityChakraMode.class).id(new ResourceLocation("narutomod", "raitonchakramode"), 129).name("raitonchakramode").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:raiton", "inventory"));
    }

    public static class EntityChakraMode
    extends Entity {
        private final double CHAKRA_BURN;
        private EntityLivingBase summoner;
        private ItemStack usingItemstack;
        private int strengthAmplifier;

        public EntityChakraMode(World a) {
            super(a);
            this.CHAKRA_BURN = ItemRaiton.CHAKRAMODE.chakraUsage;
            this.strengthAmplifier = 9;
            this.func_70105_a(0.01f, 0.01f);
        }

        protected EntityChakraMode(EntityLivingBase summonerIn, ItemStack stack) {
            this(summonerIn.field_70170_p);
            this.summoner = summonerIn;
            this.func_70107_b(summonerIn.field_70165_t, summonerIn.field_70163_u, summonerIn.field_70161_v);
            if (stack.func_77973_b() instanceof ItemJutsu.Base) {
                this.usingItemstack = stack;
            }
            if (summonerIn.func_70644_a(MobEffects.field_76420_g)) {
                this.strengthAmplifier += summonerIn.func_70660_b(MobEffects.field_76420_g).func_76458_c() + 1;
            }
        }

        protected void func_70088_a() {
        }

        public void func_70106_y() {
            super.func_70106_y();
            this.setNewCooldown();
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.summoner != null && this.summoner.func_70089_S()) {
                if (this.field_70173_aa % 20 == 2) {
                    Chakra.Pathway chakra = Chakra.pathway(this.summoner);
                    if (!chakra.consume(this.CHAKRA_BURN)) {
                        this.func_70106_y();
                    }
                    int i = Math.max((int)((double)MathHelper.func_76133_a((double)chakra.getAmount()) / 7.5), 9) - 9;
                    this.summoner.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 22, 3, false, false));
                    this.summoner.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 22, 32, false, false));
                    this.summoner.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 22, this.strengthAmplifier + i, false, false));
                    this.summoner.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 22, 5, false, false));
                }
                this.func_70107_b(this.summoner.field_70165_t, this.summoner.field_70163_u, this.summoner.field_70161_v);
                if (this.field_70146_Z.nextInt(8) == 0) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:electricity")), 0.1f, this.field_70146_Z.nextFloat() * 0.6f + 0.3f);
                }
                EntityLightningArc.spawnAsParticle(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.3, this.field_70163_u + this.field_70146_Z.nextDouble() * 1.3, this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.3, 0.5, 0.0, 0.15, 0.0, new int[0]);
                Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 20, 0.3, 0.0, 0.3, 0.0, 0.5, 0.0, 545313023, 50, 5, 240, this.summoner.func_145782_y());
                if (this.summoner.field_110158_av == 1 && this.summoner instanceof EntityPlayer) {
                    Entity target = ProcedureUtils.objectEntityLookingAt((Entity)this.summoner, (double)3.0, (Entity)this).field_72308_g;
                    if (target == null && (target = ProcedureUtils.objectEntityLookingAt((Entity)this.summoner, (double)12.0, (double)3.0, (Entity)this).field_72308_g) instanceof EntityLivingBase) {
                        Vec3d vec = target.func_174824_e(1.0f).func_178788_d(this.summoner.func_174824_e(1.0f)).func_72432_b();
                        this.summoner.field_70177_z = ProcedureUtils.getYawFromVec(vec);
                        this.summoner.field_70125_A = ProcedureUtils.getPitchFromVec(vec);
                        this.summoner.func_70634_a(target.field_70165_t - vec.field_72450_a, target.field_70163_u - vec.field_72448_b + 0.5, target.field_70161_v - vec.field_72449_c);
                        ((EntityPlayer)this.summoner).func_71059_n(target);
                    }
                    if (target instanceof EntityLivingBase) {
                        ProcedureUtils.pushEntity((Entity)this.summoner, target, 12.0, 1.5f);
                    }
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        private void setNewCooldown() {
            if (this.usingItemstack != null && this.summoner != null) {
                ItemStack stack;
                ItemStack itemStack = stack = this.summoner instanceof EntityPlayer ? ProcedureUtils.getMatchingItemStack((EntityPlayer)this.summoner, this.usingItemstack) : this.usingItemstack;
                if (stack != null) {
                    ItemJutsu.Base item = (ItemJutsu.Base)stack.func_77973_b();
                    item.setJutsuCooldown(stack, CHAKRAMODE, (long)((float)this.field_70173_aa * item.getModifier(stack, this.summoner)) + 40L);
                }
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ID_KEY = "EntityChakraModeIdKey";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Entity entity1 = entity.field_70170_p.func_73045_a(stack.func_77978_p().func_74762_e(ID_KEY));
                if (entity1 instanceof EntityChakraMode) {
                    entity1.func_70106_y();
                    stack.func_77978_p().func_82580_o(ID_KEY);
                    return false;
                }
                if (ItemFuton.CHAKRAFLOW.jutsu.isActivated(entity)) {
                    ItemFuton.CHAKRAFLOW.jutsu.deactivate(entity);
                }
                entity1 = new EntityChakraMode(entity, stack);
                entity.field_70170_p.func_72838_d(entity1);
                stack.func_77978_p().func_74768_a(ID_KEY, entity1.func_145782_y());
                return true;
            }

            @Override
            public boolean isActivated(EntityLivingBase entity) {
                return this.getData(entity) != null;
            }

            @Override
            public void deactivate(EntityLivingBase entity) {
                ItemJutsu.IJutsuCallback.JutsuData jd = this.getData(entity);
                if (jd != null) {
                    jd.entity.func_70106_y();
                    jd.stack.func_77978_p().func_82580_o(ID_KEY);
                }
            }

            @Override
            @Nullable
            public ItemJutsu.IJutsuCallback.JutsuData getData(EntityLivingBase entity) {
                ItemStack stack;
                if (entity instanceof EntityPlayer && (stack = ProcedureUtils.getMatchingItemStack((EntityPlayer)entity, block)) != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(ID_KEY)) {
                    Entity entity1 = entity.field_70170_p.func_73045_a(stack.func_77978_p().func_74762_e(ID_KEY));
                    return entity1 instanceof EntityChakraMode ? new ItemJutsu.IJutsuCallback.JutsuData(entity1, stack) : null;
                }
                return null;
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.RAITON, list);
            this.func_77655_b("raiton");
            this.setRegistryName("raiton");
            this.func_77637_a(TabModTab.tab);
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == CHASINGDOG) {
                return this.getPower(stack, entity, timeLeft, 4.0f, 30.0f);
            }
            if (jutsu == GIAN) {
                return this.getPower(stack, entity, timeLeft, 1.0f, 150.0f);
            }
            if (jutsu == KIRIN) {
                return this.getPower(stack, entity, timeLeft, 0.0f, 400.0f);
            }
            if (jutsu == BLACKPANTHER) {
                return this.getPower(stack, entity, timeLeft, 0.0f, 100.0f);
            }
            return 1.0f;
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            float f = super.getMaxPower(stack, entity);
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == KIRIN) {
                return Math.min(f, 1.0f);
            }
            if (jutsu == BLACKPANTHER) {
                return Math.min(f, 5.0f);
            }
            return f;
        }

        @Override
        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (!world.field_72995_K && entity instanceof EntityPlayer && entity.field_70173_aa % 10 == 3 && ((RangedItem)itemstack.func_77973_b()).canUseJutsu(itemstack, CHIDORI, (EntityLivingBase)((EntityPlayer)entity)) && ((RangedItem)itemstack.func_77973_b()).getXpRatio(itemstack, CHIDORI) >= 1.0f && !this.isJutsuEnabled(itemstack, KIRIN)) {
                this.enableJutsu(itemstack, KIRIN, true);
                ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("chattext.jutsu.enabled", new Object[]{KIRIN.getName()}), false);
            }
        }

        @Override
        public void onUsingTick(ItemStack stack, EntityLivingBase player, int timeLeft) {
            if (!player.field_70170_p.field_72995_K) {
                ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
                if (jutsu == KIRIN) {
                    EntityKirin.chargingEffects(player, this.getPower(stack, player, timeLeft));
                } else if (jutsu == BLACKPANTHER) {
                    EntityLightningArc.spawnAsParticle(player.field_70170_p, player.field_70165_t + field_77697_d.nextGaussian() * 0.3, player.field_70163_u + field_77697_d.nextDouble() * 1.3, player.field_70161_v + field_77697_d.nextGaussian() * 0.3, 1.0, 0.0, 0.15, 0.0, 0);
                    Particles.spawnParticle(player.field_70170_p, Particles.Types.SMOKE, player.field_70165_t, player.field_70163_u, player.field_70161_v, 20, 0.3, 0.0, 0.3, 0.0, 0.5, 0.0, 0x20000000, 50, 5, 240, player.func_145782_y());
                }
            }
            super.onUsingTick(stack, player, timeLeft);
        }

        @Override
        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            ActionResult<ItemStack> result = super.func_77659_a(world, entity, hand);
            if (result.func_188397_a() == EnumActionResult.SUCCESS && this.getCurrentJutsu(entity.func_184586_b(hand)) == KIRIN && !world.field_72995_K) {
                EntityKirin.startWeatherThunder((Entity)entity);
            }
            return result;
        }
    }
}

