/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityLaserCircus;
import net.narutomod.entity.EntityLightningArc;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemRaiton;
import net.narutomod.item.ItemSuiton;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemRanton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:ranton")
    public static final Item block = null;
    public static final int ENTITYID = 278;
    public static final ItemJutsu.JutsuEnum CLOUD = new ItemJutsu.JutsuEnum(0, "rantoncloud", 'S', 1.0, (ItemJutsu.IJutsuCallback)new EntityRaiunkuha.Jutsu());
    public static final ItemJutsu.JutsuEnum LASERCIRCUS = new ItemJutsu.JutsuEnum(1, "laser_circus", 'S', 100.0, (ItemJutsu.IJutsuCallback)new EntityLaserCircus.EC.Jutsu());

    public ItemRanton(ElementsNarutomodMod instance) {
        super(instance, 597);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(CLOUD, LASERCIRCUS));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityRaiunkuha.class).id(new ResourceLocation("narutomod", "rantoncloud"), 278).name("rantoncloud").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:ranton", "inventory"));
    }

    public static class EntityRaiunkuha
    extends Entity {
        private final double chakrUsage;
        private EntityLivingBase summoner;
        private float damageMultiplier;

        public EntityRaiunkuha(World a) {
            super(a);
            this.chakrUsage = ItemRanton.CLOUD.chakraUsage;
            this.func_70105_a(0.01f, 0.01f);
        }

        protected EntityRaiunkuha(EntityLivingBase summonerIn, ItemStack stack) {
            this(summonerIn.field_70170_p);
            this.func_70105_a(0.01f, 0.01f);
            this.summoner = summonerIn;
            this.damageMultiplier = Math.max(((ItemJutsu.Base)stack.func_77973_b()).getXpRatio(stack, CLOUD), 1.0f);
            this.func_70107_b(summonerIn.field_70165_t, summonerIn.field_70163_u, summonerIn.field_70161_v);
        }

        protected void func_70088_a() {
        }

        public void func_70071_h_() {
            if (this.summoner != null && this.summoner.func_70089_S() && Chakra.pathway(this.summoner).consume(this.chakrUsage)) {
                this.func_70107_b(this.summoner.field_70165_t, this.summoner.field_70163_u, this.summoner.field_70161_v);
                if (this.field_70146_Z.nextInt(20) == 0) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:electricity")), 0.1f, this.field_70146_Z.nextFloat() * 0.6f + 0.3f);
                }
                EntityLightningArc.spawnAsParticle(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 2.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 1.6, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 1.2, 0.0, 0.0, 0.0, new int[0]);
                Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u + 0.9, this.field_70161_v, 100, 0.4, 0.6, 0.4, 0.0, 0.0, 0.0, -13619152, 30, 0, 0, this.summoner.func_145782_y(), 0);
                for (EntityLivingBase entity1 : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.summoner.func_174813_aQ().func_186662_g(4.0))) {
                    if (entity1.equals((Object)this.summoner) || !entity1.func_70089_S()) continue;
                    this.setLightningOn(entity1);
                }
                RayTraceResult res = ProcedureUtils.objectEntityLookingAt((Entity)this.summoner, 10.0);
                if (res != null && res.field_72308_g instanceof EntityLivingBase) {
                    this.setLightningOn((EntityLivingBase)res.field_72308_g);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        private void setLightningOn(EntityLivingBase entity) {
            EntityLightningArc.Base entity2 = new EntityLightningArc.Base(this.field_70170_p, this.func_174791_d().func_72441_c(0.0, 1.0, 0.0), entity.func_174791_d().func_72441_c(0.0, (double)(entity.field_70131_O / 2.0f), 0.0), -1073741569, 1, 0.0f);
            entity2.setDamage(ItemJutsu.causeJutsuDamage(this, this.summoner), this.getDamage(), this.summoner, 0);
            this.field_70170_p.func_72838_d((Entity)entity2);
        }

        private float getDamage() {
            return this.field_70146_Z.nextFloat() * this.damageMultiplier * 10.0f;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String RaiunkuhaID = "RaiunkuhaEntityId";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Entity entity1 = entity.field_70170_p.func_73045_a(stack.func_77978_p().func_74762_e(RaiunkuhaID));
                if (entity1 instanceof EntityRaiunkuha) {
                    entity1.func_70106_y();
                    stack.func_77978_p().func_82580_o(RaiunkuhaID);
                    return false;
                }
                entity1 = new EntityRaiunkuha(entity, stack);
                entity.field_70170_p.func_72838_d(entity1);
                stack.func_77978_p().func_74768_a(RaiunkuhaID, entity1.func_145782_y());
                return true;
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.RANTON, list);
            this.func_77655_b("ranton");
            this.setRegistryName("ranton");
            this.func_77637_a(TabModTab.tab);
            this.defaultCooldownMap[ItemRanton.CLOUD.index] = 0L;
            this.defaultCooldownMap[ItemRanton.LASERCIRCUS.index] = 0L;
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            if (this.getCurrentJutsu(stack) == LASERCIRCUS) {
                return this.getPower(stack, entity, timeLeft, 0.1f, 50.0f);
            }
            return 1.0f;
        }

        @Override
        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            ItemStack stack = entity.func_184586_b(hand);
            if (entity.func_184812_l_() || ProcedureUtils.hasItemInInventory(entity, ItemRaiton.block) && ProcedureUtils.hasItemInInventory(entity, ItemSuiton.block)) {
                ActionResult<ItemStack> result = super.func_77659_a(world, entity, hand);
                if (!world.field_72995_K && result.func_188397_a() == EnumActionResult.SUCCESS && this.getCurrentJutsu(stack) == LASERCIRCUS && !EntityLaserCircus.ringSpawned(world, stack)) {
                    world.func_72838_d((Entity)new EntityLaserCircus.EntityRing((EntityLivingBase)entity, stack));
                }
                return result;
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }

        @Override
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.ranton.musthave") + TextFormatting.RESET);
        }
    }
}

