/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityBijuManager;
import net.narutomod.entity.EntityBuddha1000;
import net.narutomod.entity.EntityRasengan;
import net.narutomod.entity.EntityRasenshuriken;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntitySnake8Heads;
import net.narutomod.gui.overlay.OverlayChakraDisplay;
import net.narutomod.item.ItemFuton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemMokuton;
import net.narutomod.item.ItemNinjutsu;
import net.narutomod.item.ItemOnBody;
import net.narutomod.procedure.ProcedureOnLeftClickEmpty;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemSenjutsu
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:senjutsu")
    public static final Item block = null;
    public static final int ENTITYID = 355;
    private static final String SAGEMODEACTIVATEDKEY = "SageModeActivated";
    private static final String SAGECHAKRADEPLETIONAMOUNT = "SageChakraDepletionAmount";
    public static final ItemJutsu.JutsuEnum SAGEMODE = new ItemJutsu.JutsuEnum(0, "tooltip.senjutsu.sagemode", 'S', 10.0, (ItemJutsu.IJutsuCallback)new SageMode());
    public static final ItemJutsu.JutsuEnum RASENGAN = new ItemJutsu.JutsuEnum(1, "tooltip.senjutsu.rasengan", 'S', ItemNinjutsu.RASENGAN.chakraUsage, (ItemJutsu.IJutsuCallback)new EntityRasengan.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum RASENSHURIKEN = new ItemJutsu.JutsuEnum(2, "tooltip.senjutsu.rasenshuriken", 'S', ItemFuton.RASENSHURIKEN.chakraUsage, (ItemJutsu.IJutsuCallback)new EntityRasenshuriken.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum WOODBUDDHA = new ItemJutsu.JutsuEnum(3, "buddha_1000", 'S', 5000.0, (ItemJutsu.IJutsuCallback)new EntityBuddha1000.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum SNAKE8H = new ItemJutsu.JutsuEnum(4, "snake_8_heads", 'S', 3000.0, (ItemJutsu.IJutsuCallback)new EntitySnake8Heads.EC.Jutsu());
    private static final Random RAND = new Random();

    public ItemSenjutsu(ElementsNarutomodMod instance) {
        super(instance, 710);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(SAGEMODE, RASENGAN, RASENSHURIKEN, WOODBUDDHA, SNAKE8H));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntitySitPlatform.class).id(new ResourceLocation("narutomod", "entitybulletsenjutsu"), 355).name("entitybulletsenjutsu").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:senjutsu", "inventory"));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHook());
        ProcedureOnLeftClickEmpty.addQualifiedItem(block, EnumHand.MAIN_HAND);
    }

    public static boolean isSageModeActivated(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(SAGEMODEACTIVATEDKEY);
    }

    public static boolean isSageModeActivated(EntityPlayer entity) {
        ItemStack stack = ProcedureUtils.getMatchingItemStack(entity, block);
        return stack != null ? ItemSenjutsu.isSageModeActivated(stack) : false;
    }

    public static void deactivateSageMode(EntityLivingBase entity) {
        ItemStack stack;
        if (entity instanceof EntityPlayer && (stack = ProcedureUtils.getMatchingItemStack((EntityPlayer)entity, block)) != null && ItemSenjutsu.isSageModeActivated(stack)) {
            ItemSenjutsu.deactivateSageMode(stack, entity);
        }
    }

    private static void deactivateSageMode(ItemStack stack, EntityLivingBase entity) {
        if (stack.func_77942_o()) {
            Chakra.Pathway cp = Chakra.pathway(entity);
            double d = stack.func_77978_p().func_74769_h(SAGECHAKRADEPLETIONAMOUNT);
            if (d > 0.0 && cp.getAmount() > d) {
                cp.consume(cp.getAmount() - d);
            }
            stack.func_77978_p().func_82580_o(SAGEMODEACTIVATEDKEY);
            stack.func_77978_p().func_82580_o(SAGECHAKRADEPLETIONAMOUNT);
        }
        if (entity instanceof EntityPlayerMP) {
            OverlayChakraDisplay.ShowFlamesMessage.send((EntityPlayerMP)entity, false);
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntitySitPlatform.class, renderManager -> new Render(renderManager){

                public void func_76986_a(Entity entity, double x, double y, double z, float entityYaw, float partialTicks) {
                }

                protected ResourceLocation func_110775_a(Entity entity) {
                    return null;
                }
            });
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelHelmetSnug
        extends ModelBiped {
            private final ModelRenderer highlight;

            public ModelHelmetSnug() {
                this.field_78090_t = 64;
                this.field_78089_u = 16;
                this.field_78116_c = new ModelRenderer((ModelBase)this);
                this.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_78116_c.field_78804_l.add(new ModelBox(this.field_78116_c, 0, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.02f, false));
                this.highlight = new ModelRenderer((ModelBase)this);
                this.highlight.func_78793_a(0.0f, 0.0f, 0.0f);
                this.highlight.field_78804_l.add(new ModelBox(this.highlight, 24, 0, -4.0f, -8.0f, -4.15f, 8, 8, 0, 0.0f, false));
                this.field_178720_f = new ModelRenderer((ModelBase)this);
                this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_178720_f.field_78804_l.add(new ModelBox(this.field_178720_f, 32, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.2f, false));
            }

            public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
                this.field_78115_e.field_78806_j = false;
                this.field_178724_i.field_78806_j = false;
                this.field_178722_k.field_78806_j = false;
                this.field_178723_h.field_78806_j = false;
                this.field_178721_j.field_78806_j = false;
                GlStateManager.func_179147_l();
                super.func_78088_a(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179084_k();
            }
        }
    }

    public static enum Type {
        NONE("none", 0),
        TOAD("toad", 1),
        SNAKE("snake", 2),
        SLUG("slug", 3);

        private final String name;
        private final int id;
        private static final Map<Integer, Type> TYPES_BY_ID;
        private static final Map<String, Type> TYPES_BY_NAME;

        private Type(String s, int i) {
            this.name = s;
            this.id = i;
        }

        public String getLocalizedName() {
            return new TextComponentTranslation("entity." + this.name + ".name", new Object[0]).func_150261_e();
        }

        public int getID() {
            return this.id;
        }

        public static Type random() {
            return Type.getTypeFromId(1 + RAND.nextInt(3));
        }

        public static Type getTypeFromId(int id) {
            return TYPES_BY_ID.containsKey(id) ? TYPES_BY_ID.get(id) : NONE;
        }

        public static Type getTypeFromName(String s) {
            return TYPES_BY_NAME.containsKey(s) ? TYPES_BY_NAME.get(s) : NONE;
        }

        static {
            TYPES_BY_ID = Maps.newHashMap();
            TYPES_BY_NAME = Maps.newHashMap();
            for (Type type : Type.values()) {
                TYPES_BY_ID.put(type.getID(), type);
                TYPES_BY_NAME.put(type.name, type);
            }
        }
    }

    public static class EntitySitPlatform
    extends Entity {
        public EntitySitPlatform(World w) {
            super(w);
            this.func_70105_a(1.0f, 0.01f);
        }

        public EntitySitPlatform(EntityLivingBase entity) {
            this(entity.field_70170_p);
            this.func_70012_b(entity.field_70165_t, entity.field_70163_u + 0.1, entity.field_70161_v, entity.field_70177_z, 0.0f);
            entity.func_184220_m((Entity)this);
        }

        protected void func_70088_a() {
        }

        public double func_70042_X() {
            return -0.25;
        }

        public void func_70071_h_() {
            this.func_70091_d(MoverType.SELF, 0.0, this.field_70181_x, 0.0);
            this.field_70181_x = this.field_70122_E ? 0.0 : this.field_70181_x - 0.08;
            this.field_70181_x *= 0.98;
            if (!this.field_70170_p.field_72995_K && !this.func_184207_aI()) {
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }
    }

    public static class SageMode
    implements ItemJutsu.IJutsuCallback {
        @Override
        public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
            if (power >= 100.0f) {
                Chakra.Pathway cp = Chakra.pathway(entity);
                stack.func_77978_p().func_74780_a(ItemSenjutsu.SAGECHAKRADEPLETIONAMOUNT, cp.getAmount());
                float f = stack.func_77973_b() == block && ((RangedItem)stack.func_77973_b()).getCurrentJutsu(stack) == SAGEMODE ? ((RangedItem)stack.func_77973_b()).getCurrentJutsuXpModifier(stack, entity) : 1.0f;
                cp.consume(-0.6f / f, true);
                stack.func_77978_p().func_74757_a(ItemSenjutsu.SAGEMODEACTIVATEDKEY, true);
                if (entity instanceof EntityPlayerMP) {
                    OverlayChakraDisplay.ShowFlamesMessage.send((EntityPlayerMP)entity, true);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isActivated(ItemStack stack) {
            return ItemSenjutsu.isSageModeActivated(stack);
        }
    }

    public static class EventHook {
        @SubscribeEvent
        public void onDeath(LivingDeathEvent event) {
            ItemSenjutsu.deactivateSageMode(event.getEntityLiving());
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.player.field_70170_p.field_72995_K) {
                ItemSenjutsu.deactivateSageMode((EntityLivingBase)event.player);
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base
    implements ItemOnBody.Interface {
        private static final String TYPEKEY = "SageType";
        private static final Map<IAttribute, AttributeModifier> buffMap = ImmutableMap.builder().put((Object)EntityPlayer.REACH_DISTANCE, (Object)new AttributeModifier(UUID.fromString("c3ee1250-8b80-4668-b58a-33af5ea73ee6"), "sagemode.reach", 2.0, 0)).put((Object)SharedMonsterAttributes.field_111264_e, (Object)new AttributeModifier(UUID.fromString("6d6202e1-9aac-4c3d-ba0c-6684bdd58868"), "sagemode.damage", 60.0, 0)).put((Object)SharedMonsterAttributes.field_188790_f, (Object)new AttributeModifier(UUID.fromString("33b7fa14-828a-4964-b014-b61863526589"), "sagemode.damagespeed", 2.0, 1)).put((Object)SharedMonsterAttributes.field_111263_d, (Object)new AttributeModifier(UUID.fromString("74f3ab51-a73f-45e3-a4c4-aae6974b6414"), "sagemode.movement", 1.5, 1)).put((Object)SharedMonsterAttributes.field_111267_a, (Object)new AttributeModifier(UUID.fromString("70e0acc2-cf75-4bbd-a21a-753088324a59"), "sagemode.health", 80.0, 0)).build();
        @SideOnly(value=Side.CLIENT)
        private ModelBiped armorModel;

        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.SENJUTSU, list);
            this.func_77655_b("senjutsu");
            this.setRegistryName("senjutsu");
            this.func_77637_a(TabModTab.tab);
        }

        public void setSageType(ItemStack stack, Type type) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74768_a(TYPEKEY, type.getID());
        }

        public Type getSageType(ItemStack stack) {
            return stack.func_77942_o() ? Type.getTypeFromId(stack.func_77978_p().func_74762_e(TYPEKEY)) : Type.NONE;
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            float f = super.getMaxPower(stack, entity);
            if (jutsu == RASENGAN) {
                return Math.min(f, 6.0f);
            }
            if (jutsu == RASENSHURIKEN) {
                return Math.min(f, 6.0f);
            }
            return Math.min(f, 100.0f);
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == RASENGAN) {
                return this.getPower(stack, entity, timeLeft, 2.9f, 200.0f);
            }
            if (jutsu == RASENSHURIKEN) {
                return this.getPower(stack, entity, timeLeft, 1.9f, 300.0f);
            }
            if (jutsu == SAGEMODE) {
                return this.getPower(stack, entity, timeLeft, 0.0f, 20.0f);
            }
            return 1.0f;
        }

        @Override
        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                Type sageType = this.getSageType(itemstack);
                if (sageType == Type.NONE) {
                    Type forcedType;
                    Type type = itemstack.func_77942_o() && itemstack.func_77978_p().func_150297_b("Type", 8) ? Type.getTypeFromName(itemstack.func_77978_p().func_74779_i("Type")) : (forcedType = entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_() ? Type.random() : Type.NONE);
                    if (forcedType != Type.NONE) {
                        this.setSageType(itemstack, forcedType);
                        this.enableJutsu(itemstack, SAGEMODE, true);
                        sageType = forcedType;
                    } else {
                        return;
                    }
                }
                EntityLivingBase living = (EntityLivingBase)entity;
                boolean flag = ItemSenjutsu.isSageModeActivated(itemstack);
                boolean flag1 = living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_180374_a(buffMap.get(SharedMonsterAttributes.field_111267_a));
                if (flag && !flag1) {
                    for (Map.Entry<IAttribute, AttributeModifier> entry : buffMap.entrySet()) {
                        IAttributeInstance attr = living.func_110148_a(entry.getKey());
                        if (attr == null) continue;
                        attr.func_111121_a(entry.getValue());
                    }
                    if (entity instanceof EntityPlayer) {
                        itemstack.func_77978_p().func_74768_a("prevFoodStat", ((EntityPlayer)entity).func_71024_bL().func_75116_a());
                    }
                } else if (!flag && flag1) {
                    for (Map.Entry<IAttribute, AttributeModifier> entry : buffMap.entrySet()) {
                        IAttributeInstance attr = living.func_110148_a(entry.getKey());
                        if (attr == null) continue;
                        attr.func_188479_b(entry.getValue().func_111167_a());
                    }
                    if (entity instanceof EntityPlayer) {
                        ((EntityPlayer)entity).func_71024_bL().func_75114_a(itemstack.func_77978_p().func_74762_e("prevFoodStat") - 5);
                    }
                }
                if (flag) {
                    Chakra.Pathway cp = Chakra.pathway(living);
                    if (cp.getAmount() < itemstack.func_77978_p().func_74769_h(ItemSenjutsu.SAGECHAKRADEPLETIONAMOUNT)) {
                        ItemSenjutsu.deactivateSageMode(itemstack, living);
                    } else if (living.field_70173_aa % 20 == 10) {
                        living.func_70690_d(new PotionEffect(MobEffects.field_76443_y, 22, 0, false, false));
                        cp.consume(50.0);
                    }
                }
                if (entity.field_70173_aa % 40 == 5 && entity instanceof EntityPlayer) {
                    ItemStack stack1 = ProcedureUtils.getMatchingItemStack((EntityPlayer)entity, ItemNinjutsu.block);
                    this.enableJutsu(itemstack, RASENGAN, stack1 != null && ((ItemNinjutsu.RangedItem)stack1.func_77973_b()).canUseJutsu(stack1, ItemNinjutsu.RASENGAN, living));
                    stack1 = ProcedureUtils.getMatchingItemStack((EntityPlayer)entity, ItemFuton.block);
                    this.enableJutsu(itemstack, RASENSHURIKEN, stack1 != null && ((ItemFuton.RangedItem)stack1.func_77973_b()).canUseJutsu(stack1, ItemFuton.RASENSHURIKEN, living));
                    stack1 = ProcedureUtils.getMatchingItemStack((EntityPlayer)entity, ItemMokuton.block);
                    this.enableJutsu(itemstack, WOODBUDDHA, stack1 != null && ((ItemMokuton.ItemCustom)stack1.func_77973_b()).canUseJutsu(stack1, ItemMokuton.GOLEM, living));
                    this.enableJutsu(itemstack, SNAKE8H, sageType == Type.SNAKE);
                }
            }
        }

        @Override
        public void func_77615_a(ItemStack itemstack, World world, EntityLivingBase entity, int timeLeft) {
            if (this.getCurrentJutsu(itemstack) == SAGEMODE) {
                if (!world.field_72995_K && entity.func_184187_bx() instanceof EntitySitPlatform) {
                    entity.func_184210_p();
                    super.func_77615_a(itemstack, world, entity, timeLeft);
                }
            } else {
                super.func_77615_a(itemstack, world, entity, timeLeft);
            }
        }

        @Override
        public void onUsingTick(ItemStack stack, EntityLivingBase player, int timeLeft) {
            if (!player.field_70170_p.field_72995_K && this.getCurrentJutsu(stack) == SAGEMODE && !(player.func_184187_bx() instanceof EntitySitPlatform)) {
                player.func_184602_cy();
            } else {
                super.onUsingTick(stack, player, timeLeft);
            }
        }

        @Override
        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            ItemStack stack = entity.func_184586_b(hand);
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == SAGEMODE && ItemSenjutsu.isSageModeActivated(stack)) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            if (jutsu != SAGEMODE && !ItemSenjutsu.isSageModeActivated(stack)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            ActionResult<ItemStack> res = super.func_77659_a(world, entity, hand);
            if (jutsu == SAGEMODE && res.func_188397_a() == EnumActionResult.SUCCESS && !world.field_72995_K) {
                if (EntityBijuManager.cloakLevel(entity) > 0 && EntityBijuManager.getCloakXp(entity, 1) < 800) {
                    entity.func_146105_b((ITextComponent)new TextComponentTranslation("chattext.senjutsu.denied", new Object[]{EntityBijuManager.getNameOfJinchurikisBiju(entity)}), true);
                    return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
                entity.field_70170_p.func_72838_d((Entity)new EntitySitPlatform((EntityLivingBase)entity));
            }
            return res;
        }

        public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer attacker, Entity target) {
            if (attacker.equals((Object)target) && this.getSageType(itemstack) == Type.TOAD && ItemSenjutsu.isSageModeActivated(itemstack) && (target = ProcedureUtils.objectEntityLookingAt((Entity)attacker, (double)ProcedureUtils.getReachDistance((EntityLivingBase)attacker), (double)3.0).field_72308_g) == null && (target = ProcedureUtils.objectEntityLookingAt((Entity)attacker, (double)ProcedureUtils.getReachDistance((EntityLivingBase)attacker), (double)4.5).field_72308_g) != null) {
                attacker.func_71059_n(target);
            }
            return super.onLeftClickEntity(itemstack, attacker, target);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            Type type = this.getSageType(itemstack);
            if (type != Type.NONE) {
                list.add(TextFormatting.BLUE + new TextComponentTranslation("tooltip.senjutsu.type", new Object[0]).func_150261_e() + type.getLocalizedName() + TextFormatting.RESET);
            }
            super.func_77624_a(itemstack, world, list, flag);
        }

        @SideOnly(value=Side.CLIENT)
        public ModelBiped getArmorModel(EntityLivingBase living, ItemStack stack, EntityEquipmentSlot slot, ModelBiped defaultModel) {
            if (ItemSenjutsu.isSageModeActivated(stack)) {
                if (this.armorModel == null) {
                    this.armorModel = new Renderer().new Renderer.ModelHelmetSnug();
                }
                this.armorModel.field_78117_n = living.func_70093_af();
                this.armorModel.field_78093_q = living.func_184218_aH();
                this.armorModel.field_78091_s = living.func_70631_g_();
                return this.armorModel;
            }
            return null;
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
            switch (this.getSageType(stack)) {
                case TOAD: {
                    return "narutomod:textures/sagetoadhelmet.png";
                }
                case SNAKE: {
                    return "narutomod:textures/sagesnakehelmet.png";
                }
                case SLUG: {
                    return "narutomod:textures/sageslughelmet.png";
                }
            }
            return null;
        }

        @Override
        public boolean showSkinLayer() {
            return true;
        }

        @Override
        public ItemOnBody.BodyPart showOnBody() {
            return ItemOnBody.BodyPart.NONE;
        }
    }
}

