/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityEnma;
import net.narutomod.entity.EntityGamabunta;
import net.narutomod.entity.EntityManda;
import net.narutomod.entity.EntitySlug;
import net.narutomod.entity.EntitySnake;
import net.narutomod.entity.EntityToad;
import net.narutomod.event.SpecialEvent;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemOnBody;
import net.narutomod.procedure.ProcedureOnLeftClickEmpty;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemSummoningContract
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:summoning_contract")
    public static final Item block = null;
    public static final int ENTITYID = 353;
    public static final int ENTITY2ID = 354;
    public static final int ENTITY3ID = 333;
    public static final int ENTITY4ID = 334;
    public static final String SUMMON_RALLY = "SummonRallyPoint";
    public static final ItemJutsu.JutsuEnum SUMMONTOAD = new ItemJutsu.JutsuEnum(0, "toad_summon", 'C', 100.0, (ItemJutsu.IJutsuCallback)new EntityGenericToad.Jutsu());
    public static final ItemJutsu.JutsuEnum SUMMONSNAKE = new ItemJutsu.JutsuEnum(1, "snake_summon", 'C', 100.0, (ItemJutsu.IJutsuCallback)new EntityGenericSnake.Jutsu());
    public static final ItemJutsu.JutsuEnum SUMMONSLUG = new ItemJutsu.JutsuEnum(2, "slug", 'C', 100.0, (ItemJutsu.IJutsuCallback)new EntitySlug.Jutsu());
    public static final ItemJutsu.JutsuEnum SUMMONENMA = new ItemJutsu.JutsuEnum(3, "enma", 'C', 100.0, (ItemJutsu.IJutsuCallback)new EntityEnma.EC.Jutsu());

    public ItemSummoningContract(ElementsNarutomodMod instance) {
        super(instance, 718);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new ItemCustom(SUMMONTOAD, SUMMONSNAKE, SUMMONSLUG, SUMMONENMA));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityGenericToad.class).id(new ResourceLocation("narutomod", "toad_summon"), 353).name("toad_summon").tracker(96, 3, true).egg(-1, -1).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityGenericSnake.class).id(new ResourceLocation("narutomod", "snake_summon"), 354).name("snake_summon").tracker(96, 3, true).egg(-1, -1).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:summoning_contract", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityGenericToad.class, renderManager -> new EntityToad.RenderCustom<EntityGenericToad>(renderManager){
            private final ResourceLocation texture;
            {
                this.texture = new ResourceLocation("narutomod:textures/toad1.png");
            }

            protected void renderModel(EntityGenericToad entity, float f1, float f2, float f3, float f4, float f5, float f6) {
                ((EntityToad.ModelToad)this.field_77045_g).showPipe(false);
                super.func_77036_a((EntityLivingBase)entity, f1, f2, f3, f4, f5, f6);
            }

            @Override
            protected ResourceLocation getEntityTexture(EntityGenericToad entity) {
                return this.texture;
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityGenericSnake.class, renderManager -> new EntitySnake.RenderSnake<EntityGenericSnake>(renderManager){
            private final ResourceLocation texture1;
            private final ResourceLocation texture2;
            {
                this.texture1 = new ResourceLocation("narutomod:textures/snake_white.png");
                this.texture2 = new ResourceLocation("narutomod:textures/snake_blue.png");
            }

            @Override
            protected ResourceLocation getEntityTexture(EntityGenericSnake entity) {
                return entity.getScale() > 4.0f ? this.texture2 : this.texture1;
            }
        });
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ProcedureOnLeftClickEmpty.addQualifiedItem(block, EnumHand.MAIN_HAND);
    }

    public static class EntityGenericSnake
    extends EntitySnake.EntityCustom {
        public EntityGenericSnake(World w) {
            super(w);
            this.postScaleFixup();
        }

        public EntityGenericSnake(EntityLivingBase entity, float size) {
            super(entity);
            this.setScale(size);
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            EntityLivingBase owner = this.getSummoner();
            if (owner != null && !owner.func_184218_aH() && this.getAge() == 1 && this.getScale() >= 4.0f) {
                owner.func_184220_m((Entity)this);
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Particles.spawnParticle(entity.field_70170_p, Particles.Types.SEAL_FORMULA, entity.field_70165_t, entity.field_70163_u + 0.015, entity.field_70161_v, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, (int)(power * 40.0f), 0, 60);
                for (int i = 0; i < 500; ++i) {
                    Particles.spawnParticle(entity.field_70170_p, Particles.Types.SMOKE, entity.field_70165_t, entity.field_70163_u + 0.015, entity.field_70161_v, 1, 0.0, 0.0, 0.0, (entity.func_70681_au().nextDouble() - 0.5) * 0.8, entity.func_70681_au().nextDouble() * 0.6 + 0.2, (entity.func_70681_au().nextDouble() - 0.5) * 0.8, -788529153, (int)(power * 30.0f));
                }
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:kuchiyosenojutsu")), SoundCategory.PLAYERS, 1.0f, 0.8f);
                EntitySnake.EntityCustom entity1 = power >= 18.0f ? new EntityManda.EntityCustom(entity) : new EntityGenericSnake(entity, power);
                entity1.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
                SpecialEvent.setDelayedSpawnEvent(entity.field_70170_p, (Entity)entity1, 0, 0, 0, entity.field_70170_p.func_82737_E() + 20L);
                return true;
            }
        }
    }

    public static class EntityGenericToad
    extends EntityToad.EntityCustom {
        public EntityGenericToad(World w) {
            super(w);
            this.postScaleFixup();
        }

        public EntityGenericToad(EntityLivingBase summonerIn, float size) {
            super(summonerIn);
            this.setScale(size);
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            EntityLivingBase owner = this.getSummoner();
            if (owner != null && !owner.func_184218_aH() && this.getAge() == 1 && this.getScale() >= 4.0f) {
                owner.func_184220_m((Entity)this);
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Particles.spawnParticle(entity.field_70170_p, Particles.Types.SEAL_FORMULA, entity.field_70165_t, entity.field_70163_u + 0.015, entity.field_70161_v, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, (int)(power * 40.0f), 0, 60);
                for (int i = 0; i < 500; ++i) {
                    Particles.spawnParticle(entity.field_70170_p, Particles.Types.SMOKE, entity.field_70165_t, entity.field_70163_u + 0.015, entity.field_70161_v, 1, 0.0, 0.0, 0.0, (entity.func_70681_au().nextDouble() - 0.5) * 0.8, entity.func_70681_au().nextDouble() * 0.6 + 0.2, (entity.func_70681_au().nextDouble() - 0.5) * 0.8, -788529153, (int)(power * 30.0f));
                }
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:kuchiyosenojutsu")), SoundCategory.PLAYERS, 1.0f, 0.8f);
                EntityToad.EntityCustom entity1 = power >= 16.0f ? new EntityGamabunta.EntityCustom(entity) : new EntityGenericToad(entity, power);
                entity1.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
                SpecialEvent.setDelayedSpawnEvent(entity.field_70170_p, (Entity)entity1, 0, 0, 0, entity.field_70170_p.func_82737_E() + 20L);
                return true;
            }
        }
    }

    public static class ItemCustom
    extends ItemJutsu.Base
    implements ItemOnBody.Interface {
        public ItemCustom(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.KUCHIYOSE, list);
            this.func_77655_b("summoning_contract");
            this.setRegistryName("summoning_contract");
            this.func_77637_a(TabModTab.tab);
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            return jutsu == SUMMONENMA ? this.getPower(stack, entity, timeLeft, 0.0f, 200.0f) : this.getPower(stack, entity, timeLeft, 0.0f, 80.0f);
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            float ret = super.getMaxPower(stack, entity);
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            return jutsu == SUMMONENMA ? Math.min(ret, 1.0f) : ret;
        }

        @Override
        protected boolean executeJutsu(ItemStack stack, EntityLivingBase entity, float power) {
            return power >= 0.1f ? super.executeJutsu(stack, entity, power) : false;
        }

        public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer attacker, Entity target) {
            if (attacker.equals((Object)target)) {
                RayTraceResult res = ProcedureUtils.objectEntityLookingAt((Entity)attacker, 50.0, 3.0);
                target = res.field_72308_g;
            }
            if (target instanceof EntityLivingBase) {
                attacker.func_70604_c((EntityLivingBase)target);
            }
            return super.onLeftClickEntity(itemstack, attacker, target);
        }

        @Override
        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (!this.isAnyJutsuEnabled(itemstack) && itemstack.func_77942_o() && itemstack.func_77978_p().func_150297_b("Type", 8)) {
                String type = itemstack.func_77978_p().func_74779_i("Type");
                this.enableJutsu(itemstack, SUMMONTOAD, type.equalsIgnoreCase("toad"));
                this.enableJutsu(itemstack, SUMMONSNAKE, type.equalsIgnoreCase("snake"));
                this.enableJutsu(itemstack, SUMMONSLUG, type.equalsIgnoreCase("slug"));
                this.enableJutsu(itemstack, SUMMONENMA, type.equalsIgnoreCase("enma"));
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            if (this.isJutsuEnabled(itemstack, SUMMONTOAD)) {
                list.add(TextFormatting.BLUE + new TextComponentTranslation("entity.toad.name", new Object[0]).func_150261_e() + " " + new TextComponentTranslation("item.summoning_contract.name", new Object[0]).func_150261_e() + TextFormatting.RESET);
            } else if (this.isJutsuEnabled(itemstack, SUMMONSNAKE)) {
                list.add(TextFormatting.BLUE + new TextComponentTranslation("entity.snake.name", new Object[0]).func_150261_e() + " " + new TextComponentTranslation("item.summoning_contract.name", new Object[0]).func_150261_e() + TextFormatting.RESET);
            } else if (this.isJutsuEnabled(itemstack, SUMMONSLUG)) {
                list.add(TextFormatting.BLUE + new TextComponentTranslation("entity.slug.name", new Object[0]).func_150261_e() + " " + new TextComponentTranslation("item.summoning_contract.name", new Object[0]).func_150261_e() + TextFormatting.RESET);
            } else if (this.isJutsuEnabled(itemstack, SUMMONENMA)) {
                list.add(TextFormatting.BLUE + new TextComponentTranslation("entity.enma.name", new Object[0]).func_150261_e() + " " + new TextComponentTranslation("item.summoning_contract.name", new Object[0]).func_150261_e() + TextFormatting.RESET);
            }
            super.func_77624_a(itemstack, world, list, flag);
        }
    }
}

