/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.PlayerTracker;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.gui.GuiTeamManager;

@ElementsNarutomodMod.ModElement.Tag
public class ItemTeamScroll
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:team_scroll")
    public static final Item block = null;

    public ItemTeamScroll(ElementsNarutomodMod instance) {
        super(instance, 555);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new ItemCustom());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:team_scroll", "inventory"));
    }

    public static class ItemCustom
    extends Item {
        public ItemCustom() {
            this.func_77656_e(0);
            this.field_77777_bU = 1;
            this.func_77655_b("team_scroll");
            this.setRegistryName("team_scroll");
            this.func_77637_a(TabModTab.tab);
        }

        public int func_77619_b() {
            return 0;
        }

        public int func_77626_a(ItemStack itemstack) {
            return 0;
        }

        public float func_150893_a(ItemStack par1ItemStack, IBlockState par2Block) {
            return 0.0f;
        }

        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            ItemStack stack = entity.func_184586_b(hand);
            if (entity.func_184812_l_() || PlayerTracker.isNinja(entity)) {
                int x = (int)entity.field_70165_t;
                int y = (int)entity.field_70163_u;
                int z = (int)entity.field_70161_v;
                entity.openGui((Object)NarutomodMod.instance, GuiTeamManager.GUIID, world, x, y, z);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }

        @Nullable
        private static ScorePlayerTeam getTeamFromItem(World world, ItemStack itemstack) {
            ScorePlayerTeam team = null;
            Scoreboard scoreboard = world.func_96441_U();
            if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b("teamName")) {
                NBTTagCompound compound = itemstack.func_77978_p();
                String teamName = compound.func_74779_i("teamName");
                String teamDisplayName = compound.func_74779_i("teamDisplayName");
                team = scoreboard.func_96508_e(teamName);
                if (team == null && !world.field_72995_K) {
                    team = scoreboard.func_96527_f(teamName);
                }
                if (team != null) {
                    if (teamDisplayName != null && !team.func_96669_c().equals(teamDisplayName)) {
                        team.func_96664_a(teamDisplayName);
                    }
                    if (compound.func_150297_b("teamMembers", 9)) {
                        int j;
                        NBTTagList taglist = compound.func_150295_c("teamMembers", 10);
                        int[] shouldRemove = new int[taglist.func_74745_c()];
                        int i = 0;
                        for (j = 0; j < taglist.func_74745_c(); ++j) {
                            EntityPlayer member;
                            NBTTagCompound compound2 = taglist.func_150305_b(j);
                            if (!compound2.func_186855_b("memberUUID") || (member = world.func_152378_a(compound2.func_186857_a("memberUUID"))) == null) continue;
                            ScorePlayerTeam memberTeam = scoreboard.func_96509_i(member.func_70005_c_());
                            if (memberTeam == null && !team.func_96670_d().contains(member.func_70005_c_())) {
                                scoreboard.func_151392_a(member.func_70005_c_(), team.func_96661_b());
                                continue;
                            }
                            if (memberTeam == null || team.func_142054_a((Team)memberTeam)) continue;
                            shouldRemove[i++] = j;
                        }
                        if (i > 0) {
                            for (j = i - 1; j >= 0; --j) {
                                taglist.func_74744_a(shouldRemove[j]);
                            }
                            compound.func_74782_a("teamMembers", (NBTBase)taglist);
                        }
                    }
                }
            }
            return team;
        }

        @Nullable
        public static ScorePlayerTeam getOrCreateTeam(World world, ItemStack stack, String teamName) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_74764_b(teamName)) {
                Scoreboard scoreboard = world.func_96441_U();
                ScorePlayerTeam team = scoreboard.func_96508_e(teamName);
                if (team == null && !world.field_72995_K) {
                    team = scoreboard.func_96527_f(teamName);
                }
                if (team != null) {
                    stack.func_77978_p().func_74778_a("teamName", teamName);
                    stack.func_77978_p().func_74778_a("teamDisplayName", teamName);
                }
                return team;
            }
            return ItemCustom.getTeamFromItem(world, stack);
        }

        public static void addTeamMember(ItemStack stack, EntityPlayer player) {
            ScorePlayerTeam team = ItemCustom.getTeamFromItem(player.field_70170_p, stack);
            if (team == null) {
                team = ItemCustom.getOrCreateTeam(player.field_70170_p, stack, player.func_70005_c_());
            }
            if (team != null && !team.func_96670_d().contains(player.func_70005_c_())) {
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_96441_U().func_151392_a(player.func_70005_c_(), team.func_96661_b());
                }
                boolean flag = true;
                NBTTagCompound compound = stack.func_77978_p();
                NBTTagList taglist = compound.func_150297_b("teamMembers", 9) ? compound.func_150295_c("teamMembers", 10) : new NBTTagList();
                for (int i = 0; i < taglist.func_74745_c(); ++i) {
                    NBTTagCompound compound3 = taglist.func_150305_b(i);
                    if (!compound3.func_186855_b("memberUUID") || !compound3.func_186857_a("memberUUID").equals(player.func_110124_au())) continue;
                    flag = false;
                    break;
                }
                if (flag) {
                    NBTTagCompound compound2 = new NBTTagCompound();
                    compound2.func_186854_a("memberUUID", player.func_110124_au());
                    taglist.func_74742_a((NBTBase)compound2);
                    compound.func_74782_a("teamMembers", (NBTBase)taglist);
                }
            }
        }

        public static void removeTeamMember(ItemStack stack, EntityPlayer player) {
            ScorePlayerTeam team = ItemCustom.getTeamFromItem(player.field_70170_p, stack);
            if (team != null && team.func_96670_d().contains(player.func_70005_c_())) {
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_96441_U().func_96512_b(player.func_70005_c_(), team);
                }
                if (stack.func_77978_p().func_150297_b("teamMembers", 9)) {
                    NBTTagList taglist = stack.func_77978_p().func_150295_c("teamMembers", 10);
                    boolean flag = false;
                    for (int i = 0; i < taglist.func_74745_c(); ++i) {
                        NBTTagCompound compound3 = taglist.func_150305_b(i);
                        if (!compound3.func_186855_b("memberUUID") || !compound3.func_186857_a("memberUUID").equals(player.func_110124_au())) continue;
                        taglist.func_74744_a(i);
                        flag = true;
                        break;
                    }
                    if (flag) {
                        stack.func_77978_p().func_74782_a("teamMembers", (NBTBase)taglist);
                    }
                }
            }
        }

        public static Collection<String> getTeamMembers(World world, ItemStack stack) {
            ScorePlayerTeam team = ItemCustom.getTeamFromItem(world, stack);
            return team != null ? team.func_96670_d() : Collections.EMPTY_LIST;
        }

        public static String getTeamDisplayName(World world, ItemStack stack) {
            ScorePlayerTeam team = ItemCustom.getTeamFromItem(world, stack);
            return team != null ? team.func_96669_c() : "";
        }

        public static void setTeamDisplayName(World world, ItemStack stack, String newName) {
            ScorePlayerTeam team = ItemCustom.getTeamFromItem(world, stack);
            if (team != null) {
                if (!world.field_72995_K) {
                    team.func_96664_a(newName);
                }
                stack.func_77978_p().func_74778_a("teamDisplayName", newName);
            }
        }
    }
}

