/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.Particles;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityLavaChakraMode;
import net.narutomod.entity.EntityMeltingJutsu;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.item.ItemDoton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemKaton;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemYooton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:yooton")
    public static final Item block = null;
    public static final int ENTITYID = 270;
    public static final ItemJutsu.JutsuEnum ROCKS = new ItemJutsu.JutsuEnum(0, "magmaball", 'S', 200, 40.0, new EntityMagmaBall.Jutsu());
    public static final ItemJutsu.JutsuEnum STREAM = new ItemJutsu.JutsuEnum(1, "melting_jutsu", 'S', 200, 50.0, new EntityMeltingJutsu.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum CHAKRAMODE = new ItemJutsu.JutsuEnum(2, "lava_chakra_mode", 'S', 250, 10.0, new EntityLavaChakraMode.EC.Jutsu());

    public ItemYooton(ElementsNarutomodMod instance) {
        super(instance, 592);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(ROCKS, STREAM, CHAKRAMODE));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityMagmaBall.class).id(new ResourceLocation("narutomod", "magmaball"), 270).name("magmaball").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:yooton", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityMagmaBall.class, renderManager -> new RenderCustom(renderManager));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new RangedItem.DamageHook());
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCustom
    extends Render<EntityMagmaBall> {
        private final ResourceLocation texture;

        public RenderCustom(RenderManager renderManager) {
            super(renderManager);
            this.texture = new ResourceLocation("narutomod:textures/magmaball.png");
            this.field_76989_e = 0.1f;
        }

        public void doRender(EntityMagmaBall entity, double x, double y, double z, float entityYaw, float partialTicks) {
            this.func_180548_c(entity);
            GlStateManager.func_179094_E();
            float scale = entity.getEntityScale();
            GlStateManager.func_179137_b((double)x, (double)(y + 0.5 * (double)scale), (double)z);
            GlStateManager.func_179091_B();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179114_b((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * -this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(9.0f * (float)entity.field_70173_aa), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
            bufferbuilder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(EntityMagmaBall entity) {
            return this.texture;
        }
    }

    public static class EntityMagmaBall
    extends EntityScalableProjectile.Base {
        private int explosionSize;
        private float damage;

        public EntityMagmaBall(World a) {
            super(a);
            this.setOGSize(1.0f, 1.0f);
        }

        public EntityMagmaBall(EntityLivingBase shooter, float scale) {
            super(shooter);
            this.setOGSize(1.0f, 1.0f);
            this.setEntityScale(scale *= 1.2f);
            this.explosionSize = Math.max((int)scale - 1, 0);
            this.damage = scale * 20.0f;
            Vec3d vec3d = shooter.func_70040_Z();
            this.func_70107_b(shooter.field_70165_t + vec3d.field_72450_a, shooter.field_70163_u + 1.2 + vec3d.field_72448_b, shooter.field_70161_v + vec3d.field_72449_c);
        }

        @Override
        protected void onImpact(RayTraceResult result) {
            if (result.field_72313_a == RayTraceResult.Type.BLOCK && this.getEntityScale() >= 2.0f && this.ticksInAir <= 15) {
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.shootingEntity != null) {
                    this.shootingEntity.getEntityData().func_74780_a(NarutomodModVariables.InvulnerableTime, 40.0);
                }
                if (result.field_72308_g != null) {
                    if (result.field_72308_g.equals((Object)this.shootingEntity) || result.field_72308_g instanceof EntityMagmaBall) {
                        return;
                    }
                    result.field_72308_g.func_70097_a(ItemJutsu.causeJutsuDamage(this, this.shootingEntity).func_76361_j(), this.damage);
                    result.field_72308_g.func_70015_d(10);
                }
                boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shootingEntity);
                this.field_70170_p.func_72885_a((Entity)this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionSize, flag, flag);
                this.func_70106_y();
            }
        }

        @Override
        public void renderParticles() {
            float scale = this.getEntityScale();
            Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, (int)(scale * 10.0f), 0.3 * (double)this.field_70130_N, 0.3 * (double)this.field_70131_O, 0.3 * (double)this.field_70130_N, 0.0, 0.0, 0.0, 0x80F50000 | this.field_70146_Z.nextInt(96) << 8, 10 + (int)(scale * 10.0f), (int)(4.0 / (this.field_70146_Z.nextDouble() * 0.8 + 0.2)), 240);
        }

        @Override
        protected void checkOnGround() {
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.field_70146_Z.nextFloat() <= 0.2f) {
                this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, this.field_70146_Z.nextFloat() + 0.5f);
            }
            if (this.ticksInAir > 100 || this.func_70090_H()) {
                this.func_70106_y();
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                this.createJutsu(entity, entity.func_70040_Z().field_72450_a, entity.func_70040_Z().field_72448_b, entity.func_70040_Z().field_72449_c, power);
                return true;
            }

            public void createJutsu(EntityLivingBase entity, double x, double y, double z, float power) {
                EntityMagmaBall entityarrow = new EntityMagmaBall(entity, power);
                entityarrow.func_70186_c(x, y, z, 1.05f, 0.0f);
                entity.field_70170_p.func_72838_d((Entity)entityarrow);
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.YOOTON, list);
            this.func_77655_b("yooton");
            this.setRegistryName("yooton");
            this.func_77637_a(TabModTab.tab);
            this.defaultCooldownMap[ItemYooton.ROCKS.index] = 0L;
            this.defaultCooldownMap[ItemYooton.STREAM.index] = 0L;
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == ROCKS) {
                return this.getPower(stack, entity, timeLeft, 1.0f, 50.0f);
            }
            if (jutsu == STREAM) {
                return this.getPower(stack, entity, timeLeft, 0.5f, 200.0f);
            }
            return 1.0f;
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            float mp = super.getMaxPower(stack, entity);
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == ROCKS) {
                return Math.min(mp, 20.0f);
            }
            if (jutsu == STREAM) {
                return Math.min(mp, 10.0f);
            }
            return mp;
        }

        @Override
        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (!world.field_72995_K && entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70066_B();
            }
        }

        @Override
        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            if (entity.func_184812_l_() || ProcedureUtils.hasItemInInventory(entity, ItemDoton.block) && ProcedureUtils.hasItemInInventory(entity, ItemKaton.block)) {
                return super.func_77659_a(world, entity, hand);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)entity.func_184586_b(hand));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.yooton.musthave") + TextFormatting.RESET);
        }

        public static class DamageHook {
            @SubscribeEvent
            public void onDamage(LivingAttackEvent event) {
                EntityLivingBase entity = event.getEntityLiving();
                DamageSource source = event.getSource();
                if ((source == DamageSource.field_76371_c || source == DamageSource.field_76372_a || source == DamageSource.field_190095_e) && entity instanceof EntityPlayer && ProcedureUtils.hasItemInInventory((EntityPlayer)entity, block)) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

