/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.keybind;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.item.ItemEightGates;
import net.narutomod.procedure.ProcedureOnLivingUpdate;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class KeyBindingExtendedReachMouseEvent
extends ElementsNarutomodMod.ModElement {
    public KeyBindingExtendedReachMouseEvent(ElementsNarutomodMod instance) {
        super(instance, 171);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(Message.Handler.class, Message.class, Side.SERVER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouseEvent(MouseEvent event) {
        if (FMLClientHandler.instance().isGUIOpen(GuiChat.class) || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (ProcedureOnLivingUpdate.isNoClip((Entity)player) && !ProcedureOnLivingUpdate.noClipAllowClicks((Entity)player)) {
            event.setCanceled(true);
            return;
        }
        if (player.getEntityData().func_74762_e("FearEffect") > 0) {
            event.setCanceled(true);
            return;
        }
        if (event.getButton() == 0 && event.isButtonstate()) {
            this.onLeftClick();
            return;
        }
        if (event.getButton() == 1 && !event.isButtonstate()) {
            this.onRightRelease();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onRightRelease() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184614_ca().func_77973_b() == ItemEightGates.block || player.func_184592_cb().func_77973_b() == ItemEightGates.block && player.func_70093_af()) {
            Minecraft.func_71410_x().field_71442_b.func_78766_c((EntityPlayer)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onLeftClick() {
        RayTraceResult rtr;
        EntityPlayerSP playerSP = Minecraft.func_71410_x().field_71439_g;
        Object attacker = playerSP.func_184218_aH() && playerSP.func_184187_bx() instanceof EntityLivingBase ? (EntityLivingBase)playerSP.func_184187_bx() : playerSP;
        double reach = ProcedureUtils.getReachDistance((EntityLivingBase)attacker);
        if (reach > 5.0 && (rtr = ProcedureUtils.objectEntityLookingAt((Entity)playerSP, reach, 3.0)) != null && rtr.field_72313_a == RayTraceResult.Type.ENTITY) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new Message(attacker.func_145782_y(), rtr.field_72308_g.func_145782_y()));
        }
    }

    public static class Message
    implements IMessage {
        int iVar1;
        int iVar2;

        public Message() {
        }

        public Message(int var1, int var2) {
            this.iVar1 = var1;
            this.iVar2 = var2;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.iVar1);
            buf.writeInt(this.iVar2);
        }

        public void fromBytes(ByteBuf buf) {
            this.iVar1 = buf.readInt();
            this.iVar2 = buf.readInt();
        }

        public static class Handler
        implements IMessageHandler<Message, IMessage> {
            public IMessage onMessage(Message message, MessageContext context) {
                EntityPlayerMP entity = context.getServerHandler().field_147369_b;
                entity.func_71121_q().func_152344_a(() -> {
                    World world = entity.field_70170_p;
                    if (!world.func_175667_e(new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v))) {
                        return;
                    }
                    Entity source = world.func_73045_a(message.iVar1);
                    Entity target = world.func_73045_a(message.iVar2);
                    if (source != null && target != null) {
                        if (source instanceof EntityPlayer) {
                            ((EntityPlayer)source).func_71059_n(target);
                        } else if (source instanceof EntityLivingBase) {
                            ((EntityLivingBase)source).func_70652_k(target);
                        }
                    }
                });
                return null;
            }
        }
    }
}

