/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.potion;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.procedure.ProcedureAirPunch;

@ElementsNarutomodMod.ModElement.Tag
public class PotionChakraEnhancedStrength
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:chakra_enhanced_strength")
    public static final Potion potion = null;
    public static boolean shouldShowInHUD = true;

    public PotionChakraEnhancedStrength(ElementsNarutomodMod instance) {
        super(instance, 529);
    }

    @Override
    public void initElements() {
        this.elements.potions.add(() -> new PotionCustom());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EntityHook());
    }

    public class EntityHook {
        @SubscribeEvent
        public void onLivingHurt(LivingHurtEvent event) {
            EntityLivingBase attacker;
            if (event.getSource().func_76364_f() instanceof EntityLivingBase && !event.getSource().func_94541_c() && event.getSource() instanceof EntityDamageSource && !((EntityDamageSource)event.getSource()).func_180139_w() && (attacker = (EntityLivingBase)event.getSource().func_76364_f()).func_70644_a(potion)) {
                int amplifier = attacker.func_70660_b(potion).func_76458_c();
                if (Chakra.pathway(attacker).consume((double)amplifier)) {
                    EntityLivingBase target = event.getEntityLiving();
                    target.field_70170_p.func_184148_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, (1.0f + (target.func_70681_au().nextFloat() - target.func_70681_au().nextFloat()) * 0.2f) * 0.7f);
                    new Punch(attacker.field_70170_p).execute(attacker, (double)amplifier * 0.4, 0.1 * (double)amplifier);
                    event.setAmount(event.getAmount() + (float)amplifier);
                }
            }
        }

        @SubscribeEvent
        public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            PotionEffect eff;
            EntityPlayer player = event.getEntityPlayer();
            if (player.func_70644_a(potion) && (eff = player.func_70660_b(potion)).func_82720_e()) {
                int amplifier = eff.func_76458_c();
                if (Chakra.pathway(player).consume(0.05 * (double)amplifier)) {
                    event.setNewSpeed(event.getOriginalSpeed() * (1.0f + 0.15f * (float)amplifier));
                }
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void onHUDRender(RenderGameOverlayEvent event) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && !event.isCancelable()) {
                PotionEffect eff;
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71439_g.func_70644_a(potion) && !(eff = mc.field_71439_g.func_70660_b(potion)).func_188418_e()) {
                    int i = 0;
                    for (PotionEffect effect : mc.field_71439_g.func_70651_bq()) {
                        Potion potion = effect.func_188419_a();
                        if (!potion.shouldRenderHUD(effect) || !effect.func_188418_e() || !potion.func_188408_i()) continue;
                        ++i;
                    }
                    int l = 1;
                    ++i;
                    int k = event.getResolution().func_78326_a();
                    if (mc.func_71355_q()) {
                        l += 15;
                    }
                    int i1 = eff.func_188419_a().func_76392_e();
                    mc.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    mc.field_71456_v.func_73729_b(k -= 25 * i, l, 165, 166, 24, 24);
                    mc.field_71456_v.func_73729_b(k + 3, l + 3, i1 % 8 * 18, 198 + i1 / 8 * 18, 18, 18);
                    eff.func_188419_a().renderHUDEffect(k, l, eff, mc, 1.0f);
                }
            }
        }

        public class Punch
        extends ProcedureAirPunch {
            private final boolean griefing;

            public Punch(World world) {
                this.blockDropChance = 0.1f;
                this.griefing = ForgeEventFactory.getMobGriefingEvent((World)world, null);
            }

            @Override
            protected void preExecuteParticles(EntityLivingBase player) {
                int i;
                Vec3d vec = player.func_70040_Z();
                Vec3d vec1 = player.func_174791_d().func_72441_c(0.0, 1.2, 0.0).func_178787_e(vec);
                Vec3d vec2 = vec.func_186678_a(this.getRange(0));
                double d = MathHelper.func_181159_b((double)this.getFarRadius(0), (double)this.getRange(0));
                for (i = 0; i < (int)(this.getRange(0) * 50.0); ++i) {
                    Vec3d vec3 = vec2.func_186678_a(this.rand.nextDouble() * 0.05 + 0.2).func_178789_a((float)(this.rand.nextGaussian() * d)).func_178785_b((float)(this.rand.nextGaussian() * d));
                    Particles.spawnParticle(player.field_70170_p, Particles.Types.SMOKE, vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, 1, 0.0, 0.0, 0.0, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, 0x20FFFFFF, (int)this.getRange(0) * 2 + this.rand.nextInt(21), 12);
                }
                int j = (int)(this.getRange(0) * 2.5);
                for (i = 1; i <= j; ++i) {
                    Vec3d vec3 = vec2.func_186678_a(-0.0012 * (double)i);
                    Particles.spawnParticle(player.field_70170_p, Particles.Types.SONIC_BOOM, vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, 1, 0.0, 0.0, 0.0, vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, 0xFFFFFF | (int)((1.0f - (float)i / (float)j) * 64.0f) << 24, i, (int)(5.0f * (1.0f + (float)i / (float)j * 0.5f)));
                }
            }

            @Override
            protected EntityItem processAffectedBlock(EntityLivingBase player, BlockPos pos, EnumFacing facing) {
                if (this.griefing && player.field_70170_p.func_180495_p(pos).func_185913_b() && player.field_70170_p.func_180495_p(pos.func_177984_a()).func_185890_d((IBlockAccess)player.field_70170_p, pos.func_177984_a()) == Block.field_185506_k) {
                    EntityFallingBlock entity = new EntityFallingBlock(player.field_70170_p, 0.5 + (double)pos.func_177958_n(), (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), player.field_70170_p.func_180495_p(pos));
                    entity.field_70181_x = 0.45;
                    player.field_70170_p.func_72838_d((Entity)entity);
                }
                return super.processAffectedBlock(player, pos, facing);
            }

            @Override
            protected float getBreakChance(BlockPos pos, EntityLivingBase player, double range) {
                return player.func_70660_b(potion).func_82720_e() ? 1.0f - (float)((Math.sqrt(player.func_174831_c(pos)) - 4.0) / range) : 0.0f;
            }
        }
    }

    public static class PotionCustom
    extends Potion {
        private final ResourceLocation potionIcon;

        public PotionCustom() {
            super(false, 0x33FFCC);
            this.func_188413_j();
            this.setRegistryName("chakra_enhanced_strength");
            this.func_76390_b("effect.chakra_enhanced_strength");
            this.potionIcon = new ResourceLocation("narutomod:textures/strength.png");
        }

        public boolean func_76403_b() {
            return true;
        }

        public boolean shouldRenderInvText(PotionEffect effect) {
            return false;
        }

        public boolean shouldRenderHUD(PotionEffect effect) {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
            if (mc.field_71462_r != null) {
                mc.func_110434_K().func_110577_a(this.potionIcon);
                Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
            mc.func_110434_K().func_110577_a(this.potionIcon);
            Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
        }

        public boolean func_76397_a(int duration, int amplifier) {
            return true;
        }
    }
}

