/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.procedure;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.narutomod.Particles;
import net.narutomod.procedure.ProcedureUtils;

public abstract class ProcedureAirPunch {
    private final List<RayTraceResult> affectedTraceList = Lists.newArrayList();
    protected Random rand = new Random();
    protected float blockDropChance = 0.1f;
    protected float blockHardnessLimit = 2.0f;
    public EnumParticleTypes particlesPre = EnumParticleTypes.EXPLOSION_LARGE;
    public EnumParticleTypes particlesDuring = EnumParticleTypes.EXPLOSION_NORMAL;
    private double range;
    private double radius;
    public static final Predicate<Entity> COLLIDABLE = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return (!(p_apply_1_ instanceof EntityPlayer) || !((EntityPlayer)p_apply_1_).func_175149_v()) && p_apply_1_.func_70067_L();
        }
    };

    public static int getPressDuration(Entity entity) {
        return entity.getEntityData().func_74762_e("pressDuration");
    }

    private static void setPressDuration(Entity entity, int duration) {
        entity.getEntityData().func_74768_a("pressDuration", duration);
    }

    public void execute(boolean is_pressed, EntityPlayer player) {
        int pressDuration = ProcedureAirPunch.getPressDuration((Entity)player);
        if (is_pressed) {
            player.func_146105_b((ITextComponent)new TextComponentString("Power range: " + (int)this.getRange(++pressDuration)), true);
            Particles.spawnParticle(player.field_70170_p, Particles.Types.SMOKE, player.field_70165_t, player.field_70163_u, player.field_70161_v, pressDuration, 0.25, 0.0, 0.25, 0.0, 0.15, 0.0, 536927743, 25, (int)(3.0 / (Math.random() * 0.8 + 0.2)));
        } else if (pressDuration > 0) {
            this.execute((EntityLivingBase)player, this.getRange(pressDuration), this.getFarRadius(pressDuration));
            pressDuration = 0;
        }
        ProcedureAirPunch.setPressDuration((Entity)player, pressDuration);
    }

    public void execute(EntityLivingBase player, double range, double radius) {
        this.execute(player, range, radius, 0.0, 1.5);
    }

    public void execute2(EntityLivingBase player, double range, double radius) {
        this.execute(player, range, radius, radius, 0.0);
    }

    public void execute(EntityLivingBase player, double range, double radius, double radiusNear, double random) {
        World world = player.field_70170_p;
        this.range = range;
        this.radius = radius;
        if (!world.field_72995_K) {
            this.preExecuteParticles(player);
            if (this.getAffectedInSight((Entity)player, range, radiusNear, radius, random)) {
                ArrayList list = Lists.newArrayList();
                for (RayTraceResult result : this.affectedTraceList) {
                    if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                        BlockPos pos = result.func_178782_a();
                        EntityItem entityItem = this.processAffectedBlock(player, pos, result.field_178784_b);
                        this.breakBlockParticles(world, pos);
                        if (entityItem == null) continue;
                        list.add(entityItem);
                        continue;
                    }
                    if (result.field_72313_a != RayTraceResult.Type.ENTITY) continue;
                    list.add(result.field_72308_g);
                }
                for (Entity entity1 : list) {
                    this.attackEntityFrom(player, entity1);
                }
            }
        }
    }

    protected void preExecuteParticles(EntityLivingBase player) {
        if (this.particlesPre != null) {
            int i = 1;
            while ((double)i <= this.range) {
                Vec3d vec3d = player.func_70040_Z().func_186678_a((double)i);
                double d = this.radius * (double)i / this.range;
                ((WorldServer)player.field_70170_p).func_175739_a(this.particlesPre, player.field_70165_t + vec3d.field_72450_a, player.field_70163_u + 1.2 + vec3d.field_72448_b, player.field_70161_v + vec3d.field_72449_c, i, d, d, d, 0.1, new int[0]);
                ++i;
            }
        }
    }

    protected void breakBlockParticles(World world, BlockPos pos) {
        if (this.particlesDuring != null) {
            ((WorldServer)world).func_175739_a(this.particlesDuring, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 2, 0.2, 0.2, 0.2, 0.0, new int[0]);
        }
    }

    @Nullable
    protected EntityItem processAffectedBlock(EntityLivingBase player, BlockPos pos, EnumFacing facing) {
        return ProcedureUtils.breakBlockAndDropWithChance(player.field_70170_p, pos, this.blockHardnessLimit, ForgeEventFactory.getMobGriefingEvent((World)player.field_70170_p, (Entity)player) ? this.getBreakChance(pos, player, this.range) : 0.0f, this.blockDropChance, false);
    }

    protected double getRange(int paramInt) {
        return this.range;
    }

    protected double getFarRadius(int paramInt) {
        return this.radius;
    }

    protected void attackEntityFrom(EntityLivingBase player, Entity target) {
        if (target.func_70104_M()) {
            ProcedureUtils.pushEntity((Entity)player, target, this.range, 2.0f);
        }
    }

    protected abstract float getBreakChance(BlockPos var1, EntityLivingBase var2, double var3);

    protected boolean getAffectedInSight(Entity entity, double range, double nearRadius, double farRadius, double randomness) {
        this.affectedTraceList.clear();
        if (entity == null || entity.field_70170_p == null) {
            return false;
        }
        Vec3d vec3d = entity.func_174824_e(1.0f).func_178786_a(0.0, 0.4, 0.0);
        Vec3d vec3d1 = entity.func_70040_Z().func_186678_a(range);
        Vec3d vec3d2 = vec3d.func_178787_e(vec3d1);
        Vec3d vec3d3 = new Vec3d(Math.copySign(farRadius, vec3d1.field_72450_a), Math.copySign(farRadius, vec3d1.field_72448_b), Math.copySign(farRadius, vec3d1.field_72449_c));
        AxisAlignedBB bigAABB = entity.func_174813_aQ().func_72321_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c).func_72321_a(Math.copySign(Math.min(range - Math.abs(vec3d1.field_72450_a), farRadius), vec3d1.field_72450_a), Math.copySign(Math.min(range - Math.abs(vec3d1.field_72448_b), farRadius), vec3d1.field_72448_b), Math.copySign(Math.min(range - Math.abs(vec3d1.field_72449_c), farRadius), vec3d1.field_72449_c)).func_72321_a(farRadius > Math.abs(vec3d1.field_72450_a) ? vec3d1.field_72450_a - vec3d3.field_72450_a : 0.0, farRadius > Math.abs(vec3d1.field_72448_b) ? vec3d1.field_72448_b - vec3d3.field_72448_b : 0.0, farRadius > Math.abs(vec3d1.field_72449_c) ? vec3d1.field_72449_c - vec3d3.field_72449_c : 0.0);
        farRadius -= nearRadius;
        BlockPos.PooledMutableBlockPos mpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (AxisAlignedBB aabb : ProcedureUtils.getBoundingBoxes(entity.field_70170_p, bigAABB)) {
            double d = Math.sqrt(entity.func_174831_c((BlockPos)mpos.func_189532_c(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c)));
            RayTraceResult raytraceresult = (aabb = aabb.func_186662_g(nearRadius + d / range * farRadius + (d > 3.0 ? this.rand.nextDouble() * randomness : 0.0))).func_72327_a(vec3d, vec3d2);
            if (raytraceresult == null) continue;
            this.affectedTraceList.add(new RayTraceResult(raytraceresult.field_72307_f, raytraceresult.field_178784_b, mpos.func_185334_h()));
        }
        mpos.func_185344_t();
        for (Entity entity1 : entity.field_70170_p.func_175674_a(entity, bigAABB, COLLIDABLE)) {
            if (entity1.func_184223_x(entity)) continue;
            AxisAlignedBB aabb = entity1.func_174813_aQ().func_186662_g(nearRadius + (double)entity1.func_70032_d(entity) / range * farRadius + 1.0);
            RayTraceResult raytraceresult = aabb.func_72327_a(vec3d, vec3d2);
            if (!aabb.func_72318_a(vec3d) && raytraceresult == null) continue;
            this.affectedTraceList.add(new RayTraceResult(entity1));
        }
        return !this.affectedTraceList.isEmpty();
    }
}

