/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.procedure;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureKamuiTeleportEntity;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ProcedureAoeCommand
extends ElementsNarutomodMod.ModElement {
    private static World world;
    private static double centerX;
    private static double centerY;
    private static double centerZ;
    private static AxisAlignedBB aabb;
    private static double minRange;
    private static double maxRange;
    private static List<Entity> entitiesList;
    private static ProcedureAoeCommand Instance;
    private static final Predicate<Entity> MIN_DISTANCE;

    public ProcedureAoeCommand(ElementsNarutomodMod instance) {
        super(instance, 169);
        Instance = this;
    }

    public static ProcedureAoeCommand set(World worldIn, double x, double y, double z, double minR, double maxR) {
        world = worldIn;
        centerX = x;
        centerY = y;
        centerZ = z;
        aabb = new AxisAlignedBB(x - 0.5, y, z - 0.5, x + 0.5, y + 1.0, z + 0.5);
        minRange = minR;
        maxRange = maxR;
        if (minRange < 0.0) {
            minRange = 0.0;
        }
        entitiesList = world.func_175647_a(Entity.class, aabb.func_186662_g(maxRange), MIN_DISTANCE);
        return Instance;
    }

    public static ProcedureAoeCommand set(Entity entity, double minR, double maxR) {
        world = entity.field_70170_p;
        centerX = entity.field_70165_t;
        centerY = entity.field_70163_u;
        centerZ = entity.field_70161_v;
        aabb = entity.func_174813_aQ();
        minRange = minR;
        maxRange = maxR;
        if (minRange < 0.0) {
            minRange = 0.0;
        }
        entitiesList = world.func_175647_a(Entity.class, aabb.func_186662_g(maxRange), MIN_DISTANCE);
        return Instance;
    }

    public ProcedureAoeCommand exclude(Entity entity) {
        if (entity != null) {
            entitiesList.remove(entity);
        }
        return this;
    }

    public ProcedureAoeCommand exclude(Class<? extends Entity> clazz) {
        if (!entitiesList.isEmpty()) {
            Iterator<Entity> iter = entitiesList.iterator();
            while (iter.hasNext()) {
                Entity entity = iter.next();
                if (!clazz.isAssignableFrom(entity.getClass())) continue;
                iter.remove();
            }
        }
        return this;
    }

    public ProcedureAoeCommand health(float health) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                if (!(entity instanceof EntityLivingBase)) continue;
                ((EntityLivingBase)entity).func_70606_j(health);
            }
        }
        return this;
    }

    public ProcedureAoeCommand clear() {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                if (!(entity instanceof EntityPlayer)) continue;
                ((EntityPlayer)entity).field_71071_by.func_174888_l();
            }
        }
        return this;
    }

    public ProcedureAoeCommand kill() {
        return this.kill(false);
    }

    public ProcedureAoeCommand kill(boolean livingOnly) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                if (livingOnly && !(entity instanceof EntityLivingBase)) continue;
                entity.func_174812_G();
            }
        }
        return this;
    }

    public ProcedureAoeCommand kill(Class<? extends Entity> entityClass) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                if (!entityClass.isAssignableFrom(entity.getClass())) continue;
                entity.func_174812_G();
            }
        }
        return this;
    }

    public ProcedureAoeCommand killNonLiving() {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                if (entity instanceof EntityLivingBase) continue;
                entity.func_174812_G();
            }
        }
        return this;
    }

    public ProcedureAoeCommand resetHurtResistanceTime() {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                entity.field_70172_ad = 10;
            }
        }
        return this;
    }

    public ProcedureAoeCommand damageEntities(DamageSource source, float amount) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                boolean bl = entity.func_70097_a(source, amount);
            }
        }
        return this;
    }

    public ProcedureAoeCommand damageEntitiesCentered(DamageSource source, float maxAmount) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                double d = 1.0 - entity.func_70011_f(centerX, centerY, centerZ) / maxRange;
                boolean bl = entity.func_70097_a(source, maxAmount * (float)d);
            }
        }
        return this;
    }

    public ProcedureAoeCommand damageEntities(@Nullable Entity caster, float amount) {
        if (caster instanceof EntityPlayer) {
            return this.damageEntities(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)caster)), amount);
        }
        if (caster instanceof EntityLivingBase) {
            return this.damageEntities(DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)caster)), amount);
        }
        if (caster instanceof EntityFireball) {
            return this.damageEntities(new EntityDamageSourceIndirect("fireball", caster, (Entity)((EntityFireball)caster).field_70235_a).func_76348_h().func_76361_j(), amount);
        }
        return this.damageEntities(DamageSource.field_76377_j, amount);
    }

    public ProcedureAoeCommand removeEntity() {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                if (entity instanceof EntityPlayer) continue;
                world.func_72900_e(entity);
            }
        }
        return this;
    }

    public ProcedureAoeCommand tpDimension(int dimid) {
        return this.tpDimension(dimid, Entity.class);
    }

    public ProcedureAoeCommand tpDimension(int dimid, Class<? extends Entity> entityclassIn) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                if (!entityclassIn.isAssignableFrom(entity.getClass())) continue;
                ProcedureKamuiTeleportEntity.eEntity(entity, (int)entity.field_70165_t, (int)entity.field_70161_v, dimid);
            }
        }
        return this;
    }

    public ProcedureAoeCommand noGravity(boolean noGravity) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                entity.func_189654_d(noGravity);
            }
        }
        return this;
    }

    public ProcedureAoeCommand motion(double motionX, double motionY, double motionZ) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                if (motionX == 0.0 && motionY == 0.0 && motionZ == 0.0 && entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).field_71075_bZ.field_75100_b = false;
                    ((EntityPlayer)entity).func_71016_p();
                }
                ProcedureUtils.setVelocity(entity, motionX, motionY, motionZ);
            }
        }
        return this;
    }

    public ProcedureAoeCommand knockback(float multiplier) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                ProcedureUtils.pushEntity(new Vec3d(centerX, centerY, centerZ), entity, maxRange, multiplier);
            }
        }
        return this;
    }

    public ProcedureAoeCommand effect(Potion potion, int duration, int amplifier) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                if (!(entity instanceof EntityLivingBase)) continue;
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(potion, duration * 20, amplifier, false, true));
            }
        }
        return this;
    }

    public ProcedureAoeCommand clearEffects() {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                if (!(entity instanceof EntityPlayer)) continue;
                ((EntityPlayer)entity).func_70674_bp();
            }
        }
        return this;
    }

    public ProcedureAoeCommand setTag(String key, boolean set) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                entity.getEntityData().func_74757_a(key, set);
            }
        }
        return this;
    }

    public ProcedureAoeCommand setTag(String key, int set) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                ((EntityLivingBase)entity).getEntityData().func_74768_a(key, set);
            }
        }
        return this;
    }

    public ProcedureAoeCommand setFire(float chance) {
        int i1 = MathHelper.func_76128_c((double)(centerX - maxRange));
        int i2 = MathHelper.func_76143_f((double)(centerX + maxRange));
        int j1 = MathHelper.func_76128_c((double)(centerZ - maxRange));
        int j2 = MathHelper.func_76143_f((double)(centerZ + maxRange));
        int k1 = MathHelper.func_76128_c((double)(centerY - maxRange));
        int k2 = MathHelper.func_76143_f((double)(centerY + maxRange));
        int i3 = MathHelper.func_76128_c((double)(centerX - minRange));
        int i4 = MathHelper.func_76143_f((double)(centerX + minRange));
        int j3 = MathHelper.func_76128_c((double)(centerZ - minRange));
        int j4 = MathHelper.func_76143_f((double)(centerZ + minRange));
        int k3 = MathHelper.func_76128_c((double)(centerY - minRange));
        int k4 = MathHelper.func_76143_f((double)(centerY + minRange));
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int i = i1; i < i2; ++i) {
            for (int j = j1; j < j2; ++j) {
                for (int k = k1; k < k2; ++k) {
                    double d = pos.func_181079_c(i, k, j).func_177957_d(centerX, centerY, centerZ);
                    if (!(d <= maxRange * maxRange)) continue;
                    if (!(d > minRange * minRange)) continue;
                    if (!world.func_175623_d((BlockPos)pos)) continue;
                    if (!world.func_180495_p(pos.func_177977_b()).func_185913_b() || !(Math.random() <= (double)chance)) continue;
                    world.func_175656_a((BlockPos)pos, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
        pos.func_185344_t();
        return this;
    }

    public ProcedureAoeCommand setFire(int seconds) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                entity.func_70015_d(seconds);
            }
        }
        return this;
    }

    public ProcedureAoeCommand fear(int duration) {
        if (!entitiesList.isEmpty()) {
            for (Entity entity : entitiesList) {
                if (!(entity instanceof EntityLivingBase)) continue;
                entity.getEntityData().func_74768_a("FearEffect", duration * 20);
                double dx = centerX - entity.field_70165_t;
                double dy = centerY - entity.field_70163_u;
                double dz = centerZ - entity.field_70161_v;
                entity.func_70080_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ProcedureUtils.getYawFromVec(dx, dz), ProcedureUtils.getPitchFromVec(dx, dy, dz));
            }
        }
        return this;
    }

    static {
        entitiesList = Lists.newArrayList();
        MIN_DISTANCE = p -> ItemJutsu.canTarget(p) && p.func_70092_e(centerX, centerY, centerZ) >= minRange * minRange;
    }
}

