/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.procedure;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityChibakuTenseiBall;
import net.narutomod.entity.EntityEarthBlocks;
import net.narutomod.procedure.ProcedureGravityPower;
import net.narutomod.procedure.ProcedurePullAndHold;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ProcedureBanShoTenin
extends ElementsNarutomodMod.ModElement {
    private static final Map<Entity, ProcedurePullAndHold> map = Maps.newHashMap();
    private static final double CHAKRA_USAGE = 0.5;
    public static final String BSTN_CD = "BanshoTenin_cooldown";

    public ProcedureBanShoTenin(ElementsNarutomodMod instance) {
        super(instance, 155);
    }

    public static void executeProcedure(Map<String, Object> dependencies) {
        if (dependencies.get("is_pressed") == null) {
            System.err.println("Failed to load dependency is_pressed for procedure ProcedureBanShoTenin!");
            return;
        }
        if (dependencies.get("entity") == null) {
            System.err.println("Failed to load dependency entity for procedure ProcedureBanShoTenin!");
            return;
        }
        boolean is_pressed = (Boolean)dependencies.get("is_pressed");
        Entity entity = (Entity)dependencies.get("entity");
        int cooldown = entity.getEntityData().func_74762_e(BSTN_CD);
        if ((int)entity.field_70170_p.func_82737_E() > cooldown) {
            RayTraceResult t = ProcedureUtils.objectEntityLookingAt(entity, 50.0);
            Entity grabbedEntity = null;
            ProcedurePullAndHold procedure = map.get(entity);
            if (procedure == null) {
                procedure = new ProcedurePullAndHold();
                map.put(entity, procedure);
            }
            Chakra.PathwayPlayer cp = Chakra.pathway((EntityPlayer)entity);
            if (is_pressed) {
                if (cp.getAmount() < 0.5) {
                    is_pressed = false;
                    ((Chakra.Pathway)cp).warningDisplay();
                } else if (procedure.getGrabbedEntity() == null) {
                    if (!(t.field_72308_g == null || t.field_72308_g instanceof EntityChibakuTenseiBall.EntityCustom || t.field_72308_g instanceof EntityEarthBlocks.Base && t.field_72308_g.field_70173_aa <= 5 || !(t.field_72308_g.field_70131_O < 24.0f))) {
                        grabbedEntity = t.field_72308_g;
                        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:BanshoTenin")), SoundCategory.PLAYERS, 5.0f, 1.0f);
                    } else if (entity.func_70093_af() && t.field_72313_a == RayTraceResult.Type.BLOCK) {
                        entity.field_70170_p.func_184133_a(null, t.func_178782_a(), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:rocks")), SoundCategory.NEUTRAL, 50.0f, 0.5f);
                        EntityEarthBlocks.Base entity1 = ProcedureGravityPower.dislodgeBlocks(entity.field_70170_p, t.func_178782_a(), 5);
                        if (entity1 != null) {
                            entity1.field_70159_w = 0.2 * (double)t.field_178784_b.func_176730_m().func_177958_n();
                            entity1.field_70181_x = 0.2 * (double)t.field_178784_b.func_176730_m().func_177956_o();
                            entity1.field_70179_y = 0.2 * (double)t.field_178784_b.func_176730_m().func_177952_p();
                        }
                        procedure.addEarthBlock(entity1);
                        cp.consume(0.5);
                    }
                }
                if (procedure.getGrabbedEntity() != null) {
                    cp.consume(0.5);
                }
            } else if (procedure.getGrabbedEntity() != null) {
                cooldown = (int)entity.field_70170_p.func_82737_E() + 100;
            }
            procedure.execute(is_pressed, entity, grabbedEntity);
        } else if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K) {
            ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("chattext.cooldown.formatted", new Object[]{new DecimalFormat(".1").format(((float)entity.getEntityData().func_74762_e(BSTN_CD) - (float)((int)entity.field_70170_p.func_82737_E())) / 20.0f)}), true);
        }
        entity.getEntityData().func_74768_a(BSTN_CD, cooldown);
    }

    public static List<EntityEarthBlocks.Base> getGrabbedEarthBlocks(Entity entity) {
        if (map.containsKey(entity)) {
            return map.get(entity).getGrabbedEarthBlocks();
        }
        return Lists.newArrayList();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerHook());
    }

    public class PlayerHook {
        @SubscribeEvent(priority=EventPriority.HIGH)
        public void onDeath(LivingDeathEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K && map.containsKey(entity)) {
                ((ProcedurePullAndHold)map.get(entity)).reset();
            }
        }
    }
}

