/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.procedure;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.Particles;
import net.narutomod.PlayerRender;
import net.narutomod.PlayerTracker;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemMangekyoSharingan;
import net.narutomod.item.ItemMangekyoSharinganEternal;
import net.narutomod.item.ItemMangekyoSharinganObito;
import net.narutomod.item.ItemSharingan;

@ElementsNarutomodMod.ModElement.Tag
public class ProcedureUtils
extends ElementsNarutomodMod.ModElement {
    public static final IAttribute MAXHEALTH = new RangedAttribute(null, "modded.maxHealth", 20.0, (double)1.4E-45f, 1048576.0).func_111117_a("Max Modded Health").func_111112_a(true);
    private static final Random RNG = new Random();
    public static final DamageSource AMATERASU = new DamageSource("ninjutsu_damage").func_76361_j();
    public static final DamageSource SPECIAL_DAMAGE = new DamageSource("wither").func_76348_h().func_151518_m();

    public ProcedureUtils(ElementsNarutomodMod instance) {
        super(instance, 177);
    }

    public static double rngGaussian() {
        return RNG.nextGaussian();
    }

    public static boolean rngBoolean() {
        return RNG.nextBoolean();
    }

    public static int rngInt(int bound) {
        return RNG.nextInt(bound);
    }

    public static Random rng() {
        return RNG;
    }

    public static double name2Id(String string) {
        long id = 0L;
        for (int i = 0; i < string.length() - 2 && i < 8; ++i) {
            id = id << 8 | (long)string.charAt(i);
        }
        return id;
    }

    @Nullable
    public static EntityLivingBase searchLivingMatchingId(UUID id) {
        Entity entity;
        MinecraftServer mcserv = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcserv != null && (entity = mcserv.func_175576_a(id)) instanceof EntityLivingBase) {
            return (EntityLivingBase)entity;
        }
        return null;
    }

    @Nullable
    public static EntityPlayerMP getPlayerMatchingUuid(UUID id) {
        MinecraftServer mcserv = FMLCommonHandler.instance().getMinecraftServerInstance();
        return mcserv != null ? mcserv.func_184103_al().func_177451_a(id) : null;
    }

    @Nullable
    public static Entity getEntityFromUUID(World world, UUID uuid) {
        if (world instanceof WorldServer) {
            return ((WorldServer)world).func_175733_a(uuid);
        }
        for (Entity entity : world.field_72996_f) {
            if (!uuid.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    @Nullable
    public static EntityLivingBase GetLivingByUuid(World world, UUID uuid) {
        for (EntityLivingBase entity : world.func_175644_a(EntityLivingBase.class, EntitySelectors.field_180132_d)) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public static void setOriginalOwner(ItemStack stack, UUID uuid) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_186854_a("player_id", uuid);
    }

    public static void setOriginalOwner(EntityLivingBase entity, ItemStack stack) {
        ProcedureUtils.setOriginalOwner(stack, entity.func_110124_au());
    }

    public static UUID getOwnerId(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_186855_b("player_id") ? stack.func_77978_p().func_186857_a("player_id") : null;
    }

    public static boolean isOriginalOwner(EntityLivingBase entity, ItemStack stack) {
        return entity.func_110124_au().equals(ProcedureUtils.getOwnerId(stack));
    }

    public static ItemStack getMatchingItemStack(EntityPlayer entity, Item item) {
        return ProcedureUtils.getItemStackIgnoreDurability(entity.field_71071_by, new ItemStack(item));
    }

    public static ItemStack getItemStackIgnoreDurability(InventoryPlayer inventory, ItemStack itemStackIn) {
        List<NonNullList> allInv = Arrays.asList(inventory.field_70462_a, inventory.field_70460_b, inventory.field_184439_c);
        for (List list : allInv) {
            for (ItemStack itemstack : list) {
                if (itemstack.func_190926_b() || itemstack.func_77973_b() != itemStackIn.func_77973_b()) continue;
                return itemstack;
            }
        }
        return null;
    }

    public static boolean hasItemInMainInventory(EntityPlayer player, Item itemIn) {
        return ProcedureUtils.getItemInMainInventory(player, itemIn) != null;
    }

    @Nullable
    public static ItemStack getItemInMainInventory(EntityPlayer player, Item itemIn) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || stack.func_77973_b() != itemIn) continue;
            return stack;
        }
        return null;
    }

    public static ItemStack getMatchingItemStack(EntityPlayer player, ItemStack itemStackIn) {
        List<NonNullList> allInv = Arrays.asList(player.field_71071_by.field_70462_a, player.field_71071_by.field_70460_b, player.field_71071_by.field_184439_c);
        for (List list : allInv) {
            for (ItemStack itemstack : list) {
                if (itemstack.func_190926_b() || !ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)itemStackIn)) continue;
                return itemstack;
            }
        }
        return null;
    }

    public static boolean hasAnyItemOfSubtype(EntityPlayer player, Class<? extends Item> itemType) {
        List<NonNullList> allInv = Arrays.asList(player.field_71071_by.field_70462_a, player.field_71071_by.field_70460_b, player.field_71071_by.field_184439_c);
        for (List list : allInv) {
            for (ItemStack itemstack : list) {
                if (itemstack.func_190926_b() || !itemType.isAssignableFrom(itemstack.func_77973_b().getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ItemStack> getAllItemsOfSubType(EntityPlayer player, Class<? extends Item> itemType) {
        List<NonNullList> allInv = Arrays.asList(player.field_71071_by.field_70462_a, player.field_71071_by.field_70460_b, player.field_71071_by.field_184439_c);
        ArrayList itemlist = Lists.newArrayList();
        for (List list : allInv) {
            for (ItemStack itemstack : list) {
                if (itemstack.func_190926_b() || !itemType.isAssignableFrom(itemstack.func_77973_b().getClass())) continue;
                itemlist.add(itemstack);
            }
        }
        return itemlist;
    }

    public static boolean hasItemStackIgnoreDurability(InventoryPlayer inventory, ItemStack itemStackIn) {
        return ProcedureUtils.getItemStackIgnoreDurability(inventory, itemStackIn) != null;
    }

    public static boolean hasItemInInventory(EntityPlayer player, Item item) {
        return ProcedureUtils.hasItemStackIgnoreDurability(player.field_71071_by, new ItemStack(item));
    }

    private static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static int getSlotFor(ItemStack stack, EntityPlayer player) {
        int i = 0;
        for (ItemStack stack1 : player.field_71071_by.field_70462_a) {
            if (!stack1.func_190926_b() && ProcedureUtils.stackEqualExact(stack, stack1)) {
                return i;
            }
            ++i;
        }
        for (ItemStack stack1 : player.field_71071_by.field_70460_b) {
            if (!stack1.func_190926_b() && ProcedureUtils.stackEqualExact(stack, stack1)) {
                return i;
            }
            ++i;
        }
        for (ItemStack stack1 : player.field_71071_by.field_184439_c) {
            if (!stack1.func_190926_b() && ProcedureUtils.stackEqualExact(stack, stack1)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getAvailableSlotsInMainInventory(EntityPlayer player) {
        int i = 0;
        for (ItemStack stack1 : player.field_71071_by.field_70462_a) {
            if (!stack1.func_190926_b()) continue;
            ++i;
        }
        return i;
    }

    public static boolean attackEntityAsMob(EntityLivingBase attacker, Entity entityIn) {
        boolean flag;
        int i = 0;
        float f = (float)ProcedureUtils.getModifiedAttackDamage(attacker);
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)attacker.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)attacker);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)attacker), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)attacker, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
                attacker.field_70159_w *= 0.6;
                attacker.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)attacker)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = attacker.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, attacker) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)attacker) * 0.05f;
                    if (RNG.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        attacker.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            if (entityIn instanceof EntityLivingBase) {
                ItemStack itemstack1 = attacker.func_184614_ca();
                if (!itemstack1.func_190926_b()) {
                    itemstack1.func_77973_b().func_77644_a(itemstack1, (EntityLivingBase)entityIn, attacker);
                }
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entityIn), (Entity)attacker);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)attacker, (Entity)entityIn);
            attacker.func_130011_c(entityIn);
        }
        return flag;
    }

    public static Vec3d getMotion(Entity entity) {
        return new Vec3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
    }

    public static double getVelocity(Entity entity) {
        return ProcedureUtils.getMotion(entity).func_72433_c();
    }

    public static void setVelocity(Entity target, double motionX, double motionY, double motionZ) {
        target.field_70133_I = target.field_70159_w != motionX || target.field_70181_x != motionY || target.field_70179_y != motionZ;
        target.field_70159_w = motionX;
        target.field_70181_x = motionY;
        target.field_70179_y = motionZ;
    }

    public static void addVelocity(Entity target, Vec3d vec) {
        ProcedureUtils.setVelocity(target, target.field_70159_w + vec.field_72450_a, target.field_70181_x + vec.field_72448_b, target.field_70179_y + vec.field_72449_c);
    }

    public static void multiplyVelocity(Entity target, double mul) {
        ProcedureUtils.setVelocity(target, target.field_70159_w * mul, target.field_70181_x * mul, target.field_70179_y * mul);
    }

    public static void multiplyVelocity(Entity target, double mulX, double mulY, double mulZ) {
        ProcedureUtils.setVelocity(target, target.field_70159_w * mulX, target.field_70181_x * mulY, target.field_70179_y * mulZ);
    }

    public static Vec3d pushEntity(Entity attacker, Entity target, double range, float multiplier) {
        return ProcedureUtils.pushEntity(attacker.func_174791_d(), target, range, multiplier);
    }

    public static Vec3d pushEntity(Vec3d src, Entity target, double range, float multiplier) {
        Vec3d vec3d = target.func_174791_d().func_178788_d(src);
        if (vec3d.func_72433_c() > range) {
            return Vec3d.field_186680_a;
        }
        multiplier *= (float)(range - vec3d.func_72433_c()) * 0.1f;
        double d = Math.sqrt(2.0 / (target instanceof EntityLivingBase ? (double)target.field_70131_O : target.func_174813_aQ().func_72320_b()));
        vec3d = vec3d.func_72432_b().func_186678_a(d);
        if (target.field_70122_E && vec3d.field_72448_b < d * 0.6) {
            vec3d = vec3d.func_72441_c(0.0, d * 0.6, 0.0);
        }
        vec3d = vec3d.func_186678_a((double)multiplier).func_72441_c(target.field_70159_w, target.field_70181_x, target.field_70179_y);
        ProcedureUtils.setVelocity(target, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        return vec3d;
    }

    public static void pullEntity(Vec3d src, Entity target, float multiplier) {
        Vec3d vec3d = src.func_178788_d(target.func_174791_d());
        multiplier *= (float)vec3d.func_72433_c() * 0.1f;
        vec3d = vec3d.func_72432_b().func_186678_a((double)multiplier);
        ProcedureUtils.setVelocity(target, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public static void removeAllEnchantments(ItemStack stack) {
        if (!stack.func_190926_b()) {
            NBTTagList nbttaglist = stack.func_77986_q();
            if (!nbttaglist.func_82582_d()) {
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    nbttaglist.func_74744_a(i);
                }
            }
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_82580_o("ench");
            }
        }
    }

    public static boolean purgeHarmfulEffects(EntityLivingBase entity) {
        ArrayList list = Lists.newArrayList();
        for (PotionEffect effect : entity.func_70651_bq()) {
            if (!effect.func_188419_a().func_76398_f()) continue;
            list.add(effect);
        }
        for (PotionEffect effect : list) {
            entity.func_184589_d(effect.func_188419_a());
        }
        return list.isEmpty();
    }

    public static UUID getUniqueId(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_186855_b(key) ? stack.func_77978_p().func_186857_a(key) : null;
    }

    public static void removeUniqueIdTag(ItemStack stack, String key) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(key + "Most");
            stack.func_77978_p().func_82580_o(key + "Least");
        }
    }

    public static void swapItemToSlot(EntityPlayer entity, EntityEquipmentSlot slot, ItemStack itemstack) {
        ItemStack itemstack1 = entity.func_184582_a(slot);
        ItemStack itemstack2 = ProcedureUtils.getMatchingItemStack(entity, itemstack);
        if (itemstack2 != null && !itemstack2.func_190926_b()) {
            itemstack = itemstack2.func_77946_l();
            itemstack2.func_190918_g(1);
        }
        if (!itemstack1.func_190926_b()) {
            if (ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)itemstack1)) {
                return;
            }
            if (itemstack1.func_77976_d() > 1) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)entity, (ItemStack)itemstack1);
            } else {
                entity.func_191521_c(itemstack1);
            }
            entity.func_110140_aT().func_111148_a(itemstack.func_111283_C(slot));
        }
        entity.func_184201_a(slot, itemstack);
    }

    public static boolean isWearingAnySharingan(EntityLivingBase entity) {
        return entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == ItemSharingan.helmet || ProcedureUtils.isWearingMangekyo(entity);
    }

    public static boolean isWearingMangekyo(EntityLivingBase entity) {
        Item item = entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b();
        return item == ItemMangekyoSharingan.helmet || item == ItemMangekyoSharinganObito.helmet || item == ItemMangekyoSharinganEternal.helmet;
    }

    public static boolean isEntityInFOV(EntityLivingBase looker, Entity entityIn) {
        double yaw = -MathHelper.func_181159_b((double)(entityIn.field_70165_t - looker.field_70165_t), (double)(entityIn.field_70161_v - looker.field_70161_v)) * 57.29577951308232;
        return Math.abs(MathHelper.func_76138_g((double)(yaw - (double)looker.field_70759_as))) < 85.0 && looker.func_70685_l(entityIn);
    }

    public static RayTraceResult raytraceBlocks(Entity entity, double distance) {
        Vec3d vec1 = entity.func_174824_e(1.0f);
        Vec3d vec2 = vec1.func_178787_e(entity.func_70040_Z().func_186678_a(distance));
        return entity.field_70170_p.func_147447_a(vec1, vec2, false, false, true);
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range) {
        return ProcedureUtils.objectEntityLookingAt(entity, range, false, false, (Predicate<Entity>)((Predicate)null));
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range, double bbGrow) {
        return ProcedureUtils.objectEntityLookingAt(entity, range, bbGrow, false, false, (Predicate<Entity>)((Predicate)null));
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range, double bbGrow, boolean trackall) {
        return ProcedureUtils.objectEntityLookingAt(entity, range, bbGrow, trackall, false, (Predicate<Entity>)((Predicate)null));
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range, @Nullable Entity excludeEntity) {
        return ProcedureUtils.objectEntityLookingAt(entity, range, false, false, excludeEntity);
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range, double bbgrow, @Nullable Entity excludeEntity) {
        return ProcedureUtils.objectEntityLookingAt(entity, range, bbgrow, false, false, excludeEntity);
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range, double bbgrow, Class<? extends Entity> excludeClazz) {
        return ProcedureUtils.objectEntityLookingAt(entity, range, bbgrow, false, false, excludeClazz);
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range, boolean trackall) {
        return ProcedureUtils.objectEntityLookingAt(entity, range, trackall, false, (Predicate<Entity>)((Predicate)null));
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range, boolean trackall, boolean stopOnLiquid) {
        return ProcedureUtils.objectEntityLookingAt(entity, range, trackall, stopOnLiquid, (Predicate<Entity>)((Predicate)null));
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range, boolean trackall, boolean stopOnLiquid, @Nullable Entity excludeEntity) {
        return ProcedureUtils.objectEntityLookingAt(entity, range, 0.0, trackall, stopOnLiquid, excludeEntity);
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range, double bbgrow, boolean trackall, boolean stopOnLiquid, final @Nullable Entity excludeEntity) {
        return ProcedureUtils.objectEntityLookingAt(entity, range, bbgrow, trackall, stopOnLiquid, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                return p_apply_1_ != null && !p_apply_1_.equals((Object)excludeEntity);
            }
        });
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range, double bbgrow, boolean trackall, boolean stopOnLiquid, final Class<? extends Entity> excludeClazz) {
        return ProcedureUtils.objectEntityLookingAt(entity, range, bbgrow, trackall, stopOnLiquid, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                return p_apply_1_ != null && !excludeClazz.isAssignableFrom(p_apply_1_.getClass());
            }
        });
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range, boolean trackall, boolean stopOnLiquid, @Nullable Predicate<Entity> filter) {
        return ProcedureUtils.objectEntityLookingAt(entity, range, 0.0, trackall, stopOnLiquid, filter);
    }

    public static RayTraceResult objectEntityLookingAt(Entity entity, double range, double bbGrow, final boolean trackall, boolean stopOnLiquid, final @Nullable Predicate<Entity> filter) {
        Vec3d vec3d1;
        Vec3d vec3d2;
        double d0;
        double d1 = d0 = range;
        Vec3d vec3d = entity.func_174824_e(1.0f);
        RayTraceResult objectMouseOver = entity.field_70170_p.func_147447_a(vec3d, vec3d2 = vec3d.func_178787_e(vec3d1 = entity.func_70040_Z().func_186678_a(d0)), stopOnLiquid, false, true);
        if (objectMouseOver != null) {
            d1 = objectMouseOver.field_72307_f.func_72438_d(vec3d);
        }
        List list = entity.field_70170_p.func_175674_a(entity, entity.func_174813_aQ().func_72321_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c).func_186662_g(1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                return p_apply_1_ != null && (trackall || p_apply_1_.func_70067_L() && !p_apply_1_.field_70145_X) && (filter == null || filter.apply((Object)p_apply_1_));
            }
        }));
        double d2 = d1;
        RayTraceResult entityTrace = null;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            if (entity1.func_184208_bv() == entity.func_184208_bv()) continue;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g(bbGrow * vec3d.func_72438_d(entity1.func_174791_d()) / 32.0);
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
            if (axisalignedbb.func_72318_a(vec3d)) {
                if (!(d2 >= 0.0)) continue;
                entityTrace = raytraceresult != null ? raytraceresult : new RayTraceResult(vec3d, EnumFacing.UP, null);
                entityTrace.field_72313_a = RayTraceResult.Type.ENTITY;
                entityTrace.field_72308_g = entity1;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
            entityTrace = raytraceresult;
            entityTrace.field_72313_a = RayTraceResult.Type.ENTITY;
            entityTrace.field_72308_g = entity1;
            d2 = d3;
        }
        if (entityTrace != null && (d2 < d1 || objectMouseOver == null)) {
            objectMouseOver = entityTrace;
        }
        return objectMouseOver;
    }

    public static EntityItem breakBlockAndDropWithChance(World world, BlockPos pos, float hardnessLimit, float breakChance, float dropChance) {
        return ProcedureUtils.breakBlockAndDropWithChance(world, pos, hardnessLimit, breakChance, dropChance, true);
    }

    @Nullable
    public static EntityItem breakBlockAndDropWithChance(World world, BlockPos pos, float hardnessLimit, float breakChance, float dropChance, boolean sound) {
        EntityItem entityToSpawn = null;
        IBlockState blockstate = world.func_180495_p(pos);
        float blockHardness = blockstate.func_185887_b(world, pos);
        if (!world.func_175623_d(pos) && blockHardness >= 0.0f && blockHardness <= hardnessLimit && RNG.nextFloat() <= breakChance) {
            if (sound) {
                SoundType type = blockstate.func_177230_c().func_185467_w();
                world.func_184133_a(null, pos, type.func_185845_c(), SoundCategory.BLOCKS, (type.func_185843_a() + 1.0f) / 2.0f, type.func_185847_b() * 0.8f);
            }
            if (ForgeEventFactory.getMobGriefingEvent((World)world, null)) {
                Item item;
                world.func_175698_g(pos);
                if (!world.field_72995_K && Math.random() <= (double)dropChance && (item = blockstate.func_177230_c().func_180660_a(blockstate, RNG, 0)) != Items.field_190931_a) {
                    entityToSpawn = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(item, 1));
                    entityToSpawn.func_174869_p();
                    world.func_72838_d((Entity)entityToSpawn);
                }
            }
            if (world instanceof WorldServer) {
                ((WorldServer)world).func_175739_a(EnumParticleTypes.BLOCK_DUST, 0.5 + (double)pos.func_177958_n(), 0.5 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), 8, 0.2, 0.2, 0.2, 0.15, new int[]{Block.func_149682_b((Block)blockstate.func_177230_c())});
            }
        }
        return entityToSpawn;
    }

    public static <T extends Entity> T findNearestSensibleEntityWithinAABB(World world, Class<? extends T> entityType, AxisAlignedBB aabb, final EntityLivingBase closestTo) {
        return ProcedureUtils.findNearestEntityWithinAABB(world, entityType, aabb, (Entity)closestTo, Predicates.and((Predicate)EntitySelectors.field_188444_d, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                return p_apply_1_ != null && p_apply_1_.func_70089_S() && p_apply_1_.func_70067_L() && closestTo.func_70685_l(p_apply_1_);
            }
        }));
    }

    public static <T extends Entity> T findNearestEntityWithinAABB(World world, Class<? extends T> entityType, AxisAlignedBB aabb, Entity closestTo, @Nullable Predicate<? super T> filter) {
        List list = world.func_175647_a(entityType, aabb, filter);
        Entity t = null;
        double d0 = Double.MAX_VALUE;
        for (int j2 = 0; j2 < list.size(); ++j2) {
            double d2;
            Entity t1 = (Entity)list.get(j2);
            if (t1 == closestTo || !EntitySelectors.field_180132_d.apply((Object)t1) || !((d2 = closestTo.func_70068_e(t1)) <= d0)) continue;
            t = t1;
            d0 = d2;
        }
        return (T)t;
    }

    public static List<BlockPos> getBlocksOfType(World world, AxisAlignedBB bb, Block block) {
        ArrayList list = Lists.newArrayList();
        int j2 = MathHelper.func_76128_c((double)bb.field_72340_a);
        int k2 = MathHelper.func_76143_f((double)bb.field_72336_d);
        int l2 = MathHelper.func_76128_c((double)bb.field_72338_b);
        int i3 = MathHelper.func_76143_f((double)bb.field_72337_e);
        int j3 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int k3 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos mutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int l3 = j2; l3 < k2; ++l3) {
            for (int i4 = l2; i4 < i3; ++i4) {
                for (int j4 = j3; j4 < k3; ++j4) {
                    if (world.func_180495_p((BlockPos)mutableblockpos.func_181079_c(l3, i4, j4)).func_177230_c() != block) continue;
                    list.add(mutableblockpos.func_185334_h());
                }
            }
        }
        mutableblockpos.func_185344_t();
        return list;
    }

    public static List<BlockPos> getNonAirBlocks(World world, AxisAlignedBB bb, float hardnessLimit, boolean hasCollisionbox) {
        ArrayList list = Lists.newArrayList();
        int j2 = MathHelper.func_76128_c((double)bb.field_72340_a);
        int k2 = MathHelper.func_76143_f((double)bb.field_72336_d);
        int l2 = MathHelper.func_76128_c((double)bb.field_72338_b);
        int i3 = MathHelper.func_76143_f((double)bb.field_72337_e);
        int j3 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int k3 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int l3 = j2; l3 < k2; ++l3) {
            for (int i4 = l2; i4 < i3; ++i4) {
                for (int j4 = j3; j4 < k3; ++j4) {
                    IBlockState blockstate = world.func_180495_p((BlockPos)pos.func_181079_c(l3, i4, j4));
                    float hardness = blockstate.func_185887_b(world, (BlockPos)pos);
                    if (world.func_175623_d((BlockPos)pos) || !(hardnessLimit < 0.0f) && (!(hardness >= 0.0f) || !(hardness <= hardnessLimit)) || hasCollisionbox && blockstate.func_185890_d((IBlockAccess)world, (BlockPos)pos) == Block.field_185506_k) continue;
                    list.add(pos.func_185334_h());
                }
            }
        }
        pos.func_185344_t();
        return list;
    }

    public static List<BlockPos> getNonAirBlocks(World world, AxisAlignedBB bb, boolean hasCollisionbox) {
        return ProcedureUtils.getNonAirBlocks(world, bb, 1000.0f, hasCollisionbox);
    }

    public static List<BlockPos> getNonAirBlocks(World world, AxisAlignedBB bb) {
        return ProcedureUtils.getNonAirBlocks(world, bb, 1000.0f, false);
    }

    public static List<AxisAlignedBB> getBoundingBoxes(World world, AxisAlignedBB bb) {
        ArrayList list = Lists.newArrayList();
        for (BlockPos pos : ProcedureUtils.getNonAirBlocks(world, bb)) {
            list.add(world.func_180495_p(pos).func_185900_c((IBlockAccess)world, pos).func_186670_a(pos));
        }
        return list;
    }

    public static List<BlockPos> getAllAirBlocks(World world, AxisAlignedBB bb) {
        ArrayList list = Lists.newArrayList();
        int j2 = MathHelper.func_76128_c((double)bb.field_72340_a);
        int k2 = MathHelper.func_76143_f((double)bb.field_72336_d);
        int l2 = MathHelper.func_76128_c((double)bb.field_72338_b);
        int i3 = MathHelper.func_76143_f((double)bb.field_72337_e);
        int j3 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int k3 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int l3 = j2; l3 < k2; ++l3) {
            for (int i4 = l2; i4 < i3; ++i4) {
                for (int j4 = j3; j4 < k3; ++j4) {
                    if (!world.func_175623_d((BlockPos)pos.func_181079_c(l3, i4, j4))) continue;
                    list.add(pos.func_185334_h());
                }
            }
        }
        pos.func_185344_t();
        return list;
    }

    @Nullable
    public static BlockPos getNearestAirBlock(World world, AxisAlignedBB bb, BlockPos closestTo) {
        List<BlockPos> list = ProcedureUtils.getAllAirBlocks(world, bb);
        if (!list.isEmpty()) {
            list.sort(new BlockposSorter(closestTo));
            return list.get(0);
        }
        return null;
    }

    @Nullable
    public static BlockPos getNearestNonAirBlock(World world, AxisAlignedBB bb, BlockPos closestTo, float hardnessLimit, boolean hasCollisionbox) {
        List<BlockPos> list = ProcedureUtils.getNonAirBlocks(world, bb, hardnessLimit, hasCollisionbox);
        if (!list.isEmpty()) {
            list.sort(new BlockposSorter(closestTo));
            return list.get(0);
        }
        return null;
    }

    public static boolean isSpaceOpenToStandOn(EntityLivingBase entity, BlockPos pos) {
        AxisAlignedBB bb = entity.func_174813_aQ();
        Vec3d vec = new Vec3d(0.5 + (double)pos.func_177958_n(), (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p()).func_178786_a(entity.field_70165_t, bb.field_72338_b, entity.field_70161_v);
        return entity.field_70170_p.func_184144_a(null, bb.func_191195_a(0.0, -0.1, 0.0).func_72314_b(0.5, 0.0, 0.5).func_191194_a(vec)).isEmpty();
    }

    public static String animateString(String string, int type, boolean returnToBlack) {
        int stringLength = string.length();
        if (stringLength < 1) {
            return "";
        }
        String outputString = "";
        if (type == 0) {
            long l = Minecraft.func_71386_F();
            for (int i = 0; i < stringLength; ++i) {
                outputString = ((long)i + l / 10L) % 188L == 0L ? outputString + TextFormatting.WHITE + string.substring(i, i + 1) : (((long)i + l / 10L) % 188L == 1L ? outputString + TextFormatting.YELLOW + string.substring(i, i + 1) : (((long)i + l / 10L) % 188L == 187L ? outputString + TextFormatting.YELLOW + string.substring(i, i + 1) : outputString + TextFormatting.GOLD + string.substring(i, i + 1)));
            }
        } else if (type == 1) {
            outputString = TextFormatting.func_175744_a((int)((int)(Minecraft.func_71386_F() / 80L % 15L) + (returnToBlack ? 0 : 1))) + string;
        }
        if (returnToBlack) {
            return outputString + TextFormatting.BLACK;
        }
        return outputString + TextFormatting.WHITE;
    }

    public static boolean advancementAchieved(EntityPlayerMP player, String advancementName) {
        Advancement adv = ((WorldServer)player.field_70170_p).func_191952_z().func_192778_a(new ResourceLocation(advancementName));
        return adv != null ? player.func_192039_O().func_192747_a(adv).func_192105_a() : false;
    }

    public static void grantAdvancement(EntityPlayerMP player, String advancementName, boolean playToast) {
        Advancement _adv = player.field_71133_b.func_191949_aK().func_192778_a(new ResourceLocation(advancementName));
        AdvancementProgress _ap = player.func_192039_O().func_192747_a(_adv);
        if (!_ap.func_192105_a()) {
            for (String _criterion : _ap.func_192107_d()) {
                player.func_192039_O().func_192750_a(_adv, _criterion);
            }
            if (playToast) {
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("ui.toast.challenge_complete")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    public static boolean isWeapon(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_111283_C(EntityEquipmentSlot.MAINHAND).containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
    }

    public static double getFollowRange(EntityLivingBase entity) {
        IAttributeInstance attribute = entity.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return attribute != null ? attribute.func_111126_e() : 0.0;
    }

    public static double getModifiedSpeed(EntityLivingBase entity) {
        IAttributeInstance attribute = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        return attribute != null ? attribute.func_111126_e() : 0.0;
    }

    public static double getAttackSpeed(EntityLivingBase entity) {
        IAttributeInstance attribute = entity.func_110148_a(SharedMonsterAttributes.field_188790_f);
        return attribute != null ? attribute.func_111126_e() : 0.0;
    }

    public static double getModifiedAttackDamage(EntityLivingBase entity) {
        IAttributeInstance attribute = entity.func_110148_a(SharedMonsterAttributes.field_111264_e);
        return attribute != null ? attribute.func_111126_e() : 0.0;
    }

    public static double getPunchDamage(EntityLivingBase entity) {
        IAttributeInstance attribute = entity.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (attribute != null) {
            double d = attribute.func_111126_e();
            ItemStack stack = entity.func_184614_ca();
            if (ProcedureUtils.isWeapon(stack)) {
                Collection modifiers = stack.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
                for (AttributeModifier modifier : modifiers) {
                    attribute.func_111124_b(modifier);
                }
                d = attribute.func_111126_e();
                for (AttributeModifier modifier : modifiers) {
                    attribute.func_111121_a(modifier);
                }
            }
            return d;
        }
        return 0.0;
    }

    public static double getMainhandItemDamage(EntityLivingBase entity) {
        return ProcedureUtils.getModifiedAttackDamage(entity) - ProcedureUtils.getPunchDamage(entity);
    }

    public static double getArmorValue(EntityLivingBase entity) {
        IAttributeInstance attribute = entity.func_110148_a(SharedMonsterAttributes.field_188791_g);
        return attribute != null ? attribute.func_111126_e() : 0.0;
    }

    public static double getReachDistance(EntityLivingBase entity) {
        IAttributeInstance attribute = entity.func_110148_a(EntityPlayer.REACH_DISTANCE);
        return attribute != null ? attribute.func_111126_e() : (double)(entity.field_70130_N * 2.0f);
    }

    public static double getReachDistanceSq(EntityLivingBase entity) {
        double d = ProcedureUtils.getReachDistance(entity);
        return d * d;
    }

    public static void setDeathAnimations(EntityLivingBase entity, int type, int duration) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_() || !entity.func_70089_S()) {
            return;
        }
        if (entity.getEntityData().func_74769_h(NarutomodModVariables.DeathAnimationTime) <= 0.0) {
            entity.getEntityData().func_74780_a("deathAnimationType", (double)type);
            entity.getEntityData().func_74780_a(NarutomodModVariables.DeathAnimationTime, (double)duration);
            if (type == 2 && entity instanceof EntityPlayer) {
                PlayerRender.setColorMultiplier((EntityPlayer)entity, 0x30000000);
            }
        }
    }

    public static void clearDeathAnimations(EntityLivingBase entity) {
        if ((int)entity.getEntityData().func_74769_h("deathAnimationType") == 2 && entity instanceof EntityPlayer) {
            PlayerRender.setColorMultiplier((EntityPlayer)entity, 0);
        }
        entity.getEntityData().func_82580_o("deathAnimationType");
        entity.getEntityData().func_82580_o(NarutomodModVariables.DeathAnimationTime);
    }

    public static Field getFieldByIndex(Class clazz, Class matchClazz, int fieldIndex) {
        if (clazz == matchClazz) {
            try {
                Field[] fields = clazz.getDeclaredFields();
                if (fields.length > fieldIndex) {
                    fields[fieldIndex].setAccessible(true);
                    return fields[fieldIndex];
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            throw new IndexOutOfBoundsException(matchClazz + " does not have " + (fieldIndex + 1) + " declared fields");
        }
        Class superClass = clazz.getSuperclass();
        if (superClass == null) {
            throw new RuntimeException("no matching class " + matchClazz);
        }
        return ProcedureUtils.getFieldByIndex(superClass, matchClazz, fieldIndex);
    }

    public static <T> T invokeMethodByParameters(Object parent, Class<? extends T> returnType, Object ... params) {
        try {
            for (Method method : parent.getClass().getDeclaredMethods()) {
                boolean match = true;
                Class<?>[] clazz1 = method.getParameterTypes();
                if (!method.getReturnType().equals(returnType) || clazz1.length != params.length) {
                    match = false;
                } else {
                    for (int i = 0; i < clazz1.length; ++i) {
                        if (clazz1[i].isAssignableFrom(params[i].getClass())) continue;
                        match = false;
                    }
                }
                if (!match) continue;
                method.setAccessible(true);
                return (T)method.invoke(parent, params);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalArgumentException(parent + " does not have methods matching parameters: " + params + ", returns: " + returnType);
    }

    public static void setInvulnerableDimensionChange(EntityPlayerMP player) {
        try {
            Field invulnerableDimensionChangeField = ProcedureUtils.getFieldByIndex(player.getClass(), EntityPlayerMP.class, 25);
            invulnerableDimensionChangeField.setBoolean(player, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Trying to set EntityPlayerMP@invulnerableDimensionChange");
        }
    }

    public static void poofWithSmoke(Entity entity) {
        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:poof")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
        Particles.spawnParticle(entity.field_70170_p, Particles.Types.SMOKE, entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v, 300, (double)entity.field_70130_N * 0.5, (double)entity.field_70131_O * 0.3, (double)entity.field_70130_N * 0.5, 0.0, 0.0, 0.0, -788529153, 30);
    }

    public static float subtractDegreesWrap(float cur, float prev) {
        while (cur - prev < -180.0f) {
            prev -= 360.0f;
        }
        while (cur - prev >= 180.0f) {
            prev += 360.0f;
        }
        return cur - prev;
    }

    public static float interpolateRotation(float prev, float cur, float pt) {
        float f;
        for (f = cur - prev; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prev + f * pt;
    }

    public static Vec3d rotateRoll(Vec3d vec3d, float roll) {
        float f = MathHelper.func_76134_b((float)roll);
        float f1 = MathHelper.func_76126_a((float)roll);
        double d0 = vec3d.field_72450_a * (double)f - vec3d.field_72448_b * (double)f1;
        double d1 = vec3d.field_72448_b * (double)f + vec3d.field_72450_a * (double)f1;
        double d2 = vec3d.field_72449_c;
        return new Vec3d(d0, d1, d2);
    }

    public static float getYawFromVec(double x, double z) {
        return (float)(-MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
    }

    public static float getYawFromVec(Vec3d vec) {
        return (float)(-MathHelper.func_181159_b((double)vec.field_72450_a, (double)vec.field_72449_c) * 57.29577951308232);
    }

    public static float getPitchFromVec(double x, double y, double z) {
        float f = MathHelper.func_76133_a((double)(x * x + z * z));
        return (float)(-MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
    }

    public static float getPitchFromVec(Vec3d vec) {
        return ProcedureUtils.getPitchFromVec(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static Vec2f getYawPitchFromVec(Vec3d vec3d) {
        return new Vec2f(ProcedureUtils.getYawFromVec(vec3d.field_72450_a, vec3d.field_72449_c), ProcedureUtils.getPitchFromVec(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c));
    }

    public static double getCDModifier(double modifier) {
        return 1.0 / (0.5 + 0.02 * modifier);
    }

    public static double getCooldownModifier(EntityPlayer player) {
        return ProcedureUtils.getCDModifier(PlayerTracker.getNinjaLevel(player));
    }

    public static double modifiedCooldown(double cooldown, EntityPlayer player) {
        return cooldown * ProcedureUtils.getCooldownModifier(player);
    }

    public static boolean isPlayerDisconnected(Entity entity) {
        return entity instanceof EntityPlayerMP && ((EntityPlayerMP)entity).func_193105_t();
    }

    public static void sendChatAll(String string) {
        MinecraftServer mcserv = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcserv != null) {
            mcserv.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(string));
        }
    }

    public static void sendChat(EntityPlayer player, String string) {
        player.func_145747_a((ITextComponent)new TextComponentString(string));
    }

    public static void sendMessageToAllNear(String string, double x, double y, double z, double radius, int dimension) {
        MinecraftServer mcserv = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcserv != null) {
            for (int i = 0; i < mcserv.func_184103_al().func_72394_k(); ++i) {
                double d2;
                double d1;
                double d0;
                EntityPlayerMP entityplayermp = (EntityPlayerMP)mcserv.func_184103_al().func_181057_v().get(i);
                if (entityplayermp.field_71093_bK != dimension || !((d0 = x - entityplayermp.field_70165_t) * d0 + (d1 = y - entityplayermp.field_70163_u) * d1 + (d2 = z - entityplayermp.field_70161_v) * d2 < radius * radius)) continue;
                entityplayermp.func_145747_a((ITextComponent)new TextComponentString(string));
            }
        }
    }

    public static class Vec2f {
        public static final Vec2f ZERO = new Vec2f(0.0f, 0.0f);
        public final float x;
        public final float y;

        public Vec2f(float xIn, float yIn) {
            this.x = xIn;
            this.y = yIn;
        }

        public boolean equals(Vec2f vec) {
            return vec == this || Vec2f.wrapDegrees(vec.x) == Vec2f.wrapDegrees(this.x) && Vec2f.wrapDegrees(vec.y) == Vec2f.wrapDegrees(this.y);
        }

        public Vec2f wrapDegrees() {
            return new Vec2f(Vec2f.wrapDegrees(this.x), Vec2f.wrapDegrees(this.y));
        }

        public Vec2f add(float f0, float f1) {
            return new Vec2f(Vec2f.wrapDegrees(this.x + f0), Vec2f.wrapDegrees(this.y + f1));
        }

        public Vec2f add(Vec2f vec) {
            return this.add(vec.x, vec.y);
        }

        public Vec2f subtract(float f0, float f1) {
            return new Vec2f(Vec2f.wrapDegrees(this.x - f0), Vec2f.wrapDegrees(this.y - f1));
        }

        public Vec2f subtract(Vec2f vec) {
            return this.subtract(vec.x, vec.y);
        }

        public Vec2f scale(float f0) {
            return new Vec2f(Vec2f.wrapDegrees(this.x * f0), Vec2f.wrapDegrees(this.y * f0));
        }

        public float lengthVector() {
            return MathHelper.func_76133_a((double)((double)this.x * (double)this.x + (double)this.y * (double)this.y));
        }

        public Vec2f rad2Deg() {
            return this.scale(57.295776f);
        }

        public static float wrapDegrees(float f0) {
            while ((double)f0 >= 180.0) {
                f0 = (float)((double)f0 - 360.0);
            }
            while ((double)f0 < -180.0) {
                f0 = (float)((double)f0 + 360.0);
            }
            return f0;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }

    public static class CollisionHelper {
        private Entity entity;
        public double dx;
        public double dy;
        public double dz;
        private final List<AxisAlignedBB>[] hitsList = new List[6];
        private final Map<Entity, EnumFacing> entitiesList = Maps.newHashMap();

        public CollisionHelper(Entity entityIn) {
            this.entity = entityIn;
            for (int i = 0; i < this.hitsList.length; ++i) {
                this.hitsList[i] = Lists.newArrayList();
            }
        }

        public void collideWithAABBs(List<AxisAlignedBB> list, double x, double y, double z) {
            double d;
            this.dx = x;
            this.dy = y;
            this.dz = z;
            for (int i = 0; i < this.hitsList.length; ++i) {
                this.hitsList[i].clear();
            }
            if (x != 0.0) {
                for (AxisAlignedBB aabb : list) {
                    d = aabb.func_72316_a(this.entity.func_174813_aQ(), x);
                    if (Math.abs(d) < Math.abs(this.dx)) {
                        this.dx = d;
                    }
                    if (d == x) continue;
                    this.hitsList[(x > 0.0 ? EnumFacing.EAST : EnumFacing.WEST).func_176745_a()].add(aabb);
                }
            }
            if (y != 0.0) {
                for (AxisAlignedBB aabb : list) {
                    d = aabb.func_72323_b(this.entity.func_174813_aQ(), y);
                    if (Math.abs(d) < Math.abs(this.dy)) {
                        this.dy = d;
                    }
                    if (d == y) continue;
                    this.hitsList[(y > 0.0 ? EnumFacing.UP : EnumFacing.DOWN).func_176745_a()].add(aabb);
                }
            }
            if (z != 0.0) {
                for (AxisAlignedBB aabb : list) {
                    d = aabb.func_72322_c(this.entity.func_174813_aQ(), z);
                    if (Math.abs(d) < Math.abs(this.dz)) {
                        this.dz = d;
                    }
                    if (d == z) continue;
                    this.hitsList[(z > 0.0 ? EnumFacing.SOUTH : EnumFacing.NORTH).func_176745_a()].add(aabb);
                }
            }
        }

        public void collideWithEntities(double x, double y, double z, @Nullable Predicate<Entity> predicate) {
            this.entitiesList.clear();
            Vec3d vec3d = new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u + (double)(this.entity.field_70131_O / 2.0f), this.entity.field_70161_v);
            Vec3d vec3d2 = vec3d.func_72441_c(x, y, z);
            for (Entity entity1 : this.entity.field_70170_p.func_175674_a(this.entity, this.entity.func_174813_aQ().func_72321_a(x, y, z), predicate)) {
                RayTraceResult res;
                if (!entity1.func_70067_L() || !ItemJutsu.canTarget(entity1) || (res = entity1.func_174813_aQ().func_72314_b((double)(this.entity.field_70130_N / 2.0f), (double)(this.entity.field_70131_O / 2.0f), (double)(this.entity.field_70130_N / 2.0f)).func_72327_a(vec3d, vec3d2)) == null) continue;
                this.entitiesList.put(entity1, res.field_178784_b.func_176734_d());
            }
        }

        public void collideWithAll(double x, double y, double z, @Nullable Predicate<Entity> predicate) {
            this.collideWithAABBs(this.entity.field_70170_p.func_184144_a(null, this.entity.func_174813_aQ().func_72321_a(x, y, z)), x, y, z);
            this.collideWithEntities(this.dx, this.dy, this.dz, predicate);
        }

        public AxisAlignedBB getUpdateEntityBoundingBox() {
            return this.entity.func_174813_aQ().func_72317_d(this.dx, this.dy, this.dz);
        }

        public Vec3d getUpdatedMotion() {
            return new Vec3d(this.dx, this.dy, this.dz);
        }

        public double minX(double x) {
            return Math.signum(x) != Math.signum(this.dx) ? 0.0 : (Math.abs(x) < Math.abs(this.dx) ? x : this.dx);
        }

        public double minY(double y) {
            return Math.signum(y) != Math.signum(this.dy) ? 0.0 : (Math.abs(y) < Math.abs(this.dy) ? y : this.dy);
        }

        public double minZ(double z) {
            return Math.signum(z) != Math.signum(this.dz) ? 0.0 : (Math.abs(z) < Math.abs(this.dz) ? z : this.dz);
        }

        public double distanceToOrigin() {
            return MathHelper.func_76133_a((double)(this.dx * this.dx + this.dy * this.dy + this.dz * this.dz));
        }

        @Nullable
        public BlockPos nearestHitOnSide(EnumFacing face) {
            double d = 40000.0;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (AxisAlignedBB aabb : this.hitsList[face.func_176745_a()]) {
                Vec3d vec = BB.getCenter(aabb);
                Vec3i veci = face.func_176730_m();
                Vec3d vec1 = new Vec3d(vec.field_72450_a * (double)Math.abs(veci.func_177958_n()), vec.field_72448_b * (double)Math.abs(veci.func_177956_o()), vec.field_72449_c * (double)Math.abs(veci.func_177952_p()));
                Vec3d vec2 = BB.getCenter(this.entity.func_174813_aQ());
                Vec3d vec3 = new Vec3d(vec2.field_72450_a * (double)Math.abs(veci.func_177958_n()), vec2.field_72448_b * (double)Math.abs(veci.func_177956_o()), vec2.field_72449_c * (double)Math.abs(veci.func_177952_p()));
                double d1 = vec1.func_72436_e(vec3);
                if (!(d1 < d)) continue;
                pos.func_189532_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                d = d1;
            }
            return d == 40000.0 ? null : pos.func_185334_h();
        }

        public List<BlockPos> hitsOnSide(EnumFacing face) {
            ArrayList newlist = Lists.newArrayList();
            for (AxisAlignedBB aabb : this.hitsList[face.func_176745_a()]) {
                newlist.add(new BlockPos(BB.getCenter(aabb)));
            }
            return newlist;
        }

        public boolean hitOnSide(EnumFacing face) {
            return !this.hitsList[face.func_176745_a()].isEmpty();
        }

        public boolean hitOnAxis(EnumFacing.Axis axis) {
            for (int i = 0; i < this.hitsList.length; ++i) {
                if (this.hitsList[i].isEmpty() || EnumFacing.func_82600_a((int)i).func_176740_k() != axis) continue;
                return true;
            }
            return false;
        }

        public boolean hitOnPlane(EnumFacing.Plane plane) {
            for (int i = 0; i < this.hitsList.length; ++i) {
                if (this.hitsList[i].isEmpty() || EnumFacing.func_82600_a((int)i).func_176740_k().func_176716_d() != plane) continue;
                return true;
            }
            return false;
        }

        public List<BlockPos> getHitBlocks() {
            ArrayList newlist = Lists.newArrayList();
            for (List<AxisAlignedBB> list : this.hitsList) {
                for (AxisAlignedBB aabb : list) {
                    newlist.add(new BlockPos(BB.getCenter(aabb)));
                }
            }
            return newlist;
        }

        public boolean anyBlockHits() {
            for (List<AxisAlignedBB> list : this.hitsList) {
                if (list.isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public BlockPos nearestHit() {
            List<BlockPos> list = this.getHitBlocks();
            if (!list.isEmpty()) {
                list.sort(new BlockposSorter(new BlockPos(this.entity.field_70165_t, this.entity.field_70163_u + (double)this.entity.field_70131_O * 0.5, this.entity.field_70161_v)));
                return list.get(0);
            }
            return null;
        }

        public Set<Entity> getEntitiesHit() {
            return this.entitiesList.keySet();
        }

        public Map<Entity, EnumFacing> getEntitiesHitMap() {
            return this.entitiesList;
        }

        public static void reposHitEntity(AxisAlignedBB referenceBB, Entity hitEntity, EnumFacing side) {
            if (side == EnumFacing.WEST) {
                hitEntity.field_70165_t = referenceBB.field_72340_a - (double)hitEntity.field_70130_N * 0.5;
            } else if (side == EnumFacing.EAST) {
                hitEntity.field_70165_t = referenceBB.field_72336_d + (double)hitEntity.field_70130_N * 0.5;
            } else if (side == EnumFacing.NORTH) {
                hitEntity.field_70161_v = referenceBB.field_72339_c - (double)hitEntity.field_70130_N * 0.5;
            } else if (side == EnumFacing.SOUTH) {
                hitEntity.field_70161_v = referenceBB.field_72334_f + (double)hitEntity.field_70130_N * 0.5;
            } else {
                hitEntity.field_70163_u = side == EnumFacing.UP ? referenceBB.field_72337_e : referenceBB.field_72338_b - (double)hitEntity.field_70131_O;
            }
            hitEntity.func_70107_b(hitEntity.field_70165_t, hitEntity.field_70163_u, hitEntity.field_70161_v);
        }
    }

    public static class BB {
        public static double calculateInvXOffset(AxisAlignedBB main, AxisAlignedBB other, double offsetX) {
            if (other.field_72337_e > main.field_72338_b && other.field_72338_b < main.field_72337_e && other.field_72334_f > main.field_72339_c && other.field_72339_c < main.field_72334_f) {
                double d0;
                if (offsetX > 0.0 && other.field_72336_d <= main.field_72336_d) {
                    double d1 = main.field_72336_d - other.field_72336_d;
                    if (d1 < offsetX) {
                        offsetX = d1;
                    }
                } else if (offsetX < 0.0 && other.field_72340_a >= main.field_72340_a && (d0 = main.field_72340_a - other.field_72340_a) > offsetX) {
                    offsetX = d0;
                }
            }
            return offsetX;
        }

        public static double calculateInvYOffset(AxisAlignedBB main, AxisAlignedBB other, double offsetY) {
            if (other.field_72336_d > main.field_72340_a && other.field_72340_a < main.field_72336_d && other.field_72334_f > main.field_72339_c && other.field_72339_c < main.field_72334_f) {
                double d0;
                if (offsetY > 0.0 && other.field_72337_e <= main.field_72337_e) {
                    double d1 = main.field_72337_e - other.field_72337_e;
                    if (d1 < offsetY) {
                        offsetY = d1;
                    }
                } else if (offsetY < 0.0 && other.field_72338_b >= main.field_72338_b && (d0 = main.field_72338_b - other.field_72338_b) > offsetY) {
                    offsetY = d0;
                }
            }
            return offsetY;
        }

        public static double calculateInvZOffset(AxisAlignedBB main, AxisAlignedBB other, double offsetZ) {
            if (other.field_72336_d > main.field_72340_a && other.field_72340_a < main.field_72336_d && other.field_72337_e > main.field_72338_b && other.field_72338_b < main.field_72337_e) {
                double d0;
                if (offsetZ > 0.0 && other.field_72334_f <= main.field_72334_f) {
                    double d1 = main.field_72334_f - other.field_72334_f;
                    if (d1 < offsetZ) {
                        offsetZ = d1;
                    }
                } else if (offsetZ < 0.0 && other.field_72339_c >= main.field_72339_c && (d0 = main.field_72339_c - other.field_72339_c) > offsetZ) {
                    offsetZ = d0;
                }
            }
            return offsetZ;
        }

        public static double getCenterX(AxisAlignedBB aabb) {
            return aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * 0.5;
        }

        public static double getCenterY(AxisAlignedBB aabb) {
            return aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * 0.5;
        }

        public static double getCenterZ(AxisAlignedBB aabb) {
            return aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * 0.5;
        }

        public static Vec3d getCenter(AxisAlignedBB aabb) {
            return new Vec3d(BB.getCenterX(aabb), BB.getCenterY(aabb), BB.getCenterZ(aabb));
        }

        public static double getVolume(AxisAlignedBB aabb) {
            return (aabb.field_72336_d - aabb.field_72340_a) * (aabb.field_72337_e - aabb.field_72338_b) * (aabb.field_72334_f - aabb.field_72339_c);
        }
    }

    public static class RayTraceResultSorter
    implements Comparator<RayTraceResult> {
        private final Vec3d vec;

        public RayTraceResultSorter(Vec3d vecIn) {
            this.vec = vecIn;
        }

        @Override
        public int compare(RayTraceResult res1, RayTraceResult res2) {
            double d1;
            double d0 = this.vec.func_72436_e(res1.field_72307_f);
            if (d0 < (d1 = this.vec.func_72436_e(res2.field_72307_f))) {
                return -1;
            }
            return d0 > d1 ? 1 : 0;
        }
    }

    public static class VecSorter
    implements Comparator<Vec3d> {
        private final Vec3d vec;
        private final boolean reverse;

        public VecSorter(Vec3d vecIn) {
            this(vecIn, false);
        }

        public VecSorter(Vec3d vecIn, boolean isReversed) {
            this.vec = vecIn;
            this.reverse = isReversed;
        }

        @Override
        public int compare(Vec3d vec1, Vec3d vec2) {
            double d1;
            double d0 = this.vec.func_72436_e(vec1);
            if (d0 < (d1 = this.vec.func_72436_e(vec2))) {
                return this.reverse ? 1 : -1;
            }
            return d0 > d1 ? (this.reverse ? -1 : 1) : 0;
        }
    }

    public static class EntitySorter
    implements Comparator<Entity> {
        private final double x;
        private final double y;
        private final double z;

        public EntitySorter(Entity entityIn) {
            this(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v);
        }

        public EntitySorter(double xIn, double yIn, double zIn) {
            this.x = xIn;
            this.y = yIn;
            this.z = zIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = p_compare_1_.func_70092_e(this.x, this.y, this.z);
            if (d0 < (d1 = p_compare_2_.func_70092_e(this.x, this.y, this.z))) {
                return -1;
            }
            return d0 > d1 ? 1 : 0;
        }
    }

    public static class BlockposSorter
    implements Comparator<BlockPos> {
        private final BlockPos pos;

        public BlockposSorter(BlockPos posIn) {
            this.pos = posIn;
        }

        @Override
        public int compare(BlockPos p_compare_1_, BlockPos p_compare_2_) {
            double d1;
            double d0 = this.pos.func_177951_i((Vec3i)p_compare_1_);
            if (d0 < (d1 = this.pos.func_177951_i((Vec3i)p_compare_2_))) {
                return -1;
            }
            return d0 > d1 ? 1 : 0;
        }
    }
}

