/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.dungeon.DungeonTunnel;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.BoundingBox;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBounded;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.IShape;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.shapes.Shape;
import java.util.Random;

public class DungeonNode
implements IBounded {
    private Coord pos;
    private DungeonBase toGenerate;
    private Cardinal[] entrances;

    public DungeonNode(Cardinal[] entrances, Coord origin) {
        this.entrances = entrances;
        this.pos = new Coord(origin);
    }

    public void setDungeon(DungeonBase toGenerate) {
        this.toGenerate = toGenerate;
    }

    public int getSize() {
        if (this.toGenerate == null) {
            return 6;
        }
        return this.toGenerate.getSize();
    }

    public void encase(WorldEditor editor, Random rand, ITheme theme) {
        int size = this.getSize();
        Coord s = new Coord(this.getPosition());
        Coord e = new Coord(s);
        s.translate(Cardinal.NORTH, size);
        s.translate(Cardinal.WEST, size);
        s.translate(Cardinal.DOWN, 3);
        e.translate(Cardinal.SOUTH, size);
        e.translate(Cardinal.EAST, size);
        e.translate(Cardinal.UP, 8);
        RectSolid.fill(editor, rand, s, e, theme.getPrimary().getWall());
    }

    public Cardinal[] getEntrances() {
        return this.entrances;
    }

    public Coord getPosition() {
        return new Coord(this.pos);
    }

    public DungeonBase getRoom() {
        return this.toGenerate;
    }

    public BoundingBox getBoundingBox(int size) {
        Coord start = new Coord(this.pos);
        Coord end = new Coord(this.pos);
        start.translate(Cardinal.NORTH, size);
        start.translate(Cardinal.WEST, size);
        start.translate(Cardinal.DOWN, 1);
        end.translate(Cardinal.SOUTH, size);
        end.translate(Cardinal.EAST, size);
        end.translate(Cardinal.UP, 8);
        return new BoundingBox(start, end);
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.getBoundingBox(this.getSize());
    }

    public boolean connectsTo(DungeonTunnel tunnel) {
        return tunnel.hasEnd(this.pos);
    }

    @Override
    public boolean collide(IBounded other) {
        return this.getBoundingBox().collide(other);
    }

    @Override
    public IShape getShape(Shape type) {
        return this.getBoundingBox().getShape(type);
    }

    @Override
    public Coord getStart() {
        return this.getBoundingBox().getStart();
    }

    @Override
    public Coord getEnd() {
        return this.getBoundingBox().getEnd();
    }

    boolean overlaps(int size, DungeonNode other) {
        return this != other && this.getBoundingBox(size).collide(other);
    }

    boolean overlaps(int size, DungeonTunnel tunnel) {
        return !this.connectsTo(tunnel) && this.getBoundingBox(size).collide(tunnel);
    }

    boolean isNotYetGenerated() {
        return this.getRoom() == null;
    }
}

