/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.dungeon.DungeonNode;
import greymerk.roguelike.dungeon.DungeonTunnel;
import greymerk.roguelike.dungeon.ILevelGenerator;
import greymerk.roguelike.dungeon.LevelLayout;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.util.graph.Edge;
import greymerk.roguelike.util.graph.Graph;
import greymerk.roguelike.util.mst.MinimumSpanningTree;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class LevelGeneratorMST
implements ILevelGenerator {
    WorldEditor editor;
    Random rand;
    LevelSettings settings;
    private LevelLayout layout;
    private int length;
    private int scatter;

    public LevelGeneratorMST(WorldEditor editor, Random rand, LevelSettings settings) {
        this.editor = editor;
        this.rand = rand;
        this.settings = settings;
        this.length = (int)Math.ceil(Math.sqrt(settings.getNumRooms()));
        this.scatter = settings.getScatter() % 2 == 0 ? settings.getScatter() + 1 : settings.getScatter();
        this.layout = new LevelLayout();
    }

    @Override
    public void generate(Coord start) {
        MinimumSpanningTree mst = new MinimumSpanningTree(this.rand, this.length, this.scatter, new Coord(start));
        Graph<Coord> layout = mst.getGraph();
        List<Edge<Coord>> edges = layout.getEdges();
        List<Coord> vertices = layout.getPoints();
        ArrayList<Edge<Coord>> used = new ArrayList<Edge<Coord>>();
        for (Coord c : vertices) {
            for (Edge<Coord> e : edges) {
                Coord[] ends;
                if (used.contains(e)) continue;
                for (Coord p : ends = new Coord[]{e.getStart(), e.getEnd()}) {
                    if (!p.equals(c)) continue;
                    Coord tStart = ends[0];
                    Coord tEnd = ends[1];
                    this.layout.addTunnel(new DungeonTunnel(tStart, tEnd));
                    used.add(e);
                }
            }
        }
        DungeonNode startDungeonNode = null;
        for (Coord c : vertices) {
            ArrayList<Cardinal> entrances = new ArrayList<Cardinal>();
            for (DungeonTunnel tunnel : this.layout.getTunnels()) {
                Coord[] ends = tunnel.getEnds();
                if (ends[0].equals(c)) {
                    entrances.add(ends[0].dirTo(ends[1]));
                    continue;
                }
                if (!ends[1].equals(c)) continue;
                entrances.add(ends[1].dirTo(ends[0]));
            }
            Cardinal[] ents = new Cardinal[entrances.size()];
            DungeonNode toAdd = new DungeonNode(entrances.toArray(ents), c);
            this.layout.addNode(toAdd);
            if (!c.equals(start)) continue;
            startDungeonNode = toAdd;
        }
        this.layout.setStartEnd(this.rand, startDungeonNode);
    }

    @Override
    public LevelLayout getLayout() {
        return this.layout;
    }
}

