/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.base.RoomsSetting;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.stream.Collectors;

public class RoomIterator
implements Iterator<DungeonBase> {
    private final LinkedList<DungeonBase> singleRooms;
    private final WeightedRandomizer<RoomSetting> randomRooms;
    private Random random;

    public RoomIterator(RoomsSetting roomsSetting, Random random) {
        this.singleRooms = roomsSetting.getSingleRoomSettings().stream().map(RoomSetting::instantiate).collect(Collectors.toCollection(LinkedList::new));
        this.randomRooms = roomsSetting.getRandomRooms();
        this.random = random;
    }

    public DungeonBase getDungeonRoom() {
        if (this.hasNext()) {
            return this.next();
        }
        if (this.randomRooms.isEmpty()) {
            return RoomType.CORNER.newSingleRoomSetting().instantiate();
        }
        return this.randomRooms.get(this.random).instantiate();
    }

    @Override
    public boolean hasNext() {
        return !this.singleRooms.isEmpty();
    }

    @Override
    public DungeonBase next() {
        return this.singleRooms.poll();
    }
}

