/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import greymerk.roguelike.worldgen.spawners.SpawnerSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DungeonPyramidSpawner
extends DungeonBase {
    public DungeonPyramidSpawner(RoomSetting roomSetting) {
        super(roomSetting);
    }

    @Override
    public DungeonBase generate(WorldEditor editor, Random rand, LevelSettings settings, Coord origin, Cardinal[] entrances) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        ITheme theme = settings.getTheme();
        IBlockFactory blocks = theme.getPrimary().getWall();
        IBlockFactory pillar = theme.getPrimary().getPillar();
        MetaBlock air = BlockType.get(BlockType.AIR);
        RectSolid.fill(editor, rand, new Coord(x - 3, y, z - 3), new Coord(x + 3, y + 3, z + 3), air);
        RectHollow.fill(editor, rand, new Coord(x - 4, y - 1, z - 4), new Coord(x + 4, y + 4, z + 4), blocks, false, true);
        RectSolid.fill(editor, rand, new Coord(x - 3, y + 4, z - 3), new Coord(x + 3, y + 6, z + 3), blocks, false, true);
        RectSolid.fill(editor, rand, new Coord(x - 2, y + 4, z - 2), new Coord(x + 2, y + 4, z + 2), air);
        RectSolid.fill(editor, rand, new Coord(x - 4, y - 1, z - 4), new Coord(x + 4, y - 1, z + 4), theme.getPrimary().getFloor(), false, true);
        Coord cursor = new Coord(x, y, z);
        cursor.translate(Cardinal.UP, 5);
        air.set(editor, cursor);
        cursor.translate(Cardinal.UP, 1);
        blocks.set(editor, rand, cursor);
        cursor = new Coord(x, y, z);
        cursor.translate(Cardinal.UP, 5);
        air.set(editor, cursor);
        cursor.translate(Cardinal.UP);
        air.set(editor, cursor);
        ArrayList<Coord> space = new ArrayList<Coord>();
        for (Cardinal dir : Cardinal.directions) {
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 3);
            cursor.translate(dir.antiClockwise(), 3);
            Coord start = new Coord(cursor);
            cursor.translate(Cardinal.UP, 3);
            Coord end = new Coord(cursor);
            RectSolid.fill(editor, rand, start, end, pillar);
            cursor.translate(Cardinal.UP, 1);
            blocks.set(editor, rand, cursor);
            cursor = new Coord(x, y, z);
            cursor.translate(Cardinal.UP, 4);
            cursor.translate(dir, 2);
            blocks.set(editor, rand, cursor);
            cursor.translate(dir.antiClockwise(), 2);
            blocks.set(editor, rand, cursor);
            cursor = new Coord(x, y, z);
            cursor.translate(Cardinal.UP, 5);
            cursor.translate(dir.antiClockwise());
            air.set(editor, cursor);
            cursor.translate(Cardinal.UP);
            air.set(editor, cursor);
            for (Cardinal orth : dir.orthogonal()) {
                cursor = new Coord(x, y, z);
                cursor.translate(Cardinal.UP, 3);
                cursor.translate(orth);
                cursor.translate(dir, 3);
                blocks.set(editor, rand, cursor);
                cursor = new Coord(x, y, z);
                cursor.translate(Cardinal.UP, 4);
                cursor.translate(dir, 2);
                blocks.set(editor, rand, cursor);
                cursor = new Coord(x, y, z);
                cursor.translate(dir, 3);
                cursor.translate(orth, 2);
                space.add(cursor);
            }
        }
        List<Coord> chestLocations = DungeonPyramidSpawner.chooseRandomLocations(rand, 1, space);
        editor.treasureChestEditor.createChests(Dungeon.getLevel(origin.getY()), chestLocations, false, this.getRoomSetting().getChestType().orElse(ChestType.chooseRandomType(rand, ChestType.COMMON_TREASURES)));
        Coord cursor1 = new Coord(x, y, z);
        SpawnerSettings spawners = settings.getSpawners();
        this.generateSpawner(editor, rand, cursor1, settings.getDifficulty(cursor1), spawners, MobType.COMMON_MOBS);
        return this;
    }

    @Override
    public int getSize() {
        return 4;
    }
}

