/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.redstone.Piston;
import greymerk.roguelike.worldgen.redstone.Torch;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class DungeonsPit
extends DungeonBase {
    WorldEditor editor;
    Random rand;
    int originX;
    int originY;
    int originZ;
    byte dungeonHeight;
    int dungeonLength = 2;
    int dungeonWidth = 2;
    int woolColor;
    int numChests;
    IBlockFactory blocks;
    MetaBlock air = BlockType.get(BlockType.AIR);

    public DungeonsPit(RoomSetting roomSetting) {
        super(roomSetting);
        this.dungeonHeight = (byte)3;
    }

    @Override
    public DungeonBase generate(WorldEditor editor, Random inRandom, LevelSettings settings, Coord origin, Cardinal[] entrances) {
        ITheme theme = settings.getTheme();
        this.editor = editor;
        this.rand = inRandom;
        this.originX = origin.getX();
        this.originY = origin.getY();
        this.originZ = origin.getZ();
        this.blocks = theme.getPrimary().getWall();
        this.buildWalls();
        this.buildFloor();
        this.buildRoof();
        this.buildPit();
        for (Cardinal dir : Cardinal.directions) {
            this.setTrap(editor, this.rand, settings, dir, origin);
        }
        ArrayList<Coord> spaces = new ArrayList<Coord>();
        spaces.add(new Coord(this.originX - 2, this.originY, this.originZ - 2));
        spaces.add(new Coord(this.originX - 2, this.originY, this.originZ + 2));
        spaces.add(new Coord(this.originX + 2, this.originY, this.originZ - 2));
        spaces.add(new Coord(this.originX + 2, this.originY, this.originZ + 2));
        List<Coord> chestLocations = DungeonsPit.chooseRandomLocations(inRandom, 1, spaces);
        editor.treasureChestEditor.createChests(Dungeon.getLevel(this.originY), chestLocations, false, this.getRoomSetting().getChestType().orElse(ChestType.chooseRandomType(this.rand, ChestType.COMMON_TREASURES)));
        return this;
    }

    protected void buildWalls() {
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockY = this.originY + this.dungeonHeight; blockY >= this.originY - 1; --blockY) {
                for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                    if (blockX == this.originX - this.dungeonLength - 1 || blockZ == this.originZ - this.dungeonWidth - 1 || blockX == this.originX + this.dungeonLength + 1 || blockZ == this.originZ + this.dungeonWidth + 1) {
                        if (blockY >= 0 && !this.editor.getBlock(new Coord(blockX, blockY - 1, blockZ)).func_185904_a().func_76220_a()) {
                            this.air.set(this.editor, new Coord(blockX, blockY, blockZ));
                            continue;
                        }
                        if (!this.editor.getBlock(new Coord(blockX, blockY, blockZ)).func_185904_a().func_76220_a()) continue;
                        this.blocks.set(this.editor, this.rand, new Coord(blockX, blockY, blockZ));
                        continue;
                    }
                    this.air.set(this.editor, new Coord(blockX, blockY, blockZ));
                }
            }
        }
    }

    protected void buildFloor() {
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                this.blocks.set(this.editor, this.rand, new Coord(blockX, this.originY - 1, blockZ));
            }
        }
    }

    protected void buildRoof() {
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                this.blocks.set(this.editor, this.rand, new Coord(blockX, this.dungeonHeight + 1, blockZ));
            }
        }
    }

    private void buildPit() {
        for (int x = this.originX - 2; x <= this.originX + 2; ++x) {
            for (int z = this.originZ - 2; z <= this.originZ + 2; ++z) {
                for (int y = this.originY - 1; y > 0; --y) {
                    if (this.editor.isAirBlock(new Coord(x, y, z)) || y < this.rand.nextInt(5) && this.editor.getBlock(new Coord(x, y, z)).func_177230_c() == BlockType.get(BlockType.BEDROCK).func_177230_c()) continue;
                    if (x == this.originX - 2 || x == this.originX + 2 || z == this.originZ - 2 || z == this.originZ + 2) {
                        this.blocks.set(this.editor, this.rand, new Coord(x, y, z), true, true);
                        continue;
                    }
                    if (y < 10) {
                        BlockType.get(BlockType.WATER_FLOWING).set(this.editor, new Coord(x, y, z));
                        continue;
                    }
                    BlockType.get(BlockType.AIR).set(this.editor, new Coord(x, y, z));
                }
            }
        }
    }

    private void setTrap(WorldEditor editor, Random rand, LevelSettings settings, Cardinal dir, Coord origin) {
        ITheme theme = settings.getTheme();
        IBlockFactory walls = theme.getPrimary().getWall();
        MetaBlock plate = BlockType.get(BlockType.PRESSURE_PLATE_STONE);
        MetaBlock wire = BlockType.get(BlockType.REDSTONE_WIRE);
        Coord start = new Coord(origin);
        start.translate(dir, 3);
        start.translate(Cardinal.DOWN);
        start.translate(dir.antiClockwise());
        Coord end = new Coord(origin);
        end.translate(dir, 6);
        end.translate(Cardinal.UP, 3);
        end.translate(dir.clockwise());
        for (Coord cell : new RectHollow(start, end)) {
            if (editor.isAirBlock(cell)) {
                return;
            }
            walls.set(editor, rand, cell);
        }
        Coord cursor = new Coord(origin);
        cursor.translate(dir, 2);
        plate.set(editor, cursor);
        cursor = new Coord(origin);
        cursor.translate(Cardinal.DOWN);
        cursor.translate(dir, 3);
        Torch.generate(editor, Torch.REDSTONE, dir, cursor);
        cursor.translate(dir);
        wire.set(editor, cursor);
        cursor.translate(Cardinal.UP);
        cursor.translate(dir);
        Torch.generate(editor, Torch.REDSTONE_UNLIT, Cardinal.UP, cursor);
        cursor.translate(dir.reverse());
        cursor.translate(Cardinal.UP);
        Piston.generate(editor, cursor, dir.reverse(), true);
    }

    @Override
    public int getSize() {
        return 4;
    }
}

