/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import greymerk.roguelike.worldgen.spawners.SpawnerSettings;
import java.util.List;
import java.util.Random;

public class DungeonsSpiderNest
extends DungeonBase {
    WorldEditor editor;
    Random rand;
    int originX;
    int originY;
    int originZ;
    byte dungeonHeight = (byte)2;
    int dungeonLength = 3;
    int dungeonWidth = 3;

    public DungeonsSpiderNest(RoomSetting roomSetting) {
        super(roomSetting);
    }

    @Override
    public DungeonBase generate(WorldEditor editor, Random inRandom, LevelSettings settings, Coord origin, Cardinal[] entrances) {
        this.editor = editor;
        this.rand = inRandom;
        this.originX = origin.getX();
        this.originY = origin.getY();
        this.originZ = origin.getZ();
        BlockWeightedRandom webs = new BlockWeightedRandom();
        webs.addBlock(BlockType.get(BlockType.WEB), 3);
        webs.addBlock(BlockType.get(BlockType.AIR), 1);
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                for (int blockY = this.originY + this.dungeonHeight; blockY >= this.originY - this.dungeonHeight; --blockY) {
                    int x = Math.abs(blockX - this.originX);
                    int z = Math.abs(blockZ - this.originZ);
                    int clearHeight = Math.max(x, z);
                    if (blockY == this.originY) {
                        webs.set(editor, inRandom, new Coord(blockX, blockY, blockZ));
                    }
                    if (clearHeight < 1) {
                        clearHeight = 1;
                    }
                    if (Math.abs(blockY - this.originY) > clearHeight) continue;
                    if (this.rand.nextInt(clearHeight) == 0) {
                        webs.set(editor, inRandom, new Coord(blockX, blockY, blockZ));
                        continue;
                    }
                    if (this.rand.nextInt(5) != 0) continue;
                    BlockType.get(BlockType.GRAVEL).set(editor, new Coord(blockX, blockY, blockZ));
                }
            }
        }
        Coord cursor = new Coord(this.originX, this.originY, this.originZ);
        SpawnerSettings spawners = settings.getSpawners();
        this.generateSpawner(editor, this.rand, cursor, settings.getDifficulty(cursor), spawners, MobType.CAVESPIDER);
        List<Coord> spaces = new RectSolid(new Coord(this.originX - this.dungeonLength, this.originY - 1, this.originZ - this.dungeonWidth), new Coord(this.originX + this.dungeonLength, this.originY + 1, this.originZ + this.dungeonWidth)).get();
        List<Coord> chestLocations = DungeonsSpiderNest.chooseRandomLocations(this.rand, 1 + this.rand.nextInt(3), spaces);
        editor.treasureChestEditor.createChests(Dungeon.getLevel(this.originY), chestLocations, false, this.getRoomSetting().getChestType().orElse(ChestType.chooseRandomType(this.rand, ChestType.COMMON_TREASURES)));
        return this;
    }

    @Override
    public int getSize() {
        return 4;
    }
}

