/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.segment.alcove.SilverfishNest;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class SegmentSilverfish
extends SegmentBase {
    @Override
    protected void genWall(WorldEditor editor, Random rand, DungeonLevel level, Cardinal dir, ITheme theme, Coord origin) {
        MetaBlock air = BlockType.get(BlockType.AIR);
        IStair stair = theme.getSecondary().getStair();
        Coord cursor = new Coord(origin);
        Cardinal[] orth = dir.orthogonal();
        cursor.translate(dir, 2);
        Coord start = new Coord(cursor);
        start.translate(orth[0], 1);
        Coord end = new Coord(cursor);
        end.translate(orth[1], 1);
        end.translate(Cardinal.UP, 2);
        RectSolid.fill(editor, rand, start, end, air);
        start.translate(dir, 1);
        end.translate(dir, 1);
        RectSolid.fill(editor, rand, start, end, theme.getPrimary().getWall(), false, true);
        cursor.translate(Cardinal.UP, 2);
        for (Cardinal d : orth) {
            Coord c = new Coord(cursor);
            c.translate(d, 1);
            stair.setOrientation(d.reverse(), true);
            stair.set(editor, c);
        }
        stair = theme.getPrimary().getStair();
        cursor = new Coord(origin);
        cursor.translate(dir, 3);
        stair.setOrientation(dir.reverse(), false);
        stair.set(editor, cursor);
        cursor.translate(Cardinal.UP);
        air.set(editor, cursor);
        cursor.translate(Cardinal.UP);
        stair.setOrientation(dir.reverse(), true);
        stair.set(editor, cursor);
        SilverfishNest nest = new SilverfishNest();
        if (nest.isValidLocation(editor, new Coord(origin), dir)) {
            nest.generate(editor, rand, level.getSettings(), new Coord(origin), dir);
            return;
        }
    }
}

