/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.worldgen.IPositionInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpawnCriteria {
    private int weight;
    private final List<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
    private List<BiomeDictionary.Type> biomeTypes = new ArrayList<BiomeDictionary.Type>();
    private final List<Integer> validDimensions = new ArrayList<Integer>();

    public SpawnCriteria() {
        this(new JsonObject());
    }

    public SpawnCriteria(JsonObject data) {
        this.weight = data.has("weight") ? data.get("weight").getAsInt() : 1;
        this.addBiomeCriteria(data);
        this.addBiomeTypeCriteria(data);
        this.addDimensionCriteria(data);
    }

    private void addBiomeCriteria(JsonObject data) {
        if (data.has("biomes")) {
            for (JsonElement biome : data.get("biomes").getAsJsonArray()) {
                if (biome.isJsonNull()) continue;
                this.biomes.add(new ResourceLocation(biome.getAsString()));
            }
        }
    }

    private void addBiomeTypeCriteria(JsonObject data) {
        if (data.has("biomeTypes")) {
            for (JsonElement biomeType : data.get("biomeTypes").getAsJsonArray()) {
                BiomeDictionary.Type type;
                if (biomeType.isJsonNull() || BiomeDictionary.getBiomes((BiomeDictionary.Type)(type = BiomeDictionary.Type.getType((String)biomeType.getAsString().toUpperCase(), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]))).size() <= 0) continue;
                this.biomeTypes.add(type);
            }
        }
    }

    private void addDimensionCriteria(JsonObject data) {
        if (data.has("dimensions")) {
            for (JsonElement dimension : data.get("dimensions").getAsJsonArray()) {
                if (dimension.isJsonNull()) continue;
                this.validDimensions.add(dimension.getAsInt());
            }
        }
    }

    public static boolean isValidDimension(int dimension) {
        return SpawnCriteria.isValidDimension(dimension, RogueConfig.getIntList(RogueConfig.DIMENSIONWL), RogueConfig.getIntList(RogueConfig.DIMENSIONBL));
    }

    public static boolean isValidDimension(int dimension, List<Integer> whiteList, List<Integer> blackList) {
        return !blackList.contains(dimension) && (whiteList.isEmpty() || whiteList.contains(dimension));
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void setBiomeTypes(List<BiomeDictionary.Type> biomeTypes) {
        this.biomeTypes = biomeTypes;
    }

    public boolean isValid(IPositionInfo positionInfo) {
        return this.isBiomeValid(positionInfo) && this.isBiomeTypeValid(positionInfo) && this.isDimensionValid(positionInfo);
    }

    private boolean isBiomeValid(IPositionInfo positionInfo) {
        return this.biomes.isEmpty() || this.includesBiome(positionInfo);
    }

    private boolean includesBiome(IPositionInfo positionInfo) {
        return this.biomes.contains(positionInfo.getBiome().getRegistryName());
    }

    private boolean isBiomeTypeValid(IPositionInfo positionInfo) {
        return this.biomeTypes.isEmpty() || this.includesBiomeType(positionInfo);
    }

    private boolean includesBiomeType(IPositionInfo positionInfo) {
        Biome biomeHere = positionInfo.getBiome();
        return this.biomeTypes.stream().anyMatch(biomeType -> BiomeDictionary.hasType((Biome)biomeHere, (BiomeDictionary.Type)biomeType));
    }

    private boolean isDimensionValid(IPositionInfo positionInfo) {
        return SpawnCriteria.isValidDimension(positionInfo.getDimension()) && this.validDimensions.isEmpty() || this.includesDimension(positionInfo);
    }

    private boolean includesDimension(IPositionInfo positionInfo) {
        return this.validDimensions.contains(positionInfo.getDimension());
    }
}

