/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.tasks;

import greymerk.roguelike.dungeon.DungeonStage;
import greymerk.roguelike.dungeon.tasks.DungeonTaskEncase;
import greymerk.roguelike.dungeon.tasks.DungeonTaskFilters;
import greymerk.roguelike.dungeon.tasks.DungeonTaskLayout;
import greymerk.roguelike.dungeon.tasks.DungeonTaskLinks;
import greymerk.roguelike.dungeon.tasks.DungeonTaskLoot;
import greymerk.roguelike.dungeon.tasks.DungeonTaskRooms;
import greymerk.roguelike.dungeon.tasks.DungeonTaskSegments;
import greymerk.roguelike.dungeon.tasks.DungeonTaskTower;
import greymerk.roguelike.dungeon.tasks.DungeonTaskTunnels;
import greymerk.roguelike.dungeon.tasks.IDungeonTask;
import greymerk.roguelike.dungeon.tasks.IDungeonTaskRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DungeonTaskRegistry
implements IDungeonTaskRegistry {
    public static DungeonTaskRegistry registry;
    private Map<DungeonStage, List<IDungeonTask>> tasks = new HashMap<DungeonStage, List<IDungeonTask>>();

    public DungeonTaskRegistry() {
        this.addTask(new DungeonTaskLayout(), DungeonStage.LAYOUT);
        this.addTask(new DungeonTaskEncase(), DungeonStage.ENCASE);
        this.addTask(new DungeonTaskTunnels(), DungeonStage.TUNNELS);
        this.addTask(new DungeonTaskRooms(), DungeonStage.ROOMS);
        this.addTask(new DungeonTaskSegments(), DungeonStage.SEGMENTS);
        this.addTask(new DungeonTaskLinks(), DungeonStage.LINKS);
        this.addTask(new DungeonTaskTower(), DungeonStage.TOWER);
        this.addTask(new DungeonTaskFilters(), DungeonStage.FILTERS);
        this.addTask(new DungeonTaskLoot(), DungeonStage.LOOT);
    }

    public static IDungeonTaskRegistry getTaskRegistry() {
        if (registry == null) {
            registry = new DungeonTaskRegistry();
        }
        return registry;
    }

    @Override
    public void addTask(IDungeonTask task, DungeonStage stage) {
        if (!this.tasks.containsKey((Object)stage)) {
            this.tasks.put(stage, new ArrayList());
        }
        this.tasks.get((Object)stage).add(task);
    }

    @Override
    public List<IDungeonTask> getTasks(DungeonStage stage) {
        if (!this.tasks.containsKey((Object)stage)) {
            return new ArrayList<IDungeonTask>();
        }
        return this.tasks.get((Object)stage);
    }
}

