/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure;

import greymerk.roguelike.treasure.Inventory;
import greymerk.roguelike.treasure.loot.ChestType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;

public class TreasureChest {
    private final Inventory inventory;
    private ChestType chestType;
    private final long seed;
    private final TileEntityChest tileEntityChest;
    private final int level;

    public TreasureChest(ChestType chestType, int level, TileEntityChest tileEntityChest, int seed, Inventory inventory) {
        this.chestType = chestType;
        this.level = level;
        this.tileEntityChest = tileEntityChest;
        this.inventory = inventory;
        this.seed = seed;
    }

    public boolean setSlot(int slot, ItemStack item) {
        return this.inventory.setInventorySlot(slot, item);
    }

    public boolean setRandomEmptySlot(ItemStack item) {
        return this.inventory.setRandomEmptySlot(item);
    }

    public boolean isEmptySlot(int slot) {
        return this.inventory.isEmptySlot(slot);
    }

    public ChestType getType() {
        return this.chestType;
    }

    public int getSize() {
        return this.inventory.getInventorySize();
    }

    public int getLevel() {
        return Math.max(0, Math.min(this.level, 4));
    }

    public void setLootTable(ResourceLocation table) {
        this.tileEntityChest.func_189404_a(table, this.seed);
    }

    public boolean isOnLevel(int level) {
        return this.getLevel() == level;
    }

    public boolean isType(ChestType chestType) {
        return this.getType().equals(chestType);
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    private boolean isEmpty() {
        return this.chestType == null || this.isType(ChestType.EMPTY);
    }
}

